/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2020-03-05 00:28:00 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_pro_entities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=42 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `author` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `slug` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(10) NOT NULL,
  `schedule_start` int(10) NOT NULL DEFAULT '0',
  `schedule_end` int(10) NOT NULL DEFAULT '0',
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `flag_popup` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_layerslider_revisions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `slider_id` int(10) NOT NULL,
  `author` int(10) NOT NULL DEFAULT '0',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=8353 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=7295 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=1373 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfblocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `expiration` bigint(20) unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfhits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `statusCode` int(11) NOT NULL DEFAULT '200',
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfhoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfknownfilelist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6514 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wflogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '1000',
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfpendingissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfsnipcache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfstatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=18977 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=960 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


 /* SQL Chunk Header Index 1 */ 

/* INSERT TABLE DATA: wp_duplicator_pro_entities */
INSERT INTO `wp_duplicator_pro_entities` VALUES(1, 'DUP_PRO_Global_Entity', '{\"uninstall_settings\":false,\"uninstall_packages\":false,\"uninstall_tables\":true,\"wpfront_integrate\":false,\"package_ui_created\":1,\"package_mysqldump\":false,\"package_mysqldump_path\":\"\",\"package_phpdump_mode\":0,\"package_phpdump_qrylimit\":500,\"package_php_chunking\":null,\"archive_build_mode\":2,\"archive_compression\":true,\"ziparchive_validation\":false,\"ziparchive_mode\":0,\"ziparchive_chunk_size_in_mb\":6,\"archive_build_mode_schedule\":-1,\"archive_compression_schedule\":true,\"server_load_reduction\":0,\"max_package_runtime_in_min\":90,\"php_max_worker_time_in_sec\":18,\"lock_mode\":0,\"json_mode\":0,\"ajax_protocol\":\"https\",\"custom_ajax_url\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-admin\\/admin-ajax.php\",\"clientside_kickoff\":false,\"basic_auth_enabled\":false,\"basic_auth_user\":\"\",\"basic_auth_password\":\"\",\"installer_base_name\":\"installer.php\",\"chunk_size\":2048,\"send_email_on_build_mode\":1,\"notification_email_address\":\"\",\"storage_htaccess_off\":false,\"max_storage_retries\":10,\"max_default_store_files\":20,\"purge_default_package_record\":false,\"dropbox_upload_chunksize_in_kb\":2000,\"dropbox_transfer_mode\":1,\"gdrive_upload_chunksize_in_kb\":2000,\"s3_upload_part_size_in_kb\":6000,\"manual_mode_storage_ids\":[\"8\"],\"license_status\":0,\"license_expiration_time\":1548778241,\"license_no_activations_left\":false,\"license_key_visible\":true,\"lkp\":\"\",\"license_limit\":-1,\"last_edd_api_response\":null,\"last_edd_api_timestamp\":0,\"last_system_check_timestamp\":1583368073,\"initial_activation_timestamp\":1548778252,\"debug_on\":false,\"trace_profiler_on\":false,\"profile_idea\":false,\"profile_beta\":false,\"dupHidePackagesGiftFeatures\":true,\"type\":\"DUP_PRO_Global_Entity\",\"notices\":{\"dupArchiveSwitch\":true}}'),
 (2, 'DUP_PRO_Secure_Global_Entity', '{\"basic_auth_password\":\"\",\"lkp\":\"\",\"type\":\"DUP_PRO_Secure_Global_Entity\"}'),
 (3, 'DUP_PRO_System_Global_Entity', '{\"recommended_fixes\":[],\"schedule_failed\":false,\"package_check_ts\":1583368084,\"type\":\"DUP_PRO_System_Global_Entity\"}'),
 (4, 'DUP_PRO_Package_Template_Entity', '{\"name\":\"Default\",\"notes\":\"The default template.\",\"filter_sites\":[],\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":[],\"installer_opts_secure_on\":null,\"installer_opts_secure_pass\":null,\"installer_opts_skip_scan\":null,\"installer_opts_db_host\":null,\"installer_opts_db_name\":null,\"installer_opts_db_user\":null,\"installer_opts_cpnl_enable\":false,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"is_default\":true,\"is_manual\":false,\"type\":\"DUP_PRO_Package_Template_Entity\"}'),
 (5, 'DUP_PRO_Package_Template_Entity', '{\"name\":\"[Manual Mode]\",\"notes\":\"\",\"filter_sites\":\"\",\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":\"\",\"installer_opts_secure_on\":0,\"installer_opts_secure_pass\":\"\",\"installer_opts_skip_scan\":0,\"installer_opts_db_host\":\"\",\"installer_opts_db_name\":\"\",\"installer_opts_db_user\":\"\",\"installer_opts_cpnl_enable\":0,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"is_default\":false,\"is_manual\":true,\"type\":\"DUP_PRO_Package_Template_Entity\"}'),
 (6, 'DUP_PRO_Schedule_Entity', '{\"name\":\"New Schedule\",\"template_id\":\"4\",\"start_ticks\":1420070400,\"repeat_type\":\"1\",\"active\":true,\"next_run_time\":1583625600,\"run_every\":1,\"weekly_days\":64,\"day_of_month\":\"1\",\"cron_string\":\"0 0 * * 0\",\"last_run_time\":1581640460,\"last_run_status\":0,\"times_run\":38,\"storage_ids\":[\"-2\"],\"type\":\"DUP_PRO_Schedule_Entity\"}'),
 (8, 'DUP_PRO_Storage_Entity', '{\"name\":\"New Storage\",\"notes\":\"\",\"storage_type\":\"2\",\"editable\":true,\"local_storage_folder\":\"\",\"local_max_files\":\"10\",\"local_filter_protection\":true,\"dropbox_access_token\":\"\",\"dropbox_access_token_secret\":\"\",\"dropbox_v2_access_token\":\"\",\"dropbox_storage_folder\":\"mofa-omission.ultimate-dimensions.net\\/\",\"dropbox_max_files\":\"10\",\"dropbox_authorization_state\":0,\"onedrive_endpoint_url\":\"\",\"onedrive_resource_id\":\"\",\"onedrive_access_token\":\"\",\"onedrive_refresh_token\":\"\",\"onedrive_token_obtained\":\"\",\"onedrive_user_id\":\"\",\"onedrive_storage_folder\":\"mofa-omission.ultimate-dimensions.net\\/\",\"onedrive_max_files\":\"10\",\"onedrive_storage_folder_id\":\"\",\"onedrive_authorization_state\":0,\"onedrive_storage_folder_web_url\":\"\",\"ftp_server\":\"mission.gov.gy\",\"ftp_port\":\"21\",\"ftp_username\":\"jsimon@ottawa.mission.gov.gy\",\"ftp_password\":\"Ottawadev1\",\"ftp_storage_folder\":\"\\/mofa-omission.ultimate-dimensions.net\\/\",\"ftp_max_files\":\"10\",\"ftp_timeout_in_secs\":\"15\",\"ftp_ssl\":false,\"ftp_passive_mode\":false,\"sftp_server\":\"\",\"sftp_port\":22,\"sftp_username\":\"\",\"sftp_password\":\"\",\"sftp_private_key\":\"\",\"sftp_private_key_password\":\"\",\"sftp_storage_folder\":\"\\/\",\"sftp_timeout_in_secs\":15,\"sftp_max_files\":10,\"gdrive_access_token_set_json\":\"\",\"gdrive_refresh_token\":\"\",\"gdrive_storage_folder\":\"Duplicator Backups\\/mofa-omission.ultimate-dimensions.net\\/\",\"gdrive_max_files\":\"10\",\"gdrive_authorization_state\":0,\"quick_connect\":false,\"s3_access_key\":\"\",\"s3_bucket\":\"\",\"s3_max_files\":\"10\",\"s3_provider\":\"amazon\",\"s3_region\":\"us-east-1\",\"s3_endpoint\":\"\",\"s3_secret_key\":\"\",\"s3_storage_class\":\"STANDARD\",\"s3_storage_folder\":\"Duplicator Backups\\/mofa-omission.ultimate-dimensions.net\\/\",\"type\":\"DUP_PRO_Storage_Entity\"}');

/* INSERT TABLE DATA: wp_duplicator_pro_packages */
INSERT INTO `wp_duplicator_pro_packages` VALUES(1, '20190129_canadianhighcommission', '5693ca0349e4ae4e8961_20190129161724', -5, '2019-01-29 16:17:31', 'unknown', '{\"Created\":\"2019-01-29 16:17:24\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.3\",\"VersionDB\":\"5.6.41\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"1\",\"Name\":\"20190129_canadianhighcommission\",\"Hash\":\"5693ca0349e4ae4e8961_20190129161724\",\"NameHash\":\"20190129_canadianhighcommission_5693ca0349e4ae4e8961_20190129161724\",\"Type\":0,\"Notes\":\"\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190129_canadianhighcommission_5693ca0349e4ae4e8961_20190129161724_scan.json\",\"timer_start\":1548780561.7687,\"Runtime\":\"61.817 sec.\",\"ExeSize\":\"36.57KB\",\"ZipSize\":\"96.08MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190129_canadianhighcommission_5693ca0349e4ae4e8961_20190129161724_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":100744742,\"Dirs\":null,\"DirCount\":1173,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8356,\"file_count\":9529,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":\"\"},\"Installer\":{\"File\":\"20190129_canadianhighcommission_5693ca0349e4ae4e8961_20190129161724_installer.php\",\"Size\":37450,\"OptsSecureOn\":0,\"OptsSecurePass\":\"\",\"OptsSkipScan\":0,\"OptsDBHost\":\"\",\"OptsDBName\":\"\",\"OptsDBUser\":\"\",\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":0,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":16346,\"tablesSizeOnDisk\":8985394,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.41\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7174043,\"File\":\"20190129_canadianhighcommission_5693ca0349e4ae4e8961_20190129161724_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":\"\",\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190129_canadianhighcommission_5693ca0349e4ae4e8961_20190129161724_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22532,34720,60436,61460,62484,1773992,2254840,6165888,6174610,6179866,6195434,6209694,6234366,6242662,6243686,6244710,7274482,7275506,7276530,8298298,8306390,8307414,8318334,8785774,8786798,8789006,8794478,8798346,8799370,8801470,8802494,8977174,8978198,8991102]},\"Status\":-5,\"schedule_id\":-1,\"build_progress\":{\"thread_start_time\":1548778724,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8356,\"next_archive_dir_index\":3519,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":36,\"tableOffset\":0,\"totalRowOffset\":16347,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1548778663.0858,\"fileOffset\":7174043,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":8996558,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10940,\"wp_duplicator_pro_packages\":12188,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":1024,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1029772,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1021768,\"wp_wfhits\":8092,\"wp_wfhoover\":1024,\"wp_wfissues\":10920,\"wp_wfknownfilelist\":467440,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfnotifications\":3868,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":174680,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5456}},\"upload_infos\":[{\"storage_id\":\"7\",\"archive_offset\":0,\"copied_installer\":false,\"copied_archive\":false,\"progress\":0,\"num_failures\":0,\"failed\":true,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1548780175,\"stopped_timestamp\":null},{\"storage_id\":\"7\",\"archive_offset\":0,\"copied_installer\":false,\"copied_archive\":false,\"progress\":0,\"num_failures\":0,\"failed\":true,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1548780229,\"stopped_timestamp\":null},{\"storage_id\":\"7\",\"archive_offset\":0,\"copied_installer\":false,\"copied_archive\":false,\"progress\":0,\"num_failures\":0,\"failed\":true,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1548780287,\"stopped_timestamp\":null},{\"storage_id\":\"7\",\"archive_offset\":0,\"copied_installer\":false,\"copied_archive\":false,\"progress\":0,\"num_failures\":0,\"failed\":true,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1548780371,\"stopped_timestamp\":null},{\"storage_id\":\"8\",\"archive_offset\":0,\"copied_installer\":false,\"copied_archive\":false,\"progress\":0,\"num_failures\":0,\"failed\":true,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1548780578,\"stopped_timestamp\":null}],\"active_storage_id\":8,\"template_id\":5}'),
 (2, '20190129_canadianhighcommission', '71fb8b66cde2a0c75418_20190129165039', 100, '2019-01-29 16:50:43', 'unknown', '{\"Created\":\"2019-01-29 16:50:39\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.3\",\"VersionDB\":\"5.6.41\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"2\",\"Name\":\"20190129_canadianhighcommission\",\"Hash\":\"71fb8b66cde2a0c75418_20190129165039\",\"NameHash\":\"20190129_canadianhighcommission_71fb8b66cde2a0c75418_20190129165039\",\"Type\":0,\"Notes\":\"\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190129_canadianhighcommission_71fb8b66cde2a0c75418_20190129165039_scan.json\",\"timer_start\":1548780655.2012,\"Runtime\":\"33.467 sec.\",\"ExeSize\":\"36.57KB\",\"ZipSize\":\"96.08MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190129_canadianhighcommission_71fb8b66cde2a0c75418_20190129165039_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":100745496,\"Dirs\":null,\"DirCount\":1173,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8356,\"file_count\":9529,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":\"\"},\"Installer\":{\"File\":\"20190129_canadianhighcommission_71fb8b66cde2a0c75418_20190129165039_installer.php\",\"Size\":37450,\"OptsSecureOn\":0,\"OptsSecurePass\":\"\",\"OptsSkipScan\":0,\"OptsDBHost\":\"\",\"OptsDBName\":\"\",\"OptsDBUser\":\"\",\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":0,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":16348,\"tablesSizeOnDisk\":9000778,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.41\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7187921,\"File\":\"20190129_canadianhighcommission_71fb8b66cde2a0c75418_20190129165039_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":\"\",\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190129_canadianhighcommission_71fb8b66cde2a0c75418_20190129165039_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22532,47048,72764,73788,74812,1786320,2267168,6178216,6186938,6192194,6207762,6222022,6246694,6254990,6256014,6257038,7286810,7287834,7288858,8310626,8318718,8319742,8330662,8798102,8799126,8801334,8806806,8810674,8811698,8813798,8814822,8989502,8990526,9003430]},\"Status\":100,\"schedule_id\":-1,\"build_progress\":{\"thread_start_time\":1548780688,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8356,\"next_archive_dir_index\":2346,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":36,\"tableOffset\":0,\"totalRowOffset\":16349,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1548780655.2034,\"fileOffset\":7187921,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9008886,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10940,\"wp_duplicator_pro_packages\":24516,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":1024,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1029772,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1021768,\"wp_wfhits\":8092,\"wp_wfhoover\":1024,\"wp_wfissues\":10920,\"wp_wfknownfilelist\":467440,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfnotifications\":3868,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":174680,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5456}},\"upload_infos\":[{\"storage_id\":\"8\",\"archive_offset\":100745496,\"copied_installer\":true,\"copied_archive\":true,\"progress\":100,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1548780689,\"stopped_timestamp\":1548780704}],\"active_storage_id\":8,\"template_id\":5}'),
 (3, '20190204_210009_New-Schedule_canadianhig', 'dac829949b9d85534203_20190204210009', 100, '2019-02-04 21:00:09', 'System', '{\"Created\":\"2019-02-04 21:00:09\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.3\",\"VersionDB\":\"5.6.41\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"3\",\"Name\":\"20190204_210009_New-Schedule_canadianhig\",\"Hash\":\"dac829949b9d85534203_20190204210009\",\"NameHash\":\"20190204_210009_New-Schedule_canadianhig_dac829949b9d85534203_20190204210009\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190204_210009_New-Schedule_canadianhig_dac829949b9d85534203_20190204210009_scan.json\",\"timer_start\":1549314022.7146,\"Runtime\":\"66.921 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"96.8MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190204_210009_New-Schedule_canadianhig_dac829949b9d85534203_20190204210009_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":101501323,\"Dirs\":null,\"DirCount\":1176,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8361,\"file_count\":9537,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190204_210009_New-Schedule_canadianhig_dac829949b9d85534203_20190204210009_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":18270,\"tablesSizeOnDisk\":9258826,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.41\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7453584,\"File\":\"20190204_210009_New-Schedule_canadianhig_dac829949b9d85534203_20190204210009_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190204_210009_New-Schedule_canadianhig_dac829949b9d85534203_20190204210009_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22532,58336,84052,85076,86100,1797608,2278456,6189504,6198226,6203482,6219050,6233310,6257982,6266278,6267302,6268326,7298326,7299350,7300374,8481330,8489662,8490686,8501606,9047802,9048826,9051034,9056506,9060714,9061738,9063838,9064862,9245282,9246306,9259210]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1549314089,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8361,\"next_archive_dir_index\":3528,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":36,\"tableOffset\":0,\"totalRowOffset\":17956,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1549314022.7163,\"fileOffset\":7453584,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9264666,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10940,\"wp_duplicator_pro_packages\":35804,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":1024,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1030000,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1180956,\"wp_wfhits\":8332,\"wp_wfhoover\":1024,\"wp_wfissues\":10920,\"wp_wfknownfilelist\":546196,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfnotifications\":4208,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":180420,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5456}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1549314090,\"stopped_timestamp\":1549314092}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (4, '20190212_072543_New-Schedule_canadianhig', '4e664e6acd146f551819_20190212072543', 100, '2019-02-12 07:25:43', 'System', '{\"Created\":\"2019-02-12 07:25:43\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.3\",\"VersionDB\":\"5.6.41\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"4\",\"Name\":\"20190212_072543_New-Schedule_canadianhig\",\"Hash\":\"4e664e6acd146f551819_20190212072543\",\"NameHash\":\"20190212_072543_New-Schedule_canadianhig_4e664e6acd146f551819_20190212072543\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190212_072543_New-Schedule_canadianhig_4e664e6acd146f551819_20190212072543_scan.json\",\"timer_start\":1549956353.0591,\"Runtime\":\"65.397 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.13MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190212_072543_New-Schedule_canadianhig_4e664e6acd146f551819_20190212072543_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":101852649,\"Dirs\":null,\"DirCount\":1201,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8473,\"file_count\":9674,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190212_072543_New-Schedule_canadianhig_4e664e6acd146f551819_20190212072543_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":18506,\"tablesSizeOnDisk\":9316050,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.41\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7523035,\"File\":\"20190212_072543_New-Schedule_canadianhig_4e664e6acd146f551819_20190212072543_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190212_072543_New-Schedule_canadianhig_4e664e6acd146f551819_20190212072543_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22552,69636,95352,96376,97400,1808908,2289756,6200804,6209526,6214782,6230350,6244610,6269282,6277578,6278602,6279626,7318458,7319482,7320506,8524302,8532634,8533658,8544578,9103590,9104614,9106822,9112294,9116502,9117526,9119626,9120650,9302518,9303542,9316446]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1549956418,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8473,\"next_archive_dir_index\":3603,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":36,\"tableOffset\":0,\"totalRowOffset\":18205,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1549956353.0612,\"fileOffset\":7523035,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9321902,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10960,\"wp_duplicator_pro_packages\":47084,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":1024,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1038832,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1203796,\"wp_wfhits\":8332,\"wp_wfhoover\":1024,\"wp_wfissues\":10920,\"wp_wfknownfilelist\":559012,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfnotifications\":4208,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":181868,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5456}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1549956419,\"stopped_timestamp\":1549956420}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (5, '20190217_022503_New-Schedule_canadianhig', 'a6a39a8baeb242c95653_20190217022503', 100, '2019-02-17 02:25:03', 'System', '{\"Created\":\"2019-02-17 02:25:03\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.3\",\"VersionDB\":\"5.6.41\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"5\",\"Name\":\"20190217_022503_New-Schedule_canadianhig\",\"Hash\":\"a6a39a8baeb242c95653_20190217022503\",\"NameHash\":\"20190217_022503_New-Schedule_canadianhig_a6a39a8baeb242c95653_20190217022503\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190217_022503_New-Schedule_canadianhig_a6a39a8baeb242c95653_20190217022503_scan.json\",\"timer_start\":1550370319.8298,\"Runtime\":\"63.725 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.28MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190217_022503_New-Schedule_canadianhig_a6a39a8baeb242c95653_20190217022503_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102000347,\"Dirs\":null,\"DirCount\":1202,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8473,\"file_count\":9675,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190217_022503_New-Schedule_canadianhig_a6a39a8baeb242c95653_20190217022503_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":18195,\"tablesSizeOnDisk\":9330704,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.41\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7529459,\"File\":\"20190217_022503_New-Schedule_canadianhig_a6a39a8baeb242c95653_20190217022503_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190217_022503_New-Schedule_canadianhig_a6a39a8baeb242c95653_20190217022503_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22552,80928,106644,107668,108692,1820200,2301048,6212096,6220818,6226074,6241642,6255902,6280574,6288870,6289894,6290918,7330986,7332010,7333034,8537038,8545370,8546394,8557314,9116454,9117478,9119686,9125158,9129546,9130570,9132670,9133694,9317138,9318162,9331066]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1550370383,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8473,\"next_archive_dir_index\":3606,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":36,\"tableOffset\":0,\"totalRowOffset\":18194,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1550370319.8316,\"fileOffset\":7529459,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9336556,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10960,\"wp_duplicator_pro_packages\":58376,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":1024,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1040068,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1204004,\"wp_wfhits\":8332,\"wp_wfhoover\":1024,\"wp_wfissues\":10920,\"wp_wfknownfilelist\":559140,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfnotifications\":4388,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":183444,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1550370384,\"stopped_timestamp\":1550370388}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (6, '20190225_163601_New-Schedule_canadianhig', '77c5768febe087861662_20190225163601', 100, '2019-02-25 16:36:01', 'System', '{\"Created\":\"2019-02-25 16:36:01\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.3\",\"VersionDB\":\"5.6.41\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"6\",\"Name\":\"20190225_163601_New-Schedule_canadianhig\",\"Hash\":\"77c5768febe087861662_20190225163601\",\"NameHash\":\"20190225_163601_New-Schedule_canadianhig_77c5768febe087861662_20190225163601\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190225_163601_New-Schedule_canadianhig_77c5768febe087861662_20190225163601_scan.json\",\"timer_start\":1551112567.8203,\"Runtime\":\"59.820 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.3MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190225_163601_New-Schedule_canadianhig_77c5768febe087861662_20190225163601_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102023103,\"Dirs\":null,\"DirCount\":1202,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8473,\"file_count\":9675,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190225_163601_New-Schedule_canadianhig_77c5768febe087861662_20190225163601_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":18512,\"tablesSizeOnDisk\":9390156,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.41\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7585173,\"File\":\"20190225_163601_New-Schedule_canadianhig_77c5768febe087861662_20190225163601_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190225_163601_New-Schedule_canadianhig_77c5768febe087861662_20190225163601_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22552,92212,117928,118952,119976,1831484,2312332,6223380,6232102,6237358,6252926,6267186,6291858,6300154,6302238,6303262,7353726,7354750,7355774,8562034,8601550,8602574,8614030,9173298,9174322,9176530,9182002,9186434,9187458,9189558,9190582,9376590,9377614,9390518]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1551112627,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8473,\"next_archive_dir_index\":3606,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":36,\"tableOffset\":0,\"totalRowOffset\":18508,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1551112567.8222,\"fileOffset\":7585173,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9396008,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10960,\"wp_duplicator_pro_packages\":69660,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1050464,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1206260,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":11456,\"wp_wfknownfilelist\":559268,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfnotifications\":4432,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":186008,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1551112628,\"stopped_timestamp\":1551112630}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (7, '20190304_164934_New-Schedule_canadianhig', '1a8b07287c85ca4e8023_20190304164934', 100, '2019-03-04 16:49:34', 'System', '{\"Created\":\"2019-03-04 16:49:34\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.3\",\"VersionDB\":\"5.6.43\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"7\",\"Name\":\"20190304_164934_New-Schedule_canadianhig\",\"Hash\":\"1a8b07287c85ca4e8023_20190304164934\",\"NameHash\":\"20190304_164934_New-Schedule_canadianhig_1a8b07287c85ca4e8023_20190304164934\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190304_164934_New-Schedule_canadianhig_1a8b07287c85ca4e8023_20190304164934_scan.json\",\"timer_start\":1551718187.5059,\"Runtime\":\"63.346 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.3MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190304_164934_New-Schedule_canadianhig_1a8b07287c85ca4e8023_20190304164934_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102026403,\"Dirs\":null,\"DirCount\":1203,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8474,\"file_count\":9677,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190304_164934_New-Schedule_canadianhig_1a8b07287c85ca4e8023_20190304164934_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":18008,\"tablesSizeOnDisk\":9378932,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.43\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7531067,\"File\":\"20190304_164934_New-Schedule_canadianhig_1a8b07287c85ca4e8023_20190304164934_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190304_164934_New-Schedule_canadianhig_1a8b07287c85ca4e8023_20190304164934_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22552,103488,129204,130228,131252,1842760,2323608,6234656,6243378,6248634,6264202,6278462,6303134,6311430,6313514,6314538,7365306,7366330,7367354,8555002,8594518,8595542,8608682,9159814,9160838,9163046,9168518,9173130,9174154,9176254,9177278,9365366,9366390,9379294]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1551718250,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8474,\"next_archive_dir_index\":3609,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":36,\"tableOffset\":0,\"totalRowOffset\":18009,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1551718187.5077,\"fileOffset\":7531067,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9384784,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10960,\"wp_duplicator_pro_packages\":80936,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1050768,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1187648,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":13140,\"wp_wfknownfilelist\":551132,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfnotifications\":4612,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":188088,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1551718251,\"stopped_timestamp\":1551718254}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (8, '20190312_170121_New-Schedule_canadianhig', 'cfa22dd61a7d62106555_20190312170121', 100, '2019-03-12 17:01:21', 'System', '{\"Created\":\"2019-03-12 17:01:21\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.3\",\"VersionDB\":\"5.6.43\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"8\",\"Name\":\"20190312_170121_New-Schedule_canadianhig\",\"Hash\":\"cfa22dd61a7d62106555_20190312170121\",\"NameHash\":\"20190312_170121_New-Schedule_canadianhig_cfa22dd61a7d62106555_20190312170121\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190312_170121_New-Schedule_canadianhig_cfa22dd61a7d62106555_20190312170121_scan.json\",\"timer_start\":1552410102.3881,\"Runtime\":\"64.343 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.31MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190312_170121_New-Schedule_canadianhig_cfa22dd61a7d62106555_20190312170121_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102039243,\"Dirs\":null,\"DirCount\":1203,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8474,\"file_count\":9677,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190312_170121_New-Schedule_canadianhig_cfa22dd61a7d62106555_20190312170121_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":18272,\"tablesSizeOnDisk\":9465660,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.43\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7593831,\"File\":\"20190312_170121_New-Schedule_canadianhig_cfa22dd61a7d62106555_20190312170121_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190312_170121_New-Schedule_canadianhig_cfa22dd61a7d62106555_20190312170121_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22552,114784,140500,141524,142548,1854056,2334904,6245952,6254674,6259930,6275498,6289758,6314430,6322726,6324810,6325834,7385362,7386386,7387410,8602694,8642210,8643234,8656374,9219958,9220982,9223190,9228662,9233274,9234298,9236398,9237422,9452082,9453106,9466010]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1552410166,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8474,\"next_archive_dir_index\":3609,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":36,\"tableOffset\":0,\"totalRowOffset\":18271,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1552410102.3902,\"fileOffset\":7593831,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9471500,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10960,\"wp_duplicator_pro_packages\":92232,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1059528,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1215284,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":13140,\"wp_wfknownfilelist\":563584,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfnotifications\":4612,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1552410167,\"stopped_timestamp\":1552410167}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (9, '20190317_231030_New-Schedule_canadianhig', 'c31147883be177034940_20190317231030', 100, '2019-03-17 23:10:30', 'System', '{\"Created\":\"2019-03-17 23:10:30\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.4\",\"VersionDB\":\"5.6.43\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"9\",\"Name\":\"20190317_231030_New-Schedule_canadianhig\",\"Hash\":\"c31147883be177034940_20190317231030\",\"NameHash\":\"20190317_231030_New-Schedule_canadianhig_c31147883be177034940_20190317231030\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190317_231030_New-Schedule_canadianhig_c31147883be177034940_20190317231030_scan.json\",\"timer_start\":1552864239.7281,\"Runtime\":\"65.174 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.31MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190317_231030_New-Schedule_canadianhig_c31147883be177034940_20190317231030_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102040781,\"Dirs\":null,\"DirCount\":1203,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8474,\"file_count\":9677,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190317_231030_New-Schedule_canadianhig_c31147883be177034940_20190317231030_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":18599,\"tablesSizeOnDisk\":9478728,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.43\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7610657,\"File\":\"20190317_231030_New-Schedule_canadianhig_c31147883be177034940_20190317231030_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190317_231030_New-Schedule_canadianhig_c31147883be177034940_20190317231030_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22552,126076,151792,152816,153840,1865348,2346196,6257244,6265966,6271222,6286790,6301050,6325722,6334018,6336102,6337126,7396898,7397922,7398946,8615462,8654978,8656002,8669142,9232854,9233878,9236086,9241558,9246350,9247374,9249474,9250498,9465158,9466182,9479086]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1552864304,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8474,\"next_archive_dir_index\":3609,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":36,\"tableOffset\":0,\"totalRowOffset\":18322,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1552864239.73,\"fileOffset\":7610657,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9484576,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10960,\"wp_duplicator_pro_packages\":103524,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1059772,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1216516,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":13140,\"wp_wfknownfilelist\":563712,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfnotifications\":4792,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1552864305,\"stopped_timestamp\":1552864306}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (10, '20190402_051044_New-Schedule_canadianhig', '624838186b396cc67889_20190402051044', 100, '2019-04-02 05:10:44', 'System', '{\"Created\":\"2019-04-02 05:10:44\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.4\",\"VersionDB\":\"5.6.43\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"10\",\"Name\":\"20190402_051044_New-Schedule_canadianhig\",\"Hash\":\"624838186b396cc67889_20190402051044\",\"NameHash\":\"20190402_051044_New-Schedule_canadianhig_624838186b396cc67889_20190402051044\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190402_051044_New-Schedule_canadianhig_624838186b396cc67889_20190402051044_scan.json\",\"timer_start\":1554181856.9819,\"Runtime\":\"62.639 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.01MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190402_051044_New-Schedule_canadianhig_624838186b396cc67889_20190402051044_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":101719235,\"Dirs\":null,\"DirCount\":1204,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8474,\"file_count\":9630,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190402_051044_New-Schedule_canadianhig_624838186b396cc67889_20190402051044_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":18344,\"tablesSizeOnDisk\":9490636,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.43\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7629993,\"File\":\"20190402_051044_New-Schedule_canadianhig_624838186b396cc67889_20190402051044_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190402_051044_New-Schedule_canadianhig_624838186b396cc67889_20190402051044_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22552,137364,163080,164104,165128,1876636,2357484,6268532,6277254,6282510,6298078,6312338,6337010,6345306,6347390,6348414,7408294,7409318,7410342,8627066,8666582,8667606,8680746,9244586,9245610,9247818,9253290,9258262,9259286,9261386,9262410,9477070,9478094,9490998]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1554181919,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8474,\"next_archive_dir_index\":3612,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":36,\"tableOffset\":0,\"totalRowOffset\":18353,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1554181856.9837,\"fileOffset\":7629993,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9496488,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10960,\"wp_duplicator_pro_packages\":114812,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1059880,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1216724,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":13140,\"wp_wfknownfilelist\":563840,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfnotifications\":4972,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1554181920,\"stopped_timestamp\":1554181922}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (11, '20190412_183050_New-Schedule_canadianhig', '29659c1c8d06adee1614_20190412183050', 100, '2019-04-12 18:30:50', 'System', '{\"Created\":\"2019-04-12 18:30:50\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.4\",\"VersionDB\":\"5.6.43\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"11\",\"Name\":\"20190412_183050_New-Schedule_canadianhig\",\"Hash\":\"29659c1c8d06adee1614_20190412183050\",\"NameHash\":\"20190412_183050_New-Schedule_canadianhig_29659c1c8d06adee1614_20190412183050\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190412_183050_New-Schedule_canadianhig_29659c1c8d06adee1614_20190412183050_scan.json\",\"timer_start\":1555093858.8173,\"Runtime\":\"59.160 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.33MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190412_183050_New-Schedule_canadianhig_29659c1c8d06adee1614_20190412183050_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102055020,\"Dirs\":null,\"DirCount\":1204,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8465,\"file_count\":9669,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190412_183050_New-Schedule_canadianhig_29659c1c8d06adee1614_20190412183050_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":18338,\"tablesSizeOnDisk\":9503652,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.43\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7640204,\"File\":\"20190412_183050_New-Schedule_canadianhig_29659c1c8d06adee1614_20190412183050_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190412_183050_New-Schedule_canadianhig_29659c1c8d06adee1614_20190412183050_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22552,148640,174356,175380,176404,1887912,2368760,6279808,6288530,6293786,6309354,6323614,6348286,6356582,6358666,6359690,7419570,7420594,7421618,8637982,8677498,8678522,8694338,9257422,9258446,9260654,9266126,9271278,9272302,9274402,9275426,9490086,9491110,9504014]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1555093917,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8465,\"next_archive_dir_index\":3612,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":36,\"tableOffset\":0,\"totalRowOffset\":18338,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1555093858.8192,\"fileOffset\":7640204,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9509504,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10960,\"wp_duplicator_pro_packages\":126088,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1059880,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1216364,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":15816,\"wp_wfknownfilelist\":563084,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfnotifications\":5152,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1555093918,\"stopped_timestamp\":1555093921}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (12, '20190417_044027_New-Schedule_canadianhig', 'ea52dfd6382ac2685688_20190417044027', 100, '2019-04-17 04:40:27', 'System', '{\"Created\":\"2019-04-17 04:40:27\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.4\",\"VersionDB\":\"5.6.43\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"12\",\"Name\":\"20190417_044027_New-Schedule_canadianhig\",\"Hash\":\"ea52dfd6382ac2685688_20190417044027\",\"NameHash\":\"20190417_044027_New-Schedule_canadianhig_ea52dfd6382ac2685688_20190417044027\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190417_044027_New-Schedule_canadianhig_ea52dfd6382ac2685688_20190417044027_scan.json\",\"timer_start\":1555476036.7517,\"Runtime\":\"64.149 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.31MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190417_044027_New-Schedule_canadianhig_ea52dfd6382ac2685688_20190417044027_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102039538,\"Dirs\":null,\"DirCount\":1204,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8465,\"file_count\":9669,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190417_044027_New-Schedule_canadianhig_ea52dfd6382ac2685688_20190417044027_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":18638,\"tablesSizeOnDisk\":9514928,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.43\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7652428,\"File\":\"20190417_044027_New-Schedule_canadianhig_ea52dfd6382ac2685688_20190417044027_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190417_044027_New-Schedule_canadianhig_ea52dfd6382ac2685688_20190417044027_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22552,159916,185632,186656,187680,1899188,2380036,6291084,6299806,6305062,6320630,6334890,6359562,6367858,6369942,6370966,7430846,7431870,7432894,8649258,8688774,8689798,8705614,9268698,9269722,9271930,9277402,9282554,9283578,9285678,9286702,9501362,9502386,9515290]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1555476100,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8465,\"next_archive_dir_index\":3612,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":36,\"tableOffset\":0,\"totalRowOffset\":18330,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1555476036.7534,\"fileOffset\":7652428,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9520780,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10960,\"wp_duplicator_pro_packages\":137364,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1059880,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1216364,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":15816,\"wp_wfknownfilelist\":563084,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfnotifications\":5152,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1555476101,\"stopped_timestamp\":1555476104}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (13, '20190428_222731_New-Schedule_canadianhig', 'dd12a9c130abdae43243_20190428222731', 100, '2019-04-28 22:27:31', 'System', '{\"Created\":\"2019-04-28 22:27:31\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.4\",\"VersionDB\":\"5.6.43\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"13\",\"Name\":\"20190428_222731_New-Schedule_canadianhig\",\"Hash\":\"dd12a9c130abdae43243_20190428222731\",\"NameHash\":\"20190428_222731_New-Schedule_canadianhig_dd12a9c130abdae43243_20190428222731\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190428_222731_New-Schedule_canadianhig_dd12a9c130abdae43243_20190428222731_scan.json\",\"timer_start\":1556490462.3521,\"Runtime\":\"67.904 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.01MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190428_222731_New-Schedule_canadianhig_dd12a9c130abdae43243_20190428222731_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":101725446,\"Dirs\":null,\"DirCount\":1204,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8465,\"file_count\":9624,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190428_222731_New-Schedule_canadianhig_dd12a9c130abdae43243_20190428222731_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":18623,\"tablesSizeOnDisk\":9528544,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.43\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7694450,\"File\":\"20190428_222731_New-Schedule_canadianhig_dd12a9c130abdae43243_20190428222731_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190428_222731_New-Schedule_canadianhig_dd12a9c130abdae43243_20190428222731_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,171204,196920,197944,198968,1910476,2391324,6302372,6311094,6316350,6331918,6346178,6370850,6379146,6381230,6382254,7443798,7444822,7445846,8662626,8702142,8703166,8718982,9282322,9283346,9285554,9291026,9296178,9297202,9299302,9300326,9514986,9516010,9528914]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1556490530,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8465,\"next_archive_dir_index\":3612,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":36,\"tableOffset\":0,\"totalRowOffset\":18623,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1556490462.3538,\"fileOffset\":7694450,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9534404,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":148632,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1061544,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1216780,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":15816,\"wp_wfknownfilelist\":563340,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfnotifications\":5152,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1556490530,\"stopped_timestamp\":1556490533}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (14, '20190506_080551_New-Schedule_canadianhig', 'ace06735a70b976b7028_20190506080551', 100, '2019-05-06 08:05:51', 'System', '{\"Created\":\"2019-05-06 08:05:51\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.4\",\"VersionDB\":\"5.6.43\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"14\",\"Name\":\"20190506_080551_New-Schedule_canadianhig\",\"Hash\":\"ace06735a70b976b7028_20190506080551\",\"NameHash\":\"20190506_080551_New-Schedule_canadianhig_ace06735a70b976b7028_20190506080551\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190506_080551_New-Schedule_canadianhig_ace06735a70b976b7028_20190506080551_scan.json\",\"timer_start\":1557129961.5011,\"Runtime\":\"56.854 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.63MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190506_080551_New-Schedule_canadianhig_ace06735a70b976b7028_20190506080551_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102375154,\"Dirs\":null,\"DirCount\":1204,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8460,\"file_count\":9664,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190506_080551_New-Schedule_canadianhig_ace06735a70b976b7028_20190506080551_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":18597,\"tablesSizeOnDisk\":9538068,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.43\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7670257,\"File\":\"20190506_080551_New-Schedule_canadianhig_ace06735a70b976b7028_20190506080551_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190506_080551_New-Schedule_canadianhig_ace06735a70b976b7028_20190506080551_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,182500,208216,209240,210264,1921772,2402620,6313668,6322390,6327646,6343214,6357474,6382146,6390442,6392526,6393550,7455094,7456118,7457142,8672362,8711878,8712902,8728718,9291838,9292862,9295070,9300542,9305694,9306718,9308818,9309842,9524502,9525526,9538430]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1557130018,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8460,\"next_archive_dir_index\":3612,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":36,\"tableOffset\":0,\"totalRowOffset\":18322,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1557129961.5033,\"fileOffset\":7670257,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9543920,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":159928,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1061544,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1215220,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":15816,\"wp_wfknownfilelist\":563120,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfnotifications\":5152,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1557130019,\"stopped_timestamp\":1557130021}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (15, '20190527_022528_New-Schedule_canadianhig', '7f73f35515edf1769703_20190527022528', 100, '2019-05-27 02:25:28', 'System', '{\"Created\":\"2019-05-27 02:25:28\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.4\",\"VersionDB\":\"5.6.43\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"15\",\"Name\":\"20190527_022528_New-Schedule_canadianhig\",\"Hash\":\"7f73f35515edf1769703_20190527022528\",\"NameHash\":\"20190527_022528_New-Schedule_canadianhig_7f73f35515edf1769703_20190527022528\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190527_022528_New-Schedule_canadianhig_7f73f35515edf1769703_20190527022528_scan.json\",\"timer_start\":1558923940.6154,\"Runtime\":\"63.194 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.03MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190527_022528_New-Schedule_canadianhig_7f73f35515edf1769703_20190527022528_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":101748234,\"Dirs\":null,\"DirCount\":1204,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8460,\"file_count\":9625,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190527_022528_New-Schedule_canadianhig_7f73f35515edf1769703_20190527022528_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":18330,\"tablesSizeOnDisk\":9549344,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.43\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7676539,\"File\":\"20190527_022528_New-Schedule_canadianhig_7f73f35515edf1769703_20190527022528_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190527_022528_New-Schedule_canadianhig_7f73f35515edf1769703_20190527022528_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,193776,219492,220516,221540,1933048,2413896,6324944,6333666,6338922,6354490,6368750,6393422,6401718,6403802,6404826,7466370,7467394,7468418,8683638,8723154,8724178,8739994,9303114,9304138,9306346,9311818,9316970,9317994,9320094,9321118,9535778,9536802,9549706]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1558924003,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8460,\"next_archive_dir_index\":3612,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":36,\"tableOffset\":0,\"totalRowOffset\":18333,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1558923940.6174,\"fileOffset\":7676539,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9555196,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":171204,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1061544,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1215220,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":15816,\"wp_wfknownfilelist\":563120,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfnotifications\":5152,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1558924004,\"stopped_timestamp\":1558924005}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (16, '20190603_081728_New-Schedule_canadianhig', '9b5063a19082c9052148_20190603081728', 100, '2019-06-03 08:17:28', 'System', '{\"Created\":\"2019-06-03 08:17:28\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.4\",\"VersionDB\":\"5.6.44\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"16\",\"Name\":\"20190603_081728_New-Schedule_canadianhig\",\"Hash\":\"9b5063a19082c9052148_20190603081728\",\"NameHash\":\"20190603_081728_New-Schedule_canadianhig_9b5063a19082c9052148_20190603081728\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190603_081728_New-Schedule_canadianhig_9b5063a19082c9052148_20190603081728_scan.json\",\"timer_start\":1559549859.9562,\"Runtime\":\"62.245 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.62MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190603_081728_New-Schedule_canadianhig_9b5063a19082c9052148_20190603081728_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102361789,\"Dirs\":null,\"DirCount\":1225,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8556,\"file_count\":9781,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190603_081728_New-Schedule_canadianhig_9b5063a19082c9052148_20190603081728_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18767,\"tablesSizeOnDisk\":9632180,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.44\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7725031,\"File\":\"20190603_081728_New-Schedule_canadianhig_9b5063a19082c9052148_20190603081728_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190603_081728_New-Schedule_canadianhig_9b5063a19082c9052148_20190603081728_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,205052,230768,231792,232816,1944324,2425172,6336220,6344942,6350198,6365766,6380026,6404698,6412994,6415078,6416102,7477646,7478670,7479694,8709570,8749086,8750110,8767074,9336618,9337642,9339850,9345322,9378090,9394474,9399806,9400830,9402930,9403954,9618614,9619638,9632542]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1559549922,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8556,\"next_archive_dir_index\":3675,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18444,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1559549859.9583,\"fileOffset\":7725031,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9638032,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":182480,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1061544,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1229876,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":16964,\"wp_wfknownfilelist\":569544,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":5332,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1559549923,\"stopped_timestamp\":1559549925}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (17, '20190610_081825_New-Schedule_canadianhig', 'c79e15181a29f1b81525_20190610081825', 100, '2019-06-10 08:18:25', 'System', '{\"Created\":\"2019-06-10 08:18:25\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.4\",\"VersionDB\":\"5.6.44\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"17\",\"Name\":\"20190610_081825_New-Schedule_canadianhig\",\"Hash\":\"c79e15181a29f1b81525_20190610081825\",\"NameHash\":\"20190610_081825_New-Schedule_canadianhig_c79e15181a29f1b81525_20190610081825\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190610_081825_New-Schedule_canadianhig_c79e15181a29f1b81525_20190610081825_scan.json\",\"timer_start\":1560154718.1836,\"Runtime\":\"58.431 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.62MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190610_081825_New-Schedule_canadianhig_c79e15181a29f1b81525_20190610081825_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102367024,\"Dirs\":null,\"DirCount\":1225,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8556,\"file_count\":9781,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190610_081825_New-Schedule_canadianhig_c79e15181a29f1b81525_20190610081825_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18844,\"tablesSizeOnDisk\":9662724,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.44\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7743806,\"File\":\"20190610_081825_New-Schedule_canadianhig_c79e15181a29f1b81525_20190610081825_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190610_081825_New-Schedule_canadianhig_c79e15181a29f1b81525_20190610081825_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,216460,242176,243200,244224,1955732,2436580,6347628,6356350,6361606,6377174,6391434,6416106,6424402,6426486,6427510,7492586,7493610,7494634,8736054,8775570,8776594,8793646,9366982,9368006,9370214,9375686,9408454,9424838,9430350,9431374,9433474,9434498,9649158,9650182,9663086]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1560154776,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8556,\"next_archive_dir_index\":3675,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18537,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1560154718.1854,\"fileOffset\":7743806,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9668576,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":193888,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1065076,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1241420,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":573336,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":5512,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1560154777,\"stopped_timestamp\":1560154780}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (18, '20190624_182703_New-Schedule_canadianhig', '6de00fbe732919e91964_20190624182703', -1, '2019-06-24 18:27:03', 'System', '{\"Created\":\"2019-06-24 18:27:03\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.4\",\"VersionDB\":\"5.6.44\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"18\",\"Name\":\"20190624_182703_New-Schedule_canadianhig\",\"Hash\":\"6de00fbe732919e91964_20190624182703\",\"NameHash\":\"20190624_182703_New-Schedule_canadianhig_6de00fbe732919e91964_20190624182703\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190624_182703_New-Schedule_canadianhig_6de00fbe732919e91964_20190624182703_scan.json\",\"timer_start\":1561400833.1889,\"Runtime\":\"54.226 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"96.96MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190624_182703_New-Schedule_canadianhig_6de00fbe732919e91964_20190624182703_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":101668386,\"Dirs\":null,\"DirCount\":1225,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8556,\"file_count\":9630,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190624_182703_New-Schedule_canadianhig_6de00fbe732919e91964_20190624182703_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18836,\"tablesSizeOnDisk\":9674772,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.44\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7775812,\"File\":\"20190624_182703_New-Schedule_canadianhig_6de00fbe732919e91964_20190624182703_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190624_182703_New-Schedule_canadianhig_6de00fbe732919e91964_20190624182703_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,227868,253584,254608,255632,1967140,2447988,6359036,6367758,6373014,6388582,6402842,6427514,6435810,6437894,6438918,7504618,7505642,7506666,8748086,8787602,8788626,8805678,9379014,9380038,9382246,9387718,9420486,9436870,9442382,9443406,9445506,9446530,9661190,9662214,9675118]},\"Status\":-1,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1561400887,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":true,\"next_archive_file_index\":8556,\"next_archive_dir_index\":3675,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18827,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1561400833.1908,\"fileOffset\":7775812,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9680608,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":205296,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1065700,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1241420,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":573336,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":5512,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":false,\"copied_archive\":false,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":false,\"status_message_details\":\"\",\"started_timestamp\":null,\"stopped_timestamp\":null}],\"active_storage_id\":-1,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (19, '20190703_165717_New-Schedule_canadianhig', 'd5150b1789658fd71452_20190703165717', 100, '2019-07-03 16:57:17', 'System', '{\"Created\":\"2019-07-03 16:57:17\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.4\",\"VersionDB\":\"5.6.44\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"19\",\"Name\":\"20190703_165717_New-Schedule_canadianhig\",\"Hash\":\"d5150b1789658fd71452_20190703165717\",\"NameHash\":\"20190703_165717_New-Schedule_canadianhig_d5150b1789658fd71452_20190703165717\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190703_165717_New-Schedule_canadianhig_d5150b1789658fd71452_20190703165717_scan.json\",\"timer_start\":1562173048.2682,\"Runtime\":\"69.417 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.63MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190703_165717_New-Schedule_canadianhig_d5150b1789658fd71452_20190703165717_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102376014,\"Dirs\":null,\"DirCount\":1228,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8575,\"file_count\":9803,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190703_165717_New-Schedule_canadianhig_d5150b1789658fd71452_20190703165717_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18736,\"tablesSizeOnDisk\":9679888,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.44\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7770395,\"File\":\"20190703_165717_New-Schedule_canadianhig_d5150b1789658fd71452_20190703165717_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190703_165717_New-Schedule_canadianhig_d5150b1789658fd71452_20190703165717_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,239244,264960,265984,267008,1978516,2459364,6370412,6379134,6384390,6399958,6414218,6438890,6447186,6449270,6450294,7515994,7517018,7518042,8753494,8793010,8794034,8811086,9383970,9384994,9387202,9392674,9425442,9441826,9447518,9448542,9450642,9451666,9666326,9667350,9680254]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1562173117,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8575,\"next_archive_dir_index\":3684,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18545,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1562173048.27,\"fileOffset\":7770395,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9685744,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":216672,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1065700,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1235452,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":572884,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":5692,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1562173118,\"stopped_timestamp\":1562173121}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (20, '20190719_031613_New-Schedule_canadianhig', '49ee0455223ad2c25947_20190719031613', 100, '2019-07-19 03:16:13', 'System', '{\"Created\":\"2019-07-19 03:16:13\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.4\",\"VersionDB\":\"5.6.44\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"20\",\"Name\":\"20190719_031613_New-Schedule_canadianhig\",\"Hash\":\"49ee0455223ad2c25947_20190719031613\",\"NameHash\":\"20190719_031613_New-Schedule_canadianhig_49ee0455223ad2c25947_20190719031613\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190719_031613_New-Schedule_canadianhig_49ee0455223ad2c25947_20190719031613_scan.json\",\"timer_start\":1563506179.2469,\"Runtime\":\"59.454 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.22MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190719_031613_New-Schedule_canadianhig_49ee0455223ad2c25947_20190719031613_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":101940559,\"Dirs\":null,\"DirCount\":1228,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8575,\"file_count\":9747,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190719_031613_New-Schedule_canadianhig_49ee0455223ad2c25947_20190719031613_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18586,\"tablesSizeOnDisk\":9703624,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.44\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7778457,\"File\":\"20190719_031613_New-Schedule_canadianhig_49ee0455223ad2c25947_20190719031613_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190719_031613_New-Schedule_canadianhig_49ee0455223ad2c25947_20190719031613_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,250652,276368,277392,278416,1989924,2470772,6381820,6390542,6395798,6411366,6425626,6450298,6458594,6460678,6461702,7527774,7528798,7529822,8774286,8813802,8814826,8831878,9407702,9408726,9410934,9416406,9449174,9465558,9471250,9472274,9474374,9475398,9690058,9691082,9703986]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1563506238,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8575,\"next_archive_dir_index\":3684,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18575,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1563506179.2487,\"fileOffset\":7778457,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9709476,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":228080,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1244464,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":575824,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":5692,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1563506239,\"stopped_timestamp\":1563506242}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (21, '20190728_093059_New-Schedule_canadianhig', '68dc45e20a4e8d636428_20190728093059', 100, '2019-07-28 09:30:59', 'System', '{\"Created\":\"2019-07-28 09:30:59\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.4\",\"VersionDB\":\"5.6.44\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"21\",\"Name\":\"20190728_093059_New-Schedule_canadianhig\",\"Hash\":\"68dc45e20a4e8d636428_20190728093059\",\"NameHash\":\"20190728_093059_New-Schedule_canadianhig_68dc45e20a4e8d636428_20190728093059\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190728_093059_New-Schedule_canadianhig_68dc45e20a4e8d636428_20190728093059_scan.json\",\"timer_start\":1564306263.9665,\"Runtime\":\"66.195 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.65MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190728_093059_New-Schedule_canadianhig_68dc45e20a4e8d636428_20190728093059_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102391730,\"Dirs\":null,\"DirCount\":1230,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8576,\"file_count\":9806,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190728_093059_New-Schedule_canadianhig_68dc45e20a4e8d636428_20190728093059_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18793,\"tablesSizeOnDisk\":9706584,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.44\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7784070,\"File\":\"20190728_093059_New-Schedule_canadianhig_68dc45e20a4e8d636428_20190728093059_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190728_093059_New-Schedule_canadianhig_68dc45e20a4e8d636428_20190728093059_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,262060,287776,288800,289824,2001332,2482180,6393228,6401950,6407206,6422774,6437034,6461706,6470002,6472086,6473110,7539182,7540206,7541230,8779238,8818754,8819778,8836830,9410482,9411506,9413714,9419186,9451954,9468338,9474210,9475234,9477334,9478358,9693018,9694042,9706946]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1564306330,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8576,\"next_archive_dir_index\":3690,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18536,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1564306263.9683,\"fileOffset\":7784070,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9712436,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":239488,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1238008,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":573652,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":5872,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1564306330,\"stopped_timestamp\":1564306333}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (22, '20190804_180225_New-Schedule_canadianhig', '32f599eea0c8d9188142_20190804180225', 100, '2019-08-04 18:02:25', 'System', '{\"Created\":\"2019-08-04 18:02:25\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.4\",\"VersionDB\":\"5.6.44\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"22\",\"Name\":\"20190804_180225_New-Schedule_canadianhig\",\"Hash\":\"32f599eea0c8d9188142_20190804180225\",\"NameHash\":\"20190804_180225_New-Schedule_canadianhig_32f599eea0c8d9188142_20190804180225\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190804_180225_New-Schedule_canadianhig_32f599eea0c8d9188142_20190804180225_scan.json\",\"timer_start\":1564941750.5414,\"Runtime\":\"66.812 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.66MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190804_180225_New-Schedule_canadianhig_32f599eea0c8d9188142_20190804180225_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102401250,\"Dirs\":null,\"DirCount\":1231,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8576,\"file_count\":9807,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190804_180225_New-Schedule_canadianhig_32f599eea0c8d9188142_20190804180225_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18764,\"tablesSizeOnDisk\":9715352,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.44\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7816364,\"File\":\"20190804_180225_New-Schedule_canadianhig_32f599eea0c8d9188142_20190804180225_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190804_180225_New-Schedule_canadianhig_32f599eea0c8d9188142_20190804180225_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,273456,299172,300196,301220,2012728,2493576,6404624,6413346,6418602,6434170,6448430,6473102,6481398,6483482,6484506,7550578,7551602,7552626,8784798,8824314,8825338,8842390,9418702,9419726,9421934,9427406,9460174,9476558,9482970,9483994,9486094,9487118,9701778,9702802,9715706]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1564941817,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8576,\"next_archive_dir_index\":3693,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18568,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1564941750.5433,\"fileOffset\":7816364,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9721196,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":250884,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1232172,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576312,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":6412,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1564941818,\"stopped_timestamp\":1564941818}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (23, '20190904_203653_New-Schedule_canadianhig', '335e339aba13d74e8109_20190904203653', 100, '2019-09-04 20:36:53', 'System', '{\"Created\":\"2019-09-04 20:36:53\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.4\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"23\",\"Name\":\"20190904_203653_New-Schedule_canadianhig\",\"Hash\":\"335e339aba13d74e8109_20190904203653\",\"NameHash\":\"20190904_203653_New-Schedule_canadianhig_335e339aba13d74e8109_20190904203653\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190904_203653_New-Schedule_canadianhig_335e339aba13d74e8109_20190904203653_scan.json\",\"timer_start\":1567629419.131,\"Runtime\":\"62.520 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.33MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190904_203653_New-Schedule_canadianhig_335e339aba13d74e8109_20190904203653_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102055097,\"Dirs\":null,\"DirCount\":1232,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8576,\"file_count\":9752,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190904_203653_New-Schedule_canadianhig_335e339aba13d74e8109_20190904203653_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18584,\"tablesSizeOnDisk\":9726716,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7822798,\"File\":\"20190904_203653_New-Schedule_canadianhig_335e339aba13d74e8109_20190904203653_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190904_203653_New-Schedule_canadianhig_335e339aba13d74e8109_20190904203653_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,284832,310548,311572,312596,2024104,2504952,6416000,6424722,6429978,6445546,6459806,6484478,6492774,6494858,6495882,7561954,7562978,7564002,8796174,8835690,8836714,8853766,9430078,9431102,9433310,9438782,9471550,9487934,9494346,9495370,9497470,9498494,9713154,9714178,9727082]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1567629481,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8576,\"next_archive_dir_index\":3696,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18585,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1567629419.1329,\"fileOffset\":7822798,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9732572,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":262260,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1232172,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576312,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":6412,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1567629482,\"stopped_timestamp\":1567629485}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (24, '20190912_223221_New-Schedule_canadianhig', 'f55904a221c542489276_20190912223221', 100, '2019-09-12 22:32:21', 'System', '{\"Created\":\"2019-09-12 22:32:21\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.6\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"24\",\"Name\":\"20190912_223221_New-Schedule_canadianhig\",\"Hash\":\"f55904a221c542489276_20190912223221\",\"NameHash\":\"20190912_223221_New-Schedule_canadianhig_f55904a221c542489276_20190912223221\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190912_223221_New-Schedule_canadianhig_f55904a221c542489276_20190912223221_scan.json\",\"timer_start\":1568327547.5031,\"Runtime\":\"52.749 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.73MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20190912_223221_New-Schedule_canadianhig_f55904a221c542489276_20190912223221_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102474594,\"Dirs\":null,\"DirCount\":1232,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8577,\"file_count\":9809,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20190912_223221_New-Schedule_canadianhig_f55904a221c542489276_20190912223221_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18916,\"tablesSizeOnDisk\":9751472,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7855265,\"File\":\"20190912_223221_New-Schedule_canadianhig_f55904a221c542489276_20190912223221_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20190912_223221_New-Schedule_canadianhig_f55904a221c542489276_20190912223221_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,296220,321936,322960,323984,2035492,2516340,6427388,6436110,6441366,6456934,6471194,6495866,6504162,6506246,6507270,7573342,7574366,7575390,8820222,8859738,8860762,8877814,9454470,9455494,9457702,9463174,9495942,9512326,9519098,9520122,9522222,9523246,9737906,9738930,9751834]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1568327600,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8577,\"next_archive_dir_index\":3696,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18619,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1568327547.505,\"fileOffset\":7855265,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9757324,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":273648,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1244832,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576656,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":6772,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1568327600,\"stopped_timestamp\":1568327603}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (25, '20191005_065543_New-Schedule_canadianhig', '6a9d4f991e76e6eb6478_20191005065543', 100, '2019-10-05 06:55:43', 'System', '{\"Created\":\"2019-10-05 06:55:43\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.6\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"25\",\"Name\":\"20191005_065543_New-Schedule_canadianhig\",\"Hash\":\"6a9d4f991e76e6eb6478_20191005065543\",\"NameHash\":\"20191005_065543_New-Schedule_canadianhig_6a9d4f991e76e6eb6478_20191005065543\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20191005_065543_New-Schedule_canadianhig_6a9d4f991e76e6eb6478_20191005065543_scan.json\",\"timer_start\":1570258556.5549,\"Runtime\":\"95.836 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.71MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20191005_065543_New-Schedule_canadianhig_6a9d4f991e76e6eb6478_20191005065543_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102459141,\"Dirs\":null,\"DirCount\":1233,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8577,\"file_count\":9810,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20191005_065543_New-Schedule_canadianhig_6a9d4f991e76e6eb6478_20191005065543_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18600,\"tablesSizeOnDisk\":9764916,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7856971,\"File\":\"20191005_065543_New-Schedule_canadianhig_6a9d4f991e76e6eb6478_20191005065543_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20191005_065543_New-Schedule_canadianhig_6a9d4f991e76e6eb6478_20191005065543_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,309664,335380,336404,337428,2048936,2529784,6440832,6449554,6454810,6470378,6484638,6509310,6517606,6519690,6520714,7586786,7587810,7588834,8833666,8873182,8874206,8891258,9467914,9468938,9471146,9476618,9509386,9525770,9532542,9533566,9535666,9536690,9751350,9752374,9765278]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1570258652,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8577,\"next_archive_dir_index\":6165,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18605,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1570258556.5569,\"fileOffset\":7856971,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9770768,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":287092,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1244832,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576656,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":6772,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1570258653,\"stopped_timestamp\":1570258655}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (26, '20191007_220445_New-Schedule_canadianhig', '6372b18e7a371f9f3732_20191007220445', 100, '2019-10-07 22:04:45', 'System', '{\"Created\":\"2019-10-07 22:04:45\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.6\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"26\",\"Name\":\"20191007_220445_New-Schedule_canadianhig\",\"Hash\":\"6372b18e7a371f9f3732_20191007220445\",\"NameHash\":\"20191007_220445_New-Schedule_canadianhig_6372b18e7a371f9f3732_20191007220445\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20191007_220445_New-Schedule_canadianhig_6372b18e7a371f9f3732_20191007220445_scan.json\",\"timer_start\":1570485890.6705,\"Runtime\":\"57.890 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.74MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20191007_220445_New-Schedule_canadianhig_6372b18e7a371f9f3732_20191007220445_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102484957,\"Dirs\":null,\"DirCount\":1233,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8577,\"file_count\":9810,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20191007_220445_New-Schedule_canadianhig_6372b18e7a371f9f3732_20191007220445_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18906,\"tablesSizeOnDisk\":9776336,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7869570,\"File\":\"20191007_220445_New-Schedule_canadianhig_6372b18e7a371f9f3732_20191007220445_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20191007_220445_New-Schedule_canadianhig_6372b18e7a371f9f3732_20191007220445_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,321072,346788,347812,348836,2060344,2541192,6452240,6460962,6466218,6481786,6496046,6520718,6529014,6531098,6532122,7598194,7599218,7600242,8845074,8884590,8885614,8902666,9479322,9480346,9482554,9488026,9520794,9537178,9543950,9544974,9547074,9548098,9762758,9763782,9776686]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1570485948,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8577,\"next_archive_dir_index\":3699,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18599,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1570485890.6724,\"fileOffset\":7869570,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9782176,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":298500,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1244832,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576656,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":6772,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1570485949,\"stopped_timestamp\":1570485949}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (27, '20191015_155854_New-Schedule_canadianhig', '736ab13b8e755e9a8635_20191015155854', 100, '2019-10-15 15:58:54', 'System', '{\"Created\":\"2019-10-15 15:58:54\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.6\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"27\",\"Name\":\"20191015_155854_New-Schedule_canadianhig\",\"Hash\":\"736ab13b8e755e9a8635_20191015155854\",\"NameHash\":\"20191015_155854_New-Schedule_canadianhig_736ab13b8e755e9a8635_20191015155854\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20191015_155854_New-Schedule_canadianhig_736ab13b8e755e9a8635_20191015155854_scan.json\",\"timer_start\":1571155139.5289,\"Runtime\":\"58.765 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.72MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20191015_155854_New-Schedule_canadianhig_736ab13b8e755e9a8635_20191015155854_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102466716,\"Dirs\":null,\"DirCount\":1233,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8577,\"file_count\":9810,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20191015_155854_New-Schedule_canadianhig_736ab13b8e755e9a8635_20191015155854_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18898,\"tablesSizeOnDisk\":9786884,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7884766,\"File\":\"20191015_155854_New-Schedule_canadianhig_736ab13b8e755e9a8635_20191015155854_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20191015_155854_New-Schedule_canadianhig_736ab13b8e755e9a8635_20191015155854_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,332468,358184,359208,360232,2071740,2552588,6463636,6472358,6477614,6493182,6507442,6532114,6540410,6542494,6543518,7609590,7610614,7611638,8855446,8894962,8895986,8913038,9489694,9490718,9492926,9498398,9531166,9547550,9554502,9555526,9557626,9558650,9773310,9774334,9787238]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1571155198,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8577,\"next_archive_dir_index\":3699,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18606,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1571155139.5309,\"fileOffset\":7884766,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9792728,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":309896,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1243808,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576656,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":6952,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1571155198,\"stopped_timestamp\":1571155201}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (28, '20191101_040615_New-Schedule_canadianhig', '7e3c5e63f5e8eb306659_20191101040615', 100, '2019-11-01 04:06:15', 'System', '{\"Created\":\"2019-11-01 04:06:15\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.7\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"28\",\"Name\":\"20191101_040615_New-Schedule_canadianhig\",\"Hash\":\"7e3c5e63f5e8eb306659_20191101040615\",\"NameHash\":\"20191101_040615_New-Schedule_canadianhig_7e3c5e63f5e8eb306659_20191101040615\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20191101_040615_New-Schedule_canadianhig_7e3c5e63f5e8eb306659_20191101040615_scan.json\",\"timer_start\":1572581181.0301,\"Runtime\":\"57.297 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.58MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20191101_040615_New-Schedule_canadianhig_7e3c5e63f5e8eb306659_20191101040615_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102319622,\"Dirs\":null,\"DirCount\":1234,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8577,\"file_count\":9811,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20191101_040615_New-Schedule_canadianhig_7e3c5e63f5e8eb306659_20191101040615_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18897,\"tablesSizeOnDisk\":9798440,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7897558,\"File\":\"20191101_040615_New-Schedule_canadianhig_7e3c5e63f5e8eb306659_20191101040615_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20191101_040615_New-Schedule_canadianhig_7e3c5e63f5e8eb306659_20191101040615_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,343844,369560,370584,371608,2083116,2563964,6475012,6483734,6488990,6504558,6518818,6543490,6551786,6553870,6554894,7620966,7621990,7623014,8866822,8906338,8907362,8924414,9501070,9502094,9504302,9509774,9542542,9558926,9566058,9567082,9569182,9570206,9784866,9785890,9798794]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1572581238,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8577,\"next_archive_dir_index\":3702,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18612,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1572581181.0321,\"fileOffset\":7897558,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9804284,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":321272,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1243808,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576656,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":7132,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1572581238,\"stopped_timestamp\":1572581241}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (29, '20191103_213215_New-Schedule_canadianhig', '63962b67d9f89bd71386_20191103213215', 100, '2019-11-03 21:32:15', 'System', '{\"Created\":\"2019-11-03 21:32:15\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.7\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"29\",\"Name\":\"20191103_213215_New-Schedule_canadianhig\",\"Hash\":\"63962b67d9f89bd71386_20191103213215\",\"NameHash\":\"20191103_213215_New-Schedule_canadianhig_63962b67d9f89bd71386_20191103213215\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20191103_213215_New-Schedule_canadianhig_63962b67d9f89bd71386_20191103213215_scan.json\",\"timer_start\":1572816740.9061,\"Runtime\":\"73.181 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.56MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20191103_213215_New-Schedule_canadianhig_63962b67d9f89bd71386_20191103213215_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102297501,\"Dirs\":null,\"DirCount\":1234,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8577,\"file_count\":9811,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20191103_213215_New-Schedule_canadianhig_63962b67d9f89bd71386_20191103213215_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18875,\"tablesSizeOnDisk\":9808812,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7900461,\"File\":\"20191103_213215_New-Schedule_canadianhig_63962b67d9f89bd71386_20191103213215_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20191103_213215_New-Schedule_canadianhig_63962b67d9f89bd71386_20191103213215_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,355232,380948,381972,382996,2094504,2575352,6486400,6495122,6500378,6515946,6530206,6554878,6563174,6565258,6566282,7632354,7633378,7634402,8877186,8916702,8917726,8934778,9511434,9512458,9514666,9520138,9552906,9569290,9576422,9577446,9579546,9580570,9795230,9796254,9809158]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1572816814,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8577,\"next_archive_dir_index\":4936,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18605,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1572816740.9081,\"fileOffset\":7900461,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9814648,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":332660,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1242784,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576656,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":7132,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1572816815,\"stopped_timestamp\":1572816815}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (30, '20191112_215320_New-Schedule_canadianhig', '73757bd5bfe861885295_20191112215320', 100, '2019-11-12 21:53:20', 'System', '{\"Created\":\"2019-11-12 21:53:20\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.7\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"30\",\"Name\":\"20191112_215320_New-Schedule_canadianhig\",\"Hash\":\"73757bd5bfe861885295_20191112215320\",\"NameHash\":\"20191112_215320_New-Schedule_canadianhig_73757bd5bfe861885295_20191112215320\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20191112_215320_New-Schedule_canadianhig_73757bd5bfe861885295_20191112215320_scan.json\",\"timer_start\":1573595605.8002,\"Runtime\":\"65.038 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.24MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20191112_215320_New-Schedule_canadianhig_73757bd5bfe861885295_20191112215320_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":101962047,\"Dirs\":null,\"DirCount\":1234,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8577,\"file_count\":9754,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20191112_215320_New-Schedule_canadianhig_73757bd5bfe861885295_20191112215320_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18619,\"tablesSizeOnDisk\":9820180,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7914738,\"File\":\"20191112_215320_New-Schedule_canadianhig_73757bd5bfe861885295_20191112215320_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20191112_215320_New-Schedule_canadianhig_73757bd5bfe861885295_20191112215320_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,366608,392324,393348,394372,2105880,2586728,6497776,6506498,6511754,6527322,6541582,6566254,6574550,6576634,6577658,7643730,7644754,7645778,8888562,8928078,8929102,8946154,9522810,9523834,9526042,9531514,9564282,9580666,9587798,9588822,9590922,9591946,9806606,9807630,9820534]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1573595670,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8577,\"next_archive_dir_index\":3702,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18622,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1573595605.8028,\"fileOffset\":7914738,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9826024,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":344036,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1242784,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576656,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":7132,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1573595671,\"stopped_timestamp\":1573595673}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (31, '20191118_083244_New-Schedule_canadianhig', '7dfafbc0b4060ac16442_20191118083244', 100, '2019-11-18 08:32:44', 'System', '{\"Created\":\"2019-11-18 08:32:44\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.7\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":\"31\",\"Name\":\"20191118_083244_New-Schedule_canadianhig\",\"Hash\":\"7dfafbc0b4060ac16442_20191118083244\",\"NameHash\":\"20191118_083244_New-Schedule_canadianhig_7dfafbc0b4060ac16442_20191118083244\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20191118_083244_New-Schedule_canadianhig_7dfafbc0b4060ac16442_20191118083244_scan.json\",\"timer_start\":1574065969.5507,\"Runtime\":\"63.323 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.65MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20191118_083244_New-Schedule_canadianhig_7dfafbc0b4060ac16442_20191118083244_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102396246,\"Dirs\":null,\"DirCount\":1234,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8576,\"file_count\":9810,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20191118_083244_New-Schedule_canadianhig_7dfafbc0b4060ac16442_20191118083244_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18786,\"tablesSizeOnDisk\":9821236,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7907397,\"File\":\"20191118_083244_New-Schedule_canadianhig_7dfafbc0b4060ac16442_20191118083244_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20191118_083244_New-Schedule_canadianhig_7dfafbc0b4060ac16442_20191118083244_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,377984,403700,404724,405748,2117256,2598104,6509152,6517874,6523130,6538698,6552958,6577630,6585926,6588010,6589034,7655106,7656130,7657154,8891914,8931430,8932454,8949506,9523686,9524710,9526918,9532390,9565158,9581542,9588854,9589878,9591978,9593002,9807662,9808686,9821590]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1574066032,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8576,\"next_archive_dir_index\":3702,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18563,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1574065969.553,\"fileOffset\":7907397,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9827080,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":355412,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1234760,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":574180,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":7312,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1574066033,\"stopped_timestamp\":1574066035}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (32, '20191205_094654_New-Schedule_canadianhig', '41e44e0a9dbd398c3058_20191205094654', 100, '2019-12-05 09:46:54', 'System', '{\"Created\":\"2019-12-05 09:46:54\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.7\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"7.1.33\",\"VersionOS\":\"Linux\",\"ID\":\"32\",\"Name\":\"20191205_094654_New-Schedule_canadianhig\",\"Hash\":\"41e44e0a9dbd398c3058_20191205094654\",\"NameHash\":\"20191205_094654_New-Schedule_canadianhig_41e44e0a9dbd398c3058_20191205094654\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20191205_094654_New-Schedule_canadianhig_41e44e0a9dbd398c3058_20191205094654_scan.json\",\"timer_start\":1575539219.7285768985748291015625,\"Runtime\":\"55.571 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.25MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20191205_094654_New-Schedule_canadianhig_41e44e0a9dbd398c3058_20191205094654_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":101971646,\"Dirs\":null,\"DirCount\":1235,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8576,\"file_count\":9755,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20191205_094654_New-Schedule_canadianhig_41e44e0a9dbd398c3058_20191205094654_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18629,\"tablesSizeOnDisk\":9843124,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7958471,\"File\":\"20191205_094654_New-Schedule_canadianhig_41e44e0a9dbd398c3058_20191205094654_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20191205_094654_New-Schedule_canadianhig_41e44e0a9dbd398c3058_20191205094654_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,389428,415144,416168,417192,2128700,2609548,6520596,6529318,6534574,6550142,6564402,6589074,6597370,6599454,6600478,7666550,7667574,7668598,8911230,8950746,8951770,8968822,9545406,9546430,9548638,9554110,9586878,9603262,9610754,9611778,9613878,9614902,9829562,9830586,9843490]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1575539275,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8576,\"next_archive_dir_index\":3705,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18635,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1575539219.73034191131591796875,\"fileOffset\":7958471,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9848980,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":366856,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1242632,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576584,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":7492,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1575539275,\"stopped_timestamp\":1575539276}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (33, '20191213_180414_New-Schedule_canadianhig', 'f826f6041611ed759153_20191213180414', 100, '2019-12-13 18:04:14', 'System', '{\"Created\":\"2019-12-13 18:04:14\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.7\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"7.1.33\",\"VersionOS\":\"Linux\",\"ID\":\"33\",\"Name\":\"20191213_180414_New-Schedule_canadianhig\",\"Hash\":\"f826f6041611ed759153_20191213180414\",\"NameHash\":\"20191213_180414_New-Schedule_canadianhig_f826f6041611ed759153_20191213180414\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20191213_180414_New-Schedule_canadianhig_f826f6041611ed759153_20191213180414_scan.json\",\"timer_start\":1576260258.5574429035186767578125,\"Runtime\":\"56.551 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.73MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20191213_180414_New-Schedule_canadianhig_f826f6041611ed759153_20191213180414_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102479110,\"Dirs\":null,\"DirCount\":1235,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8576,\"file_count\":9811,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20191213_180414_New-Schedule_canadianhig_f826f6041611ed759153_20191213180414_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":13355,\"tablesSizeOnDisk\":8835320,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7388031,\"File\":\"20191213_180414_New-Schedule_canadianhig_f826f6041611ed759153_20191213180414_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20191213_180414_New-Schedule_canadianhig_f826f6041611ed759153_20191213180414_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,400860,426576,427600,428624,2140132,2620980,6532028,6540750,6546006,6561574,6575834,6600506,6608802,6610886,6611910,7677982,7679006,7680030,7903458,7942974,7943998,7961050,8537634,8538658,8540866,8546338,8579106,8595490,8602982,8604006,8606106,8607130,8821790,8822814,8835718]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1576260314,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8576,\"next_archive_dir_index\":3705,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":13356,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1576260258.5588209629058837890625,\"fileOffset\":7388031,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":8841208,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":378288,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":223428,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576584,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":7492,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1576260315,\"stopped_timestamp\":1576260317}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (34, '20191215_205143_New-Schedule_canadianhig', '8407b95c94ae4df42640_20191215205143', 100, '2019-12-15 20:51:43', 'System', '{\"Created\":\"2019-12-15 20:51:43\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.8\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"7.1.33\",\"VersionOS\":\"Linux\",\"ID\":\"34\",\"Name\":\"20191215_205143_New-Schedule_canadianhig\",\"Hash\":\"8407b95c94ae4df42640_20191215205143\",\"NameHash\":\"20191215_205143_New-Schedule_canadianhig_8407b95c94ae4df42640_20191215205143\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20191215_205143_New-Schedule_canadianhig_8407b95c94ae4df42640_20191215205143_scan.json\",\"timer_start\":1576443108.5001900196075439453125,\"Runtime\":\"56.350 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.68MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20191215_205143_New-Schedule_canadianhig_8407b95c94ae4df42640_20191215205143_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102421705,\"Dirs\":null,\"DirCount\":1235,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8576,\"file_count\":9811,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20191215_205143_New-Schedule_canadianhig_8407b95c94ae4df42640_20191215205143_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18625,\"tablesSizeOnDisk\":9869372,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7982650,\"File\":\"20191215_205143_New-Schedule_canadianhig_8407b95c94ae4df42640_20191215205143_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20191215_205143_New-Schedule_canadianhig_8407b95c94ae4df42640_20191215205143_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,412284,438000,439024,440048,2151556,2632404,6543452,6552174,6557430,6572998,6587258,6611930,6620226,6622310,6623334,7689406,7690430,7691454,8937158,8976674,8977698,8994750,9571334,9572358,9574566,9580038,9612806,9629190,9637042,9638066,9640166,9641190,9855850,9856874,9869778]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1576443164,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8576,\"next_archive_dir_index\":3705,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18628,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1576443108.5017449855804443359375,\"fileOffset\":7982650,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9875268,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":389712,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1245704,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576584,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":7852,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1576443165,\"stopped_timestamp\":1576443165}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (35, '20191224_113818_New-Schedule_canadianhig', 'c69ddd62ee3994fe7708_20191224113818', 100, '2019-12-24 11:38:18', 'System', '{\"Created\":\"2019-12-24 11:38:18\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.8\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"7.1.33\",\"VersionOS\":\"Linux\",\"ID\":\"35\",\"Name\":\"20191224_113818_New-Schedule_canadianhig\",\"Hash\":\"c69ddd62ee3994fe7708_20191224113818\",\"NameHash\":\"20191224_113818_New-Schedule_canadianhig_c69ddd62ee3994fe7708_20191224113818\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20191224_113818_New-Schedule_canadianhig_c69ddd62ee3994fe7708_20191224113818_scan.json\",\"timer_start\":1577187504.0002930164337158203125,\"Runtime\":\"67.940 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.69MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20191224_113818_New-Schedule_canadianhig_c69ddd62ee3994fe7708_20191224113818_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102440385,\"Dirs\":null,\"DirCount\":1235,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8576,\"file_count\":9811,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20191224_113818_New-Schedule_canadianhig_c69ddd62ee3994fe7708_20191224113818_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18635,\"tablesSizeOnDisk\":9880784,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7996395,\"File\":\"20191224_113818_New-Schedule_canadianhig_c69ddd62ee3994fe7708_20191224113818_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20191224_113818_New-Schedule_canadianhig_c69ddd62ee3994fe7708_20191224113818_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,423696,449412,450436,451460,2162968,2643816,6554864,6563586,6568842,6584410,6598670,6623342,6631638,6633722,6634746,7700818,7701842,7702866,8948570,8988086,8989110,9006162,9582746,9583770,9585978,9591450,9624218,9640602,9648454,9649478,9651578,9652602,9867262,9868286,9881190]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1577187571,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8576,\"next_archive_dir_index\":4940,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18641,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1577187504.0020210742950439453125,\"fileOffset\":7996395,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9886680,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":401124,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1245704,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576584,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":7852,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1577187572,\"stopped_timestamp\":1577187573}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (36, '20191231_181306_New-Schedule_canadianhig', 'd5425220dc460cde1157_20191231181306', 100, '2019-12-31 18:13:06', 'System', '{\"Created\":\"2019-12-31 18:13:06\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.8\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"7.1.33\",\"VersionOS\":\"Linux\",\"ID\":\"36\",\"Name\":\"20191231_181306_New-Schedule_canadianhig\",\"Hash\":\"d5425220dc460cde1157_20191231181306\",\"NameHash\":\"20191231_181306_New-Schedule_canadianhig_d5425220dc460cde1157_20191231181306\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20191231_181306_New-Schedule_canadianhig_d5425220dc460cde1157_20191231181306_scan.json\",\"timer_start\":1577815991.7454268932342529296875,\"Runtime\":\"65.157 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.7MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20191231_181306_New-Schedule_canadianhig_d5425220dc460cde1157_20191231181306_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102442004,\"Dirs\":null,\"DirCount\":1235,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8576,\"file_count\":9811,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20191231_181306_New-Schedule_canadianhig_d5425220dc460cde1157_20191231181306_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18866,\"tablesSizeOnDisk\":9892212,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":7996155,\"File\":\"20191231_181306_New-Schedule_canadianhig_d5425220dc460cde1157_20191231181306_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20191231_181306_New-Schedule_canadianhig_d5425220dc460cde1157_20191231181306_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,435116,460832,461856,462880,2174388,2655236,6566284,6575006,6580262,6595830,6610090,6634762,6643058,6645142,6646166,7712238,7713262,7714286,8959990,8999506,9000530,9017582,9594166,9595190,9597398,9602870,9635638,9652022,9659874,9660898,9662998,9664022,9878682,9879706,9892610]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1577816056,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8576,\"next_archive_dir_index\":3705,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18597,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1577815991.74719905853271484375,\"fileOffset\":7996155,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9898100,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":412544,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1245704,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576584,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":7852,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1577816057,\"stopped_timestamp\":1577816059}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (37, '20200106_225056_New-Schedule_canadianhig', 'e15e3ad234f129081086_20200106225056', 100, '2020-01-06 22:50:56', 'System', '{\"Created\":\"2020-01-06 22:50:56\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.8\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"7.1.33\",\"VersionOS\":\"Linux\",\"ID\":\"37\",\"Name\":\"20200106_225056_New-Schedule_canadianhig\",\"Hash\":\"e15e3ad234f129081086_20200106225056\",\"NameHash\":\"20200106_225056_New-Schedule_canadianhig_e15e3ad234f129081086_20200106225056\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20200106_225056_New-Schedule_canadianhig_e15e3ad234f129081086_20200106225056_scan.json\",\"timer_start\":1578351061.385654926300048828125,\"Runtime\":\"64.255 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.69MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20200106_225056_New-Schedule_canadianhig_e15e3ad234f129081086_20200106225056_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102437686,\"Dirs\":null,\"DirCount\":1237,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8576,\"file_count\":9813,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20200106_225056_New-Schedule_canadianhig_e15e3ad234f129081086_20200106225056_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18831,\"tablesSizeOnDisk\":9903616,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":8019456,\"File\":\"20200106_225056_New-Schedule_canadianhig_e15e3ad234f129081086_20200106225056_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20200106_225056_New-Schedule_canadianhig_e15e3ad234f129081086_20200106225056_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,446524,472240,473264,474288,2185796,2666644,6577692,6586414,6591670,6607238,6621498,6646170,6654466,6656550,6657574,7723646,7724670,7725694,8971398,9010914,9011938,9028990,9605574,9606598,9608806,9614278,9647046,9663430,9671282,9672306,9674406,9675430,9890090,9891114,9904018]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1578351125,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8576,\"next_archive_dir_index\":3711,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18622,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1578351061.387486934661865234375,\"fileOffset\":8019456,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9909508,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":423952,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1245704,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576584,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":7852,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1578351126,\"stopped_timestamp\":1578351129}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (38, '20200129_234905_New-Schedule_canadianhig', '6222ecd0002c01b17899_20200129234905', 100, '2020-01-29 23:49:05', 'System', '{\"Created\":\"2020-01-29 23:49:05\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.8\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"7.1.33\",\"VersionOS\":\"Linux\",\"ID\":\"38\",\"Name\":\"20200129_234905_New-Schedule_canadianhig\",\"Hash\":\"6222ecd0002c01b17899_20200129234905\",\"NameHash\":\"20200129_234905_New-Schedule_canadianhig_6222ecd0002c01b17899_20200129234905\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20200129_234905_New-Schedule_canadianhig_6222ecd0002c01b17899_20200129234905_scan.json\",\"timer_start\":1580341750.63424396514892578125,\"Runtime\":\"73.812 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.28MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20200129_234905_New-Schedule_canadianhig_6222ecd0002c01b17899_20200129234905_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102006965,\"Dirs\":null,\"DirCount\":1237,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8576,\"file_count\":9757,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20200129_234905_New-Schedule_canadianhig_6222ecd0002c01b17899_20200129234905_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18834,\"tablesSizeOnDisk\":9915096,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":8044103,\"File\":\"20200129_234905_New-Schedule_canadianhig_6222ecd0002c01b17899_20200129234905_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20200129_234905_New-Schedule_canadianhig_6222ecd0002c01b17899_20200129234905_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,457968,483684,484708,485732,2197240,2678088,6589136,6597858,6603114,6618682,6632942,6657614,6665910,6667994,6669018,7735090,7736114,7737138,8982842,9022358,9023382,9040434,9617018,9618042,9620250,9625722,9658490,9674874,9682726,9683750,9685850,9686874,9901534,9902558,9915462]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1580341824,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8576,\"next_archive_dir_index\":4948,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18831,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1580341750.6359040737152099609375,\"fileOffset\":8044103,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9920952,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":435396,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1245704,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576584,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":7852,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1580341825,\"stopped_timestamp\":1580341826}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (39, '20200203_100715_New-Schedule_canadianhig', '1fadbbb697a1258f6096_20200203100715', 100, '2020-02-03 10:07:15', 'System', '{\"Created\":\"2020-02-03 10:07:15\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.8\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"7.1.33\",\"VersionOS\":\"Linux\",\"ID\":\"39\",\"Name\":\"20200203_100715_New-Schedule_canadianhig\",\"Hash\":\"1fadbbb697a1258f6096_20200203100715\",\"NameHash\":\"20200203_100715_New-Schedule_canadianhig_1fadbbb697a1258f6096_20200203100715\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20200203_100715_New-Schedule_canadianhig_1fadbbb697a1258f6096_20200203100715_scan.json\",\"timer_start\":1580724439.5152819156646728515625,\"Runtime\":\"64.764 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.71MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20200203_100715_New-Schedule_canadianhig_1fadbbb697a1258f6096_20200203100715_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102455806,\"Dirs\":null,\"DirCount\":1238,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8577,\"file_count\":9815,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20200203_100715_New-Schedule_canadianhig_1fadbbb697a1258f6096_20200203100715_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18622,\"tablesSizeOnDisk\":9926516,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":8043171,\"File\":\"20200203_100715_New-Schedule_canadianhig_1fadbbb697a1258f6096_20200203100715_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20200203_100715_New-Schedule_canadianhig_1fadbbb697a1258f6096_20200203100715_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,469388,495104,496128,497152,2208660,2689508,6600556,6609278,6614534,6630102,6644362,6669034,6677330,6679414,6680438,7746510,7747534,7748558,8994262,9033778,9034802,9051854,9628438,9629462,9631670,9637142,9669910,9686294,9694146,9695170,9697270,9698294,9912954,9913978,9926882]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1580724504,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8577,\"next_archive_dir_index\":3714,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18627,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1580724439.5169909000396728515625,\"fileOffset\":8043171,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9932372,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":446816,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1245704,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576584,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":7852,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1580724504,\"stopped_timestamp\":1580724506}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (40, '20200214_003303_New-Schedule_canadianhig', 'bceed745db6701451406_20200214003303', 100, '2020-02-14 00:33:03', 'System', '{\"Created\":\"2020-02-14 00:33:03\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.8\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"7.1.33\",\"VersionOS\":\"Linux\",\"ID\":\"40\",\"Name\":\"20200214_003303_New-Schedule_canadianhig\",\"Hash\":\"bceed745db6701451406_20200214003303\",\"NameHash\":\"20200214_003303_New-Schedule_canadianhig_bceed745db6701451406_20200214003303\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20200214_003303_New-Schedule_canadianhig_bceed745db6701451406_20200214003303_scan.json\",\"timer_start\":1581640388.5088160037994384765625,\"Runtime\":\"69.970 sec.\",\"ExeSize\":\"36.58KB\",\"ZipSize\":\"97.31MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20200214_003303_New-Schedule_canadianhig_bceed745db6701451406_20200214003303_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":102032478,\"Dirs\":null,\"DirCount\":1238,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8577,\"file_count\":9759,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20200214_003303_New-Schedule_canadianhig_bceed745db6701451406_20200214003303_installer.php\",\"Size\":37460,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18835,\"tablesSizeOnDisk\":9937296,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":8080370,\"File\":\"20200214_003303_New-Schedule_canadianhig_bceed745db6701451406_20200214003303_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20200214_003303_New-Schedule_canadianhig_bceed745db6701451406_20200214003303_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572,480812,506528,507552,508576,2220084,2700932,6611980,6620702,6625958,6641526,6655786,6680458,6688754,6690838,6691862,7757934,7758958,7759982,9004818,9044334,9045358,9062410,9639070,9640094,9642302,9647774,9680542,9696926,9704958,9705982,9708082,9709106,9923766,9924790,9937694]},\"Status\":100,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1581640458,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":8577,\"next_archive_dir_index\":4952,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":38,\"tableOffset\":0,\"totalRowOffset\":18834,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1581640388.5103790760040283203125,\"fileOffset\":8080370,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9943184,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":458240,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1244836,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576660,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":8032,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1581640459,\"stopped_timestamp\":1581640459}],\"active_storage_id\":-2,\"template_id\":-1,\"template_name\":\"Default\"}'),
 (41, '20200305_002753_New-Schedule_canadianhig', '37d5e3b506cda6849908_20200305002753', 20, '2020-03-05 00:27:53', 'System', '{\"Created\":\"2020-03-05 00:27:53\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.8\",\"VersionDB\":\"5.6.45\",\"VersionPHP\":\"7.1.33\",\"VersionOS\":\"Linux\",\"ID\":\"41\",\"Name\":\"20200305_002753_New-Schedule_canadianhig\",\"Hash\":\"37d5e3b506cda6849908_20200305002753\",\"NameHash\":\"20200305_002753_New-Schedule_canadianhig_37d5e3b506cda6849908_20200305002753\",\"Type\":1,\"Notes\":\"Created by schedule New Schedule\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20200305_002753_New-Schedule_canadianhig_37d5e3b506cda6849908_20200305002753_scan.json\",\"timer_start\":1583368079.1870479583740234375,\"Runtime\":null,\"ExeSize\":null,\"ZipSize\":0,\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20200305_002753_New-Schedule_canadianhig_37d5e3b506cda6849908_20200305002753_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":192392497,\"Dirs\":null,\"DirCount\":1239,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8577,\"file_count\":-1,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false},\"Multisite\":{\"FilterSites\":[]},\"Installer\":{\"File\":\"20200305_002753_New-Schedule_canadianhig_37d5e3b506cda6849908_20200305002753_installer.php\",\"Size\":0,\"OptsSecureOn\":null,\"OptsSecurePass\":null,\"OptsSkipScan\":null,\"OptsDBHost\":null,\"OptsDBName\":null,\"OptsDBUser\":null,\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":false,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":39,\"tablesFinalCount\":39,\"tablesRowCount\":18627,\"tablesSizeOnDisk\":9948724,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.45\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":null,\"File\":\"20200305_002753_New-Schedule_canadianhig_37d5e3b506cda6849908_20200305002753_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":null,\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\\/20200305_002753_New-Schedule_canadianhig_37d5e3b506cda6849908_20200305002753_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,4096,11592,22572],\"intFieldsStruct\":{\"wp_commentmeta\":{\"meta_id\":\"NULL\",\"comment_id\":\"0\"},\"wp_comments\":{\"comment_ID\":\"NULL\",\"comment_post_ID\":\"0\",\"comment_karma\":\"0\",\"comment_parent\":\"0\",\"user_id\":\"0\"},\"wp_duplicator_pro_entities\":{\"id\":\"NULL\"}}},\"Status\":20,\"schedule_id\":\"6\",\"build_progress\":{\"thread_start_time\":1583368084,\"initialized\":true,\"installer_built\":false,\"archive_started\":false,\"archive_has_database\":false,\"archive_built\":false,\"database_script_built\":false,\"failed\":false,\"next_archive_file_index\":0,\"next_archive_dir_index\":0,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":0,\"tableOffset\":0,\"totalRowOffset\":0,\"chunkIndex\":null,\"validationStage1\":false,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":false,\"tablesToProcess\":[\"wp_commentmeta\",\"wp_comments\",\"wp_duplicator_pro_entities\",\"wp_duplicator_pro_packages\",\"wp_layerslider\",\"wp_layerslider_revisions\",\"wp_links\",\"wp_options\",\"wp_postmeta\",\"wp_posts\",\"wp_term_relationships\",\"wp_term_taxonomy\",\"wp_termmeta\",\"wp_terms\",\"wp_usermeta\",\"wp_users\",\"wp_wfblockediplog\",\"wp_wfblocks7\",\"wp_wfconfig\",\"wp_wfcrawlers\",\"wp_wffilechanges\",\"wp_wffilemods\",\"wp_wfhits\",\"wp_wfhoover\",\"wp_wfissues\",\"wp_wfknownfilelist\",\"wp_wflivetraffichuman\",\"wp_wflocs\",\"wp_wflogins\",\"wp_wfls_2fa_secrets\",\"wp_wfls_settings\",\"wp_wfnotifications\",\"wp_wfpendingissues\",\"wp_wfreversecache\",\"wp_wfsnipcache\",\"wp_wfstatus\",\"wp_wftrafficrates\",\"wp_yoast_seo_links\",\"wp_yoast_seo_meta\"],\"startTime\":1583368079.1890399456024169921875,\"fileOffset\":20028,\"wasInterrupted\":true,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9954616,\"tablesSchemaSizes\":{\"wp_commentmeta\":4096,\"wp_comments\":7496,\"wp_duplicator_pro_entities\":10980,\"wp_duplicator_pro_packages\":469672,\"wp_layerslider\":25716,\"wp_layerslider_revisions\":1024,\"wp_links\":1024,\"wp_options\":1711508,\"wp_postmeta\":480848,\"wp_posts\":3911048,\"wp_term_relationships\":8722,\"wp_term_taxonomy\":5256,\"wp_termmeta\":15568,\"wp_terms\":14260,\"wp_usermeta\":24672,\"wp_users\":8296,\"wp_wfblockediplog\":2084,\"wp_wfblocks7\":1024,\"wp_wfconfig\":1066072,\"wp_wfcrawlers\":1024,\"wp_wffilechanges\":1024,\"wp_wffilemods\":1244836,\"wp_wfhits\":39516,\"wp_wfhoover\":1024,\"wp_wfissues\":17052,\"wp_wfknownfilelist\":576660,\"wp_wflivetraffichuman\":1024,\"wp_wflocs\":2208,\"wp_wflogins\":5472,\"wp_wfls_2fa_secrets\":32768,\"wp_wfls_settings\":16384,\"wp_wfnotifications\":8032,\"wp_wfpendingissues\":1024,\"wp_wfreversecache\":2100,\"wp_wfsnipcache\":1024,\"wp_wfstatus\":214660,\"wp_wftrafficrates\":1024,\"wp_yoast_seo_links\":12904,\"wp_yoast_seo_meta\":5490}},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":false,\"copied_archive\":false,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":false,\"status_message_details\":\"\",\"started_timestamp\":null,\"stopped_timestamp\":null}],\"active_storage_id\":-1,\"template_id\":-1,\"template_name\":\"Default\"}');

/* INSERT TABLE DATA: wp_layerslider */
INSERT INTO `wp_layerslider` VALUES(1, 1, 'Home Page', '', '{\"properties\":{\"title\":\"Home Page\",\"slug\":\"\",\"sliderVersion\":\"6.7.6\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"responsive\",\"width\":1170,\"height\":585,\"maxwidth\":\"\",\"responsiveunder\":\"\",\"fullSizeMode\":\"normal\",\"fitScreenWidth\":true,\"allowFullscreen\":true,\"maxRatio\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"\",\"hideover\":\"\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":\"enabled\",\"keybnav\":true,\"touchnav\":true,\"playByScrollSpeed\":\"1\",\"loops\":\"0\",\"forceloopnum\":true,\"skin\":\"v6\",\"sliderfadeinduration\":\"350\",\"sliderclass\":\"\",\"sliderstyle\":\"margin-bottom: 0px;\",\"backgroundcolor\":\"\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"auto\",\"circletimer\":true,\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":true,\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"popupPositionHorizontal\":\"center\",\"popupPositionVertical\":\"middle\",\"popupWidth\":\"640\",\"popupHeight\":\"360\",\"popupDistanceLeft\":\"10\",\"popupDistanceRight\":\"10\",\"popupDistanceTop\":\"10\",\"popupDistanceBottom\":\"10\",\"popupShowOnTimeout\":\"\",\"popupShowOnIdle\":\"\",\"popupShowOnScroll\":\"\",\"popupShowOnClick\":\"\",\"popupCloseOnTimeout\":\"\",\"popupCloseOnScroll\":\"\",\"popup_repeat\":true,\"popup_repeat_days\":\"\",\"popupShowOnce\":true,\"popup_pages_custom\":\"\",\"popup_pages_exclude\":\"\",\"popup_roles_administrator\":true,\"popup_roles_editor\":true,\"popup_roles_author\":true,\"popup_roles_contributor\":true,\"popup_roles_subscriber\":true,\"popup_roles_visitor\":true,\"popupTransitionIn\":\"fade\",\"popupDurationIn\":\"1000\",\"popupDelayIn\":\"200\",\"popupTransitionOut\":\"fade\",\"popupDurationOut\":\"500\",\"popupResetOnClose\":\"slide\",\"popupShowCloseButton\":true,\"popupCloseButtonStyle\":\"\",\"popupOverlayClickToClose\":true,\"popupOverlayBackground\":\"rgba(0,0,0,.85)\",\"popupOverlayTransitionIn\":\"fade\",\"popupOverlayDurationIn\":\"400\",\"popupOverlayTransitionOut\":\"fade\",\"popupOverlayDurationOut\":\"400\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"slideBGSize\":\"cover\",\"slideBGPosition\":\"50% 50%\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":true,\"preferBlendMode\":\"disabled\",\"previewId\":\"\",\"preview\":\"\",\"navprevnext\":false,\"navstartstop\":false,\"navbuttons\":false,\"hoverprevnext\":false,\"createdWith\":\"6.7.6\",\"cbinit\":\"function(element) {\\r\\n\\r\\n}\",\"cbstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbpause\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbprev\":\"function(data) {\\r\\n\\r\\n}\",\"cbnext\":\"function(data) {\\r\\n\\r\\n}\",\"undefined\":false},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":1110,\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide5.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide5-300x150.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":2},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide5.jpg\",\"backgroundId\":1110,\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide5.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"slidedelay\":\"\"},\"redo\":{\"slidedelay\":\"5000\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"slidedelay\":\"3\"},\"redo\":{\"slidedelay\":\"3000\"}}]}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":1105,\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide1.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide1-300x150.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":0},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide1.jpg\",\"backgroundId\":1105,\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide1.jpg\"}}}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":1107,\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/parliament-1.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/parliament-1-300x148.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":0},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/parliament-1.jpg\",\"backgroundId\":1107,\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/parliament-1.jpg\"}}}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":1109,\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide2.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide2-300x150.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":1},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide2.jpg\",\"backgroundId\":1109,\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide2.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"slidedelay\":\"\"},\"redo\":{\"slidedelay\":\"5000\"}}]}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":1169,\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/Baganara-House-Beach.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/Baganara-House-Beach.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":1},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":4,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/Baganara-House-Beach.jpg\",\"backgroundId\":1169,\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/Baganara-House-Beach.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"slidedelay\":\"\"},\"redo\":{\"slidedelay\":\"3\"}}]}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":1170,\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/stenacarron1-e1530233443767.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/stenacarron1-e1530233443767.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":1},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":5,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/stenacarron1-e1530233443767.jpg\",\"backgroundId\":1170,\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/stenacarron1-e1530233443767.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":5,\"undo\":{\"slidedelay\":\"\"},\"redo\":{\"slidedelay\":\"3000\"}}]}]}]}', 1544710965, 1544815729, 0, 0, 0, 0, 0),
 (2, 1, 'Tourism', '', '{\"properties\":{\"title\":\"Tourism\",\"slug\":\"\",\"sliderVersion\":\"6.7.6\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"responsive\",\"width\":\"1280\",\"height\":\"720\",\"maxwidth\":\"\",\"responsiveunder\":\"\",\"fullSizeMode\":\"normal\",\"fitScreenWidth\":true,\"allowFullscreen\":true,\"maxRatio\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"\",\"hideover\":\"\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":\"enabled\",\"keybnav\":true,\"touchnav\":true,\"playByScrollSpeed\":\"1\",\"loops\":\"0\",\"forceloopnum\":true,\"skin\":\"v6\",\"sliderfadeinduration\":\"350\",\"sliderclass\":\"\",\"sliderstyle\":\"margin-bottom: 0px;\",\"backgroundcolor\":\"\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"auto\",\"navprevnext\":true,\"navstartstop\":true,\"navbuttons\":true,\"hoverprevnext\":true,\"circletimer\":true,\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":true,\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"popupPositionHorizontal\":\"center\",\"popupPositionVertical\":\"middle\",\"popupWidth\":\"640\",\"popupHeight\":\"360\",\"popupDistanceLeft\":\"10\",\"popupDistanceRight\":\"10\",\"popupDistanceTop\":\"10\",\"popupDistanceBottom\":\"10\",\"popupShowOnTimeout\":\"\",\"popupShowOnIdle\":\"\",\"popupShowOnScroll\":\"\",\"popupShowOnClick\":\"\",\"popupCloseOnTimeout\":\"\",\"popupCloseOnScroll\":\"\",\"popup_repeat\":true,\"popup_repeat_days\":\"\",\"popupShowOnce\":true,\"popup_pages_custom\":\"\",\"popup_pages_exclude\":\"\",\"popup_roles_administrator\":true,\"popup_roles_editor\":true,\"popup_roles_author\":true,\"popup_roles_contributor\":true,\"popup_roles_subscriber\":true,\"popup_roles_visitor\":true,\"popupTransitionIn\":\"fade\",\"popupDurationIn\":\"1000\",\"popupDelayIn\":\"200\",\"popupTransitionOut\":\"fade\",\"popupDurationOut\":\"500\",\"popupResetOnClose\":\"slide\",\"popupShowCloseButton\":true,\"popupCloseButtonStyle\":\"\",\"popupOverlayClickToClose\":true,\"popupOverlayBackground\":\"rgba(0,0,0,.85)\",\"popupOverlayTransitionIn\":\"fade\",\"popupOverlayDurationIn\":\"400\",\"popupOverlayTransitionOut\":\"fade\",\"popupOverlayDurationOut\":\"400\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"slideBGSize\":\"cover\",\"slideBGPosition\":\"50% 50%\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":true,\"preferBlendMode\":\"disabled\",\"previewId\":\"\",\"preview\":\"\",\"createdWith\":\"6.7.6\"},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"11\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":1288,\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2019\\/01\\/hibiscus.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2019\\/01\\/hibiscus.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":1},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide5.jpg\",\"backgroundId\":1110,\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide5.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide5.jpg\",\"backgroundId\":1110,\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide5.jpg\"},\"redo\":{\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2019\\/01\\/hibiscus.jpg\",\"backgroundId\":1288,\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2019\\/01\\/hibiscus.jpg\"}}}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"11\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":1105,\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide1.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide1.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":0},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide1.jpg\",\"backgroundId\":1105,\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide1.jpg\"}}}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"11\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":1169,\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/Baganara-House-Beach-e1544815651765.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/Baganara-House-Beach-e1544815651765.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":0},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/Baganara-House-Beach-e1544815651765.jpg\",\"backgroundId\":1169,\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/Baganara-House-Beach-e1544815651765.jpg\"}}}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"11\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":1109,\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide2.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide2.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":0},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide2.jpg\",\"backgroundId\":1109,\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2018\\/12\\/slide2.jpg\"}}}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"11\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":1287,\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2019\\/01\\/tree-frog.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2019\\/01\\/tree-frog.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":1},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":4,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2019\\/01\\/tree-frog.jpg\",\"backgroundId\":1287,\"backgroundThumb\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/uploads\\/2019\\/01\\/tree-frog.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"slidedelay\":\"\"},\"redo\":{\"slidedelay\":\"3500\"}}]}]}]}', 1547639044, 1547639697, 0, 0, 0, 0, 0);

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES(1, 'siteurl', 'https://mofa-omission.ultimate-dimensions.net', 'yes'),
 (2, 'home', 'https://mofa-omission.ultimate-dimensions.net', 'yes'),
 (3, 'blogname', 'Canadian High Commission', 'yes'),
 (4, 'blogdescription', 'Ministry of Foreign Affairs Guyana', 'yes'),
 (5, 'users_can_register', '0', 'yes'),
 (6, 'admin_email', 'sales@ultimate-dimensions.net', 'yes'),
 (7, 'start_of_week', '1', 'yes'),
 (8, 'use_balanceTags', '0', 'yes'),
 (9, 'use_smilies', '1', 'yes'),
 (10, 'require_name_email', '1', 'yes'),
 (11, 'comments_notify', '1', 'yes'),
 (12, 'posts_per_rss', '10', 'yes'),
 (13, 'rss_use_excerpt', '0', 'yes'),
 (14, 'mailserver_url', 'mail.example.com', 'yes'),
 (15, 'mailserver_login', 'login@example.com', 'yes'),
 (16, 'mailserver_pass', 'password', 'yes'),
 (17, 'mailserver_port', '110', 'yes'),
 (18, 'default_category', '1', 'yes'),
 (19, 'default_comment_status', 'closed', 'yes'),
 (20, 'default_ping_status', 'open', 'yes'),
 (21, 'default_pingback_flag', '1', 'yes'),
 (22, 'posts_per_page', '10', 'yes'),
 (23, 'date_format', 'F j, Y', 'yes'),
 (24, 'time_format', 'g:i a', 'yes'),
 (25, 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
 (26, 'comment_moderation', '', 'yes'),
 (27, 'moderation_notify', '1', 'yes'),
 (28, 'permalink_structure', '/%year%/%monthnum%/%day%/%postname%/', 'yes'),
 (30, 'hack_file', '0', 'yes'),
 (31, 'blog_charset', 'UTF-8', 'yes'),
 (32, 'moderation_keys', '', 'no'),
 (33, 'active_plugins', 'a:10:{i:0;s:27:\"LayerSlider/layerslider.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:33:\"duplicator-pro/duplicator-pro.php\";i:3;s:33:\"fusion-builder/fusion-builder.php\";i:4;s:27:\"fusion-core/fusion-core.php\";i:5;s:47:\"memphis-documents-library/memphis-documents.php\";i:6;s:23:\"wordfence/wordfence.php\";i:7;s:24:\"wordpress-seo/wp-seo.php\";i:8;s:36:\"yotuwp-easy-youtube-embed/yotuwp.php\";i:9;s:30:\"youtube-embed-plus/youtube.php\";}', 'yes'),
 (34, 'category_base', '', 'yes'),
 (35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
 (36, 'comment_max_links', '2', 'yes'),
 (37, 'gmt_offset', '0', 'yes'),
 (38, 'default_email_category', '1', 'yes'),
 (39, 'recently_edited', '', 'no'),
 (40, 'template', 'Avada', 'yes'),
 (41, 'stylesheet', 'Avada', 'yes'),
 (42, 'comment_whitelist', '1', 'yes'),
 (43, 'blacklist_keys', '', 'no'),
 (44, 'comment_registration', '', 'yes'),
 (45, 'html_type', 'text/html', 'yes'),
 (46, 'use_trackback', '0', 'yes'),
 (47, 'default_role', 'subscriber', 'yes'),
 (48, 'db_version', '43764', 'yes'),
 (49, 'uploads_use_yearmonth_folders', '1', 'yes'),
 (50, 'upload_path', '', 'yes'),
 (51, 'blog_public', '0', 'yes'),
 (52, 'default_link_category', '2', 'yes'),
 (53, 'show_on_front', 'page', 'yes'),
 (54, 'tag_base', '', 'yes'),
 (55, 'show_avatars', '1', 'yes'),
 (56, 'avatar_rating', 'G', 'yes'),
 (57, 'upload_url_path', '', 'yes'),
 (58, 'thumbnail_size_w', '150', 'yes'),
 (59, 'thumbnail_size_h', '150', 'yes'),
 (60, 'thumbnail_crop', '1', 'yes'),
 (61, 'medium_size_w', '300', 'yes'),
 (62, 'medium_size_h', '300', 'yes'),
 (63, 'avatar_default', 'mystery', 'yes'),
 (64, 'large_size_w', '1024', 'yes'),
 (65, 'large_size_h', '1024', 'yes'),
 (66, 'image_default_link_type', 'none', 'yes'),
 (67, 'image_default_size', '', 'yes'),
 (68, 'image_default_align', '', 'yes'),
 (69, 'close_comments_for_old_posts', '', 'yes'),
 (70, 'close_comments_days_old', '14', 'yes'),
 (71, 'thread_comments', '1', 'yes'),
 (72, 'thread_comments_depth', '5', 'yes'),
 (73, 'page_comments', '', 'yes'),
 (74, 'comments_per_page', '50', 'yes'),
 (75, 'default_comments_page', 'newest', 'yes'),
 (76, 'comment_order', 'asc', 'yes'),
 (77, 'sticky_posts', 'a:0:{}', 'yes'),
 (78, 'widget_categories', 'a:3:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:3;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (79, 'widget_text', 'a:3:{i:1;a:0:{}i:2;a:12:{s:5:\"title\";s:5:\"Links\";s:4:\"text\";s:965:\"<ul>\r\n 	<li><a href=\"http://www.bankofguyana.org.gy/\" target=\"1\">Bank Of Guyana</a></li>\r\n 	<li><a href=\"http://www.gina.gov.gy/home/\" target=\"1\">Goverment Information Agency</a></li>\r\n 	<li><a href=\"http://goinvest.gov.gy/\" target=\"_blank\" rel=\"noopener\">The Guyana Office for Investment</a></li>\r\n 	<li><a title=\"Ministry of The Presidency\" href=\"http://www.motp.gov.gy/\" target=\"_blank\" rel=\"noopener\">Ministry of the Presidency</a></li>\r\n 	<li><a href=\"http://agriculture.gov.gy/\" target=\"_blank\" rel=\"noopener\">Ministry of Agriculture</a></li>\r\n 	<li><a href=\"http://minbusiness.gov.gy/\" target=\"_blank\" rel=\"noopener\">Ministry of Business</a></li>\r\n 	<li><a href=\"https://chpa.gov.gy/\" target=\"_blank\" rel=\"noopener\">Ministry of Communities</a></li>\r\n 	<li><a href=\"http://educationgy.org/\" target=\"_blank\" rel=\"noopener\">Ministry of Education</a></li>\r\n 	<li><a href=\"http://finance.gov.gy/\" target=\"_blank\" rel=\"noopener\">Ministry of Finance</a></li>\r\n</ul>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (80, 'widget_rss', 'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (81, 'uninstall_plugins', 'a:1:{s:27:\"LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";}', 'no'),
 (82, 'timezone_string', '', 'yes'),
 (83, 'page_for_posts', '0', 'yes'),
 (84, 'page_on_front', '1046', 'yes'),
 (85, 'default_post_format', '0', 'yes'),
 (86, 'link_manager_enabled', '0', 'yes'),
 (87, 'finished_splitting_shared_terms', '1', 'yes'),
 (88, 'site_icon', '0', 'yes'),
 (89, 'medium_large_size_w', '768', 'yes'),
 (90, 'medium_large_size_h', '0', 'yes'),
 (91, 'wp_page_for_privacy_policy', '3', 'yes'),
 (92, 'show_comments_cookies_opt_in', '', 'yes'),
 (93, 'initial_db_version', '38590', 'yes'),
 (94, 'wp_user_roles', 'a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:82:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:16:\"mdocs_batch_edit\";b:1;s:16:\"mdocs_batch_move\";b:1;s:18:\"mdocs_batch_delete\";b:1;s:27:\"mdocs_allow_upload_frontend\";b:1;s:20:\"mdocs_manage_options\";b:1;s:21:\"mdocs_manage_settings\";b:1;s:18:\"mdocs_allow_upload\";b:1;s:20:\"wpseo_manage_options\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:15:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:7:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:23:\"edit_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}', 'yes'),
 (95, 'fresh_site', '0', 'yes'),
 (96, 'widget_search', 'a:3:{i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (97, 'widget_recent-posts', 'a:3:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}i:3;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (98, 'widget_recent-comments', 'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (99, 'widget_archives', 'a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (100, 'widget_meta', 'a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (101, 'sidebars_widgets', 'a:6:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"avada-blog-sidebar\";a:13:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";i:6;s:8:\"search-3\";i:7;s:18:\"pyre_tabs-widget-2\";i:8;s:11:\"tag_cloud-2\";i:9;s:15:\"tweets-widget-2\";i:10;s:14:\"recent-posts-3\";i:11;s:15:\"flickr-widget-2\";i:12;s:12:\"categories-3\";}s:21:\"avada-footer-widget-1\";a:1:{i:0;s:6:\"text-2\";}s:25:\"avada-slidingbar-widget-1\";a:0:{}s:25:\"avada-slidingbar-widget-2\";a:0:{}s:13:\"array_version\";i:3;}', 'yes'),
 (787, 'db_upgraded', '', 'yes'),
 (102, 'widget_pages', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (103, 'widget_calendar', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (104, 'widget_media_audio', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (105, 'widget_media_image', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (106, 'widget_media_gallery', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (107, 'widget_media_video', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (108, 'widget_tag_cloud', 'a:2:{i:2;a:2:{s:5:\"title\";s:12:\"Popular Tags\";s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (109, 'widget_nav_menu', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (110, 'widget_custom_html', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (111, 'cron', 'a:14:{i:1581711858;a:1:{s:24:\"tribe_common_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1582226429;a:1:{s:30:\"yotuwp_weekly_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1583368082;a:1:{s:40:\"wordfence_completeCoreUpdateNotification\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1583370499;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1583371179;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1583381979;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1583410001;a:1:{s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1583425187;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1583438786;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1583438884;a:1:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1583438899;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1583516400;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"e1fa51eceb0a5f68e3322b587918ed8c\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1583516400;}}}}i:1583775600;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"711e47a114acf68d71e72b3e3c211e15\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1583775600;}}}}s:7:\"version\";i:2;}', 'yes'),
 (112, 'theme_mods_twentyseventeen', 'a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1544097926;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}', 'yes'),
 (8341, '_site_transient_timeout_theme_roots', '1583369878', 'no'),
 (8342, '_site_transient_theme_roots', 'a:5:{s:5:\"Avada\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:14:\"twentynineteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}', 'no'),
 (355, 'widget_fusion_author-widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (356, 'widget_contact_info-widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (8349, '_transient_timeout_ls-slider-data-1', '1583389679', 'no'),
 (8350, '_transient_ls-slider-data-1', 'a:10:{s:4:\"init\";s:557:\"var lsjQuery = jQuery;lsjQuery(document).ready(function() {\r\nif(typeof lsjQuery.fn.layerSlider == \"undefined\") {\r\nif( window._layerSlider && window._layerSlider.showNotice) { \r\nwindow._layerSlider.showNotice(\'layerslider_1\',\'jquery\');\r\n}\r\n} else {\r\nlsjQuery(\"#layerslider_1\").layerSlider({createdWith: \'6.7.6\', sliderVersion: \'6.7.6\', skin: \'v6\', navPrevNext: false, hoverPrevNext: false, navStartStop: false, navButtons: false, skinsPath: \'https://mofa-omission.ultimate-dimensions.net/wp-content/plugins/LayerSlider/static/layerslider/skins/\'});\r\n}\r\n});\r\n\";s:9:\"container\";s:130:\"<div id=\"layerslider_1\" class=\"ls-wp-container fitvidsignore\" style=\"width:1170px;height:585px;margin:0 auto;margin-bottom: 0px;\">\";s:6:\"markup\";s:5940:\"<div class=\"ls-slide\" data-ls=\"duration:3000;kenburnsscale:1.2;\"><img width=\"1170\" height=\"585\" src=\"https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide5.jpg\" class=\"ls-bg\" alt=\"\" srcset=\"https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide5-200x100.jpg 200w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide5-300x150.jpg 300w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide5-400x200.jpg 400w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide5-600x300.jpg 600w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide5-768x384.jpg 768w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide5-800x400.jpg 800w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide5-1024x512.jpg 1024w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide5.jpg 1170w\" sizes=\"(max-width: 1170px) 100vw, 1170px\" /></div><div class=\"ls-slide\" data-ls=\"duration:3000;kenburnsscale:1.2;\"><img width=\"1170\" height=\"585\" src=\"https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide1.jpg\" class=\"ls-bg\" alt=\"\" srcset=\"https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide1-200x100.jpg 200w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide1-300x150.jpg 300w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide1-400x200.jpg 400w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide1-600x300.jpg 600w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide1-768x384.jpg 768w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide1-800x400.jpg 800w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide1-1024x512.jpg 1024w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide1.jpg 1170w\" sizes=\"(max-width: 1170px) 100vw, 1170px\" /></div><div class=\"ls-slide\" data-ls=\"duration:3000;kenburnsscale:1.2;\"><img width=\"1990\" height=\"983\" src=\"https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/parliament-1.jpg\" class=\"ls-bg\" alt=\"\" srcset=\"https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/parliament-1-200x99.jpg 200w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/parliament-1-300x148.jpg 300w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/parliament-1-400x198.jpg 400w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/parliament-1-600x296.jpg 600w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/parliament-1-768x379.jpg 768w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/parliament-1-800x395.jpg 800w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/parliament-1-1024x506.jpg 1024w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/parliament-1-1200x593.jpg 1200w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/parliament-1.jpg 1990w\" sizes=\"(max-width: 1990px) 100vw, 1990px\" /></div><div class=\"ls-slide\" data-ls=\"duration:3000;kenburnsscale:1.2;\"><img width=\"1170\" height=\"585\" src=\"https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide2.jpg\" class=\"ls-bg\" alt=\"\" srcset=\"https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide2-200x100.jpg 200w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide2-300x150.jpg 300w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide2-400x200.jpg 400w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide2-600x300.jpg 600w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide2-768x384.jpg 768w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide2-800x400.jpg 800w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide2-1024x512.jpg 1024w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/slide2.jpg 1170w\" sizes=\"(max-width: 1170px) 100vw, 1170px\" /></div><div class=\"ls-slide\" data-ls=\"duration:3000;kenburnsscale:1.2;\"><img width=\"1170\" height=\"878\" src=\"https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/Baganara-House-Beach-e1544815651765.jpg\" class=\"ls-bg\" alt=\"\" /></div><div class=\"ls-slide\" data-ls=\"duration:3000;kenburnsscale:1.2;\"><img width=\"1790\" height=\"1194\" src=\"https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/stenacarron1-e1530233443767.jpg\" class=\"ls-bg\" alt=\"\" srcset=\"https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/stenacarron1-e1530233443767-200x133.jpg 200w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/stenacarron1-e1530233443767-300x200.jpg 300w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/stenacarron1-e1530233443767-400x267.jpg 400w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/stenacarron1-e1530233443767-600x400.jpg 600w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/stenacarron1-e1530233443767-768x512.jpg 768w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/stenacarron1-e1530233443767-800x534.jpg 800w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/stenacarron1-e1530233443767-1024x683.jpg 1024w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/stenacarron1-e1530233443767-1200x800.jpg 1200w, https://mofa-omission.ultimate-dimensions.net/wp-content/uploads/2018/12/stenacarron1-e1530233443767.jpg 1790w\" sizes=\"(max-width: 1790px) 100vw, 1790px\" /></div></div>\";s:7:\"plugins\";a:0:{}s:5:\"fonts\";a:0:{}s:2:\"id\";s:1:\"1\";s:14:\"schedule_start\";s:1:\"0\";s:12:\"schedule_end\";s:1:\"0\";s:11:\"flag_hidden\";s:1:\"0\";s:12:\"flag_deleted\";s:1:\"0\";}', 'no'),
 (6204, '_transient_fusion_fontawesome_en', '.fa,.fab,.fal,.far,.fas{-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;display:inline-block;font-style:normal;font-variant:normal;text-rendering:auto;line-height:1}.fa-lg{font-size:1.33333em;line-height:.75em;vertical-align:-.0667em}.fa-xs{font-size:.75em}.fa-sm{font-size:.875em}.fa-1x{font-size:1em}.fa-2x{font-size:2em}.fa-3x{font-size:3em}.fa-4x{font-size:4em}.fa-5x{font-size:5em}.fa-6x{font-size:6em}.fa-7x{font-size:7em}.fa-8x{font-size:8em}.fa-9x{font-size:9em}.fa-10x{font-size:10em}.fa-fw{text-align:center;width:1.25em}.fa-ul{list-style-type:none;margin-left:2.5em;padding-left:0}.fa-ul>li{position:relative}.fa-li{left:-2em;position:absolute;text-align:center;width:2em;line-height:inherit}.fa-border{border:solid .08em #eee;border-radius:.1em;padding:.2em .25em .15em}.fa-pull-left{float:left}.fa-pull-right{float:right}.fa.fa-pull-left,.fab.fa-pull-left,.fal.fa-pull-left,.far.fa-pull-left,.fas.fa-pull-left{margin-right:.3em}.fa.fa-pull-right,.fab.fa-pull-right,.fal.fa-pull-right,.far.fa-pull-right,.fas.fa-pull-right{margin-left:.3em}.fa-spin{-webkit-animation:fa-spin 2s infinite linear;animation:fa-spin 2s infinite linear}.fa-pulse{-webkit-animation:fa-spin 1s infinite steps(8);animation:fa-spin 1s infinite steps(8)}@-webkit-keyframes fa-spin{0%{-webkit-transform:rotate(0);transform:rotate(0)}100%{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@keyframes fa-spin{0%{-webkit-transform:rotate(0);transform:rotate(0)}100%{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}.fa-rotate-90{-webkit-transform:rotate(90deg);transform:rotate(90deg)}.fa-rotate-180{-webkit-transform:rotate(180deg);transform:rotate(180deg)}.fa-rotate-270{-webkit-transform:rotate(270deg);transform:rotate(270deg)}.fa-flip-horizontal{-webkit-transform:scale(-1,1);transform:scale(-1,1)}.fa-flip-vertical{-webkit-transform:scale(1,-1);transform:scale(1,-1)}.fa-flip-horizontal.fa-flip-vertical{-webkit-transform:scale(-1,-1);transform:scale(-1,-1)}:root .fa-flip-horizontal,:root .fa-flip-vertical,:root .fa-rotate-180,:root .fa-rotate-270,:root .fa-rotate-90{-webkit-filter:none;filter:none}.fa-stack{display:inline-block;height:2em;line-height:2em;position:relative;vertical-align:middle;width:2.5em}.fa-stack-1x,.fa-stack-2x{left:0;position:absolute;text-align:center;width:100%}.fa-stack-1x{line-height:inherit}.fa-stack-2x{font-size:2em}.fa-inverse{color:#fff}@font-face{font-family:\"Font Awesome 5 Brands\";font-style:normal;font-weight:normal;src:url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.eot);src:url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.eot?#iefix) format(\"embedded-opentype\"),url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.woff2) format(\"woff2\"),url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.woff) format(\"woff\"),url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.ttf) format(\"truetype\"),url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.svg#fontawesome) format(\"svg\")}.fab{font-family:\"Font Awesome 5 Brands\"}@font-face{font-family:\"Font Awesome 5 Free\";font-style:normal;font-weight:400;src:url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.eot);src:url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.eot?#iefix) format(\"embedded-opentype\"),url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.woff2) format(\"woff2\"),url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.woff) format(\"woff\"),url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.ttf) format(\"truetype\"),url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.svg#fontawesome) format(\"svg\")}.far{font-family:\"Font Awesome 5 Free\";font-weight:400}@font-face{font-family:\"Font Awesome 5 Free\";font-style:normal;font-weight:900;src:url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.eot);src:url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.eot?#iefix) format(\"embedded-opentype\"),url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.woff2) format(\"woff2\"),url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/fa-solid-900.woff) format(\"woff\"),url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.ttf) format(\"truetype\"),url(//mofa-omission.ultimate-dimensions.net/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.svg#fontawesome) format(\"svg\")}.fa,.fas{font-family:\"Font Awesome 5 Free\";font-weight:900}.fa-500px:before{content:\"\\f26e\"}.fa-accessible-icon:before{content:\"\\f368\"}.fa-accusoft:before{content:\"\\f369\"}.fa-acquisitions-incorporated:before{content:\"\\f6af\"}.fa-ad:before{content:\"\\f641\"}.fa-address-book:before{content:\"\\f2b9\"}.fa-address-card:before{content:\"\\f2bb\"}.fa-adjust:before{content:\"\\f042\"}.fa-adn:before{content:\"\\f170\"}.fa-adobe:before{content:\"\\f778\"}.fa-adversal:before{content:\"\\f36a\"}.fa-affiliatetheme:before{content:\"\\f36b\"}.fa-air-freshener:before{content:\"\\f5d0\"}.fa-algolia:before{content:\"\\f36c\"}.fa-align-center:before{content:\"\\f037\"}.fa-align-justify:before{content:\"\\f039\"}.fa-align-left:before{content:\"\\f036\"}.fa-align-right:before{content:\"\\f038\"}.fa-alipay:before{content:\"\\f642\"}.fa-allergies:before{content:\"\\f461\"}.fa-amazon:before{content:\"\\f270\"}.fa-amazon-pay:before{content:\"\\f42c\"}.fa-ambulance:before{content:\"\\f0f9\"}.fa-american-sign-language-interpreting:before{content:\"\\f2a3\"}.fa-amilia:before{content:\"\\f36d\"}.fa-anchor:before{content:\"\\f13d\"}.fa-android:before{content:\"\\f17b\"}.fa-angellist:before{content:\"\\f209\"}.fa-angle-double-down:before{content:\"\\f103\"}.fa-angle-double-left:before{content:\"\\f100\"}.fa-angle-double-right:before{content:\"\\f101\"}.fa-angle-double-up:before{content:\"\\f102\"}.fa-angle-down:before{content:\"\\f107\"}.fa-angle-left:before{content:\"\\f104\"}.fa-angle-right:before{content:\"\\f105\"}.fa-angle-up:before{content:\"\\f106\"}.fa-angry:before{content:\"\\f556\"}.fa-angrycreative:before{content:\"\\f36e\"}.fa-angular:before{content:\"\\f420\"}.fa-ankh:before{content:\"\\f644\"}.fa-app-store:before{content:\"\\f36f\"}.fa-app-store-ios:before{content:\"\\f370\"}.fa-apper:before{content:\"\\f371\"}.fa-apple:before{content:\"\\f179\"}.fa-apple-alt:before{content:\"\\f5d1\"}.fa-apple-pay:before{content:\"\\f415\"}.fa-archive:before{content:\"\\f187\"}.fa-archway:before{content:\"\\f557\"}.fa-arrow-alt-circle-down:before{content:\"\\f358\"}.fa-arrow-alt-circle-left:before{content:\"\\f359\"}.fa-arrow-alt-circle-right:before{content:\"\\f35a\"}.fa-arrow-alt-circle-up:before{content:\"\\f35b\"}.fa-arrow-circle-down:before{content:\"\\f0ab\"}.fa-arrow-circle-left:before{content:\"\\f0a8\"}.fa-arrow-circle-right:before{content:\"\\f0a9\"}.fa-arrow-circle-up:before{content:\"\\f0aa\"}.fa-arrow-down:before{content:\"\\f063\"}.fa-arrow-left:before{content:\"\\f060\"}.fa-arrow-right:before{content:\"\\f061\"}.fa-arrow-up:before{content:\"\\f062\"}.fa-arrows-alt:before{content:\"\\f0b2\"}.fa-arrows-alt-h:before{content:\"\\f337\"}.fa-arrows-alt-v:before{content:\"\\f338\"}.fa-artstation:before{content:\"\\f77a\"}.fa-assistive-listening-systems:before{content:\"\\f2a2\"}.fa-asterisk:before{content:\"\\f069\"}.fa-asymmetrik:before{content:\"\\f372\"}.fa-at:before{content:\"\\f1fa\"}.fa-atlas:before{content:\"\\f558\"}.fa-atlassian:before{content:\"\\f77b\"}.fa-atom:before{content:\"\\f5d2\"}.fa-audible:before{content:\"\\f373\"}.fa-audio-description:before{content:\"\\f29e\"}.fa-autoprefixer:before{content:\"\\f41c\"}.fa-avianex:before{content:\"\\f374\"}.fa-aviato:before{content:\"\\f421\"}.fa-award:before{content:\"\\f559\"}.fa-aws:before{content:\"\\f375\"}.fa-baby:before{content:\"\\f77c\"}.fa-baby-carriage:before{content:\"\\f77d\"}.fa-backspace:before{content:\"\\f55a\"}.fa-backward:before{content:\"\\f04a\"}.fa-balance-scale:before{content:\"\\f24e\"}.fa-ban:before{content:\"\\f05e\"}.fa-band-aid:before{content:\"\\f462\"}.fa-bandcamp:before{content:\"\\f2d5\"}.fa-barcode:before{content:\"\\f02a\"}.fa-bars:before{content:\"\\f0c9\"}.fa-baseball-ball:before{content:\"\\f433\"}.fa-basketball-ball:before{content:\"\\f434\"}.fa-bath:before{content:\"\\f2cd\"}.fa-battery-empty:before{content:\"\\f244\"}.fa-battery-full:before{content:\"\\f240\"}.fa-battery-half:before{content:\"\\f242\"}.fa-battery-quarter:before{content:\"\\f243\"}.fa-battery-three-quarters:before{content:\"\\f241\"}.fa-bed:before{content:\"\\f236\"}.fa-beer:before{content:\"\\f0fc\"}.fa-behance:before{content:\"\\f1b4\"}.fa-behance-square:before{content:\"\\f1b5\"}.fa-bell:before{content:\"\\f0f3\"}.fa-bell-slash:before{content:\"\\f1f6\"}.fa-bezier-curve:before{content:\"\\f55b\"}.fa-bible:before{content:\"\\f647\"}.fa-bicycle:before{content:\"\\f206\"}.fa-bimobject:before{content:\"\\f378\"}.fa-binoculars:before{content:\"\\f1e5\"}.fa-biohazard:before{content:\"\\f780\"}.fa-birthday-cake:before{content:\"\\f1fd\"}.fa-bitbucket:before{content:\"\\f171\"}.fa-bitcoin:before{content:\"\\f379\"}.fa-bity:before{content:\"\\f37a\"}.fa-black-tie:before{content:\"\\f27e\"}.fa-blackberry:before{content:\"\\f37b\"}.fa-blender:before{content:\"\\f517\"}.fa-blender-phone:before{content:\"\\f6b6\"}.fa-blind:before{content:\"\\f29d\"}.fa-blog:before{content:\"\\f781\"}.fa-blogger:before{content:\"\\f37c\"}.fa-blogger-b:before{content:\"\\f37d\"}.fa-bluetooth:before{content:\"\\f293\"}.fa-bluetooth-b:before{content:\"\\f294\"}.fa-bold:before{content:\"\\f032\"}.fa-bolt:before{content:\"\\f0e7\"}.fa-bomb:before{content:\"\\f1e2\"}.fa-bone:before{content:\"\\f5d7\"}.fa-bong:before{content:\"\\f55c\"}.fa-book:before{content:\"\\f02d\"}.fa-book-dead:before{content:\"\\f6b7\"}.fa-book-open:before{content:\"\\f518\"}.fa-book-reader:before{content:\"\\f5da\"}.fa-bookmark:before{content:\"\\f02e\"}.fa-bowling-ball:before{content:\"\\f436\"}.fa-box:before{content:\"\\f466\"}.fa-box-open:before{content:\"\\f49e\"}.fa-boxes:before{content:\"\\f468\"}.fa-braille:before{content:\"\\f2a1\"}.fa-brain:before{content:\"\\f5dc\"}.fa-briefcase:before{content:\"\\f0b1\"}.fa-briefcase-medical:before{content:\"\\f469\"}.fa-broadcast-tower:before{content:\"\\f519\"}.fa-broom:before{content:\"\\f51a\"}.fa-brush:before{content:\"\\f55d\"}.fa-btc:before{content:\"\\f15a\"}.fa-bug:before{content:\"\\f188\"}.fa-building:before{content:\"\\f1ad\"}.fa-bullhorn:before{content:\"\\f0a1\"}.fa-bullseye:before{content:\"\\f140\"}.fa-burn:before{content:\"\\f46a\"}.fa-buromobelexperte:before{content:\"\\f37f\"}.fa-bus:before{content:\"\\f207\"}.fa-bus-alt:before{content:\"\\f55e\"}.fa-business-time:before{content:\"\\f64a\"}.fa-buysellads:before{content:\"\\f20d\"}.fa-calculator:before{content:\"\\f1ec\"}.fa-calendar:before{content:\"\\f133\"}.fa-calendar-alt:before{content:\"\\f073\"}.fa-calendar-check:before{content:\"\\f274\"}.fa-calendar-day:before{content:\"\\f783\"}.fa-calendar-minus:before{content:\"\\f272\"}.fa-calendar-plus:before{content:\"\\f271\"}.fa-calendar-times:before{content:\"\\f273\"}.fa-calendar-week:before{content:\"\\f784\"}.fa-camera:before{content:\"\\f030\"}.fa-camera-retro:before{content:\"\\f083\"}.fa-campground:before{content:\"\\f6bb\"}.fa-canadian-maple-leaf:before{content:\"\\f785\"}.fa-candy-cane:before{content:\"\\f786\"}.fa-cannabis:before{content:\"\\f55f\"}.fa-capsules:before{content:\"\\f46b\"}.fa-car:before{content:\"\\f1b9\"}.fa-car-alt:before{content:\"\\f5de\"}.fa-car-battery:before{content:\"\\f5df\"}.fa-car-crash:before{content:\"\\f5e1\"}.fa-car-side:before{content:\"\\f5e4\"}.fa-caret-down:before{content:\"\\f0d7\"}.fa-caret-left:before{content:\"\\f0d9\"}.fa-caret-right:before{content:\"\\f0da\"}.fa-caret-square-down:before{content:\"\\f150\"}.fa-caret-square-left:before{content:\"\\f191\"}.fa-caret-square-right:before{content:\"\\f152\"}.fa-caret-square-up:before{content:\"\\f151\"}.fa-caret-up:before{content:\"\\f0d8\"}.fa-carrot:before{content:\"\\f787\"}.fa-cart-arrow-down:before{content:\"\\f218\"}.fa-cart-plus:before{content:\"\\f217\"}.fa-cash-register:before{content:\"\\f788\"}.fa-cat:before{content:\"\\f6be\"}.fa-cc-amazon-pay:before{content:\"\\f42d\"}.fa-cc-amex:before{content:\"\\f1f3\"}.fa-cc-apple-pay:before{content:\"\\f416\"}.fa-cc-diners-club:before{content:\"\\f24c\"}.fa-cc-discover:before{content:\"\\f1f2\"}.fa-cc-jcb:before{content:\"\\f24b\"}.fa-cc-mastercard:before{content:\"\\f1f1\"}.fa-cc-paypal:before{content:\"\\f1f4\"}.fa-cc-stripe:before{content:\"\\f1f5\"}.fa-cc-visa:before{content:\"\\f1f0\"}.fa-centercode:before{content:\"\\f380\"}.fa-centos:before{content:\"\\f789\"}.fa-certificate:before{content:\"\\f0a3\"}.fa-chair:before{content:\"\\f6c0\"}.fa-chalkboard:before{content:\"\\f51b\"}.fa-chalkboard-teacher:before{content:\"\\f51c\"}.fa-charging-station:before{content:\"\\f5e7\"}.fa-chart-area:before{content:\"\\f1fe\"}.fa-chart-bar:before{content:\"\\f080\"}.fa-chart-line:before{content:\"\\f201\"}.fa-chart-pie:before{content:\"\\f200\"}.fa-check:before{content:\"\\f00c\"}.fa-check-circle:before{content:\"\\f058\"}.fa-check-double:before{content:\"\\f560\"}.fa-check-square:before{content:\"\\f14a\"}.fa-chess:before{content:\"\\f439\"}.fa-chess-bishop:before{content:\"\\f43a\"}.fa-chess-board:before{content:\"\\f43c\"}.fa-chess-king:before{content:\"\\f43f\"}.fa-chess-knight:before{content:\"\\f441\"}.fa-chess-pawn:before{content:\"\\f443\"}.fa-chess-queen:before{content:\"\\f445\"}.fa-chess-rook:before{content:\"\\f447\"}.fa-chevron-circle-down:before{content:\"\\f13a\"}.fa-chevron-circle-left:before{content:\"\\f137\"}.fa-chevron-circle-right:before{content:\"\\f138\"}.fa-chevron-circle-up:before{content:\"\\f139\"}.fa-chevron-down:before{content:\"\\f078\"}.fa-chevron-left:before{content:\"\\f053\"}.fa-chevron-right:before{content:\"\\f054\"}.fa-chevron-up:before{content:\"\\f077\"}.fa-child:before{content:\"\\f1ae\"}.fa-chrome:before{content:\"\\f268\"}.fa-church:before{content:\"\\f51d\"}.fa-circle:before{content:\"\\f111\"}.fa-circle-notch:before{content:\"\\f1ce\"}.fa-city:before{content:\"\\f64f\"}.fa-clipboard:before{content:\"\\f328\"}.fa-clipboard-check:before{content:\"\\f46c\"}.fa-clipboard-list:before{content:\"\\f46d\"}.fa-clock:before{content:\"\\f017\"}.fa-clone:before{content:\"\\f24d\"}.fa-closed-captioning:before{content:\"\\f20a\"}.fa-cloud:before{content:\"\\f0c2\"}.fa-cloud-download-alt:before{content:\"\\f381\"}.fa-cloud-meatball:before{content:\"\\f73b\"}.fa-cloud-moon:before{content:\"\\f6c3\"}.fa-cloud-moon-rain:before{content:\"\\f73c\"}.fa-cloud-rain:before{content:\"\\f73d\"}.fa-cloud-showers-heavy:before{content:\"\\f740\"}.fa-cloud-sun:before{content:\"\\f6c4\"}.fa-cloud-sun-rain:before{content:\"\\f743\"}.fa-cloud-upload-alt:before{content:\"\\f382\"}.fa-cloudscale:before{content:\"\\f383\"}.fa-cloudsmith:before{content:\"\\f384\"}.fa-cloudversify:before{content:\"\\f385\"}.fa-cocktail:before{content:\"\\f561\"}.fa-code:before{content:\"\\f121\"}.fa-code-branch:before{content:\"\\f126\"}.fa-codepen:before{content:\"\\f1cb\"}.fa-codiepie:before{content:\"\\f284\"}.fa-coffee:before{content:\"\\f0f4\"}.fa-cog:before{content:\"\\f013\"}.fa-cogs:before{content:\"\\f085\"}.fa-coins:before{content:\"\\f51e\"}.fa-columns:before{content:\"\\f0db\"}.fa-comment:before{content:\"\\f075\"}.fa-comment-alt:before{content:\"\\f27a\"}.fa-comment-dollar:before{content:\"\\f651\"}.fa-comment-dots:before{content:\"\\f4ad\"}.fa-comment-slash:before{content:\"\\f4b3\"}.fa-comments:before{content:\"\\f086\"}.fa-comments-dollar:before{content:\"\\f653\"}.fa-compact-disc:before{content:\"\\f51f\"}.fa-compass:before{content:\"\\f14e\"}.fa-compress:before{content:\"\\f066\"}.fa-compress-arrows-alt:before{content:\"\\f78c\"}.fa-concierge-bell:before{content:\"\\f562\"}.fa-confluence:before{content:\"\\f78d\"}.fa-connectdevelop:before{content:\"\\f20e\"}.fa-contao:before{content:\"\\f26d\"}.fa-cookie:before{content:\"\\f563\"}.fa-cookie-bite:before{content:\"\\f564\"}.fa-copy:before{content:\"\\f0c5\"}.fa-copyright:before{content:\"\\f1f9\"}.fa-couch:before{content:\"\\f4b8\"}.fa-cpanel:before{content:\"\\f388\"}.fa-creative-commons:before{content:\"\\f25e\"}.fa-creative-commons-by:before{content:\"\\f4e7\"}.fa-creative-commons-nc:before{content:\"\\f4e8\"}.fa-creative-commons-nc-eu:before{content:\"\\f4e9\"}.fa-creative-commons-nc-jp:before{content:\"\\f4ea\"}.fa-creative-commons-nd:before{content:\"\\f4eb\"}.fa-creative-commons-pd:before{content:\"\\f4ec\"}.fa-creative-commons-pd-alt:before{content:\"\\f4ed\"}.fa-creative-commons-remix:before{content:\"\\f4ee\"}.fa-creative-commons-sa:before{content:\"\\f4ef\"}.fa-creative-commons-sampling:before{content:\"\\f4f0\"}.fa-creative-commons-sampling-plus:before{content:\"\\f4f1\"}.fa-creative-commons-share:before{content:\"\\f4f2\"}.fa-creative-commons-zero:before{content:\"\\f4f3\"}.fa-credit-card:before{content:\"\\f09d\"}.fa-critical-role:before{content:\"\\f6c9\"}.fa-crop:before{content:\"\\f125\"}.fa-crop-alt:before{content:\"\\f565\"}.fa-cross:before{content:\"\\f654\"}.fa-crosshairs:before{content:\"\\f05b\"}.fa-crow:before{content:\"\\f520\"}.fa-crown:before{content:\"\\f521\"}.fa-css3:before{content:\"\\f13c\"}.fa-css3-alt:before{content:\"\\f38b\"}.fa-cube:before{content:\"\\f1b2\"}.fa-cubes:before{content:\"\\f1b3\"}.fa-cut:before{content:\"\\f0c4\"}.fa-cuttlefish:before{content:\"\\f38c\"}.fa-d-and-d:before{content:\"\\f38d\"}.fa-d-and-d-beyond:before{content:\"\\f6ca\"}.fa-dashcube:before{content:\"\\f210\"}.fa-database:before{content:\"\\f1c0\"}.fa-deaf:before{content:\"\\f2a4\"}.fa-delicious:before{content:\"\\f1a5\"}.fa-democrat:before{content:\"\\f747\"}.fa-deploydog:before{content:\"\\f38e\"}.fa-deskpro:before{content:\"\\f38f\"}.fa-desktop:before{content:\"\\f108\"}.fa-dev:before{content:\"\\f6cc\"}.fa-deviantart:before{content:\"\\f1bd\"}.fa-dharmachakra:before{content:\"\\f655\"}.fa-dhl:before{content:\"\\f790\"}.fa-diagnoses:before{content:\"\\f470\"}.fa-diaspora:before{content:\"\\f791\"}.fa-dice:before{content:\"\\f522\"}.fa-dice-d20:before{content:\"\\f6cf\"}.fa-dice-d6:before{content:\"\\f6d1\"}.fa-dice-five:before{content:\"\\f523\"}.fa-dice-four:before{content:\"\\f524\"}.fa-dice-one:before{content:\"\\f525\"}.fa-dice-six:before{content:\"\\f526\"}.fa-dice-three:before{content:\"\\f527\"}.fa-dice-two:before{content:\"\\f528\"}.fa-digg:before{content:\"\\f1a6\"}.fa-digital-ocean:before{content:\"\\f391\"}.fa-digital-tachograph:before{content:\"\\f566\"}.fa-directions:before{content:\"\\f5eb\"}.fa-discord:before{content:\"\\f392\"}.fa-discourse:before{content:\"\\f393\"}.fa-divide:before{content:\"\\f529\"}.fa-dizzy:before{content:\"\\f567\"}.fa-dna:before{content:\"\\f471\"}.fa-dochub:before{content:\"\\f394\"}.fa-docker:before{content:\"\\f395\"}.fa-dog:before{content:\"\\f6d3\"}.fa-dollar-sign:before{content:\"\\f155\"}.fa-dolly:before{content:\"\\f472\"}.fa-dolly-flatbed:before{content:\"\\f474\"}.fa-donate:before{content:\"\\f4b9\"}.fa-door-closed:before{content:\"\\f52a\"}.fa-door-open:before{content:\"\\f52b\"}.fa-dot-circle:before{content:\"\\f192\"}.fa-dove:before{content:\"\\f4ba\"}.fa-download:before{content:\"\\f019\"}.fa-draft2digital:before{content:\"\\f396\"}.fa-drafting-compass:before{content:\"\\f568\"}.fa-dragon:before{content:\"\\f6d5\"}.fa-draw-polygon:before{content:\"\\f5ee\"}.fa-dribbble:before{content:\"\\f17d\"}.fa-dribbble-square:before{content:\"\\f397\"}.fa-dropbox:before{content:\"\\f16b\"}.fa-drum:before{content:\"\\f569\"}.fa-drum-steelpan:before{content:\"\\f56a\"}.fa-drumstick-bite:before{content:\"\\f6d7\"}.fa-drupal:before{content:\"\\f1a9\"}.fa-dumbbell:before{content:\"\\f44b\"}.fa-dumpster:before{content:\"\\f793\"}.fa-dumpster-fire:before{content:\"\\f794\"}.fa-dungeon:before{content:\"\\f6d9\"}.fa-dyalog:before{content:\"\\f399\"}.fa-earlybirds:before{content:\"\\f39a\"}.fa-ebay:before{content:\"\\f4f4\"}.fa-edge:before{content:\"\\f282\"}.fa-edit:before{content:\"\\f044\"}.fa-eject:before{content:\"\\f052\"}.fa-elementor:before{content:\"\\f430\"}.fa-ellipsis-h:before{content:\"\\f141\"}.fa-ellipsis-v:before{content:\"\\f142\"}.fa-ello:before{content:\"\\f5f1\"}.fa-ember:before{content:\"\\f423\"}.fa-empire:before{content:\"\\f1d1\"}.fa-envelope:before{content:\"\\f0e0\"}.fa-envelope-open:before{content:\"\\f2b6\"}.fa-envelope-open-text:before{content:\"\\f658\"}.fa-envelope-square:before{content:\"\\f199\"}.fa-envira:before{content:\"\\f299\"}.fa-equals:before{content:\"\\f52c\"}.fa-eraser:before{content:\"\\f12d\"}.fa-erlang:before{content:\"\\f39d\"}.fa-ethereum:before{content:\"\\f42e\"}.fa-ethernet:before{content:\"\\f796\"}.fa-etsy:before{content:\"\\f2d7\"}.fa-euro-sign:before{content:\"\\f153\"}.fa-exchange-alt:before{content:\"\\f362\"}.fa-exclamation:before{content:\"\\f12a\"}.fa-exclamation-circle:before{content:\"\\f06a\"}.fa-exclamation-triangle:before{content:\"\\f071\"}.fa-expand:before{content:\"\\f065\"}.fa-expand-arrows-alt:before{content:\"\\f31e\"}.fa-expeditedssl:before{content:\"\\f23e\"}.fa-external-link-alt:before{content:\"\\f35d\"}.fa-external-link-square-alt:before{content:\"\\f360\"}.fa-eye:before{content:\"\\f06e\"}.fa-eye-dropper:before{content:\"\\f1fb\"}.fa-eye-slash:before{content:\"\\f070\"}.fa-facebook:before{content:\"\\f09a\"}.fa-facebook-f:before{content:\"\\f39e\"}.fa-facebook-messenger:before{content:\"\\f39f\"}.fa-facebook-square:before{content:\"\\f082\"}.fa-fantasy-flight-games:before{content:\"\\f6dc\"}.fa-fast-backward:before{content:\"\\f049\"}.fa-fast-forward:before{content:\"\\f050\"}.fa-fax:before{content:\"\\f1ac\"}.fa-feather:before{content:\"\\f52d\"}.fa-feather-alt:before{content:\"\\f56b\"}.fa-fedex:before{content:\"\\f797\"}.fa-fedora:before{content:\"\\f798\"}.fa-female:before{content:\"\\f182\"}.fa-fighter-jet:before{content:\"\\f0fb\"}.fa-figma:before{content:\"\\f799\"}.fa-file:before{content:\"\\f15b\"}.fa-file-alt:before{content:\"\\f15c\"}.fa-file-archive:before{content:\"\\f1c6\"}.fa-file-audio:before{content:\"\\f1c7\"}.fa-file-code:before{content:\"\\f1c9\"}.fa-file-contract:before{content:\"\\f56c\"}.fa-file-csv:before{content:\"\\f6dd\"}.fa-file-download:before{content:\"\\f56d\"}.fa-file-excel:before{content:\"\\f1c3\"}.fa-file-export:before{content:\"\\f56e\"}.fa-file-image:before{content:\"\\f1c5\"}.fa-file-import:before{content:\"\\f56f\"}.fa-file-invoice:before{content:\"\\f570\"}.fa-file-invoice-dollar:before{content:\"\\f571\"}.fa-file-medical:before{content:\"\\f477\"}.fa-file-medical-alt:before{content:\"\\f478\"}.fa-file-pdf:before{content:\"\\f1c1\"}.fa-file-powerpoint:before{content:\"\\f1c4\"}.fa-file-prescription:before{content:\"\\f572\"}.fa-file-signature:before{content:\"\\f573\"}.fa-file-upload:before{content:\"\\f574\"}.fa-file-video:before{content:\"\\f1c8\"}.fa-file-word:before{content:\"\\f1c2\"}.fa-fill:before{content:\"\\f575\"}.fa-fill-drip:before{content:\"\\f576\"}.fa-film:before{content:\"\\f008\"}.fa-filter:before{content:\"\\f0b0\"}.fa-fingerprint:before{content:\"\\f577\"}.fa-fire:before{content:\"\\f06d\"}.fa-fire-alt:before{content:\"\\f7e4\"}.fa-fire-extinguisher:before{content:\"\\f134\"}.fa-firefox:before{content:\"\\f269\"}.fa-first-aid:before{content:\"\\f479\"}.fa-first-order:before{content:\"\\f2b0\"}.fa-first-order-alt:before{content:\"\\f50a\"}.fa-firstdraft:before{content:\"\\f3a1\"}.fa-fish:before{content:\"\\f578\"}.fa-fist-raised:before{content:\"\\f6de\"}.fa-flag:before{content:\"\\f024\"}.fa-flag-checkered:before{content:\"\\f11e\"}.fa-flag-usa:before{content:\"\\f74d\"}.fa-flask:before{content:\"\\f0c3\"}.fa-flickr:before{content:\"\\f16e\"}.fa-flipboard:before{content:\"\\f44d\"}.fa-flushed:before{content:\"\\f579\"}.fa-fly:before{content:\"\\f417\"}.fa-folder:before{content:\"\\f07b\"}.fa-folder-minus:before{content:\"\\f65d\"}.fa-folder-open:before{content:\"\\f07c\"}.fa-folder-plus:before{content:\"\\f65e\"}.fa-font:before{content:\"\\f031\"}.fa-font-awesome:before{content:\"\\f2b4\"}.fa-font-awesome-alt:before{content:\"\\f35c\"}.fa-font-awesome-flag:before{content:\"\\f425\"}.fa-fonticons:before{content:\"\\f280\"}.fa-fonticons-fi:before{content:\"\\f3a2\"}.fa-football-ball:before{content:\"\\f44e\"}.fa-fort-awesome:before{content:\"\\f286\"}.fa-fort-awesome-alt:before{content:\"\\f3a3\"}.fa-forumbee:before{content:\"\\f211\"}.fa-forward:before{content:\"\\f04e\"}.fa-foursquare:before{content:\"\\f180\"}.fa-free-code-camp:before{content:\"\\f2c5\"}.fa-freebsd:before{content:\"\\f3a4\"}.fa-frog:before{content:\"\\f52e\"}.fa-frown:before{content:\"\\f119\"}.fa-frown-open:before{content:\"\\f57a\"}.fa-fulcrum:before{content:\"\\f50b\"}.fa-funnel-dollar:before{content:\"\\f662\"}.fa-futbol:before{content:\"\\f1e3\"}.fa-galactic-republic:before{content:\"\\f50c\"}.fa-galactic-senate:before{content:\"\\f50d\"}.fa-gamepad:before{content:\"\\f11b\"}.fa-gas-pump:before{content:\"\\f52f\"}.fa-gavel:before{content:\"\\f0e3\"}.fa-gem:before{content:\"\\f3a5\"}.fa-genderless:before{content:\"\\f22d\"}.fa-get-pocket:before{content:\"\\f265\"}.fa-gg:before{content:\"\\f260\"}.fa-gg-circle:before{content:\"\\f261\"}.fa-ghost:before{content:\"\\f6e2\"}.fa-gift:before{content:\"\\f06b\"}.fa-gifts:before{content:\"\\f79c\"}.fa-git:before{content:\"\\f1d3\"}.fa-git-square:before{content:\"\\f1d2\"}.fa-github:before{content:\"\\f09b\"}.fa-github-alt:before{content:\"\\f113\"}.fa-github-square:before{content:\"\\f092\"}.fa-gitkraken:before{content:\"\\f3a6\"}.fa-gitlab:before{content:\"\\f296\"}.fa-gitter:before{content:\"\\f426\"}.fa-glass-cheers:before{content:\"\\f79f\"}.fa-glass-martini:before{content:\"\\f000\"}.fa-glass-martini-alt:before{content:\"\\f57b\"}.fa-glass-whiskey:before{content:\"\\f7a0\"}.fa-glasses:before{content:\"\\f530\"}.fa-glide:before{content:\"\\f2a5\"}.fa-glide-g:before{content:\"\\f2a6\"}.fa-globe:before{content:\"\\f0ac\"}.fa-globe-africa:before{content:\"\\f57c\"}.fa-globe-americas:before{content:\"\\f57d\"}.fa-globe-asia:before{content:\"\\f57e\"}.fa-globe-europe:before{content:\"\\f7a2\"}.fa-gofore:before{content:\"\\f3a7\"}.fa-golf-ball:before{content:\"\\f450\"}.fa-goodreads:before{content:\"\\f3a8\"}.fa-goodreads-g:before{content:\"\\f3a9\"}.fa-google:before{content:\"\\f1a0\"}.fa-google-drive:before{content:\"\\f3aa\"}.fa-google-play:before{content:\"\\f3ab\"}.fa-google-plus:before{content:\"\\f2b3\"}.fa-google-plus-g:before{content:\"\\f0d5\"}.fa-google-plus-square:before{content:\"\\f0d4\"}.fa-google-wallet:before{content:\"\\f1ee\"}.fa-gopuram:before{content:\"\\f664\"}.fa-graduation-cap:before{content:\"\\f19d\"}.fa-gratipay:before{content:\"\\f184\"}.fa-grav:before{content:\"\\f2d6\"}.fa-greater-than:before{content:\"\\f531\"}.fa-greater-than-equal:before{content:\"\\f532\"}.fa-grimace:before{content:\"\\f57f\"}.fa-grin:before{content:\"\\f580\"}.fa-grin-alt:before{content:\"\\f581\"}.fa-grin-beam:before{content:\"\\f582\"}.fa-grin-beam-sweat:before{content:\"\\f583\"}.fa-grin-hearts:before{content:\"\\f584\"}.fa-grin-squint:before{content:\"\\f585\"}.fa-grin-squint-tears:before{content:\"\\f586\"}.fa-grin-stars:before{content:\"\\f587\"}.fa-grin-tears:before{content:\"\\f588\"}.fa-grin-tongue:before{content:\"\\f589\"}.fa-grin-tongue-squint:before{content:\"\\f58a\"}.fa-grin-tongue-wink:before{content:\"\\f58b\"}.fa-grin-wink:before{content:\"\\f58c\"}.fa-grip-horizontal:before{content:\"\\f58d\"}.fa-grip-lines:before{content:\"\\f7a4\"}.fa-grip-lines-vertical:before{content:\"\\f7a5\"}.fa-grip-vertical:before{content:\"\\f58e\"}.fa-gripfire:before{content:\"\\f3ac\"}.fa-grunt:before{content:\"\\f3ad\"}.fa-guitar:before{content:\"\\f7a6\"}.fa-gulp:before{content:\"\\f3ae\"}.fa-h-square:before{content:\"\\f0fd\"}.fa-hacker-news:before{content:\"\\f1d4\"}.fa-hacker-news-square:before{content:\"\\f3af\"}.fa-hackerrank:before{content:\"\\f5f7\"}.fa-hammer:before{content:\"\\f6e3\"}.fa-hamsa:before{content:\"\\f665\"}.fa-hand-holding:before{content:\"\\f4bd\"}.fa-hand-holding-heart:before{content:\"\\f4be\"}.fa-hand-holding-usd:before{content:\"\\f4c0\"}.fa-hand-lizard:before{content:\"\\f258\"}.fa-hand-paper:before{content:\"\\f256\"}.fa-hand-peace:before{content:\"\\f25b\"}.fa-hand-point-down:before{content:\"\\f0a7\"}.fa-hand-point-left:before{content:\"\\f0a5\"}.fa-hand-point-right:before{content:\"\\f0a4\"}.fa-hand-point-up:before{content:\"\\f0a6\"}.fa-hand-pointer:before{content:\"\\f25a\"}.fa-hand-rock:before{content:\"\\f255\"}.fa-hand-scissors:before{content:\"\\f257\"}.fa-hand-spock:before{content:\"\\f259\"}.fa-hands:before{content:\"\\f4c2\"}.fa-hands-helping:before{content:\"\\f4c4\"}.fa-handshake:before{content:\"\\f2b5\"}.fa-hanukiah:before{content:\"\\f6e6\"}.fa-hashtag:before{content:\"\\f292\"}.fa-hat-wizard:before{content:\"\\f6e8\"}.fa-haykal:before{content:\"\\f666\"}.fa-hdd:before{content:\"\\f0a0\"}.fa-heading:before{content:\"\\f1dc\"}.fa-headphones:before{content:\"\\f025\"}.fa-headphones-alt:before{content:\"\\f58f\"}.fa-headset:before{content:\"\\f590\"}.fa-heart:before{content:\"\\f004\"}.fa-heart-broken:before{content:\"\\f7a9\"}.fa-heartbeat:before{content:\"\\f21e\"}.fa-helicopter:before{content:\"\\f533\"}.fa-highlighter:before{content:\"\\f591\"}.fa-hiking:before{content:\"\\f6ec\"}.fa-hippo:before{content:\"\\f6ed\"}.fa-hips:before{content:\"\\f452\"}.fa-hire-a-helper:before{content:\"\\f3b0\"}.fa-history:before{content:\"\\f1da\"}.fa-hockey-puck:before{content:\"\\f453\"}.fa-holly-berry:before{content:\"\\f7aa\"}.fa-home:before{content:\"\\f015\"}.fa-hooli:before{content:\"\\f427\"}.fa-hornbill:before{content:\"\\f592\"}.fa-horse:before{content:\"\\f6f0\"}.fa-horse-head:before{content:\"\\f7ab\"}.fa-hospital:before{content:\"\\f0f8\"}.fa-hospital-alt:before{content:\"\\f47d\"}.fa-hospital-symbol:before{content:\"\\f47e\"}.fa-hot-tub:before{content:\"\\f593\"}.fa-hotel:before{content:\"\\f594\"}.fa-hotjar:before{content:\"\\f3b1\"}.fa-hourglass:before{content:\"\\f254\"}.fa-hourglass-end:before{content:\"\\f253\"}.fa-hourglass-half:before{content:\"\\f252\"}.fa-hourglass-start:before{content:\"\\f251\"}.fa-house-damage:before{content:\"\\f6f1\"}.fa-houzz:before{content:\"\\f27c\"}.fa-hryvnia:before{content:\"\\f6f2\"}.fa-html5:before{content:\"\\f13b\"}.fa-hubspot:before{content:\"\\f3b2\"}.fa-i-cursor:before{content:\"\\f246\"}.fa-icicles:before{content:\"\\f7ad\"}.fa-id-badge:before{content:\"\\f2c1\"}.fa-id-card:before{content:\"\\f2c2\"}.fa-id-card-alt:before{content:\"\\f47f\"}.fa-igloo:before{content:\"\\f7ae\"}.fa-image:before{content:\"\\f03e\"}.fa-images:before{content:\"\\f302\"}.fa-imdb:before{content:\"\\f2d8\"}.fa-inbox:before{content:\"\\f01c\"}.fa-indent:before{content:\"\\f03c\"}.fa-industry:before{content:\"\\f275\"}.fa-infinity:before{content:\"\\f534\"}.fa-info:before{content:\"\\f129\"}.fa-info-circle:before{content:\"\\f05a\"}.fa-instagram:before{content:\"\\f16d\"}.fa-intercom:before{content:\"\\f7af\"}.fa-internet-explorer:before{content:\"\\f26b\"}.fa-invision:before{content:\"\\f7b0\"}.fa-ioxhost:before{content:\"\\f208\"}.fa-italic:before{content:\"\\f033\"}.fa-itunes:before{content:\"\\f3b4\"}.fa-itunes-note:before{content:\"\\f3b5\"}.fa-java:before{content:\"\\f4e4\"}.fa-jedi:before{content:\"\\f669\"}.fa-jedi-order:before{content:\"\\f50e\"}.fa-jenkins:before{content:\"\\f3b6\"}.fa-jira:before{content:\"\\f7b1\"}.fa-joget:before{content:\"\\f3b7\"}.fa-joint:before{content:\"\\f595\"}.fa-joomla:before{content:\"\\f1aa\"}.fa-journal-whills:before{content:\"\\f66a\"}.fa-js:before{content:\"\\f3b8\"}.fa-js-square:before{content:\"\\f3b9\"}.fa-jsfiddle:before{content:\"\\f1cc\"}.fa-kaaba:before{content:\"\\f66b\"}.fa-kaggle:before{content:\"\\f5fa\"}.fa-key:before{content:\"\\f084\"}.fa-keybase:before{content:\"\\f4f5\"}.fa-keyboard:before{content:\"\\f11c\"}.fa-keycdn:before{content:\"\\f3ba\"}.fa-khanda:before{content:\"\\f66d\"}.fa-kickstarter:before{content:\"\\f3bb\"}.fa-kickstarter-k:before{content:\"\\f3bc\"}.fa-kiss:before{content:\"\\f596\"}.fa-kiss-beam:before{content:\"\\f597\"}.fa-kiss-wink-heart:before{content:\"\\f598\"}.fa-kiwi-bird:before{content:\"\\f535\"}.fa-korvue:before{content:\"\\f42f\"}.fa-landmark:before{content:\"\\f66f\"}.fa-language:before{content:\"\\f1ab\"}.fa-laptop:before{content:\"\\f109\"}.fa-laptop-code:before{content:\"\\f5fc\"}.fa-laravel:before{content:\"\\f3bd\"}.fa-lastfm:before{content:\"\\f202\"}.fa-lastfm-square:before{content:\"\\f203\"}.fa-laugh:before{content:\"\\f599\"}.fa-laugh-beam:before{content:\"\\f59a\"}.fa-laugh-squint:before{content:\"\\f59b\"}.fa-laugh-wink:before{content:\"\\f59c\"}.fa-layer-group:before{content:\"\\f5fd\"}.fa-leaf:before{content:\"\\f06c\"}.fa-leanpub:before{content:\"\\f212\"}.fa-lemon:before{content:\"\\f094\"}.fa-less:before{content:\"\\f41d\"}.fa-less-than:before{content:\"\\f536\"}.fa-less-than-equal:before{content:\"\\f537\"}.fa-level-down-alt:before{content:\"\\f3be\"}.fa-level-up-alt:before{content:\"\\f3bf\"}.fa-life-ring:before{content:\"\\f1cd\"}.fa-lightbulb:before{content:\"\\f0eb\"}.fa-line:before{content:\"\\f3c0\"}.fa-link:before{content:\"\\f0c1\"}.fa-linkedin:before{content:\"\\f08c\"}.fa-linkedin-in:before{content:\"\\f0e1\"}.fa-linode:before{content:\"\\f2b8\"}.fa-linux:before{content:\"\\f17c\"}.fa-lira-sign:before{content:\"\\f195\"}.fa-list:before{content:\"\\f03a\"}.fa-list-alt:before{content:\"\\f022\"}.fa-list-ol:before{content:\"\\f0cb\"}.fa-list-ul:before{content:\"\\f0ca\"}.fa-location-arrow:before{content:\"\\f124\"}.fa-lock:before{content:\"\\f023\"}.fa-lock-open:before{content:\"\\f3c1\"}.fa-long-arrow-alt-down:before{content:\"\\f309\"}.fa-long-arrow-alt-left:before{content:\"\\f30a\"}.fa-long-arrow-alt-right:before{content:\"\\f30b\"}.fa-long-arrow-alt-up:before{content:\"\\f30c\"}.fa-low-vision:before{content:\"\\f2a8\"}.fa-luggage-cart:before{content:\"\\f59d\"}.fa-lyft:before{content:\"\\f3c3\"}.fa-magento:before{content:\"\\f3c4\"}.fa-magic:before{content:\"\\f0d0\"}.fa-magnet:before{content:\"\\f076\"}.fa-mail-bulk:before{content:\"\\f674\"}.fa-mailchimp:before{content:\"\\f59e\"}.fa-male:before{content:\"\\f183\"}.fa-mandalorian:before{content:\"\\f50f\"}.fa-map:before{content:\"\\f279\"}.fa-map-marked:before{content:\"\\f59f\"}.fa-map-marked-alt:before{content:\"\\f5a0\"}.fa-map-marker:before{content:\"\\f041\"}.fa-map-marker-alt:before{content:\"\\f3c5\"}.fa-map-pin:before{content:\"\\f276\"}.fa-map-signs:before{content:\"\\f277\"}.fa-markdown:before{content:\"\\f60f\"}.fa-marker:before{content:\"\\f5a1\"}.fa-mars:before{content:\"\\f222\"}.fa-mars-double:before{content:\"\\f227\"}.fa-mars-stroke:before{content:\"\\f229\"}.fa-mars-stroke-h:before{content:\"\\f22b\"}.fa-mars-stroke-v:before{content:\"\\f22a\"}.fa-mask:before{content:\"\\f6fa\"}.fa-mastodon:before{content:\"\\f4f6\"}.fa-maxcdn:before{content:\"\\f136\"}.fa-medal:before{content:\"\\f5a2\"}.fa-medapps:before{content:\"\\f3c6\"}.fa-medium:before{content:\"\\f23a\"}.fa-medium-m:before{content:\"\\f3c7\"}.fa-medkit:before{content:\"\\f0fa\"}.fa-medrt:before{content:\"\\f3c8\"}.fa-meetup:before{content:\"\\f2e0\"}.fa-megaport:before{content:\"\\f5a3\"}.fa-meh:before{content:\"\\f11a\"}.fa-meh-blank:before{content:\"\\f5a4\"}.fa-meh-rolling-eyes:before{content:\"\\f5a5\"}.fa-memory:before{content:\"\\f538\"}.fa-mendeley:before{content:\"\\f7b3\"}.fa-menorah:before{content:\"\\f676\"}.fa-mercury:before{content:\"\\f223\"}.fa-meteor:before{content:\"\\f753\"}.fa-microchip:before{content:\"\\f2db\"}.fa-microphone:before{content:\"\\f130\"}.fa-microphone-alt:before{content:\"\\f3c9\"}.fa-microphone-alt-slash:before{content:\"\\f539\"}.fa-microphone-slash:before{content:\"\\f131\"}.fa-microscope:before{content:\"\\f610\"}.fa-microsoft:before{content:\"\\f3ca\"}.fa-minus:before{content:\"\\f068\"}.fa-minus-circle:before{content:\"\\f056\"}.fa-minus-square:before{content:\"\\f146\"}.fa-mitten:before{content:\"\\f7b5\"}.fa-mix:before{content:\"\\f3cb\"}.fa-mixcloud:before{content:\"\\f289\"}.fa-mizuni:before{content:\"\\f3cc\"}.fa-mobile:before{content:\"\\f10b\"}.fa-mobile-alt:before{content:\"\\f3cd\"}.fa-modx:before{content:\"\\f285\"}.fa-monero:before{content:\"\\f3d0\"}.fa-money-bill:before{content:\"\\f0d6\"}.fa-money-bill-alt:before{content:\"\\f3d1\"}.fa-money-bill-wave:before{content:\"\\f53a\"}.fa-money-bill-wave-alt:before{content:\"\\f53b\"}.fa-money-check:before{content:\"\\f53c\"}.fa-money-check-alt:before{content:\"\\f53d\"}.fa-monument:before{content:\"\\f5a6\"}.fa-moon:before{content:\"\\f186\"}.fa-mortar-pestle:before{content:\"\\f5a7\"}.fa-mosque:before{content:\"\\f678\"}.fa-motorcycle:before{content:\"\\f21c\"}.fa-mountain:before{content:\"\\f6fc\"}.fa-mouse-pointer:before{content:\"\\f245\"}.fa-mug-hot:before{content:\"\\f7b6\"}.fa-music:before{content:\"\\f001\"}.fa-napster:before{content:\"\\f3d2\"}.fa-neos:before{content:\"\\f612\"}.fa-network-wired:before{content:\"\\f6ff\"}.fa-neuter:before{content:\"\\f22c\"}.fa-newspaper:before{content:\"\\f1ea\"}.fa-nimblr:before{content:\"\\f5a8\"}.fa-nintendo-switch:before{content:\"\\f418\"}.fa-node:before{content:\"\\f419\"}.fa-node-js:before{content:\"\\f3d3\"}.fa-not-equal:before{content:\"\\f53e\"}.fa-notes-medical:before{content:\"\\f481\"}.fa-npm:before{content:\"\\f3d4\"}.fa-ns8:before{content:\"\\f3d5\"}.fa-nutritionix:before{content:\"\\f3d6\"}.fa-object-group:before{content:\"\\f247\"}.fa-object-ungroup:before{content:\"\\f248\"}.fa-odnoklassniki:before{content:\"\\f263\"}.fa-odnoklassniki-square:before{content:\"\\f264\"}.fa-oil-can:before{content:\"\\f613\"}.fa-old-republic:before{content:\"\\f510\"}.fa-om:before{content:\"\\f679\"}.fa-opencart:before{content:\"\\f23d\"}.fa-openid:before{content:\"\\f19b\"}.fa-opera:before{content:\"\\f26a\"}.fa-optin-monster:before{content:\"\\f23c\"}.fa-osi:before{content:\"\\f41a\"}.fa-otter:before{content:\"\\f700\"}.fa-outdent:before{content:\"\\f03b\"}.fa-page4:before{content:\"\\f3d7\"}.fa-pagelines:before{content:\"\\f18c\"}.fa-paint-brush:before{content:\"\\f1fc\"}.fa-paint-roller:before{content:\"\\f5aa\"}.fa-palette:before{content:\"\\f53f\"}.fa-palfed:before{content:\"\\f3d8\"}.fa-pallet:before{content:\"\\f482\"}.fa-paper-plane:before{content:\"\\f1d8\"}.fa-paperclip:before{content:\"\\f0c6\"}.fa-parachute-box:before{content:\"\\f4cd\"}.fa-paragraph:before{content:\"\\f1dd\"}.fa-parking:before{content:\"\\f540\"}.fa-passport:before{content:\"\\f5ab\"}.fa-pastafarianism:before{content:\"\\f67b\"}.fa-paste:before{content:\"\\f0ea\"}.fa-patreon:before{content:\"\\f3d9\"}.fa-pause:before{content:\"\\f04c\"}.fa-pause-circle:before{content:\"\\f28b\"}.fa-paw:before{content:\"\\f1b0\"}.fa-paypal:before{content:\"\\f1ed\"}.fa-peace:before{content:\"\\f67c\"}.fa-pen:before{content:\"\\f304\"}.fa-pen-alt:before{content:\"\\f305\"}.fa-pen-fancy:before{content:\"\\f5ac\"}.fa-pen-nib:before{content:\"\\f5ad\"}.fa-pen-square:before{content:\"\\f14b\"}.fa-pencil-alt:before{content:\"\\f303\"}.fa-pencil-ruler:before{content:\"\\f5ae\"}.fa-penny-arcade:before{content:\"\\f704\"}.fa-people-carry:before{content:\"\\f4ce\"}.fa-percent:before{content:\"\\f295\"}.fa-percentage:before{content:\"\\f541\"}.fa-periscope:before{content:\"\\f3da\"}.fa-person-booth:before{content:\"\\f756\"}.fa-phabricator:before{content:\"\\f3db\"}.fa-phoenix-framework:before{content:\"\\f3dc\"}.fa-phoenix-squadron:before{content:\"\\f511\"}.fa-phone:before{content:\"\\f095\"}.fa-phone-slash:before{content:\"\\f3dd\"}.fa-phone-square:before{content:\"\\f098\"}.fa-phone-volume:before{content:\"\\f2a0\"}.fa-php:before{content:\"\\f457\"}.fa-pied-piper:before{content:\"\\f2ae\"}.fa-pied-piper-alt:before{content:\"\\f1a8\"}.fa-pied-piper-hat:before{content:\"\\f4e5\"}.fa-pied-piper-pp:before{content:\"\\f1a7\"}.fa-piggy-bank:before{content:\"\\f4d3\"}.fa-pills:before{content:\"\\f484\"}.fa-pinterest:before{content:\"\\f0d2\"}.fa-pinterest-p:before{content:\"\\f231\"}.fa-pinterest-square:before{content:\"\\f0d3\"}.fa-place-of-worship:before{content:\"\\f67f\"}.fa-plane:before{content:\"\\f072\"}.fa-plane-arrival:before{content:\"\\f5af\"}.fa-plane-departure:before{content:\"\\f5b0\"}.fa-play:before{content:\"\\f04b\"}.fa-play-circle:before{content:\"\\f144\"}.fa-playstation:before{content:\"\\f3df\"}.fa-plug:before{content:\"\\f1e6\"}.fa-plus:before{content:\"\\f067\"}.fa-plus-circle:before{content:\"\\f055\"}.fa-plus-square:before{content:\"\\f0fe\"}.fa-podcast:before{content:\"\\f2ce\"}.fa-poll:before{content:\"\\f681\"}.fa-poll-h:before{content:\"\\f682\"}.fa-poo:before{content:\"\\f2fe\"}.fa-poo-storm:before{content:\"\\f75a\"}.fa-poop:before{content:\"\\f619\"}.fa-portrait:before{content:\"\\f3e0\"}.fa-pound-sign:before{content:\"\\f154\"}.fa-power-off:before{content:\"\\f011\"}.fa-pray:before{content:\"\\f683\"}.fa-praying-hands:before{content:\"\\f684\"}.fa-prescription:before{content:\"\\f5b1\"}.fa-prescription-bottle:before{content:\"\\f485\"}.fa-prescription-bottle-alt:before{content:\"\\f486\"}.fa-print:before{content:\"\\f02f\"}.fa-procedures:before{content:\"\\f487\"}.fa-product-hunt:before{content:\"\\f288\"}.fa-project-diagram:before{content:\"\\f542\"}.fa-pushed:before{content:\"\\f3e1\"}.fa-puzzle-piece:before{content:\"\\f12e\"}.fa-python:before{content:\"\\f3e2\"}.fa-qq:before{content:\"\\f1d6\"}.fa-qrcode:before{content:\"\\f029\"}.fa-question:before{content:\"\\f128\"}.fa-question-circle:before{content:\"\\f059\"}.fa-quidditch:before{content:\"\\f458\"}.fa-quinscape:before{content:\"\\f459\"}.fa-quora:before{content:\"\\f2c4\"}.fa-quote-left:before{content:\"\\f10d\"}.fa-quote-right:before{content:\"\\f10e\"}.fa-quran:before{content:\"\\f687\"}.fa-r-project:before{content:\"\\f4f7\"}.fa-radiation:before{content:\"\\f7b9\"}.fa-radiation-alt:before{content:\"\\f7ba\"}.fa-rainbow:before{content:\"\\f75b\"}.fa-random:before{content:\"\\f074\"}.fa-raspberry-pi:before{content:\"\\f7bb\"}.fa-ravelry:before{content:\"\\f2d9\"}.fa-react:before{content:\"\\f41b\"}.fa-reacteurope:before{content:\"\\f75d\"}.fa-readme:before{content:\"\\f4d5\"}.fa-rebel:before{content:\"\\f1d0\"}.fa-receipt:before{content:\"\\f543\"}.fa-recycle:before{content:\"\\f1b8\"}.fa-red-river:before{content:\"\\f3e3\"}.fa-reddit:before{content:\"\\f1a1\"}.fa-reddit-alien:before{content:\"\\f281\"}.fa-reddit-square:before{content:\"\\f1a2\"}.fa-redhat:before{content:\"\\f7bc\"}.fa-redo:before{content:\"\\f01e\"}.fa-redo-alt:before{content:\"\\f2f9\"}.fa-registered:before{content:\"\\f25d\"}.fa-renren:before{content:\"\\f18b\"}.fa-reply:before{content:\"\\f3e5\"}.fa-reply-all:before{content:\"\\f122\"}.fa-replyd:before{content:\"\\f3e6\"}.fa-republican:before{content:\"\\f75e\"}.fa-researchgate:before{content:\"\\f4f8\"}.fa-resolving:before{content:\"\\f3e7\"}.fa-restroom:before{content:\"\\f7bd\"}.fa-retweet:before{content:\"\\f079\"}.fa-rev:before{content:\"\\f5b2\"}.fa-ribbon:before{content:\"\\f4d6\"}.fa-ring:before{content:\"\\f70b\"}.fa-road:before{content:\"\\f018\"}.fa-robot:before{content:\"\\f544\"}.fa-rocket:before{content:\"\\f135\"}.fa-rocketchat:before{content:\"\\f3e8\"}.fa-rockrms:before{content:\"\\f3e9\"}.fa-route:before{content:\"\\f4d7\"}.fa-rss:before{content:\"\\f09e\"}.fa-rss-square:before{content:\"\\f143\"}.fa-ruble-sign:before{content:\"\\f158\"}.fa-ruler:before{content:\"\\f545\"}.fa-ruler-combined:before{content:\"\\f546\"}.fa-ruler-horizontal:before{content:\"\\f547\"}.fa-ruler-vertical:before{content:\"\\f548\"}.fa-running:before{content:\"\\f70c\"}.fa-rupee-sign:before{content:\"\\f156\"}.fa-sad-cry:before{content:\"\\f5b3\"}.fa-sad-tear:before{content:\"\\f5b4\"}.fa-safari:before{content:\"\\f267\"}.fa-sass:before{content:\"\\f41e\"}.fa-satellite:before{content:\"\\f7bf\"}.fa-satellite-dish:before{content:\"\\f7c0\"}.fa-save:before{content:\"\\f0c7\"}.fa-schlix:before{content:\"\\f3ea\"}.fa-school:before{content:\"\\f549\"}.fa-screwdriver:before{content:\"\\f54a\"}.fa-scribd:before{content:\"\\f28a\"}.fa-scroll:before{content:\"\\f70e\"}.fa-sd-card:before{content:\"\\f7c2\"}.fa-search:before{content:\"\\f002\"}.fa-search-dollar:before{content:\"\\f688\"}.fa-search-location:before{content:\"\\f689\"}.fa-search-minus:before{content:\"\\f010\"}.fa-search-plus:before{content:\"\\f00e\"}.fa-searchengin:before{content:\"\\f3eb\"}.fa-seedling:before{content:\"\\f4d8\"}.fa-sellcast:before{content:\"\\f2da\"}.fa-sellsy:before{content:\"\\f213\"}.fa-server:before{content:\"\\f233\"}.fa-servicestack:before{content:\"\\f3ec\"}.fa-shapes:before{content:\"\\f61f\"}.fa-share:before{content:\"\\f064\"}.fa-share-alt:before{content:\"\\f1e0\"}.fa-share-alt-square:before{content:\"\\f1e1\"}.fa-share-square:before{content:\"\\f14d\"}.fa-shekel-sign:before{content:\"\\f20b\"}.fa-shield-alt:before{content:\"\\f3ed\"}.fa-ship:before{content:\"\\f21a\"}.fa-shipping-fast:before{content:\"\\f48b\"}.fa-shirtsinbulk:before{content:\"\\f214\"}.fa-shoe-prints:before{content:\"\\f54b\"}.fa-shopping-bag:before{content:\"\\f290\"}.fa-shopping-basket:before{content:\"\\f291\"}.fa-shopping-cart:before{content:\"\\f07a\"}.fa-shopware:before{content:\"\\f5b5\"}.fa-shower:before{content:\"\\f2cc\"}.fa-shuttle-van:before{content:\"\\f5b6\"}.fa-sign:before{content:\"\\f4d9\"}.fa-sign-in-alt:before{content:\"\\f2f6\"}.fa-sign-language:before{content:\"\\f2a7\"}.fa-sign-out-alt:before{content:\"\\f2f5\"}.fa-signal:before{content:\"\\f012\"}.fa-signature:before{content:\"\\f5b7\"}.fa-sim-card:before{content:\"\\f7c4\"}.fa-simplybuilt:before{content:\"\\f215\"}.fa-sistrix:before{content:\"\\f3ee\"}.fa-sitemap:before{content:\"\\f0e8\"}.fa-sith:before{content:\"\\f512\"}.fa-skating:before{content:\"\\f7c5\"}.fa-sketch:before{content:\"\\f7c6\"}.fa-skiing:before{content:\"\\f7c9\"}.fa-skiing-nordic:before{content:\"\\f7ca\"}.fa-skull:before{content:\"\\f54c\"}.fa-skull-crossbones:before{content:\"\\f714\"}.fa-skyatlas:before{content:\"\\f216\"}.fa-skype:before{content:\"\\f17e\"}.fa-slack:before{content:\"\\f198\"}.fa-slack-hash:before{content:\"\\f3ef\"}.fa-slash:before{content:\"\\f715\"}.fa-sleigh:before{content:\"\\f7cc\"}.fa-sliders-h:before{content:\"\\f1de\"}.fa-slideshare:before{content:\"\\f1e7\"}.fa-smile:before{content:\"\\f118\"}.fa-smile-beam:before{content:\"\\f5b8\"}.fa-smile-wink:before{content:\"\\f4da\"}.fa-smog:before{content:\"\\f75f\"}.fa-smoking:before{content:\"\\f48d\"}.fa-smoking-ban:before{content:\"\\f54d\"}.fa-sms:before{content:\"\\f7cd\"}.fa-snapchat:before{content:\"\\f2ab\"}.fa-snapchat-ghost:before{content:\"\\f2ac\"}.fa-snapchat-square:before{content:\"\\f2ad\"}.fa-snowboarding:before{content:\"\\f7ce\"}.fa-snowflake:before{content:\"\\f2dc\"}.fa-snowman:before{content:\"\\f7d0\"}.fa-snowplow:before{content:\"\\f7d2\"}.fa-socks:before{content:\"\\f696\"}.fa-solar-panel:before{content:\"\\f5ba\"}.fa-sort:before{content:\"\\f0dc\"}.fa-sort-alpha-down:before{content:\"\\f15d\"}.fa-sort-alpha-up:before{content:\"\\f15e\"}.fa-sort-amount-down:before{content:\"\\f160\"}.fa-sort-amount-up:before{content:\"\\f161\"}.fa-sort-down:before{content:\"\\f0dd\"}.fa-sort-numeric-down:before{content:\"\\f162\"}.fa-sort-numeric-up:before{content:\"\\f163\"}.fa-sort-up:before{content:\"\\f0de\"}.fa-soundcloud:before{content:\"\\f1be\"}.fa-sourcetree:before{content:\"\\f7d3\"}.fa-spa:before{content:\"\\f5bb\"}.fa-space-shuttle:before{content:\"\\f197\"}.fa-speakap:before{content:\"\\f3f3\"}.fa-spider:before{content:\"\\f717\"}.fa-spinner:before{content:\"\\f110\"}.fa-splotch:before{content:\"\\f5bc\"}.fa-spotify:before{content:\"\\f1bc\"}.fa-spray-can:before{content:\"\\f5bd\"}.fa-square:before{content:\"\\f0c8\"}.fa-square-full:before{content:\"\\f45c\"}.fa-square-root-alt:before{content:\"\\f698\"}.fa-squarespace:before{content:\"\\f5be\"}.fa-stack-exchange:before{content:\"\\f18d\"}.fa-stack-overflow:before{content:\"\\f16c\"}.fa-stamp:before{content:\"\\f5bf\"}.fa-star:before{content:\"\\f005\"}.fa-star-and-crescent:before{content:\"\\f699\"}.fa-star-half:before{content:\"\\f089\"}.fa-star-half-alt:before{content:\"\\f5c0\"}.fa-star-of-david:before{content:\"\\f69a\"}.fa-star-of-life:before{content:\"\\f621\"}.fa-staylinked:before{content:\"\\f3f5\"}.fa-steam:before{content:\"\\f1b6\"}.fa-steam-square:before{content:\"\\f1b7\"}.fa-steam-symbol:before{content:\"\\f3f6\"}.fa-step-backward:before{content:\"\\f048\"}.fa-step-forward:before{content:\"\\f051\"}.fa-stethoscope:before{content:\"\\f0f1\"}.fa-sticker-mule:before{content:\"\\f3f7\"}.fa-sticky-note:before{content:\"\\f249\"}.fa-stop:before{content:\"\\f04d\"}.fa-stop-circle:before{content:\"\\f28d\"}.fa-stopwatch:before{content:\"\\f2f2\"}.fa-store:before{content:\"\\f54e\"}.fa-store-alt:before{content:\"\\f54f\"}.fa-strava:before{content:\"\\f428\"}.fa-stream:before{content:\"\\f550\"}.fa-street-view:before{content:\"\\f21d\"}.fa-strikethrough:before{content:\"\\f0cc\"}.fa-stripe:before{content:\"\\f429\"}.fa-stripe-s:before{content:\"\\f42a\"}.fa-stroopwafel:before{content:\"\\f551\"}.fa-studiovinari:before{content:\"\\f3f8\"}.fa-stumbleupon:before{content:\"\\f1a4\"}.fa-stumbleupon-circle:before{content:\"\\f1a3\"}.fa-subscript:before{content:\"\\f12c\"}.fa-subway:before{content:\"\\f239\"}.fa-suitcase:before{content:\"\\f0f2\"}.fa-suitcase-rolling:before{content:\"\\f5c1\"}.fa-sun:before{content:\"\\f185\"}.fa-superpowers:before{content:\"\\f2dd\"}.fa-superscript:before{content:\"\\f12b\"}.fa-supple:before{content:\"\\f3f9\"}.fa-surprise:before{content:\"\\f5c2\"}.fa-suse:before{content:\"\\f7d6\"}.fa-swatchbook:before{content:\"\\f5c3\"}.fa-swimmer:before{content:\"\\f5c4\"}.fa-swimming-pool:before{content:\"\\f5c5\"}.fa-synagogue:before{content:\"\\f69b\"}.fa-sync:before{content:\"\\f021\"}.fa-sync-alt:before{content:\"\\f2f1\"}.fa-syringe:before{content:\"\\f48e\"}.fa-table:before{content:\"\\f0ce\"}.fa-table-tennis:before{content:\"\\f45d\"}.fa-tablet:before{content:\"\\f10a\"}.fa-tablet-alt:before{content:\"\\f3fa\"}.fa-tablets:before{content:\"\\f490\"}.fa-tachometer-alt:before{content:\"\\f3fd\"}.fa-tag:before{content:\"\\f02b\"}.fa-tags:before{content:\"\\f02c\"}.fa-tape:before{content:\"\\f4db\"}.fa-tasks:before{content:\"\\f0ae\"}.fa-taxi:before{content:\"\\f1ba\"}.fa-teamspeak:before{content:\"\\f4f9\"}.fa-teeth:before{content:\"\\f62e\"}.fa-teeth-open:before{content:\"\\f62f\"}.fa-telegram:before{content:\"\\f2c6\"}.fa-telegram-plane:before{content:\"\\f3fe\"}.fa-temperature-high:before{content:\"\\f769\"}.fa-temperature-low:before{content:\"\\f76b\"}.fa-tencent-weibo:before{content:\"\\f1d5\"}.fa-tenge:before{content:\"\\f7d7\"}.fa-terminal:before{content:\"\\f120\"}.fa-text-height:before{content:\"\\f034\"}.fa-text-width:before{content:\"\\f035\"}.fa-th:before{content:\"\\f00a\"}.fa-th-large:before{content:\"\\f009\"}.fa-th-list:before{content:\"\\f00b\"}.fa-the-red-yeti:before{content:\"\\f69d\"}.fa-theater-masks:before{content:\"\\f630\"}.fa-themeco:before{content:\"\\f5c6\"}.fa-themeisle:before{content:\"\\f2b2\"}.fa-thermometer:before{content:\"\\f491\"}.fa-thermometer-empty:before{content:\"\\f2cb\"}.fa-thermometer-full:before{content:\"\\f2c7\"}.fa-thermometer-half:before{content:\"\\f2c9\"}.fa-thermometer-quarter:before{content:\"\\f2ca\"}.fa-thermometer-three-quarters:before{content:\"\\f2c8\"}.fa-think-peaks:before{content:\"\\f731\"}.fa-thumbs-down:before{content:\"\\f165\"}.fa-thumbs-up:before{content:\"\\f164\"}.fa-thumbtack:before{content:\"\\f08d\"}.fa-ticket-alt:before{content:\"\\f3ff\"}.fa-times:before{content:\"\\f00d\"}.fa-times-circle:before{content:\"\\f057\"}.fa-tint:before{content:\"\\f043\"}.fa-tint-slash:before{content:\"\\f5c7\"}.fa-tired:before{content:\"\\f5c8\"}.fa-toggle-off:before{content:\"\\f204\"}.fa-toggle-on:before{content:\"\\f205\"}.fa-toilet:before{content:\"\\f7d8\"}.fa-toilet-paper:before{content:\"\\f71e\"}.fa-toolbox:before{content:\"\\f552\"}.fa-tools:before{content:\"\\f7d9\"}.fa-tooth:before{content:\"\\f5c9\"}.fa-torah:before{content:\"\\f6a0\"}.fa-torii-gate:before{content:\"\\f6a1\"}.fa-tractor:before{content:\"\\f722\"}.fa-trade-federation:before{content:\"\\f513\"}.fa-trademark:before{content:\"\\f25c\"}.fa-traffic-light:before{content:\"\\f637\"}.fa-train:before{content:\"\\f238\"}.fa-tram:before{content:\"\\f7da\"}.fa-transgender:before{content:\"\\f224\"}.fa-transgender-alt:before{content:\"\\f225\"}.fa-trash:before{content:\"\\f1f8\"}.fa-trash-alt:before{content:\"\\f2ed\"}.fa-tree:before{content:\"\\f1bb\"}.fa-trello:before{content:\"\\f181\"}.fa-tripadvisor:before{content:\"\\f262\"}.fa-trophy:before{content:\"\\f091\"}.fa-truck:before{content:\"\\f0d1\"}.fa-truck-loading:before{content:\"\\f4de\"}.fa-truck-monster:before{content:\"\\f63b\"}.fa-truck-moving:before{content:\"\\f4df\"}.fa-truck-pickup:before{content:\"\\f63c\"}.fa-tshirt:before{content:\"\\f553\"}.fa-tty:before{content:\"\\f1e4\"}.fa-tumblr:before{content:\"\\f173\"}.fa-tumblr-square:before{content:\"\\f174\"}.fa-tv:before{content:\"\\f26c\"}.fa-twitch:before{content:\"\\f1e8\"}.fa-twitter:before{content:\"\\f099\"}.fa-twitter-square:before{content:\"\\f081\"}.fa-typo3:before{content:\"\\f42b\"}.fa-uber:before{content:\"\\f402\"}.fa-ubuntu:before{content:\"\\f7df\"}.fa-uikit:before{content:\"\\f403\"}.fa-umbrella:before{content:\"\\f0e9\"}.fa-umbrella-beach:before{content:\"\\f5ca\"}.fa-underline:before{content:\"\\f0cd\"}.fa-undo:before{content:\"\\f0e2\"}.fa-undo-alt:before{content:\"\\f2ea\"}.fa-uniregistry:before{content:\"\\f404\"}.fa-universal-access:before{content:\"\\f29a\"}.fa-university:before{content:\"\\f19c\"}.fa-unlink:before{content:\"\\f127\"}.fa-unlock:before{content:\"\\f09c\"}.fa-unlock-alt:before{content:\"\\f13e\"}.fa-untappd:before{content:\"\\f405\"}.fa-upload:before{content:\"\\f093\"}.fa-ups:before{content:\"\\f7e0\"}.fa-usb:before{content:\"\\f287\"}.fa-user:before{content:\"\\f007\"}.fa-user-alt:before{content:\"\\f406\"}.fa-user-alt-slash:before{content:\"\\f4fa\"}.fa-user-astronaut:before{content:\"\\f4fb\"}.fa-user-check:before{content:\"\\f4fc\"}.fa-user-circle:before{content:\"\\f2bd\"}.fa-user-clock:before{content:\"\\f4fd\"}.fa-user-cog:before{content:\"\\f4fe\"}.fa-user-edit:before{content:\"\\f4ff\"}.fa-user-friends:before{content:\"\\f500\"}.fa-user-graduate:before{content:\"\\f501\"}.fa-user-injured:before{content:\"\\f728\"}.fa-user-lock:before{content:\"\\f502\"}.fa-user-md:before{content:\"\\f0f0\"}.fa-user-minus:before{content:\"\\f503\"}.fa-user-ninja:before{content:\"\\f504\"}.fa-user-plus:before{content:\"\\f234\"}.fa-user-secret:before{content:\"\\f21b\"}.fa-user-shield:before{content:\"\\f505\"}.fa-user-slash:before{content:\"\\f506\"}.fa-user-tag:before{content:\"\\f507\"}.fa-user-tie:before{content:\"\\f508\"}.fa-user-times:before{content:\"\\f235\"}.fa-users:before{content:\"\\f0c0\"}.fa-users-cog:before{content:\"\\f509\"}.fa-usps:before{content:\"\\f7e1\"}.fa-ussunnah:before{content:\"\\f407\"}.fa-utensil-spoon:before{content:\"\\f2e5\"}.fa-utensils:before{content:\"\\f2e7\"}.fa-vaadin:before{content:\"\\f408\"}.fa-vector-square:before{content:\"\\f5cb\"}.fa-venus:before{content:\"\\f221\"}.fa-venus-double:before{content:\"\\f226\"}.fa-venus-mars:before{content:\"\\f228\"}.fa-viacoin:before{content:\"\\f237\"}.fa-viadeo:before{content:\"\\f2a9\"}.fa-viadeo-square:before{content:\"\\f2aa\"}.fa-vial:before{content:\"\\f492\"}.fa-vials:before{content:\"\\f493\"}.fa-viber:before{content:\"\\f409\"}.fa-video:before{content:\"\\f03d\"}.fa-video-slash:before{content:\"\\f4e2\"}.fa-vihara:before{content:\"\\f6a7\"}.fa-vimeo:before{content:\"\\f40a\"}.fa-vimeo-square:before{content:\"\\f194\"}.fa-vimeo-v:before{content:\"\\f27d\"}.fa-vine:before{content:\"\\f1ca\"}.fa-vk:before{content:\"\\f189\"}.fa-vnv:before{content:\"\\f40b\"}.fa-volleyball-ball:before{content:\"\\f45f\"}.fa-volume-down:before{content:\"\\f027\"}.fa-volume-mute:before{content:\"\\f6a9\"}.fa-volume-off:before{content:\"\\f026\"}.fa-volume-up:before{content:\"\\f028\"}.fa-vote-yea:before{content:\"\\f772\"}.fa-vr-cardboard:before{content:\"\\f729\"}.fa-vuejs:before{content:\"\\f41f\"}.fa-walking:before{content:\"\\f554\"}.fa-wallet:before{content:\"\\f555\"}.fa-warehouse:before{content:\"\\f494\"}.fa-water:before{content:\"\\f773\"}.fa-weebly:before{content:\"\\f5cc\"}.fa-weibo:before{content:\"\\f18a\"}.fa-weight:before{content:\"\\f496\"}.fa-weight-hanging:before{content:\"\\f5cd\"}.fa-weixin:before{content:\"\\f1d7\"}.fa-whatsapp:before{content:\"\\f232\"}.fa-whatsapp-square:before{content:\"\\f40c\"}.fa-wheelchair:before{content:\"\\f193\"}.fa-whmcs:before{content:\"\\f40d\"}.fa-wifi:before{content:\"\\f1eb\"}.fa-wikipedia-w:before{content:\"\\f266\"}.fa-wind:before{content:\"\\f72e\"}.fa-window-close:before{content:\"\\f410\"}.fa-window-maximize:before{content:\"\\f2d0\"}.fa-window-minimize:before{content:\"\\f2d1\"}.fa-window-restore:before{content:\"\\f2d2\"}.fa-windows:before{content:\"\\f17a\"}.fa-wine-bottle:before{content:\"\\f72f\"}.fa-wine-glass:before{content:\"\\f4e3\"}.fa-wine-glass-alt:before{content:\"\\f5ce\"}.fa-wix:before{content:\"\\f5cf\"}.fa-wizards-of-the-coast:before{content:\"\\f730\"}.fa-wolf-pack-battalion:before{content:\"\\f514\"}.fa-won-sign:before{content:\"\\f159\"}.fa-wordpress:before{content:\"\\f19a\"}.fa-wordpress-simple:before{content:\"\\f411\"}.fa-wpbeginner:before{content:\"\\f297\"}.fa-wpexplorer:before{content:\"\\f2de\"}.fa-wpforms:before{content:\"\\f298\"}.fa-wpressr:before{content:\"\\f3e4\"}.fa-wrench:before{content:\"\\f0ad\"}.fa-x-ray:before{content:\"\\f497\"}.fa-xbox:before{content:\"\\f412\"}.fa-xing:before{content:\"\\f168\"}.fa-xing-square:before{content:\"\\f169\"}.fa-y-combinator:before{content:\"\\f23b\"}.fa-yahoo:before{content:\"\\f19e\"}.fa-yandex:before{content:\"\\f413\"}.fa-yandex-international:before{content:\"\\f414\"}.fa-yarn:before{content:\"\\f7e3\"}.fa-yelp:before{content:\"\\f1e9\"}.fa-yen-sign:before{content:\"\\f157\"}.fa-yin-yang:before{content:\"\\f6ad\"}.fa-yoast:before{content:\"\\f2b1\"}.fa-youtube:before{content:\"\\f167\"}.fa-youtube-square:before{content:\"\\f431\"}.fa-zhihu:before{content:\"\\f63f\"}.fa.fa-glass:before{content:\"\\f000\"}.fa.fa-meetup{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-star-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-star-o:before{content:\"\\f005\"}.fa.fa-close:before,.fa.fa-remove:before{content:\"\\f00d\"}.fa.fa-gear:before{content:\"\\f013\"}.fa.fa-trash-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-trash-o:before{content:\"\\f2ed\"}.fa.fa-file-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-o:before{content:\"\\f15b\"}.fa.fa-clock-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-clock-o:before{content:\"\\f017\"}.fa.fa-arrow-circle-o-down{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-arrow-circle-o-down:before{content:\"\\f358\"}.fa.fa-arrow-circle-o-up{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-arrow-circle-o-up:before{content:\"\\f35b\"}.fa.fa-play-circle-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-play-circle-o:before{content:\"\\f144\"}.fa.fa-repeat:before,.fa.fa-rotate-right:before{content:\"\\f01e\"}.fa.fa-refresh:before{content:\"\\f021\"}.fa.fa-list-alt{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-dedent:before{content:\"\\f03b\"}.fa.fa-video-camera:before{content:\"\\f03d\"}.fa.fa-picture-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-picture-o:before{content:\"\\f03e\"}.fa.fa-photo{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-photo:before{content:\"\\f03e\"}.fa.fa-image{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-image:before{content:\"\\f03e\"}.fa.fa-pencil:before{content:\"\\f303\"}.fa.fa-map-marker:before{content:\"\\f3c5\"}.fa.fa-pencil-square-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-pencil-square-o:before{content:\"\\f044\"}.fa.fa-share-square-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-share-square-o:before{content:\"\\f14d\"}.fa.fa-check-square-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-check-square-o:before{content:\"\\f14a\"}.fa.fa-arrows:before{content:\"\\f0b2\"}.fa.fa-times-circle-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-times-circle-o:before{content:\"\\f057\"}.fa.fa-check-circle-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-check-circle-o:before{content:\"\\f058\"}.fa.fa-mail-forward:before{content:\"\\f064\"}.fa.fa-eye,.fa.fa-eye-slash{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-warning:before{content:\"\\f071\"}.fa.fa-calendar:before{content:\"\\f073\"}.fa.fa-arrows-v:before{content:\"\\f338\"}.fa.fa-arrows-h:before{content:\"\\f337\"}.fa.fa-bar-chart{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-bar-chart:before{content:\"\\f080\"}.fa.fa-bar-chart-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-bar-chart-o:before{content:\"\\f080\"}.fa.fa-facebook-square,.fa.fa-twitter-square{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-gears:before{content:\"\\f085\"}.fa.fa-thumbs-o-up{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-thumbs-o-up:before{content:\"\\f164\"}.fa.fa-thumbs-o-down{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-thumbs-o-down:before{content:\"\\f165\"}.fa.fa-heart-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-heart-o:before{content:\"\\f004\"}.fa.fa-sign-out:before{content:\"\\f2f5\"}.fa.fa-linkedin-square{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-linkedin-square:before{content:\"\\f08c\"}.fa.fa-thumb-tack:before{content:\"\\f08d\"}.fa.fa-external-link:before{content:\"\\f35d\"}.fa.fa-sign-in:before{content:\"\\f2f6\"}.fa.fa-github-square{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-lemon-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-lemon-o:before{content:\"\\f094\"}.fa.fa-square-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-square-o:before{content:\"\\f0c8\"}.fa.fa-bookmark-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-bookmark-o:before{content:\"\\f02e\"}.fa.fa-facebook,.fa.fa-twitter{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-facebook:before{content:\"\\f39e\"}.fa.fa-facebook-f{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-facebook-f:before{content:\"\\f39e\"}.fa.fa-github{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-credit-card{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-feed:before{content:\"\\f09e\"}.fa.fa-hdd-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hdd-o:before{content:\"\\f0a0\"}.fa.fa-hand-o-right{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hand-o-right:before{content:\"\\f0a4\"}.fa.fa-hand-o-left{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hand-o-left:before{content:\"\\f0a5\"}.fa.fa-hand-o-up{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hand-o-up:before{content:\"\\f0a6\"}.fa.fa-hand-o-down{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hand-o-down:before{content:\"\\f0a7\"}.fa.fa-arrows-alt:before{content:\"\\f31e\"}.fa.fa-group:before{content:\"\\f0c0\"}.fa.fa-chain:before{content:\"\\f0c1\"}.fa.fa-scissors:before{content:\"\\f0c4\"}.fa.fa-files-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-files-o:before{content:\"\\f0c5\"}.fa.fa-floppy-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-floppy-o:before{content:\"\\f0c7\"}.fa.fa-navicon:before,.fa.fa-reorder:before{content:\"\\f0c9\"}.fa.fa-google-plus,.fa.fa-google-plus-square,.fa.fa-pinterest,.fa.fa-pinterest-square{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-google-plus:before{content:\"\\f0d5\"}.fa.fa-money{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-money:before{content:\"\\f3d1\"}.fa.fa-unsorted:before{content:\"\\f0dc\"}.fa.fa-sort-desc:before{content:\"\\f0dd\"}.fa.fa-sort-asc:before{content:\"\\f0de\"}.fa.fa-linkedin{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-linkedin:before{content:\"\\f0e1\"}.fa.fa-rotate-left:before{content:\"\\f0e2\"}.fa.fa-legal:before{content:\"\\f0e3\"}.fa.fa-dashboard:before,.fa.fa-tachometer:before{content:\"\\f3fd\"}.fa.fa-comment-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-comment-o:before{content:\"\\f075\"}.fa.fa-comments-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-comments-o:before{content:\"\\f086\"}.fa.fa-flash:before{content:\"\\f0e7\"}.fa.fa-clipboard,.fa.fa-paste{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-paste:before{content:\"\\f328\"}.fa.fa-lightbulb-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-lightbulb-o:before{content:\"\\f0eb\"}.fa.fa-exchange:before{content:\"\\f362\"}.fa.fa-cloud-download:before{content:\"\\f381\"}.fa.fa-cloud-upload:before{content:\"\\f382\"}.fa.fa-bell-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-bell-o:before{content:\"\\f0f3\"}.fa.fa-cutlery:before{content:\"\\f2e7\"}.fa.fa-file-text-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-text-o:before{content:\"\\f15c\"}.fa.fa-building-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-building-o:before{content:\"\\f1ad\"}.fa.fa-hospital-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hospital-o:before{content:\"\\f0f8\"}.fa.fa-tablet:before{content:\"\\f3fa\"}.fa.fa-mobile-phone:before,.fa.fa-mobile:before{content:\"\\f3cd\"}.fa.fa-circle-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-circle-o:before{content:\"\\f111\"}.fa.fa-mail-reply:before{content:\"\\f3e5\"}.fa.fa-github-alt{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-folder-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-folder-o:before{content:\"\\f07b\"}.fa.fa-folder-open-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-folder-open-o:before{content:\"\\f07c\"}.fa.fa-smile-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-smile-o:before{content:\"\\f118\"}.fa.fa-frown-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-frown-o:before{content:\"\\f119\"}.fa.fa-meh-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-meh-o:before{content:\"\\f11a\"}.fa.fa-keyboard-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-keyboard-o:before{content:\"\\f11c\"}.fa.fa-flag-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-flag-o:before{content:\"\\f024\"}.fa.fa-mail-reply-all:before{content:\"\\f122\"}.fa.fa-star-half-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-star-half-o:before{content:\"\\f089\"}.fa.fa-star-half-empty{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-star-half-empty:before{content:\"\\f089\"}.fa.fa-star-half-full{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-star-half-full:before{content:\"\\f089\"}.fa.fa-code-fork:before{content:\"\\f126\"}.fa.fa-chain-broken:before{content:\"\\f127\"}.fa.fa-shield:before{content:\"\\f3ed\"}.fa.fa-calendar-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-calendar-o:before{content:\"\\f133\"}.fa.fa-css3,.fa.fa-html5,.fa.fa-maxcdn{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-ticket:before{content:\"\\f3ff\"}.fa.fa-minus-square-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-minus-square-o:before{content:\"\\f146\"}.fa.fa-level-up:before{content:\"\\f3bf\"}.fa.fa-level-down:before{content:\"\\f3be\"}.fa.fa-pencil-square:before{content:\"\\f14b\"}.fa.fa-external-link-square:before{content:\"\\f360\"}.fa.fa-compass{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-caret-square-o-down{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-caret-square-o-down:before{content:\"\\f150\"}.fa.fa-toggle-down{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-toggle-down:before{content:\"\\f150\"}.fa.fa-caret-square-o-up{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-caret-square-o-up:before{content:\"\\f151\"}.fa.fa-toggle-up{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-toggle-up:before{content:\"\\f151\"}.fa.fa-caret-square-o-right{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-caret-square-o-right:before{content:\"\\f152\"}.fa.fa-toggle-right{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-toggle-right:before{content:\"\\f152\"}.fa.fa-eur:before,.fa.fa-euro:before{content:\"\\f153\"}.fa.fa-gbp:before{content:\"\\f154\"}.fa.fa-dollar:before,.fa.fa-usd:before{content:\"\\f155\"}.fa.fa-inr:before,.fa.fa-rupee:before{content:\"\\f156\"}.fa.fa-cny:before,.fa.fa-jpy:before,.fa.fa-rmb:before,.fa.fa-yen:before{content:\"\\f157\"}.fa.fa-rouble:before,.fa.fa-rub:before,.fa.fa-ruble:before{content:\"\\f158\"}.fa.fa-krw:before,.fa.fa-won:before{content:\"\\f159\"}.fa.fa-bitcoin,.fa.fa-btc{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-bitcoin:before{content:\"\\f15a\"}.fa.fa-file-text:before{content:\"\\f15c\"}.fa.fa-sort-alpha-asc:before{content:\"\\f15d\"}.fa.fa-sort-alpha-desc:before{content:\"\\f15e\"}.fa.fa-sort-amount-asc:before{content:\"\\f160\"}.fa.fa-sort-amount-desc:before{content:\"\\f161\"}.fa.fa-sort-numeric-asc:before{content:\"\\f162\"}.fa.fa-sort-numeric-desc:before{content:\"\\f163\"}.fa.fa-xing,.fa.fa-xing-square,.fa.fa-youtube,.fa.fa-youtube-play,.fa.fa-youtube-square{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-youtube-play:before{content:\"\\f167\"}.fa.fa-adn,.fa.fa-bitbucket,.fa.fa-bitbucket-square,.fa.fa-dropbox,.fa.fa-flickr,.fa.fa-instagram,.fa.fa-stack-overflow{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-bitbucket-square:before{content:\"\\f171\"}.fa.fa-tumblr,.fa.fa-tumblr-square{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-long-arrow-down:before{content:\"\\f309\"}.fa.fa-long-arrow-up:before{content:\"\\f30c\"}.fa.fa-long-arrow-left:before{content:\"\\f30a\"}.fa.fa-long-arrow-right:before{content:\"\\f30b\"}.fa.fa-android,.fa.fa-apple,.fa.fa-dribbble,.fa.fa-foursquare,.fa.fa-gittip,.fa.fa-gratipay,.fa.fa-linux,.fa.fa-skype,.fa.fa-trello,.fa.fa-windows{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-gittip:before{content:\"\\f184\"}.fa.fa-sun-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-sun-o:before{content:\"\\f185\"}.fa.fa-moon-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-moon-o:before{content:\"\\f186\"}.fa.fa-pagelines,.fa.fa-renren,.fa.fa-stack-exchange,.fa.fa-vk,.fa.fa-weibo{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-arrow-circle-o-right{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-arrow-circle-o-right:before{content:\"\\f35a\"}.fa.fa-arrow-circle-o-left{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-arrow-circle-o-left:before{content:\"\\f359\"}.fa.fa-caret-square-o-left{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-caret-square-o-left:before{content:\"\\f191\"}.fa.fa-toggle-left{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-toggle-left:before{content:\"\\f191\"}.fa.fa-dot-circle-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-dot-circle-o:before{content:\"\\f192\"}.fa.fa-vimeo-square{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-try:before,.fa.fa-turkish-lira:before{content:\"\\f195\"}.fa.fa-plus-square-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-plus-square-o:before{content:\"\\f0fe\"}.fa.fa-openid,.fa.fa-slack,.fa.fa-wordpress{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-bank:before,.fa.fa-institution:before{content:\"\\f19c\"}.fa.fa-mortar-board:before{content:\"\\f19d\"}.fa.fa-delicious,.fa.fa-digg,.fa.fa-drupal,.fa.fa-google,.fa.fa-joomla,.fa.fa-pied-piper-alt,.fa.fa-pied-piper-pp,.fa.fa-reddit,.fa.fa-reddit-square,.fa.fa-stumbleupon,.fa.fa-stumbleupon-circle,.fa.fa-yahoo{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-spoon:before{content:\"\\f2e5\"}.fa.fa-behance,.fa.fa-behance-square,.fa.fa-steam,.fa.fa-steam-square{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-automobile:before{content:\"\\f1b9\"}.fa.fa-cab:before{content:\"\\f1ba\"}.fa.fa-envelope-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-envelope-o:before{content:\"\\f0e0\"}.fa.fa-deviantart,.fa.fa-soundcloud{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-file-pdf-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-pdf-o:before{content:\"\\f1c1\"}.fa.fa-file-word-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-word-o:before{content:\"\\f1c2\"}.fa.fa-file-excel-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-excel-o:before{content:\"\\f1c3\"}.fa.fa-file-powerpoint-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-powerpoint-o:before{content:\"\\f1c4\"}.fa.fa-file-image-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-image-o:before{content:\"\\f1c5\"}.fa.fa-file-photo-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-photo-o:before{content:\"\\f1c5\"}.fa.fa-file-picture-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-picture-o:before{content:\"\\f1c5\"}.fa.fa-file-archive-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-archive-o:before{content:\"\\f1c6\"}.fa.fa-file-zip-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-zip-o:before{content:\"\\f1c6\"}.fa.fa-file-audio-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-audio-o:before{content:\"\\f1c7\"}.fa.fa-file-sound-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-sound-o:before{content:\"\\f1c7\"}.fa.fa-file-video-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-video-o:before{content:\"\\f1c8\"}.fa.fa-file-movie-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-movie-o:before{content:\"\\f1c8\"}.fa.fa-file-code-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-file-code-o:before{content:\"\\f1c9\"}.fa.fa-codepen,.fa.fa-jsfiddle,.fa.fa-vine{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-life-bouy,.fa.fa-life-ring{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-life-bouy:before{content:\"\\f1cd\"}.fa.fa-life-buoy{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-life-buoy:before{content:\"\\f1cd\"}.fa.fa-life-saver{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-life-saver:before{content:\"\\f1cd\"}.fa.fa-support{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-support:before{content:\"\\f1cd\"}.fa.fa-circle-o-notch:before{content:\"\\f1ce\"}.fa.fa-ra,.fa.fa-rebel{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-ra:before{content:\"\\f1d0\"}.fa.fa-resistance{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-resistance:before{content:\"\\f1d0\"}.fa.fa-empire,.fa.fa-ge{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-ge:before{content:\"\\f1d1\"}.fa.fa-git,.fa.fa-git-square,.fa.fa-hacker-news,.fa.fa-y-combinator-square{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-y-combinator-square:before{content:\"\\f1d4\"}.fa.fa-yc-square{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-yc-square:before{content:\"\\f1d4\"}.fa.fa-qq,.fa.fa-tencent-weibo,.fa.fa-wechat,.fa.fa-weixin{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-wechat:before{content:\"\\f1d7\"}.fa.fa-send:before{content:\"\\f1d8\"}.fa.fa-paper-plane-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-paper-plane-o:before{content:\"\\f1d8\"}.fa.fa-send-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-send-o:before{content:\"\\f1d8\"}.fa.fa-circle-thin{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-circle-thin:before{content:\"\\f111\"}.fa.fa-header:before{content:\"\\f1dc\"}.fa.fa-sliders:before{content:\"\\f1de\"}.fa.fa-futbol-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-futbol-o:before{content:\"\\f1e3\"}.fa.fa-soccer-ball-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-soccer-ball-o:before{content:\"\\f1e3\"}.fa.fa-slideshare,.fa.fa-twitch,.fa.fa-yelp{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-newspaper-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-newspaper-o:before{content:\"\\f1ea\"}.fa.fa-cc-amex,.fa.fa-cc-discover,.fa.fa-cc-mastercard,.fa.fa-cc-paypal,.fa.fa-cc-stripe,.fa.fa-cc-visa,.fa.fa-google-wallet,.fa.fa-paypal{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-bell-slash-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-bell-slash-o:before{content:\"\\f1f6\"}.fa.fa-trash:before{content:\"\\f2ed\"}.fa.fa-copyright{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-eyedropper:before{content:\"\\f1fb\"}.fa.fa-area-chart:before{content:\"\\f1fe\"}.fa.fa-pie-chart:before{content:\"\\f200\"}.fa.fa-line-chart:before{content:\"\\f201\"}.fa.fa-angellist,.fa.fa-ioxhost,.fa.fa-lastfm,.fa.fa-lastfm-square{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-cc{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-cc:before{content:\"\\f20a\"}.fa.fa-ils:before,.fa.fa-shekel:before,.fa.fa-sheqel:before{content:\"\\f20b\"}.fa.fa-meanpath{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-meanpath:before{content:\"\\f2b4\"}.fa.fa-buysellads,.fa.fa-connectdevelop,.fa.fa-dashcube,.fa.fa-forumbee,.fa.fa-leanpub,.fa.fa-sellsy,.fa.fa-shirtsinbulk,.fa.fa-simplybuilt,.fa.fa-skyatlas{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-diamond{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-diamond:before{content:\"\\f3a5\"}.fa.fa-intersex:before{content:\"\\f224\"}.fa.fa-facebook-official{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-facebook-official:before{content:\"\\f09a\"}.fa.fa-pinterest-p,.fa.fa-whatsapp{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-hotel:before{content:\"\\f236\"}.fa.fa-medium,.fa.fa-viacoin,.fa.fa-y-combinator,.fa.fa-yc{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-yc:before{content:\"\\f23b\"}.fa.fa-expeditedssl,.fa.fa-opencart,.fa.fa-optin-monster{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-battery-4:before,.fa.fa-battery:before{content:\"\\f240\"}.fa.fa-battery-3:before{content:\"\\f241\"}.fa.fa-battery-2:before{content:\"\\f242\"}.fa.fa-battery-1:before{content:\"\\f243\"}.fa.fa-battery-0:before{content:\"\\f244\"}.fa.fa-object-group,.fa.fa-object-ungroup,.fa.fa-sticky-note-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-sticky-note-o:before{content:\"\\f249\"}.fa.fa-cc-diners-club,.fa.fa-cc-jcb{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-clone,.fa.fa-hourglass-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hourglass-o:before{content:\"\\f254\"}.fa.fa-hourglass-1:before{content:\"\\f251\"}.fa.fa-hourglass-2:before{content:\"\\f252\"}.fa.fa-hourglass-3:before{content:\"\\f253\"}.fa.fa-hand-rock-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hand-rock-o:before{content:\"\\f255\"}.fa.fa-hand-grab-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hand-grab-o:before{content:\"\\f255\"}.fa.fa-hand-paper-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hand-paper-o:before{content:\"\\f256\"}.fa.fa-hand-stop-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hand-stop-o:before{content:\"\\f256\"}.fa.fa-hand-scissors-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hand-scissors-o:before{content:\"\\f257\"}.fa.fa-hand-lizard-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hand-lizard-o:before{content:\"\\f258\"}.fa.fa-hand-spock-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hand-spock-o:before{content:\"\\f259\"}.fa.fa-hand-pointer-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hand-pointer-o:before{content:\"\\f25a\"}.fa.fa-hand-peace-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-hand-peace-o:before{content:\"\\f25b\"}.fa.fa-registered{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-chrome,.fa.fa-creative-commons,.fa.fa-firefox,.fa.fa-get-pocket,.fa.fa-gg,.fa.fa-gg-circle,.fa.fa-internet-explorer,.fa.fa-odnoklassniki,.fa.fa-odnoklassniki-square,.fa.fa-opera,.fa.fa-safari,.fa.fa-tripadvisor,.fa.fa-wikipedia-w{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-television:before{content:\"\\f26c\"}.fa.fa-500px,.fa.fa-amazon,.fa.fa-contao{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-calendar-plus-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-calendar-plus-o:before{content:\"\\f271\"}.fa.fa-calendar-minus-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-calendar-minus-o:before{content:\"\\f272\"}.fa.fa-calendar-times-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-calendar-times-o:before{content:\"\\f273\"}.fa.fa-calendar-check-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-calendar-check-o:before{content:\"\\f274\"}.fa.fa-map-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-map-o:before{content:\"\\f279\"}.fa.fa-commenting:before{content:\"\\f4ad\"}.fa.fa-commenting-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-commenting-o:before{content:\"\\f4ad\"}.fa.fa-houzz,.fa.fa-vimeo{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-vimeo:before{content:\"\\f27d\"}.fa.fa-black-tie,.fa.fa-edge,.fa.fa-fonticons,.fa.fa-reddit-alien{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-credit-card-alt:before{content:\"\\f09d\"}.fa.fa-codiepie,.fa.fa-fort-awesome,.fa.fa-mixcloud,.fa.fa-modx,.fa.fa-product-hunt,.fa.fa-scribd,.fa.fa-usb{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-pause-circle-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-pause-circle-o:before{content:\"\\f28b\"}.fa.fa-stop-circle-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-stop-circle-o:before{content:\"\\f28d\"}.fa.fa-bluetooth,.fa.fa-bluetooth-b,.fa.fa-envira,.fa.fa-gitlab,.fa.fa-wheelchair-alt,.fa.fa-wpbeginner,.fa.fa-wpforms{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-wheelchair-alt:before{content:\"\\f368\"}.fa.fa-question-circle-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-question-circle-o:before{content:\"\\f059\"}.fa.fa-volume-control-phone:before{content:\"\\f2a0\"}.fa.fa-asl-interpreting:before{content:\"\\f2a3\"}.fa.fa-deafness:before,.fa.fa-hard-of-hearing:before{content:\"\\f2a4\"}.fa.fa-glide,.fa.fa-glide-g{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-signing:before{content:\"\\f2a7\"}.fa.fa-first-order,.fa.fa-google-plus-official,.fa.fa-pied-piper,.fa.fa-snapchat,.fa.fa-snapchat-ghost,.fa.fa-snapchat-square,.fa.fa-themeisle,.fa.fa-viadeo,.fa.fa-viadeo-square,.fa.fa-yoast{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-google-plus-official:before{content:\"\\f2b3\"}.fa.fa-google-plus-circle{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-google-plus-circle:before{content:\"\\f2b3\"}.fa.fa-fa,.fa.fa-font-awesome{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-fa:before{content:\"\\f2b4\"}.fa.fa-handshake-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-handshake-o:before{content:\"\\f2b5\"}.fa.fa-envelope-open-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-envelope-open-o:before{content:\"\\f2b6\"}.fa.fa-linode{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-address-book-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-address-book-o:before{content:\"\\f2b9\"}.fa.fa-vcard:before{content:\"\\f2bb\"}.fa.fa-address-card-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-address-card-o:before{content:\"\\f2bb\"}.fa.fa-vcard-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-vcard-o:before{content:\"\\f2bb\"}.fa.fa-user-circle-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-user-circle-o:before{content:\"\\f2bd\"}.fa.fa-user-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-user-o:before{content:\"\\f007\"}.fa.fa-id-badge{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-drivers-license:before{content:\"\\f2c2\"}.fa.fa-id-card-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-id-card-o:before{content:\"\\f2c2\"}.fa.fa-drivers-license-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-drivers-license-o:before{content:\"\\f2c2\"}.fa.fa-free-code-camp,.fa.fa-quora,.fa.fa-telegram{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-thermometer-4:before,.fa.fa-thermometer:before{content:\"\\f2c7\"}.fa.fa-thermometer-3:before{content:\"\\f2c8\"}.fa.fa-thermometer-2:before{content:\"\\f2c9\"}.fa.fa-thermometer-1:before{content:\"\\f2ca\"}.fa.fa-thermometer-0:before{content:\"\\f2cb\"}.fa.fa-bathtub:before,.fa.fa-s15:before{content:\"\\f2cd\"}.fa.fa-window-maximize,.fa.fa-window-restore{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-times-rectangle:before{content:\"\\f410\"}.fa.fa-window-close-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-window-close-o:before{content:\"\\f410\"}.fa.fa-times-rectangle-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-times-rectangle-o:before{content:\"\\f410\"}.fa.fa-bandcamp,.fa.fa-eercast,.fa.fa-etsy,.fa.fa-grav,.fa.fa-imdb,.fa.fa-ravelry{font-family:\"Font Awesome 5 Brands\";font-weight:400}.fa.fa-eercast:before{content:\"\\f2da\"}.fa.fa-snowflake-o{font-family:\"Font Awesome 5 Free\";font-weight:400}.fa.fa-snowflake-o:before{content:\"\\f2dc\"}.fa.fa-spotify,.fa.fa-superpowers,.fa.fa-wpexplorer{font-family:\"Font Awesome 5 Brands\";font-weight:400}', 'yes'),
 (7390, 'wordfence_ls_version', '1.0.5', 'yes'),
 (8027, 'ls-p-url', 'https://layerslider.kreaturamedia.com/pricing/', 'yes'),
 (8140, '_transient_timeout_wpseo_meta_table_inaccessible', '1607852367', 'no'),
 (8141, '_transient_wpseo_meta_table_inaccessible', '0', 'no'),
 (8337, '_transient_doing_cron', '1583368076.1967990398406982421875', 'yes'),
 (8347, '_transient_timeout_avada_googlefonts_contents_en', '1583454479', 'no'),
 (8348, '_transient_avada_googlefonts_contents_en', '@font-face {font-display: block;\n  font-family: \'Open Sans\';\n  font-style: italic;\n  font-weight: 400;\n  src: local(\'Open Sans Italic\'), local(\'OpenSans-Italic\'), url(https://fonts.gstatic.com/s/opensans/v17/mem6YaGs126MiZpBA-UFUK0Zdcg.ttf) format(\'truetype\');\n}\n@font-face {font-display: block;\n  font-family: \'Open Sans\';\n  font-style: italic;\n  font-weight: 700;\n  src: local(\'Open Sans Bold Italic\'), local(\'OpenSans-BoldItalic\'), url(https://fonts.gstatic.com/s/opensans/v17/memnYaGs126MiZpBA-UFUKWiUNhrIqY.ttf) format(\'truetype\');\n}\n@font-face {font-display: block;\n  font-family: \'Open Sans\';\n  font-style: normal;\n  font-weight: 400;\n  src: local(\'Open Sans Regular\'), local(\'OpenSans-Regular\'), url(https://fonts.gstatic.com/s/opensans/v17/mem8YaGs126MiZpBA-UFVZ0e.ttf) format(\'truetype\');\n}\n@font-face {font-display: block;\n  font-family: \'Open Sans\';\n  font-style: normal;\n  font-weight: 700;\n  src: local(\'Open Sans Bold\'), local(\'OpenSans-Bold\'), url(https://fonts.gstatic.com/s/opensans/v17/mem5YaGs126MiZpBA-UN7rgOUuhs.ttf) format(\'truetype\');\n}\n@font-face {font-display: block;\n  font-family: \'PT Sans\';\n  font-style: normal;\n  font-weight: 700;\n  src: local(\'PT Sans Bold\'), local(\'PTSans-Bold\'), url(https://fonts.gstatic.com/s/ptsans/v11/jizfRExUiTo99u79B_mh0O6tKA.ttf) format(\'truetype\');\n}\n@font-face {font-display: block;\n  font-family: \'Raleway\';\n  font-style: normal;\n  font-weight: 700;\n  src: local(\'Raleway Bold\'), local(\'Raleway-Bold\'), url(https://fonts.gstatic.com/s/raleway/v14/1Ptrg8zYS_SKggPNwJYtWqZPBQ.ttf) format(\'truetype\');\n}\n', 'no'),
 (8124, '_site_transient_update_core', 'O:8:\"stdClass\":4:{s:7:\"updates\";a:4:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.3.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.3.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.3.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.3.2-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.3.2\";s:7:\"version\";s:5:\"5.3.2\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.3\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.3.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.3.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.3.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.3.2-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.3.2\";s:7:\"version\";s:5:\"5.3.2\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.3\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:2;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.2.5.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.2.5.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.2.5-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.2.5-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.2.5\";s:7:\"version\";s:5:\"5.2.5\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.3\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:3;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.1.4.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.1.4.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.1.4-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.1.4-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.1.4\";s:7:\"version\";s:5:\"5.1.4\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.3\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}}s:12:\"last_checked\";i:1583368076;s:15:\"version_checked\";s:5:\"5.0.8\";s:12:\"translations\";a:0:{}}', 'no'),
 (8339, '_transient_timeout_avada_premium_plugins_info', '1583454477', 'no'),
 (8340, '_transient_avada_premium_plugins_info', 'a:14:{s:11:\"fusion-core\";a:18:{s:4:\"name\";s:11:\"Fusion Core\";s:11:\"plugin_name\";s:11:\"Fusion Core\";s:4:\"slug\";s:11:\"fusion-core\";s:13:\"plugin_author\";s:11:\"ThemeFusion\";s:17:\"plugin_author_url\";s:23:\"http://theme-fusion.com\";s:5:\"image\";s:75:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/fusion_core.png\";s:9:\"image_url\";s:75:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/fusion_core.png\";s:12:\"external_url\";s:0:\"\";s:7:\"premium\";b:1;s:14:\"latest_version\";s:3:\"3.8\";s:8:\"required\";b:1;s:4:\"icon\";s:75:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/themefusion.svg\";s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:88:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/fusion-core-company-site.jpg\";s:11:\"has_package\";b:1;s:7:\"version\";s:3:\"3.8\";s:6:\"Author\";s:11:\"ThemeFusion\";s:9:\"AuthorURI\";s:23:\"http://theme-fusion.com\";}s:14:\"fusion-builder\";a:18:{s:4:\"name\";s:14:\"Fusion Builder\";s:11:\"plugin_name\";s:14:\"Fusion Builder\";s:4:\"slug\";s:14:\"fusion-builder\";s:13:\"plugin_author\";s:11:\"ThemeFusion\";s:17:\"plugin_author_url\";s:24:\"https://theme-fusion.com\";s:5:\"image\";s:109:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/66927247-61fef380-f027-11e9-997d-88f7ea10e475.png\";s:9:\"image_url\";s:109:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/66927247-61fef380-f027-11e9-997d-88f7ea10e475.png\";s:12:\"external_url\";s:0:\"\";s:7:\"premium\";b:1;s:14:\"latest_version\";s:3:\"1.8\";s:8:\"required\";b:1;s:4:\"icon\";s:75:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/themefusion.svg\";s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:109:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/67201242-c0e4b400-f3fd-11e9-9dc5-b33c5a944e81.jpg\";s:11:\"has_package\";b:1;s:7:\"version\";s:3:\"1.8\";s:6:\"Author\";s:11:\"ThemeFusion\";s:9:\"AuthorURI\";s:24:\"https://theme-fusion.com\";}s:27:\"fusion-white-label-branding\";a:18:{s:4:\"name\";s:27:\"Fusion White Label Branding\";s:11:\"plugin_name\";s:27:\"Fusion White Label Branding\";s:4:\"slug\";s:27:\"fusion-white-label-branding\";s:13:\"plugin_author\";s:11:\"ThemeFusion\";s:17:\"plugin_author_url\";s:24:\"https://theme-fusion.com\";s:5:\"image\";s:92:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/fusion_whiite_label_branding.png\";s:9:\"image_url\";s:92:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/fusion_whiite_label_branding.png\";s:12:\"external_url\";s:0:\"\";s:7:\"premium\";b:1;s:14:\"latest_version\";s:5:\"1.1.3\";s:8:\"required\";b:0;s:4:\"icon\";s:75:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/themefusion.svg\";s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:80:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/FusionWhiteLabel.jpg\";s:11:\"has_package\";b:1;s:7:\"version\";s:5:\"1.1.3\";s:6:\"Author\";s:11:\"ThemeFusion\";s:9:\"AuthorURI\";s:24:\"https://theme-fusion.com\";}s:11:\"convertplug\";a:18:{s:4:\"name\";s:12:\"Convert Plus\";s:11:\"plugin_name\";s:12:\"Convert Plus\";s:4:\"slug\";s:11:\"convertplug\";s:13:\"plugin_author\";s:16:\"Brainstorm Force\";s:17:\"plugin_author_url\";s:31:\"https://www.brainstormforce.com\";s:5:\"image\";s:85:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/convertplus_thumbnail.jpg\";s:9:\"image_url\";s:85:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/convertplus_thumbnail.jpg\";s:12:\"external_url\";s:0:\"\";s:7:\"premium\";b:1;s:14:\"latest_version\";s:5:\"3.5.5\";s:8:\"required\";b:0;s:4:\"icon\";b:0;s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:98:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/convertplus_thumbnail_company_site.jpg\";s:11:\"has_package\";b:1;s:7:\"version\";s:5:\"3.5.5\";s:6:\"Author\";s:16:\"Brainstorm Force\";s:9:\"AuthorURI\";s:31:\"https://www.brainstormforce.com\";}s:26:\"advanced-custom-fields-pro\";a:18:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:11:\"plugin_name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:13:\"plugin_author\";s:13:\"Elliot Condon\";s:17:\"plugin_author_url\";s:28:\"http://www.elliotcondon.com/\";s:5:\"image\";s:71:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/acf_pro.png\";s:9:\"image_url\";s:71:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/acf_pro.png\";s:12:\"external_url\";s:0:\"\";s:7:\"premium\";b:1;s:14:\"latest_version\";s:5:\"5.8.7\";s:8:\"required\";b:0;s:4:\"icon\";b:0;s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:84:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/acf_pro_company_site.jpg\";s:11:\"has_package\";b:1;s:7:\"version\";s:5:\"5.8.7\";s:6:\"Author\";s:13:\"Elliot Condon\";s:9:\"AuthorURI\";s:28:\"http://www.elliotcondon.com/\";}s:11:\"LayerSlider\";a:18:{s:4:\"name\";s:14:\"LayerSlider WP\";s:11:\"plugin_name\";s:14:\"LayerSlider WP\";s:4:\"slug\";s:11:\"LayerSlider\";s:13:\"plugin_author\";s:14:\"Kreatura Media\";s:17:\"plugin_author_url\";s:38:\"https://layerslider.kreaturamedia.com/\";s:5:\"image\";s:89:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/layer_slider_plugin_thumb.png\";s:9:\"image_url\";s:89:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/layer_slider_plugin_thumb.png\";s:12:\"external_url\";s:0:\"\";s:7:\"premium\";b:1;s:14:\"latest_version\";s:6:\"6.10.2\";s:8:\"required\";b:0;s:4:\"icon\";b:0;s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:88:\"https://updates.theme-fusion.com/wp-content/uploads/2016/08/layerslider_company_site.jpg\";s:11:\"has_package\";b:1;s:7:\"version\";s:6:\"6.10.2\";s:6:\"Author\";s:14:\"Kreatura Media\";s:9:\"AuthorURI\";s:38:\"https://layerslider.kreaturamedia.com/\";}s:9:\"revslider\";a:18:{s:4:\"name\";s:17:\"Slider Revolution\";s:11:\"plugin_name\";s:17:\"Slider Revolution\";s:4:\"slug\";s:9:\"revslider\";s:13:\"plugin_author\";s:10:\"ThemePunch\";s:17:\"plugin_author_url\";s:22:\"http://themepunch.com/\";s:5:\"image\";s:83:\"https://updates.theme-fusion.com/wp-content/uploads/2016/08/slider_revolution-1.png\";s:9:\"image_url\";s:83:\"https://updates.theme-fusion.com/wp-content/uploads/2016/08/slider_revolution-1.png\";s:12:\"external_url\";s:0:\"\";s:7:\"premium\";b:1;s:14:\"latest_version\";s:5:\"6.2.1\";s:8:\"required\";b:0;s:4:\"icon\";b:0;s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:84:\"https://updates.theme-fusion.com/wp-content/uploads/2016/08/slider_revolution_cs.png\";s:11:\"has_package\";b:1;s:7:\"version\";s:5:\"6.2.1\";s:6:\"Author\";s:10:\"ThemePunch\";s:9:\"AuthorURI\";s:22:\"http://themepunch.com/\";}s:3:\"pwa\";a:15:{s:4:\"name\";s:3:\"PWA\";s:11:\"plugin_name\";s:3:\"PWA\";s:4:\"slug\";s:3:\"pwa\";s:13:\"plugin_author\";s:23:\"PWA Plugin Contributors\";s:17:\"plugin_author_url\";s:49:\"https://github.com/xwp/pwa-wp/graphs/contributors\";s:5:\"image\";s:75:\"https://updates.theme-fusion.com/wp-content/uploads/2019/01/pwa_880_660.jpg\";s:9:\"image_url\";s:75:\"https://updates.theme-fusion.com/wp-content/uploads/2019/01/pwa_880_660.jpg\";s:12:\"external_url\";s:46:\"https://downloads.wordpress.org/plugin/pwa.zip\";s:7:\"premium\";b:0;s:14:\"latest_version\";s:0:\"\";s:8:\"required\";b:0;s:4:\"icon\";s:75:\"https://updates.theme-fusion.com/wp-content/uploads/2019/01/pwa_256_256.jpg\";s:6:\"banner\";s:76:\"https://updates.theme-fusion.com/wp-content/uploads/2019/01/pwa_1544_500.jpg\";s:11:\"tf_cs_image\";s:75:\"https://updates.theme-fusion.com/wp-content/uploads/2019/01/pwa_840_438.jpg\";s:11:\"has_package\";b:0;}s:11:\"woocommerce\";a:15:{s:4:\"name\";s:11:\"WooCommerce\";s:11:\"plugin_name\";s:11:\"WooCommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:13:\"plugin_author\";s:10:\"Automattic\";s:17:\"plugin_author_url\";s:23:\"https://woocommerce.com\";s:5:\"image\";s:88:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/woocommerce_plugin_thumb.png\";s:9:\"image_url\";s:88:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/woocommerce_plugin_thumb.png\";s:12:\"external_url\";s:54:\"https://downloads.wordpress.org/plugin/woocommerce.zip\";s:7:\"premium\";b:0;s:14:\"latest_version\";s:0:\"\";s:8:\"required\";b:0;s:4:\"icon\";b:0;s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:88:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/woocommerce_plugin_thumb.png\";s:11:\"has_package\";b:0;}s:19:\"the-events-calendar\";a:15:{s:4:\"name\";s:19:\"The Events Calendar\";s:11:\"plugin_name\";s:19:\"The Events Calendar\";s:4:\"slug\";s:19:\"the-events-calendar\";s:13:\"plugin_author\";s:18:\"Modern Tribe, Inc.\";s:17:\"plugin_author_url\";s:18:\"http://m.tri.be/1x\";s:5:\"image\";s:92:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/events_calendar_plugin_thumb.png\";s:9:\"image_url\";s:92:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/events_calendar_plugin_thumb.png\";s:12:\"external_url\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.7.zip\";s:7:\"premium\";b:0;s:14:\"latest_version\";s:0:\"\";s:8:\"required\";b:0;s:4:\"icon\";N;s:6:\"banner\";N;s:11:\"tf_cs_image\";N;s:11:\"has_package\";b:0;}s:13:\"wordpress-seo\";a:15:{s:4:\"name\";s:9:\"Yoast SEO\";s:11:\"plugin_name\";s:9:\"Yoast SEO\";s:4:\"slug\";s:13:\"wordpress-seo\";s:13:\"plugin_author\";s:10:\"Team Yoast\";s:17:\"plugin_author_url\";s:18:\"https://yoast.com/\";s:5:\"image\";s:69:\"https://updates.theme-fusion.com/wp-content/uploads/2018/03/yoast.png\";s:9:\"image_url\";s:69:\"https://updates.theme-fusion.com/wp-content/uploads/2018/03/yoast.png\";s:12:\"external_url\";s:56:\"https://downloads.wordpress.org/plugin/wordpress-seo.zip\";s:7:\"premium\";b:0;s:14:\"latest_version\";s:0:\"\";s:8:\"required\";b:0;s:4:\"icon\";b:0;s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:69:\"https://updates.theme-fusion.com/wp-content/uploads/2018/03/yoast.png\";s:11:\"has_package\";b:0;}s:6:\"leadin\";a:15:{s:4:\"name\";s:7:\"HubSpot\";s:11:\"plugin_name\";s:7:\"HubSpot\";s:4:\"slug\";s:6:\"leadin\";s:13:\"plugin_author\";s:7:\"HubSpot\";s:17:\"plugin_author_url\";s:23:\"https://www.hubspot.com\";s:5:\"image\";s:84:\"https://updates.theme-fusion.com/wp-content/uploads/2019/10/hubspot_plugin_thumb.jpg\";s:9:\"image_url\";s:84:\"https://updates.theme-fusion.com/wp-content/uploads/2019/10/hubspot_plugin_thumb.jpg\";s:12:\"external_url\";s:54:\"https://downloads.wordpress.org/plugin/woocommerce.zip\";s:7:\"premium\";b:0;s:14:\"latest_version\";s:0:\"\";s:8:\"required\";b:0;s:4:\"icon\";b:0;s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:84:\"https://updates.theme-fusion.com/wp-content/uploads/2019/10/hubspot_plugin_thumb.jpg\";s:11:\"has_package\";b:0;}s:14:\"contact-form-7\";a:15:{s:4:\"name\";s:14:\"Contact Form 7\";s:11:\"plugin_name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:13:\"plugin_author\";s:16:\"Takayuki Miyoshi\";s:17:\"plugin_author_url\";s:31:\"https://ideasilo.wordpress.com/\";s:5:\"image\";s:78:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/contact_form_7.png\";s:9:\"image_url\";s:78:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/contact_form_7.png\";s:12:\"external_url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"premium\";b:0;s:14:\"latest_version\";s:0:\"\";s:8:\"required\";b:0;s:4:\"icon\";N;s:6:\"banner\";N;s:11:\"tf_cs_image\";N;s:11:\"has_package\";b:0;}s:7:\"bbpress\";a:15:{s:4:\"name\";s:7:\"bbPress\";s:11:\"plugin_name\";s:7:\"bbPress\";s:4:\"slug\";s:7:\"bbpress\";s:13:\"plugin_author\";s:21:\"The bbPress Community\";s:17:\"plugin_author_url\";s:19:\"https://bbpress.org\";s:5:\"image\";s:71:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/bbpress.png\";s:9:\"image_url\";s:71:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/bbpress.png\";s:12:\"external_url\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.14.zip\";s:7:\"premium\";b:0;s:14:\"latest_version\";s:0:\"\";s:8:\"required\";b:0;s:4:\"icon\";N;s:6:\"banner\";N;s:11:\"tf_cs_image\";N;s:11:\"has_package\";b:0;}}', 'no'),
 (8343, '_site_transient_update_themes', 'O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1583368079;s:7:\"checked\";a:5:{s:5:\"Avada\";s:3:\"5.8\";s:13:\"twentyfifteen\";s:3:\"2.3\";s:14:\"twentynineteen\";s:3:\"1.2\";s:15:\"twentyseventeen\";s:3:\"2.0\";s:13:\"twentysixteen\";s:3:\"1.8\";}s:8:\"response\";a:5:{s:13:\"twentyfifteen\";a:6:{s:5:\"theme\";s:13:\"twentyfifteen\";s:11:\"new_version\";s:3:\"2.5\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentyfifteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentyfifteen.2.5.zip\";s:8:\"requires\";s:3:\"4.1\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:14:\"twentynineteen\";a:6:{s:5:\"theme\";s:14:\"twentynineteen\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentynineteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentynineteen.1.4.zip\";s:8:\"requires\";s:5:\"4.9.6\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:15:\"twentyseventeen\";a:6:{s:5:\"theme\";s:15:\"twentyseventeen\";s:11:\"new_version\";s:3:\"2.2\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentyseventeen/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentyseventeen.2.2.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:13:\"twentysixteen\";a:6:{s:5:\"theme\";s:13:\"twentysixteen\";s:11:\"new_version\";s:3:\"2.0\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentysixteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentysixteen.2.0.zip\";s:8:\"requires\";s:3:\"4.4\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:5:\"Avada\";a:4:{s:5:\"theme\";s:5:\"Avada\";s:11:\"new_version\";s:5:\"6.2.1\";s:3:\"url\";s:58:\"https://theme-fusion.com/avada-documentation/changelog.txt\";s:7:\"package\";s:111:\"https://mofa-omission.ultimate-dimensions.net/wp-admin/admin.php?page=avada&deferred_download=1&item_id=2833226\";}}s:12:\"translations\";a:0:{}}', 'no'),
 (8344, '_site_transient_update_plugins', 'O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1583368079;s:7:\"checked\";a:11:{s:19:\"akismet/akismet.php\";s:3:\"4.1\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"5.1.1\";s:33:\"duplicator-pro/duplicator-pro.php\";s:5:\"3.8.0\";s:33:\"fusion-builder/fusion-builder.php\";s:3:\"1.8\";s:27:\"fusion-core/fusion-core.php\";s:3:\"3.8\";s:27:\"LayerSlider/layerslider.php\";s:5:\"6.7.6\";s:47:\"memphis-documents-library/memphis-documents.php\";s:6:\"3.9.17\";s:23:\"wordfence/wordfence.php\";s:5:\"7.4.6\";s:24:\"wordpress-seo/wp-seo.php\";s:3:\"9.5\";s:36:\"yotuwp-easy-youtube-embed/yotuwp.php\";s:5:\"1.3.4\";s:30:\"youtube-embed-plus/youtube.php\";s:6:\"13.0.1\";}s:8:\"response\";a:5:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"4.1.3\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.4.1.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.3.2\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"5.1.6\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/contact-form-7/assets/icon-256x256.png?rev=984007\";s:2:\"1x\";s:66:\"https://ps.w.org/contact-form-7/assets/icon-128x128.png?rev=984007\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.3.2\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:47:\"memphis-documents-library/memphis-documents.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:39:\"w.org/plugins/memphis-documents-library\";s:4:\"slug\";s:25:\"memphis-documents-library\";s:6:\"plugin\";s:47:\"memphis-documents-library/memphis-documents.php\";s:11:\"new_version\";s:6:\"3.10.5\";s:3:\"url\";s:56:\"https://wordpress.org/plugins/memphis-documents-library/\";s:7:\"package\";s:75:\"https://downloads.wordpress.org/plugin/memphis-documents-library.3.10.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/memphis-documents-library/assets/icon-256x256.png?rev=1521353\";s:2:\"1x\";s:78:\"https://ps.w.org/memphis-documents-library/assets/icon-128x128.png?rev=1521353\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:81:\"https://ps.w.org/memphis-documents-library/assets/banner-1544x500.png?rev=1588287\";s:2:\"1x\";s:80:\"https://ps.w.org/memphis-documents-library/assets/banner-772x250.png?rev=1521356\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.3.2\";s:12:\"requires_php\";s:3:\"5.6\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:30:\"youtube-embed-plus/youtube.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:32:\"w.org/plugins/youtube-embed-plus\";s:4:\"slug\";s:18:\"youtube-embed-plus\";s:6:\"plugin\";s:30:\"youtube-embed-plus/youtube.php\";s:11:\"new_version\";s:6:\"13.2.1\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/youtube-embed-plus/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/youtube-embed-plus.13.2.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/youtube-embed-plus/assets/icon-256x256.png?rev=2165403\";s:2:\"1x\";s:71:\"https://ps.w.org/youtube-embed-plus/assets/icon-128x128.png?rev=2165403\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/youtube-embed-plus/assets/banner-1544x500.png?rev=2165457\";s:2:\"1x\";s:73:\"https://ps.w.org/youtube-embed-plus/assets/banner-772x250.png?rev=2165403\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.3.2\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:27:\"LayerSlider/layerslider.php\";O:8:\"stdClass\":10:{s:4:\"slug\";s:11:\"LayerSlider\";s:6:\"plugin\";s:27:\"LayerSlider/layerslider.php\";s:7:\"version\";s:6:\"6.10.2\";s:5:\"icons\";a:3:{s:2:\"1x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png?ver=6.9.2\";s:2:\"2x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";s:7:\"default\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";}s:7:\"banners\";a:3:{s:3:\"low\";s:94:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png?ver=6.9.2\";s:4:\"high\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";s:7:\"default\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";}s:3:\"url\";s:79:\"http://codecanyon.net/item/layerslider-wp-the-wordpress-parallax-slider/1362246\";s:7:\"package\";s:0:\"\";s:6:\"tested\";s:5:\"5.3.2\";s:14:\"upgrade_notice\";s:142:\"This release further improves compatibility with WordPress 5.3 and is strongly recommended for everyone using the latest version of WordPress.\";s:11:\"new_version\";s:6:\"6.10.2\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:3:{s:23:\"wordfence/wordfence.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:23:\"w.org/plugins/wordfence\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:5:\"7.4.6\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/wordfence.7.4.6.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/wordfence/assets/icon-256x256.png?rev=2070855\";s:2:\"1x\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";s:3:\"svg\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/wordfence/assets/banner-1544x500.jpg?rev=2124102\";s:2:\"1x\";s:64:\"https://ps.w.org/wordfence/assets/banner-772x250.jpg?rev=2124102\";}s:11:\"banners_rtl\";a:0:{}}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:4:\"13.2\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.13.2.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-256x256.png?rev=1834347\";s:2:\"1x\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=1946641\";s:3:\"svg\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=1946641\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=1843435\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=1843435\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=1843435\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=1843435\";}s:6:\"tested\";s:5:\"5.3.2\";s:12:\"requires_php\";s:6:\"5.6.20\";s:13:\"compatibility\";a:0:{}}s:36:\"yotuwp-easy-youtube-embed/yotuwp.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:39:\"w.org/plugins/yotuwp-easy-youtube-embed\";s:4:\"slug\";s:25:\"yotuwp-easy-youtube-embed\";s:6:\"plugin\";s:36:\"yotuwp-easy-youtube-embed/yotuwp.php\";s:11:\"new_version\";s:5:\"1.3.4\";s:3:\"url\";s:56:\"https://wordpress.org/plugins/yotuwp-easy-youtube-embed/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/yotuwp-easy-youtube-embed.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/yotuwp-easy-youtube-embed/assets/icon-256x256.png?rev=1958376\";s:2:\"1x\";s:78:\"https://ps.w.org/yotuwp-easy-youtube-embed/assets/icon-128x128.png?rev=1958376\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:81:\"https://ps.w.org/yotuwp-easy-youtube-embed/assets/banner-1544x500.png?rev=1759755\";s:2:\"1x\";s:80:\"https://ps.w.org/yotuwp-easy-youtube-embed/assets/banner-772x250.png?rev=1759755\";}s:11:\"banners_rtl\";a:0:{}}}}', 'no'),
 (8345, '_transient_timeout_fusion_dynamic_js_filenames', '1583371679', 'no'),
 (8346, '_transient_fusion_dynamic_js_filenames', 'a:1:{s:36:\"10469b2ce8b9f4b91052f76a3be0e4382c2e\";s:32:\"39d587f050db749a3f8975c4123c5933\";}', 'no'),
 (8351, '_site_transient_timeout_avada_autoloader_paths_200246c02d31ca6bb1c2dcd342016b3b', '1583368114', 'no'),
 (8352, '_site_transient_avada_autoloader_paths_200246c02d31ca6bb1c2dcd342016b3b', 'a:43:{s:28:\"Fusion_Builder_Redux_Options\";s:112:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-fusion-builder-redux-options.php\";s:11:\"Avada_Admin\";s:95:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-admin.php\";s:14:\"Avada_Settings\";s:98:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-settings.php\";s:10:\"Avada_Init\";s:94:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-init.php\";s:17:\"Avada_Social_Icon\";s:101:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-social-icon.php\";s:20:\"Avada_Social_Sharing\";s:104:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-social-sharing.php\";s:14:\"Avada_Template\";s:98:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-template.php\";s:10:\"Avada_Blog\";s:94:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-blog.php\";s:12:\"Avada_Images\";s:96:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-images.php\";s:10:\"Avada_Head\";s:94:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-head.php\";s:12:\"Avada_Layout\";s:96:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-layout.php\";s:15:\"Avada_GoogleMap\";s:99:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-googlemap.php\";s:22:\"Avada_Remote_Installer\";s:106:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-remote-installer.php\";s:20:\"Avada_Sermon_Manager\";s:104:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-sermon-manager.php\";s:20:\"Avada_Privacy_Embeds\";s:104:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-privacy-embeds.php\";s:9:\"Avada_PWA\";s:93:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-pwa.php\";s:19:\"Avada_Importer_Data\";s:112:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/importer/class-avada-importer-data.php\";s:30:\"Avada_Multiple_Featured_Images\";s:114:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-multiple-featured-images.php\";s:14:\"Avada_Sidebars\";s:98:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-sidebars.php\";s:19:\"Avada_Admin_Notices\";s:103:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-admin-notices.php\";s:18:\"Avada_Widget_Style\";s:102:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-widget-style.php\";s:18:\"Avada_Page_Options\";s:102:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-page-options.php\";s:11:\"Avada_Fonts\";s:95:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-fonts.php\";s:13:\"Avada_Scripts\";s:97:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-scripts.php\";s:27:\"Avada_TGM_Plugin_Activation\";s:111:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-tgm-plugin-activation.php\";s:24:\"Avada_Megamenu_Framework\";s:108:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-megamenu-framework.php\";s:14:\"Avada_Megamenu\";s:98:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-megamenu.php\";s:16:\"Avada_Nav_Walker\";s:100:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-nav-walker.php\";s:25:\"Avada_Nav_Walker_Megamenu\";s:109:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-nav-walker-megamenu.php\";s:17:\"Avada_Dynamic_CSS\";s:101:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-dynamic-css.php\";s:12:\"Avada_Helper\";s:96:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-helper.php\";s:24:\"Fusion_Widget_Ad_125_125\";s:115:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/widget/class-fusion-widget-ad-125-125.php\";s:20:\"Fusion_Widget_Author\";s:111:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/widget/class-fusion-widget-author.php\";s:26:\"Fusion_Widget_Contact_Info\";s:117:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/widget/class-fusion-widget-contact-info.php\";s:18:\"Fusion_Widget_Tabs\";s:109:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/widget/class-fusion-widget-tabs.php\";s:26:\"Fusion_Widget_Recent_Works\";s:117:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/widget/class-fusion-widget-recent-works.php\";s:20:\"Fusion_Widget_Tweets\";s:111:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/widget/class-fusion-widget-tweets.php\";s:20:\"Fusion_Widget_Flickr\";s:111:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/widget/class-fusion-widget-flickr.php\";s:26:\"Fusion_Widget_Social_Links\";s:117:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/widget/class-fusion-widget-social-links.php\";s:27:\"Fusion_Widget_Facebook_Page\";s:118:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/widget/class-fusion-widget-facebook-page.php\";s:18:\"Fusion_Widget_Menu\";s:109:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/widget/class-fusion-widget-menu.php\";s:27:\"Fusion_Widget_Vertical_Menu\";s:118:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/widget/class-fusion-widget-vertical-menu.php\";s:13:\"Avada_Options\";s:97:\"/home/ultimat3/public_html/mofa-omission/wp-content/themes/Avada/includes/class-avada-options.php\";}', 'no'),
 (6576, 'wordfence_syncingAttackData', '0', 'no'),
 (6577, 'wordfence_lastSyncAttackData', '1553231450', 'no'),
 (6051, 'yotuwp_tracking_notice', '1', 'yes'),
 (6086, 'duplicator_pro_ui_view_state', 'a:5:{s:27:\"dup-settings-diag-srv-panel\";s:1:\"1\";s:22:\"dup-pack-storage-panel\";s:1:\"1\";s:22:\"dup-pack-archive-panel\";s:1:\"0\";s:25:\"dpro-pack-installer-panel\";s:1:\"1\";s:25:\"dup-transfer-transfer-log\";s:1:\"1\";}', 'yes'),
 (6097, 'duplicator_pro_package_active', '{\"Created\":\"2019-01-29 16:50:39\",\"Version\":\"3.8.0\",\"VersionWP\":\"5.0.3\",\"VersionDB\":\"5.6.41\",\"VersionPHP\":\"5.6.40\",\"VersionOS\":\"Linux\",\"ID\":null,\"Name\":\"20190129_canadianhighcommission\",\"Hash\":\"71fb8b66cde2a0c75418_20190129165039\",\"NameHash\":\"20190129_canadianhighcommission_71fb8b66cde2a0c75418_20190129165039\",\"Type\":0,\"Notes\":\"\",\"StorePath\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/mofa-omission.ultimate-dimensions.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20190129_canadianhighcommission_71fb8b66cde2a0c75418_20190129165039_scan.json\",\"timer_start\":-1,\"Runtime\":null,\"ExeSize\":null,\"ZipSize\":0,\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":null,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":null,\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\",\"Size\":185901078,\"Dirs\":null,\"DirCount\":1173,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":8356,\"file_count\":-1,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/ai1wm-backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/backupwordpress\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/contents\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/managewp\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/old-cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/updraft\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wishlist-backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/wfcache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/cache\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":4568028,\"bytes\":\"4.36MB\",\"name\":\"Newletter Final1.pdf\",\"dir\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\",\"path\":\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-content\\/uploads\\/mdocs\\/Newletter Final1.pdf\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/.htaccess\",\"\\/home\\/ultimat3\\/public_html\\/mofa-omission\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false},\"Multisite\":{\"FilterSites\":\"\"},\"Installer\":{\"File\":null,\"Size\":0,\"OptsSecureOn\":0,\"OptsSecurePass\":\"\",\"OptsSkipScan\":0,\"OptsDBHost\":\"\",\"OptsDBName\":\"\",\"OptsDBUser\":\"\",\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":0,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"ultimat3_ottawa\",\"tablesBaseCount\":37,\"tablesFinalCount\":37,\"tablesRowCount\":16348,\"tablesSizeOnDisk\":9000778,\"varLowerCaseTables\":\"0\",\"version\":\"5.6.41\",\"versionComment\":\"MySQL Community Server (GPL)\"},\"Type\":\"MySQL\",\"Size\":null,\"File\":null,\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":null,\"Compatible\":\"\",\"Comments\":\"MySQL Community Server (GPL)\",\"dbStorePathPublic\":null},\"Status\":5,\"schedule_id\":-1,\"build_progress\":{\"thread_start_time\":null,\"initialized\":false,\"installer_built\":false,\"archive_started\":false,\"archive_has_database\":false,\"archive_built\":false,\"database_script_built\":false,\"failed\":false,\"next_archive_file_index\":0,\"next_archive_dir_index\":0,\"retries\":0,\"current_build_mode\":-1,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":0,\"tableOffset\":0,\"totalRowOffset\":0,\"chunkIndex\":null,\"validationStage1\":false,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":false,\"doneFiltering\":false,\"doneCreates\":false,\"completed\":false,\"tablesToProcess\":[],\"startTime\":null,\"fileOffset\":0,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":0,\"tablesSchemaSizes\":[]},\"upload_infos\":[{\"storage_id\":\"8\",\"archive_offset\":0,\"copied_installer\":false,\"copied_archive\":false,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":false,\"status_message_details\":\"\",\"started_timestamp\":null,\"stopped_timestamp\":null}],\"active_storage_id\":-1,\"template_id\":5}', 'yes'),
 (6080, 'duplicator_pro_plugin_version', '3.8.0', 'yes'),
 (6081, 'duplicator_pro_license_key', 'NULLED-BY-GANJAPARKER', 'yes'),
 (161, 'recently_activated', 'a:1:{s:35:\"wp-youtube-lyte/wp-youtube-lyte.php\";i:1548358143;}', 'yes'),
 (5796, 'widget_wylwidget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (5795, 'lyte_version', '1.7.0', 'yes'),
 (172, 'wordfence_version', '7.4.6', 'yes'),
 (173, 'wordfence_case', '1', 'yes'),
 (174, 'wordfence_installed', '1', 'yes'),
 (6575, 'wordfence_syncAttackDataAttempts', '0', 'no'),
 (175, 'wordfenceActivated', '1', 'yes'),
 (176, 'wf_plugin_act_error', '', 'yes'),
 (897, 'avada_disable_encoding', '1', 'yes'),
 (187, 'widget_mdocs_top_downloads', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (188, 'widget_mdocs_top_rated', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (189, 'widget_mdocs_last_updated', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (190, 'mdocs-v3-9-14-patch-var-1', '1', 'yes'),
 (191, 'mdocs-v3-9-11-patch-var-1', '1', 'yes'),
 (192, 'mdocs-v3-9-2-patch-var-1', '1', 'yes'),
 (193, 'mdocs-v3-9-patch-var-1', '1', 'yes'),
 (194, 'mdocs-v3-8-7-patch-var-1', '1', 'yes'),
 (195, 'mdocs-v3-8-6-patch-var-4', '1', 'yes'),
 (196, 'mdocs-v3-8-6-patch-var-3', '1', 'yes'),
 (197, 'mdocs-v3-7-4-patch-var-1', '1', 'yes'),
 (198, 'mdocs-v3-7-3-patch-var-1', '1', 'yes'),
 (199, 'mdocs-v3-7-1-patch-var-1', '1', 'yes'),
 (200, 'mdocs-v3-6-13-patch-var-1', '1', 'yes'),
 (201, 'mdocs-v3-6-patch-var-1', '1', 'yes'),
 (202, 'mdocs-v3-4-patch-var-1', '1', 'yes'),
 (203, 'mdocs-v3-0-patch-var-3', '1', 'yes'),
 (204, 'mdocs-v3-0-patch-var-2', '1', 'yes'),
 (205, 'mdocs-v3-0-patch-var-1', '1', 'yes'),
 (206, 'mdocs-box-view-updated', '1', 'yes'),
 (207, 'mdocs-v2-5-patch-var-1', '1', 'yes'),
 (208, 'mdocs-v2-4-patch-var-1', '1', 'yes'),
 (209, 'mdocs-v2-3-1-patch-var-1', '1', 'yes'),
 (210, 'mdocs-2-1-patch-1', '1', 'yes'),
 (311, 'mdocs-list', 'a:9:{i:0;a:24:{s:2:\"id\";s:4:\"1232\";s:6:\"parent\";s:4:\"1231\";s:8:\"filename\";s:20:\"Newletter Final1.pdf\";s:4:\"name\";s:13:\"December 2017\";s:4:\"desc\";s:0:\"\";s:4:\"type\";s:3:\"pdf\";s:3:\"cat\";s:11:\"mdocs-cat-1\";s:5:\"owner\";s:5:\"admin\";s:12:\"contributors\";a:0:{}s:6:\"author\";s:0:\"\";s:4:\"size\";i:4568028;s:8:\"modified\";d:1547607180;s:7:\"version\";s:3:\"1.0\";s:11:\"show_social\";s:2:\"on\";s:11:\"non_members\";s:2:\"on\";s:11:\"file_status\";s:6:\"public\";s:11:\"post_status\";s:7:\"publish\";s:15:\"post_status_sys\";s:7:\"publish\";s:11:\"doc_preview\";s:0:\"\";s:9:\"downloads\";i:0;s:8:\"archived\";a:0:{}s:7:\"ratings\";a:0:{}s:6:\"rating\";i:0;s:11:\"box-view-id\";i:0;}i:1;a:23:{s:2:\"id\";s:1:\"7\";s:6:\"parent\";s:1:\"6\";s:8:\"filename\";s:36:\"Police_Certificate_of_Character.docx\";s:4:\"name\";s:53:\"Police Certificate of Character/Clearance Application\";s:4:\"desc\";s:0:\"\";s:4:\"type\";s:4:\"docx\";s:3:\"cat\";s:10:\"mdocuments\";s:5:\"owner\";s:5:\"admin\";s:12:\"contributors\";a:0:{}s:4:\"size\";s:5:\"11195\";s:8:\"modified\";i:1544095907;s:7:\"version\";s:3:\"1.0\";s:11:\"show_social\";s:2:\"on\";s:11:\"non_members\";s:2:\"on\";s:11:\"file_status\";s:6:\"public\";s:11:\"post_status\";s:7:\"publish\";s:15:\"post_status_sys\";s:7:\"publish\";s:11:\"doc_preview\";s:0:\"\";s:9:\"downloads\";s:1:\"0\";s:8:\"archived\";a:0:{}s:7:\"ratings\";a:0:{}s:6:\"rating\";i:0;s:11:\"box-view-id\";i:0;}i:2;a:23:{s:2:\"id\";s:1:\"9\";s:6:\"parent\";s:1:\"8\";s:8:\"filename\";s:73:\"Renunciation-Declaration-Form-THE-GUYANA-CITIZENSHIP-REGULATIONS-FORM.pdf\";s:4:\"name\";s:30:\"Renunciation Declaration Form \";s:4:\"desc\";s:0:\"\";s:4:\"type\";s:3:\"pdf\";s:3:\"cat\";s:10:\"mdocuments\";s:5:\"owner\";s:5:\"admin\";s:12:\"contributors\";a:0:{}s:4:\"size\";s:6:\"109390\";s:8:\"modified\";i:1544095907;s:7:\"version\";s:3:\"1.0\";s:11:\"show_social\";s:2:\"on\";s:11:\"non_members\";s:2:\"on\";s:11:\"file_status\";s:6:\"public\";s:11:\"post_status\";s:7:\"publish\";s:15:\"post_status_sys\";s:7:\"publish\";s:11:\"doc_preview\";s:0:\"\";s:9:\"downloads\";s:1:\"0\";s:8:\"archived\";a:0:{}s:7:\"ratings\";a:0:{}s:6:\"rating\";i:0;s:11:\"box-view-id\";i:0;}i:3;a:23:{s:2:\"id\";s:2:\"11\";s:6:\"parent\";s:2:\"10\";s:8:\"filename\";s:25:\"VISA_APPLICATION_FORM.pdf\";s:4:\"name\";s:16:\"Visa Application\";s:4:\"desc\";s:0:\"\";s:4:\"type\";s:3:\"pdf\";s:3:\"cat\";s:10:\"mdocuments\";s:5:\"owner\";s:5:\"admin\";s:12:\"contributors\";a:0:{}s:4:\"size\";s:6:\"161912\";s:8:\"modified\";i:1544095907;s:7:\"version\";s:3:\"1.0\";s:11:\"show_social\";s:2:\"on\";s:11:\"non_members\";s:2:\"on\";s:11:\"file_status\";s:6:\"public\";s:11:\"post_status\";s:7:\"publish\";s:15:\"post_status_sys\";s:7:\"publish\";s:11:\"doc_preview\";s:0:\"\";s:9:\"downloads\";i:1;s:8:\"archived\";a:0:{}s:7:\"ratings\";a:0:{}s:6:\"rating\";i:0;s:11:\"box-view-id\";i:0;}i:4;a:23:{s:2:\"id\";s:2:\"13\";s:6:\"parent\";s:2:\"12\";s:8:\"filename\";s:38:\"birth_certificate_application_form.pdf\";s:4:\"name\";s:29:\"Birth Certificate Application\";s:4:\"desc\";s:0:\"\";s:4:\"type\";s:3:\"pdf\";s:3:\"cat\";s:10:\"mdocuments\";s:5:\"owner\";s:5:\"admin\";s:12:\"contributors\";a:0:{}s:4:\"size\";s:5:\"50169\";s:8:\"modified\";i:1544095907;s:7:\"version\";s:3:\"1.0\";s:11:\"show_social\";s:2:\"on\";s:11:\"non_members\";s:2:\"on\";s:11:\"file_status\";s:6:\"public\";s:11:\"post_status\";s:7:\"publish\";s:15:\"post_status_sys\";s:7:\"publish\";s:11:\"doc_preview\";s:0:\"\";s:9:\"downloads\";s:1:\"0\";s:8:\"archived\";a:0:{}s:7:\"ratings\";a:0:{}s:6:\"rating\";i:0;s:11:\"box-view-id\";i:0;}i:5;a:23:{s:2:\"id\";s:2:\"15\";s:6:\"parent\";s:2:\"14\";s:8:\"filename\";s:38:\"death_certificate_application_form.pdf\";s:4:\"name\";s:29:\"Death Certificate Application\";s:4:\"desc\";s:0:\"\";s:4:\"type\";s:3:\"pdf\";s:3:\"cat\";s:10:\"mdocuments\";s:5:\"owner\";s:5:\"admin\";s:12:\"contributors\";a:0:{}s:4:\"size\";s:5:\"50726\";s:8:\"modified\";i:1544095907;s:7:\"version\";s:3:\"1.0\";s:11:\"show_social\";s:2:\"on\";s:11:\"non_members\";s:2:\"on\";s:11:\"file_status\";s:6:\"public\";s:11:\"post_status\";s:7:\"publish\";s:15:\"post_status_sys\";s:7:\"publish\";s:11:\"doc_preview\";s:0:\"\";s:9:\"downloads\";s:1:\"0\";s:8:\"archived\";a:0:{}s:7:\"ratings\";a:0:{}s:6:\"rating\";i:0;s:11:\"box-view-id\";i:0;}i:6;a:23:{s:2:\"id\";s:2:\"17\";s:6:\"parent\";s:2:\"16\";s:8:\"filename\";s:23:\"guyana_passport_app.pdf\";s:4:\"name\";s:20:\"Passport Application\";s:4:\"desc\";s:0:\"\";s:4:\"type\";s:3:\"pdf\";s:3:\"cat\";s:10:\"mdocuments\";s:5:\"owner\";s:5:\"admin\";s:12:\"contributors\";a:0:{}s:4:\"size\";s:5:\"44211\";s:8:\"modified\";i:1544095907;s:7:\"version\";s:3:\"1.0\";s:11:\"show_social\";s:2:\"on\";s:11:\"non_members\";s:2:\"on\";s:11:\"file_status\";s:6:\"public\";s:11:\"post_status\";s:7:\"publish\";s:15:\"post_status_sys\";s:7:\"publish\";s:11:\"doc_preview\";s:0:\"\";s:9:\"downloads\";i:2;s:8:\"archived\";a:0:{}s:7:\"ratings\";a:0:{}s:6:\"rating\";i:0;s:11:\"box-view-id\";i:0;}i:7;a:23:{s:2:\"id\";s:2:\"19\";s:6:\"parent\";s:2:\"18\";s:8:\"filename\";s:24:\"marriage_certificate.pdf\";s:4:\"name\";s:32:\"Marriage Certificate Application\";s:4:\"desc\";s:0:\"\";s:4:\"type\";s:3:\"pdf\";s:3:\"cat\";s:10:\"mdocuments\";s:5:\"owner\";s:5:\"admin\";s:12:\"contributors\";a:0:{}s:4:\"size\";s:5:\"50707\";s:8:\"modified\";i:1544095907;s:7:\"version\";s:3:\"1.0\";s:11:\"show_social\";s:2:\"on\";s:11:\"non_members\";s:2:\"on\";s:11:\"file_status\";s:6:\"public\";s:11:\"post_status\";s:7:\"publish\";s:15:\"post_status_sys\";s:7:\"publish\";s:11:\"doc_preview\";s:0:\"\";s:9:\"downloads\";s:1:\"0\";s:8:\"archived\";a:0:{}s:7:\"ratings\";a:0:{}s:6:\"rating\";i:0;s:11:\"box-view-id\";i:0;}i:8;a:23:{s:2:\"id\";s:2:\"21\";s:6:\"parent\";s:2:\"20\";s:8:\"filename\";s:30:\"remigrant_application_form.pdf\";s:4:\"name\";s:26:\"Remigrant Application Form\";s:4:\"desc\";s:0:\"\";s:4:\"type\";s:3:\"pdf\";s:3:\"cat\";s:10:\"mdocuments\";s:5:\"owner\";s:5:\"admin\";s:12:\"contributors\";a:0:{}s:4:\"size\";s:6:\"347106\";s:8:\"modified\";i:1544095907;s:7:\"version\";s:3:\"1.0\";s:11:\"show_social\";s:2:\"on\";s:11:\"non_members\";s:2:\"on\";s:11:\"file_status\";s:6:\"public\";s:11:\"post_status\";s:7:\"publish\";s:15:\"post_status_sys\";s:7:\"publish\";s:11:\"doc_preview\";s:0:\"\";s:9:\"downloads\";s:1:\"0\";s:8:\"archived\";a:0:{}s:7:\"ratings\";a:0:{}s:6:\"rating\";i:0;s:11:\"box-view-id\";i:0;}}', 'no'),
 (312, 'mdocs-cats', 'a:2:{i:0;a:8:{s:11:\"base_parent\";s:0:\"\";s:5:\"index\";i:0;s:12:\"parent_index\";i:0;s:4:\"slug\";s:10:\"mdocuments\";s:4:\"name\";s:5:\"Forms\";s:6:\"parent\";s:0:\"\";s:8:\"children\";a:0:{}s:5:\"depth\";i:0;}i:1;a:8:{s:11:\"base_parent\";s:0:\"\";s:5:\"index\";i:1;s:12:\"parent_index\";i:0;s:4:\"slug\";s:11:\"mdocs-cat-1\";s:4:\"name\";s:11:\"Newsletters\";s:6:\"parent\";s:0:\"\";s:8:\"children\";a:0:{}s:5:\"depth\";i:0;}}', 'yes'),
 (214, 'mdocs-num-cats', '2', 'yes'),
 (215, 'mdocs-zip', 'mdocs-export.zip', 'yes'),
 (216, 'mdocs-top-downloads', '10', 'yes'),
 (217, 'mdocs-top-rated', '10', 'yes'),
 (218, 'mdocs-last-updated', '10', 'yes'),
 (219, 'mdocs-list-type', 'small', 'yes'),
 (220, 'mdocs-list-type-dashboard', '', 'yes'),
 (221, 'mdocs-hide-all-files-non-members', '', 'yes'),
 (222, 'mdocs-hide-all-posts-non-members', '', 'yes'),
 (223, 'mdocs-hide-all-posts-non-members-default', '', 'yes'),
 (224, 'mdocs-hide-all-files', '', 'yes'),
 (225, 'mdocs-hide-all-posts', '', 'yes'),
 (226, 'mdocs-hide-all-posts-default', '', 'yes'),
 (227, 'mdocs-default-content', 'preview', 'yes'),
 (228, 'mdocs-show-description', '', 'yes'),
 (229, 'mdocs-show-preview', '1', 'yes'),
 (230, 'mdocs-show-versions', '', 'yes'),
 (231, 'mdocs-caps', 'a:8:{s:12:\"allow-upload\";a:2:{s:5:\"title\";s:15:\"Allow to Upload\";s:4:\"caps\";a:1:{i:0;s:18:\"mdocs_allow_upload\";}}s:21:\"allow-upload-frontend\";a:2:{s:5:\"title\";s:24:\"Allow to Upload Frontend\";s:4:\"caps\";a:1:{i:0;s:27:\"mdocs_allow_upload_frontend\";}}s:12:\"batch-delete\";a:2:{s:5:\"title\";s:21:\"Allow to Batch Delete\";s:4:\"caps\";a:1:{i:0;s:18:\"mdocs_batch_delete\";}}s:10:\"batch-edit\";a:2:{s:5:\"title\";s:19:\"Allow to Batch Edit\";s:4:\"caps\";a:1:{i:0;s:16:\"mdocs_batch_edit\";}}s:10:\"batch-move\";a:2:{s:5:\"title\";s:19:\"Allow to Batch Move\";s:4:\"caps\";a:1:{i:0;s:16:\"mdocs_batch_move\";}}s:14:\"manage-options\";a:2:{s:5:\"title\";s:14:\"Manage Options\";s:4:\"caps\";a:1:{i:0;s:20:\"mdocs_manage_options\";}}s:15:\"manage-settings\";a:2:{s:5:\"title\";s:15:\"Manage Settings\";s:4:\"caps\";a:2:{i:0;s:21:\"mdocs_manage_settings\";i:1;s:14:\"manage_options\";}}s:20:\"private-post-viewing\";a:3:{s:5:\"title\";s:28:\"View Private Posts and Pages\";s:4:\"caps\";a:2:{i:0;s:18:\"read_private_posts\";i:1;s:18:\"read_private_pages\";}s:5:\"roles\";a:1:{i:0;s:6:\"editor\";}}}', 'yes'),
 (232, 'mdocs-box-show-print-and-download', '', 'yes'),
 (233, 'mdocs-hide-widget-numbers', '1', 'yes'),
 (234, 'mdocs-show-share', '', 'yes'),
 (235, 'mdocs-show-social', '', 'yes'),
 (236, 'mdocs-download-color-normal', '#d14836', 'yes'),
 (237, 'mdocs-download-color-hover', '#c34131', 'yes'),
 (238, 'mdocs-download-text-color-normal', '#ffffff', 'yes'),
 (239, 'mdocs-download-text-color-hover', '#ffffff', 'yes'),
 (240, 'mdocs-navbar-bgcolor', '#f8f8f8', 'yes'),
 (241, 'mdocs-navbar-bordercolor', '#c4c4c4', 'yes'),
 (242, 'mdocs-navbar-text-color-normal', '#777777', 'yes'),
 (243, 'mdocs-navbar-text-color-hover', '#333333', 'yes'),
 (244, 'mdocs-show-new-banners', '', 'yes'),
 (245, 'mdocs-hide-file-type-icon', '1', 'yes'),
 (246, 'mdocs-hide-new-update-label', '1', 'yes'),
 (247, 'mdocs-hide-name', '', 'yes'),
 (248, 'mdocs-hide-filename', '1', 'yes'),
 (249, 'mdocs-time-to-display-banners', '14', 'yes'),
 (250, 'mdocs-doc-preview', '', 'yes'),
 (251, 'mdocs-sort-type', 'modified', 'yes'),
 (252, 'mdocs-sort-style', 'desc', 'yes'),
 (253, 'mdocs-htaccess', 'Deny from all\r\nOptions +Indexes', 'yes'),
 (254, 'mdocs-view-private', 'a:1:{s:13:\"administrator\";s:1:\"1\";}', 'yes'),
 (835, 'mdocs-override-post-title-font-size', '', 'yes'),
 (255, 'mdocs-date-format', 'd-m-Y G:i', 'yes'),
 (256, 'mdocs-allow-upload', '', 'yes'),
 (257, 'mdocs-font-size', '14', 'yes'),
 (258, 'mdocs-post-show-title', '1', 'yes'),
 (259, 'mdocs-post-title-font-size', '', 'yes'),
 (260, 'mdocs-override-document-list-title-font-size', '', 'yes'),
 (261, 'mdocs-hide-subfolders', '', 'yes'),
 (262, 'mdocs-hide-all-subfolders', '', 'yes'),
 (263, 'mdocs-show-post-menu', '', 'yes'),
 (264, 'mdocs-disable-user-sort', '', 'yes'),
 (265, 'mdocs-disable-bootstrap', '', 'yes'),
 (266, 'mdocs-disable-bootstrap-admin', '', 'yes'),
 (267, 'mdocs-disable-jquery', '', 'yes'),
 (268, 'mdocs-disable-fontawesome', '', 'yes'),
 (269, 'mdocs-show-no-file-found', '1', 'yes'),
 (270, 'mdocs-preview-type', 'google', 'yes'),
 (271, 'mdocs-box-view-key', '', 'yes'),
 (272, 'mdocs-remove-posts-from-homepage', '', 'yes'),
 (273, 'mdocs-dropdown-toggle-fix', '', 'yes'),
 (274, 'mdocs-hide-navbar', '', 'yes'),
 (275, 'mdocs-hide-sortbar', '', 'yes'),
 (276, 'mdocs-convert-to-latin', '', 'yes'),
 (277, 'mdocs-hide-footer', '', 'yes'),
 (278, 'mdocs-file-highlight-color-new-normal', '#dff0d8', 'yes'),
 (279, 'mdocs-file-highlight-color-new-hover', '#d0e9c6', 'yes'),
 (280, 'mdocs-file-highlight-color-updated-normal', '#d9edf7', 'yes'),
 (281, 'mdocs-file-highlight-color-updated-hover', '#c4e3f3', 'yes'),
 (282, 'mdocs-show-upload-folder', '1', 'yes'),
 (283, 'mdocs-show-upload-version', '1', 'yes'),
 (284, 'mdocs-show-upload-date', '', 'yes'),
 (285, 'mdocs-show-upload-file-status', '1', 'yes'),
 (286, 'mdocs-show-upload-post-status', '1', 'yes'),
 (287, 'mdocs-show-upload-social', '', 'yes'),
 (288, 'mdocs-show-upload-show-social-apps', '', 'yes'),
 (289, 'mdocs-show-non-members', '', 'yes'),
 (290, 'mdocs-show-upload-downloadable-by-non-members', '', 'yes'),
 (291, 'mdocs-show-upload-contributors', '', 'yes'),
 (292, 'mdocs-show-upload-tags', '', 'yes'),
 (293, 'mdocs-show-upload-categories', '1', 'yes'),
 (294, 'mdocs-show-upload-description', '', 'yes'),
 (295, 'mdocs-show-upload-real-author', '', 'yes'),
 (296, 'mdocs-show-upload-author', '', 'yes'),
 (297, 'mdocs-show-current-folder-on-top', '', 'yes'),
 (298, 'mdocs-show-upload-button-on-normal-page', '', 'yes'),
 (299, 'mdocs-show-media-files', '', 'yes'),
 (300, 'mdocs-show-advanced-search', '1', 'yes'),
 (301, 'mdocs-hide-entry-div', '1', 'yes'),
 (302, 'mdocs-override-time-offset', '', 'yes'),
 (303, 'mdocs-override-time-offset-value', '', 'yes'),
 (304, 'mdocs-disable-sessions', '', 'yes'),
 (305, 'mdocs-post-target-type', '_blank', 'yes'),
 (306, 'mdocs-hide-widget-titles', '1', 'yes'),
 (307, 'mdocs-allowed-mime-types', 'a:0:{}', 'yes'),
 (308, 'mdocs-removed-mime-types', 'a:0:{}', 'yes'),
 (309, 'mdocs-patches', 'a:0:{}', 'yes'),
 (310, 'mdocs-displayed-file-info', 'a:11:{s:9:\"show-name\";a:8:{s:4:\"slug\";s:4:\"name\";s:4:\"text\";s:4:\"Name\";s:4:\"icon\";s:0:\"\";s:5:\"color\";s:0:\"\";s:8:\"function\";s:18:\"mdocs_display_name\";s:5:\"order\";s:1:\"0\";s:5:\"width\";s:2:\"15\";s:4:\"show\";s:1:\"1\";}s:16:\"show-description\";a:7:{s:4:\"slug\";s:11:\"description\";s:4:\"text\";s:11:\"Description\";s:4:\"icon\";s:0:\"\";s:5:\"color\";s:0:\"\";s:8:\"function\";s:25:\"mdocs_display_description\";s:5:\"order\";s:1:\"1\";s:5:\"width\";s:2:\"30\";}s:14:\"show-downloads\";a:8:{s:4:\"slug\";s:9:\"downloads\";s:4:\"text\";s:9:\"Downloads\";s:4:\"icon\";s:25:\"fas fa-cloud-download-alt\";s:5:\"color\";s:12:\"mdocs-orange\";s:8:\"function\";s:23:\"mdocs_display_downloads\";s:5:\"order\";s:1:\"2\";s:5:\"width\";s:2:\"12\";s:4:\"show\";s:1:\"1\";}s:12:\"show-version\";a:7:{s:4:\"slug\";s:7:\"version\";s:4:\"text\";s:7:\"Version\";s:4:\"icon\";s:13:\"fa fa-history\";s:5:\"color\";s:10:\"mdocs-blue\";s:8:\"function\";s:21:\"mdocs_display_version\";s:5:\"order\";s:1:\"3\";s:5:\"width\";s:1:\"9\";}s:11:\"show-author\";a:7:{s:4:\"slug\";s:6:\"author\";s:4:\"text\";s:5:\"Owner\";s:4:\"icon\";s:12:\"fa fa-pencil\";s:5:\"color\";s:11:\"mdocs-green\";s:8:\"function\";s:19:\"mdocs_display_owner\";s:5:\"order\";s:1:\"4\";s:5:\"width\";s:1:\"9\";}s:16:\"show-real-author\";a:7:{s:4:\"slug\";s:11:\"real-author\";s:4:\"text\";s:6:\"Author\";s:4:\"icon\";s:0:\"\";s:5:\"color\";s:0:\"\";s:8:\"function\";s:25:\"mdocs_display_real_author\";s:5:\"order\";s:1:\"5\";s:5:\"width\";s:1:\"9\";}s:13:\"show-modified\";a:7:{s:4:\"slug\";s:8:\"modified\";s:4:\"text\";s:13:\"Last Modified\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:5:\"color\";s:9:\"mdocs-red\";s:8:\"function\";s:21:\"mdocs_display_updated\";s:5:\"order\";s:1:\"6\";s:5:\"width\";s:2:\"15\";}s:11:\"show-rating\";a:7:{s:4:\"slug\";s:6:\"rating\";s:4:\"text\";s:6:\"Rating\";s:4:\"icon\";s:0:\"\";s:5:\"color\";s:0:\"\";s:8:\"function\";s:20:\"mdocs_display_rating\";s:5:\"order\";s:1:\"7\";s:5:\"width\";s:2:\"10\";}s:13:\"show-download\";a:7:{s:4:\"slug\";s:8:\"download\";s:4:\"text\";s:8:\"Download\";s:4:\"icon\";s:14:\"fa fa-download\";s:5:\"color\";s:0:\"\";s:8:\"function\";s:26:\"mdocs_display_download_btn\";s:5:\"order\";s:1:\"8\";s:5:\"width\";s:2:\"12\";}s:14:\"show-file-size\";a:8:{s:4:\"slug\";s:9:\"file-size\";s:4:\"text\";s:9:\"File Size\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:5:\"color\";s:0:\"\";s:8:\"function\";s:23:\"mdocs_display_file_size\";s:5:\"order\";s:1:\"9\";s:5:\"width\";s:1:\"9\";s:4:\"show\";s:1:\"1\";}s:14:\"show-file-type\";a:7:{s:4:\"slug\";s:9:\"file-type\";s:4:\"text\";s:9:\"File Type\";s:4:\"icon\";s:0:\"\";s:5:\"color\";s:11:\"mdocs-black\";s:8:\"function\";s:23:\"mdocs_display_file_type\";s:5:\"order\";s:2:\"10\";s:5:\"width\";s:1:\"9\";}}', 'yes'),
 (313, 'mdocs-v2-6-6-patch-var-1', '1', 'yes'),
 (314, 'mdocs-v2-6-7-patch-var-1', '1', 'yes'),
 (211, 'mdocs-documents-page-created', '1', 'yes'),
 (354, 'widget_ad_125_125-widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (350, 'current_theme', 'Avada', 'yes'),
 (351, 'theme_mods_Avada', 'a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:15:\"main_navigation\";i:15;}s:18:\"custom_css_post_id\";i:-1;}', 'yes'),
 (352, 'theme_switched', '', 'yes'),
 (353, 'avada_version', '5.8.0', 'yes'),
 (357, 'widget_pyre_tabs-widget', 'a:2:{i:2;a:8:{s:5:\"posts\";s:1:\"3\";s:8:\"comments\";s:1:\"3\";s:4:\"tags\";s:1:\"3\";s:18:\"show_popular_posts\";s:2:\"on\";s:17:\"show_recent_posts\";s:2:\"on\";s:13:\"show_comments\";s:2:\"on\";s:9:\"show_tags\";N;s:7:\"orderby\";s:16:\"Highest Comments\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (358, 'widget_recent_works-widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (359, 'widget_tweets-widget', 'a:2:{i:2;a:18:{s:5:\"title\";s:13:\"Recent Tweets\";s:12:\"consumer_key\";s:0:\"\";s:15:\"consumer_secret\";s:0:\"\";s:12:\"access_token\";s:0:\"\";s:19:\"access_token_secret\";s:0:\"\";s:10:\"twitter_id\";s:12:\"theme_fusion\";s:5:\"count\";s:1:\"3\";s:9:\"widget_id\";s:0:\"\";s:11:\"widget_type\";s:13:\"twitter_style\";s:5:\"width\";s:3:\"222\";s:6:\"height\";s:0:\"\";s:5:\"theme\";s:5:\"light\";s:10:\"link_color\";s:7:\"#549f97\";s:12:\"border_color\";s:7:\"#e0dede\";s:11:\"show_header\";N;s:11:\"show_footer\";N;s:12:\"show_borders\";N;s:14:\"transparent_bg\";s:2:\"on\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (360, 'widget_flickr-widget', 'a:2:{i:2;a:4:{s:5:\"title\";s:13:\"Flickr Photos\";s:11:\"screen_name\";s:14:\"fabianoaccorsi\";s:6:\"number\";s:1:\"6\";s:3:\"api\";s:32:\"c9d2c2fda03a2ff487cb4769dc0781ea\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (361, 'widget_social_links-widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (362, 'widget_facebook-like-widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (363, 'widget_menu-widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (364, 'widget_avada-vertical-menu-widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (367, '_transient_timeout_avada_demos', '1544702727', 'no'),
 (409, 'fusion_core_version', '3.8', 'yes'),
 (598, 'fusion_applied_patches', 'a:4:{i:0;i:416672;i:1;i:416675;i:2;i:416685;i:3;i:416773;}', 'no'),
 (583, 'wpseo-gsc', 'a:1:{s:7:\"profile\";s:0:\"\";}', 'yes'),
 (5654, 'fusion_core_flush_permalinks', '1', 'yes'),
 (510, 'ls-plugin-version', '6.7.6', 'yes'),
 (511, 'ls-db-version', '6.5.5', 'yes'),
 (512, 'ls-installed', '1', 'yes'),
 (513, 'ls-date-installed', '1544098162', 'yes'),
 (485, 'fusion_registration', 'a:1:{s:5:\"avada\";a:1:{s:5:\"token\";s:32:\"ayaGocYt1Cnn8X6V2ihBQUfceVzNwD1v\";}}', 'yes'),
 (486, 'fusion_registered', 'a:2:{s:5:\"avada\";b:1;s:6:\"scopes\";a:1:{s:5:\"avada\";a:5:{i:0;s:7:\"default\";i:1;s:13:\"user:username\";i:2;s:17:\"purchase:download\";i:3;s:13:\"purchase:list\";i:4;s:15:\"purchase:verify\";}}}', 'yes'),
 (386, '_transient_timeout_avada_ri_Fusion Core', '1544098540', 'no'),
 (505, '_transient_timeout_avada_remote_installer_package_Revolution Slider', '1544098442', 'no'),
 (390, '_transient_timeout_avada_ri_Fusion Builder', '1544098540', 'no'),
 (515, 'widget_layerslider_widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (394, '_transient_timeout_avada_ri_Fusion White Label Branding', '1544098540', 'no'),
 (396, '_transient_timeout_avada_ri_Convert Plus', '1544098541', 'no'),
 (398, '_transient_timeout_avada_ri_Advanced Custom Fields PRO', '1544098541', 'no'),
 (400, '_transient_timeout_avada_ri_LayerSlider WP', '1544098541', 'no'),
 (402, '_transient_timeout_avada_ri_Revolution Slider', '1544098542', 'no'),
 (406, '_site_transient_fusion_wordpress_org_plugins', 'a:5:{s:11:\"woocommerce\";a:25:{s:4:\"name\";s:11:\"WooCommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:7:\"version\";s:5:\"3.5.2\";s:6:\"author\";s:48:\"<a href=\"https://woocommerce.com\">Automattic</a>\";s:14:\"author_profile\";s:40:\"https://profiles.wordpress.org/woothemes\";s:8:\"requires\";s:3:\"4.7\";s:6:\"tested\";s:3:\"5.0\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";a:0:{}s:6:\"rating\";d:92;s:7:\"ratings\";a:5:{i:5;i:2605;i:4;i:125;i:3;i:64;i:2;i:65;i:1;i:208;}s:11:\"num_ratings\";i:3067;s:15:\"support_threads\";i:1516;s:24:\"support_threads_resolved\";i:1172;s:10:\"downloaded\";i:56579098;s:12:\"last_updated\";s:21:\"2018-11-29 5:19pm GMT\";s:5:\"added\";s:10:\"2011-09-27\";s:8:\"homepage\";s:24:\"https://woocommerce.com/\";s:8:\"sections\";a:5:{s:11:\"description\";s:7240:\"<p>WooCommerce is a free eCommerce plugin that allows you to sell anything, beautifully. Built to integrate seamlessly with WordPress, WooCommerce is the world’s favorite eCommerce solution that gives both store owners and developers complete control.</p>\n<p>With endless flexibility and access to hundreds of free and premium WordPress extensions, WooCommerce now powers 30% of all online stores &mdash; more than any other platform.</p>\n<span class=\"embed-youtube\" style=\"text-align:center; display: block;\"><iframe class=\'youtube-player\' type=\'text/html\' width=\'640\' height=\'390\' src=\'https://www.youtube.com/embed/1KahlicghaE?version=3&#038;rel=1&#038;fs=1&#038;autohide=2&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;wmode=transparent\' allowfullscreen=\'true\' style=\'border:0;\'></iframe></span>\n<h4>Sell anything, anywhere</h4>\n<p>With WooCommerce, you can sell both physical and digital goods in all shapes and sizes, offer product variations, multiple configurations, and instant downloads to shoppers, and even sell affiliate goods from online marketplaces.</p>\n<p>With premium extensions, you can offer bookings, memberships, and recurring subscriptions. Perhaps you’d like to sell monthly subscriptions for physical goods, or offer your members a discount on digital downloads? It’s all possible.</p>\n<h4>Ship wherever you like</h4>\n<p>Offer free shipping, flat rate shipping, or make real-time calculations. Limit your shipments to specific countries, or open your store up to the world. Shipping is highly configurable, and WooCommerce even supports drop shipping.</p>\n<h4>Extensive payment options</h4>\n<p>WooCommerce comes bundled with the ability to accept major credit cards, PayPal, BACS (bank transfers), and cash on delivery. Need additional options? More than 140 region-specific gateways integrate with WooCommerce, including popular choices like Stripe, Authorize.Net, and Amazon Payments.</p>\n<h4>You control it all &mdash; forever</h4>\n<p>WooCommerce gives you complete control of your store, from taxes to stock levels to customer accounts. Add and remove extensions, change your design, and switch settings as you please. It’s all under your control.</p>\n<p>One of the biggest risks of using a hosted eCommerce platform is what happens to your store if the provider closes up shop. With WooCommerce, you have complete control, so there’s never any reason to worry. Your data belongs to you &mdash; and it’s kept secure, thanks to regular audits by industry leaders.</p>\n<h4>Define your style with Storefront</h4>\n<p><a href=\"https://woocommerce.com/storefront/\" rel=\"nofollow\">Storefront</a> is a free WordPress theme available to any WooCommerce store. Along with deep WooCommerce integration, Storefront prioritizes speed and uptime while eliminating theme and plugin conflicts during major updates.</p>\n<p>Define your style even further by customizing Storefront to your liking or choosing from one of our several <a href=\"https://woocommerce.com/product-category/themes/storefront-child-theme-themes/\" rel=\"nofollow\">Storefront child themes</a>. It’s all up to you, and all open source.</p>\n<h4>Built with developers in mind</h4>\n<p>Extendable, adaptable, and open source &mdash; WooCommerce was created with developers in mind. With its strong, robust framework, you can scale your client’s store all the way from basic to high-end (infinity and beyond).</p>\n<p>Built with a REST API, WooCommerce can integrate with virtually any service. Your store’s data can be accessed anywhere, anytime, 100% securely. WooCommerce allows developers to easily create, modify, and grow a store that meets their specifications.</p>\n<p>No matter the size of the store you want to build, WooCommerce will scale to meet your requirements. With a growing collection of more than 300 extensions, you can enhance each store’s features to meet your client’s unique needs &mdash; or even create your own solution.</p>\n<p>If security is a concern, rest easy. WooCommerce is audited by a dedicated team of developers working around the clock to identify and patch any and all discovered bugs.</p>\n<p>We also support WooCommerce and all its extensions with comprehensive, easily-accessible documentation. With our docs, you’ll learn how to create the exact site your client needs.</p>\n<h4>Extensions galore</h4>\n<p>WordPress.org is home to some amazing extensions for WooCommerce, including:</p>\n<ul>\n<li><a href=\"https://wordpress.org/plugins/woocommerce-google-analytics-integration/\">Google Analytics</a></li>\n<li><a href=\"https://wordpress.org/plugins/woocommerce-delivery-notes/\">Delivery Notes</a></li>\n<li><a href=\"https://wordpress.org/plugins/woocommerce-pdf-invoices-packing-slips/\">PDF Invoices and Packing Slips</a></li>\n<li><a href=\"https://wordpress.org/plugins/affiliates-woocommerce-light/\">Affiliates Integration Light</a></li>\n<li><a href=\"https://wordpress.org/plugins/woocommerce-new-product-badge/\">New Product Badges</a></li>\n</ul>\n<p>Keen to see them all? Search WordPress.org for ‘WooCommerce’ to dive in.</p>\n<p>If you’re looking for something endorsed and maintained by the developers who built WooCommerce, there are a plethora of premium eCommerce extensions, the most popular of which include:</p>\n<ul>\n<li><a href=\"https://woocommerce.com/products/woocommerce-subscriptions/\" rel=\"nofollow\">WooCommerce Subscriptions</a></li>\n<li><a href=\"https://woocommerce.com/products/woocommerce-memberships/\" rel=\"nofollow\">WooCommerce Memberships</a></li>\n<li><a href=\"https://woocommerce.com/products/woocommerce-bookings/\" rel=\"nofollow\">WooCommerce Bookings</a></li>\n<li><a href=\"https://woocommerce.com/products/dynamic-pricing/\" rel=\"nofollow\">Dynamic Pricing</a></li>\n<li><a href=\"https://woocommerce.com/products/table-rate-shipping/\" rel=\"nofollow\">Table Rate Shipping</a></li>\n<li><a href=\"https://woocommerce.com/products/product-csv-import-suite/\" rel=\"nofollow\">Product CSV Import Suite</a></li>\n</ul>\n<p>And there’s plenty more where they came from. Visit our <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/\" rel=\"nofollow\">extensions page</a> to find out everything you’re capable of and all that&#8217;s possible with premium WooCommerce extensions.</p>\n<h4>Join our growing community</h4>\n<p>When you download WooCommerce, you join a community of more than a million store owners, developers, and WordPress enthusiasts. We&#8217;re one of the fastest-growing open source communities online, and no matter your skill level we&#8217;d love to have you!</p>\n<p>If you’re interested in contributing to WooCommerce we’ve got more than 350 contributors, and there’s always room for more. Head over to the <a href=\"https://github.com/woocommerce/woocommerce\" rel=\"nofollow\">WooCommerce GitHub Repository</a> to find out how you can pitch in.</p>\n<p>Want to add a new language to WooCommerce? Swell! You can contribute via <a href=\"https://translate.wordpress.org/projects/wp-plugins/woocommerce\" rel=\"nofollow\">translate.wordpress.org</a>.</p>\n<p>And, finally, consider joining or spearheading a WooCommerce Meetup locally, more about those <a href=\"https://woocommerce.com/woocommerce/meetups/\" rel=\"nofollow\">here</a>.</p>\n\";s:12:\"installation\";s:2221:\"<h4>Minimum Requirements</h4>\n<ul>\n<li>PHP version 5.2.4 or greater (PHP 7.2 or greater is recommended)</li>\n<li>MySQL version 5.0 or greater (MySQL 5.6 or greater is recommended)</li>\n</ul>\n<p>Visit the <a href=\"https://docs.woocommerce.com/document/server-requirements/\" rel=\"nofollow\">WooCommerce server requirements documentation</a> for a detailed list of server requirements.</p>\n<h4>Automatic installation</h4>\n<p>Automatic installation is the easiest option as WordPress handles the file transfers itself and you don’t need to leave your web browser. To do an automatic install of WooCommerce, log in to your WordPress dashboard, navigate to the Plugins menu and click Add New.</p>\n<p>In the search field type “WooCommerce” and click Search Plugins. Once you’ve found our eCommerce plugin you can view details about it such as the point release, rating and description. Most importantly of course, you can install it by simply clicking “Install Now”.</p>\n<h4>Manual installation</h4>\n<p>The manual installation method involves downloading our eCommerce plugin and uploading it to your webserver via your favourite FTP application. The WordPress codex contains <a href=\"https://codex.wordpress.org/Managing_Plugins#Manual_Plugin_Installation\" rel=\"nofollow\">instructions on how to do this here</a>.</p>\n<h4>Updating</h4>\n<p>Automatic updates should work like a charm; as always though, ensure you backup your site just in case.</p>\n<p>If on the off-chance you do encounter issues with the shop/category pages after an update you simply need to flush the permalinks by going to WordPress &gt; Settings &gt; Permalinks and hitting &#8216;save&#8217;. That should return things to normal.</p>\n<h4>Sample data</h4>\n<p>WooCommerce comes with some sample data you can use to see how products look; import sample_products.xml via the <a href=\"https://wordpress.org/plugins/wordpress-importer/\">WordPress importer</a>. You can also use the core <a href=\"https://docs.woocommerce.com/document/product-csv-importer-exporter/\" rel=\"nofollow\">CSV importer</a> or our <a href=\"https://woocommerce.com/products/product-csv-import-suite/\" rel=\"nofollow\">CSV Import Suite plugin</a> to import sample_products.csv.</p>\n\";s:3:\"faq\";s:2228:\"\n<h4>Where can I find WooCommerce documentation and user guides?</h4>\n<p>\n<p>For help setting up and configuring WooCommerce please refer to our <a href=\"https://docs.woocommerce.com/documentation/plugins/woocommerce/getting-started/\" rel=\"nofollow\">user guide</a></p>\n<p>For extending or theming WooCommerce, see our <a href=\"https://docs.woocommerce.com/documentation/plugins/woocommerce/woocommerce-codex/\" rel=\"nofollow\">codex</a>.</p>\n</p>\n<h4>Where can I get support or talk to other users?</h4>\n<p>\n<p>If you get stuck, you can ask for help in the <a href=\"https://wordpress.org/support/plugin/woocommerce\" rel=\"nofollow\">WooCommerce Plugin Forum</a>.</p>\n<p>For help with premium extensions from WooCommerce.com, use <a href=\"https://woocommerce.com/my-account/tickets/\" rel=\"nofollow\">our helpdesk</a>.</p>\n</p>\n<h4>Will WooCommerce work with my theme?</h4>\n<p>\n<p>Yes; WooCommerce will work with any theme, but may require some styling to make it match nicely. Please see our <a href=\"https://docs.woocommerce.com/documentation/plugins/woocommerce/woocommerce-codex/\" rel=\"nofollow\">codex</a> for help. If you&#8217;re looking for a theme with built in WooCommerce integration we recommend <a href=\"https://woocommerce.com/storefront/\" rel=\"nofollow\">Storefront</a>.</p>\n</p>\n<h4>Where can I request new features, eCommerce themes and extensions?</h4>\n<p>\n<p>You can vote on and request new features and extensions in our <a href=\"http://ideas.woocommerce.com/forums/133476-woocommerce\" rel=\"nofollow\">WooIdeas board</a></p>\n</p>\n<h4>Where can I report bugs or contribute to the project?</h4>\n<p>\n<p>Bugs can be reported either in our support forum or preferably on the <a href=\"https://github.com/woocommerce/woocommerce/issues\" rel=\"nofollow\">WooCommerce GitHub repository</a>.</p>\n</p>\n<h4>Where can I find the REST API documentation?</h4>\n<p>\n<p>You can find the documentation of our REST API on the <a href=\"https://woocommerce.github.io/woocommerce-rest-api-docs/\" rel=\"nofollow\">WooCommerce REST API Docs</a>.</p>\n</p>\n<h4>WooCommerce is awesome! Can I contribute?</h4>\n<p>\n<p>Yes you can! Join in on our <a href=\"https://github.com/woocommerce/woocommerce/\" rel=\"nofollow\">GitHub repository</a> 🙂</p>\n</p>\n\n\";s:9:\"changelog\";s:19679:\"<h4>3.5.2 &#8211; 2018-11-29</h4>\n<ul>\n<li>Enhancement &#8211; Added compatibility for Twenty Nineteen theme. #21970</li>\n<li>Update &#8211; Prepare WooCommerce for PHP 7.3. #22009</li>\n<li>Tweak &#8211; Updates the signature field type to &#8220;password&#8221; in PayPal settings for increased security. #21715</li>\n<li>Tweak &#8211; Change the filter name in the /myaccount/lost-password-confirmation.php template to differentiate between other filter with same name and different message. #21829</li>\n<li>Tweak &#8211; Reintroduce Preview button by popular demand with the understanding that the Preview will only work on some product fields. It was removed from pubished products in 3.5.0 to prevent confusion. #21838</li>\n<li>Tweak &#8211; Add tool to systems status tools for running the DB update routine. #21923</li>\n<li>Tweak &#8211; Revert default behavior for <code>woocommerce_formatted_address_force_country_display</code> filter to maintain backwards compatibility. #21865</li>\n<li>Tweak &#8211; Update products block notice for WP 5.0. #21930</li>\n<li>Tweak &#8211; Use wp_kses_post instead of esc_html for sanitizing product titles to allow minimal HTML in product titles. #21936</li>\n<li>Tweak &#8211; Use dedicated woocommerce_add_order_again_cart_item to filter cart item data when ordering again. Prevents issues with applying woocommerce_add_cart_item out of context. #21947</li>\n<li>Tweak &#8211; Remove postal code for Angola, São Tomé and Príncipe since they don&#8217;t use postal codes and update locale info. #21984 #21985 #21987</li>\n<li>Fix &#8211; Metadata with array key of 0 can save properly. #21641</li>\n<li>Fix &#8211; Prevent deleting the default product category via REST API. #21696</li>\n<li>Fix &#8211; Fix &#8216;Table does not exist&#8217; messages on System Status Report in multisite. #21706</li>\n<li>Fix &#8211; Add dynamic SSL check to dashboard SSL notice to prevent misdiagnosing that sites aren&#8217;t set up with SSL. #21738</li>\n<li>Fix &#8211; Don&#8217;t show escaped HTML in admin order item details for fees. #21769</li>\n<li>Fix &#8211; Don&#8217;t include draft variable products in on sale product results. #21778</li>\n<li>Fix &#8211; Add woocommerce_hold_stock_minutes check back to stock check in cart/checkout. #21797 #22050</li>\n<li>Fix &#8211; Fix potential undefined index notice on checkout fields when comparing the sort order. #21801</li>\n<li>Fix &#8211; Throw an error when trying to set a variation as the parent of a variation in the CSV importer. #21810</li>\n<li>Fix &#8211; Make &#8220;account erasure request&#8221; text translatable. #21812</li>\n<li>Fix &#8211; Display notices on Order Pay page. #21821</li>\n<li>Fix &#8211; Fix tax rate uploading by file path. #21831</li>\n<li>Fix &#8211; Make wc_download_log_permission_id constraint creation work better on multisites and multiple sites using the same DB. #21836 #21940</li>\n<li>Fix &#8211; Don&#8217;t render undecoded HTML entities in variations dimensions. #21844</li>\n<li>Fix &#8211; Do not check for stock when not managing stock or have backorders enabled when paying through the order-pay page. #21849</li>\n<li>Fix &#8211; Apply priority field sorting on additional filters to make it apply on the edit address pages as well. #21856</li>\n<li>Fix &#8211; Fix export and edit of attribute labels with html encoded special characters in product CSV exporter. #21864</li>\n<li>Fix &#8211; Prevent fatal error when rendering plaintext customer invoice email. #21879</li>\n<li>Fix &#8211; Prevent fatal error when delivering webhooks using v3 API. #21921</li>\n<li>Fix &#8211; Prevent undefined variable notice in wc_increase_stock_levels. #21928</li>\n<li>Fix &#8211; Fix overescaping image output on product widget. #21929</li>\n<li>Fix &#8211; Croatian Kuna symbol should be lowercase. #21934</li>\n<li>Fix &#8211; Fixed an error when deleting logged entries when using the &#8216;WC_Log_Handler_DB&#8217; handler. #21949</li>\n<li>Fix &#8211; Update ShipStation plugin info so install works through setup wizard. #21953</li>\n<li>Fix &#8211; Use dynamic DB table name in product list table shipping class query. #21954</li>\n<li>Fix &#8211; Log file date/time should be in UTC and not site timezone as per the +00:00:00 string appended to it. #21981</li>\n<li>Fix &#8211; Set customer&#8217;s country to selling country when only selling to one country and default customer location is &#8216;none&#8217;. #21995</li>\n<li>Fix &#8211; Change new account email copy to be compatible with auto-generated accounts. #21999</li>\n<li>Fix &#8211; Correct Aria-Labelledby attribute for quantity selectors. #22000</li>\n<li>Fix &#8211; Show notices on lost password page. #22001</li>\n<li>Fix &#8211; Fix authentication errors when using the REST API with 3rd-party authentication. #22013</li>\n<li>Fix &#8211; Fix issues where potentially not all active plugins were included on the system status report. #22057</li>\n<li>Fix &#8211; Make PDT validation use the same rounding as the IPN validation to prevent erroneous totals mismatch. #21729</li>\n</ul>\n<h4>3.5.1 &#8211; 2018-10-31</h4>\n<ul>\n<li>Fix &#8211; Use CRUD method to get product images to fix custom tables missing images. #21608</li>\n<li>Fix &#8211; Use HTML entity for times sign when outputting dimensions to fix RTL support. #21633</li>\n<li>Fix &#8211; Fix India address format to look nice in the shipping calculator. #21647</li>\n<li>Fix &#8211; Don&#8217;t default gallery variation images to gallery thumbnail size if flexslider is disabled. #21655</li>\n<li>Fix &#8211; Revert show shipping behavior change to prevent missing shipping line on Cart page. #21658</li>\n<li>Fix &#8211; Removed non-existing WC_Product_Simple-&gt;set_date_created_gmt method. #21675</li>\n<li>Fix &#8211; Use correct comment_type when fetching recent reviews for widget. #21689</li>\n<li>Fix &#8211; Do not include strong tags as part of translation string on subscriptions disconnect message. #21690</li>\n<li>Fix &#8211; Make it possible to send webhooks with the v3 API. #21745</li>\n<li>Fix &#8211; Fix get_cart_from_session infinite loop when filters used. #21749</li>\n<li>Fix &#8211; Use array instead of string to define class for address line 2 input on checkout. #21757</li>\n<li>Fix &#8211; Make checkout fields priority work correctly again. #21763</li>\n<li>Tweak &#8211; Remove mentions of deprecated live shipping rates from setup wizard. #21645</li>\n<li>Tweak- Update product block editor hook for WP 5.0. #21703</li>\n<li>Tweak &#8211; Merged similar strings to reduce number of translateable strings. #21704</li>\n<li>Tweak &#8211; Remove hated &#8220;Over to you&#8221; text from emails. #21709</li>\n<li>Tweak &#8211; Revert problematiic customer as post author change. #21740</li>\n</ul>\n<h4>3.5.0 &#8211; 2018-10-17</h4>\n<ul>\n<li>Feature &#8211; REST API v3. #20111</li>\n<li>Feature &#8211; Option has been added on the inventory tab of the edit product page to set a low stock threshold for individual products. #20260</li>\n<li>Feature &#8211; Add ability to export products by category to the CSV exporter. #20870</li>\n<li>Feature &#8211; Ability to define custom product placeholder images that will resize to correct store aspect ratio. #20644</li>\n<li>Enhancement &#8211; Excluded children categories from WP_Query in product shortcode if cat_operator=AND. #20207</li>\n<li>Enhancement &#8211; Add anchor tag example to email template preview. #20246</li>\n<li>Enhancement &#8211; Introduce is_paypal_supported_currency check in setup wizard. #20244</li>\n<li>Enhancement &#8211; Payment method table reordering accessibility. #19844</li>\n<li>Enhancement &#8211; Log errors from transaction emails with logger. #20203</li>\n<li>Enhancement &#8211; Improved shipping calculator experience. Shows destination country and added context to calculate shipping link. #20345</li>\n<li>Enhancement &#8211; On the fly image generation for frontend, if image sizes are missing. #20011</li>\n<li>Enhancement &#8211; SelectWoo enabled product categories dropdown widget. #20617</li>\n<li>Enhancement &#8211; Make it easier to read and act upon the outdated template notice. #20732</li>\n<li>Enhancement &#8211; Styled date, time, etc. inputs in admin to match styling of other inputs. #21013</li>\n<li>Enhancement &#8211; Show update notices on the System Status page for WordPress.org hosted Official WooCommerce extensions. #21073</li>\n<li>Enhancement &#8211; Better wording for transactional emails. #21288</li>\n<li>Fix &#8211; Check billing email is posted before using in WC_Cart::check_customer_coupons. #20180</li>\n<li>Fix &#8211; Shipping postcode formatting when only posting a billing address. #20330</li>\n<li>Fix &#8211; Correctly show/hide save card checkbox on tokenization form. #20506</li>\n<li>Fix &#8211; orderby and order parameters in WC_Customer_Download_Log_Data_Store::get_download_logs() were ignored. #20931</li>\n<li>Fix &#8211; Unslash city name to prevent double escape in tax settings. #21205</li>\n<li>Fix &#8211; Updated phone validation logic. #21188</li>\n<li>Fix &#8211; Fix weight and dimensions cache of variable products if childs doesn&#8217;t have any of those params. #21244</li>\n<li>Fix &#8211; Correctly replace images in the woocommerce_uploads folder with the placeholder image. #20848</li>\n<li>Fix &#8211; Show parent variable product in shipping class admin screen when variation has shipping class. #21278</li>\n<li>Fix &#8211; Correctly excluded administrators from &#8220;Customer list&#8221; report. #21304</li>\n<li>Fix &#8211; Update quick edit logic to show/hide Stock qty and Backorders fields. #21301</li>\n<li>Fix &#8211; Fix Layered Nav Widget where special HTML entities did not display correctly in the &#8220;Any %s&#8221; string. #21312</li>\n<li>Fix &#8211; Set the is_checkout javascript parameter on any page that uses the checkout filter or shortcode. #21328</li>\n<li>Fix &#8211; Fix cron_interval property support in WP_Background_Process. #21353</li>\n<li>Fix &#8211; CSS Changes to make text fields line up on the shipping settings page. #21247</li>\n<li>Fix &#8211; Add extra null check to fix an issue with select payment fields using disabed select as placeholders. #21391</li>\n<li>Fix &#8211; Don&#8217;t modify attributes orderby when sorting by name. #21408</li>\n<li>Fix &#8211; Allow saving a stock quantity of 0 using quick edit. #21447</li>\n<li>Fix &#8211; Change the query used to save session data to the database to protect against deadlocks. #21455</li>\n<li>Fix &#8211; Make sure default category tooltip is rendered when the image column is deactivated. #21410</li>\n<li>Fix &#8211; Fix warning when using logger instance in woocommerce_logging_class filter. #21448</li>\n<li>Fix &#8211; Use uppercase &#8220;ID&#8221; when sorting product queries by ID. #21461</li>\n<li>Fix &#8211; Consistently escape the gateway ID in the checkout payment method template. #21439</li>\n<li>Fix &#8211; Avoid treating HTTP 301 and 302 codes as failures for webhooks. #21491 </li>\n<li>Fix &#8211; Add address_1 to shipping packages info in WC_Cart:: get_shipping_packages to make it work correctly in address formatting functions. #21493</li>\n<li>Fix &#8211; Don&#8217;t fire two of the same action when saving shipping settings. #21494</li>\n<li>Fix &#8211; Remove double condition for address line 2 in <code>WC_Countries::get_default_address_fields</code>.  #20629</li>\n<li>Fix &#8211; Correctly handle shorthand values for memory_limit in php.ini. #21557</li>\n<li>Fix &#8211; Product shortcode numeric term slug matching. #21560</li>\n<li>Fix &#8211; Remove the erasure tools links from the descriptions of the erasure settings for users without the manage_privacy_options capability. #21565</li>\n<li>Fix &#8211; Don&#8217;t double urldecode posted variation attributes. #21570</li>\n<li>Fix &#8211; Don&#8217;t double-sanitize cart images. #21574</li>\n<li>Fix &#8211; Check if ID exists and is not empty before set Product&#8217;s download ID in API. #21588</li>\n<li>Fix &#8211; Ensure wp_list_pluck() gets a array and not possibly null in WC_Product_Data_Store_CPT::update_attributes. #21591</li>\n<li>Fix &#8211; Trim CSV header rows to prevent leading/trailing whitespace issues. #21614</li>\n<li>Fix &#8211; Show draft products in previews on unsupported themes. #21619</li>\n<li>Fix/Tweak &#8211; Fire <code>woocommerce_grant_product_download_access</code> hook after the download has its ID set. #20905</li>\n<li>Fix/Tweak/Performance &#8211; Change wp_woocommerce_sessions primary key to session_id. #21245</li>\n<li>Tweak &#8211; Show empty terms in admin product category filter dropdown. #20324</li>\n<li>Tweak &#8211; Don&#8217;t force default token gateway active by default. #20125</li>\n<li>Tweak &#8211; Move notice output to hooked in functions. #19794</li>\n<li>Tweak &#8211; Apply order bulk actions in chronological order. #20338</li>\n<li>Tweak &#8211; Updated Emogrifier to 2.0. #20547</li>\n<li>Tweak &#8211; Avoid using wp.template (eval) in add-to-cart-variation.js. #19496</li>\n<li>Tweak &#8211; Hide Preview button when creating new products, as most fields aren&#8217;t set up for it. #20650</li>\n<li>Tweak &#8211; For guests, store all address fields to the session whilst placing an order. #20665</li>\n<li>Tweak &#8211; Removed &#8216;ajax_add_to_cart&#8217; class from &#8216;Read more&#8217; button. #20690</li>\n<li>Tweak &#8211; Removed unnecessary checkout form change trigger on load of the checkout page. #20655</li>\n<li>Tweak &#8211; Add image size filters to wc_get_product_attachment_props(). #20722</li>\n<li>Tweak &#8211; Only display the current site&#8217;s tables for a multisite install when viewing the system status. #20731</li>\n<li>Tweak &#8211; include the file path and line number where a fatal error occurred in the fatal errors log. #20787</li>\n<li>Tweak &#8211; Cast tax rate to float so that it can be treated as number further on in the code. #20910</li>\n<li>Tweak &#8211; Send webhooks using Action Scheduler. #20030</li>\n<li>Tweak &#8211; Update customer&#8217;s ip address on successful payment. #21038</li>\n<li>Tweak &#8211; Changed wc_clean to checking for valid utf8 for line items and password. #20993</li>\n<li>Tweak &#8211; Add to cart notice actions (View cart/Continue shopping) now have tabindex 1 for improved accessibility. #21108</li>\n<li>Tweak &#8211; Remove icanhazip from geolocation services. #21198</li>\n<li>Tweak &#8211; Remove unnecessary aria-required attributes from product reviews template. #21211</li>\n<li>Tweak &#8211; Added hidden label for screen readers on checkout address line 2 input. #21193</li>\n<li>Tweak &#8211; Remove empty space in mini-cart template. #21261</li>\n<li>Tweak &#8211; Tax display in cart now depends on whether customer is tax exempt. #21292</li>\n<li>Tweak &#8211; Change sort dropdown option &#8220;Sort by newness&#8221; to &#8220;Sort by latest&#8221;. #21311</li>\n<li>Tweak &#8211; Sanitize endpoint slugs upon saving. #21355</li>\n<li>Tweak &#8211; Ignore converting float meta value for registered post meta. #21333</li>\n<li>Tweak &#8211; Remove &#8216;order_again&#8217; query string to avoid multiple re-orders. #21444</li>\n<li>Tweak &#8211; Remove Netherlands Antilles from the North America continent definitions. #21449</li>\n<li>Tweak &#8211; Display label and meta on the same line in order emails to match frontend Order Details styling. #21456</li>\n<li>Tweak &#8211; Use wp_get_upload_dir for geolite DB path. #21550</li>\n<li>Performance/Tweak &#8211; Use post_author for the order customer instead of &#8216;_customer_user&#8217; meta data. #17895</li>\n<li>Performance &#8211; Exclude frontend include from REST API calls. #20000</li>\n<li>Performance &#8211; Improve performance of the query to delete version transients by removing unneeded &#8220;ORDER BY&#8221;. #21274</li>\n<li>Dev &#8211; REST API &#8211; Allows oAuth1.0a authentication under SSL.</li>\n<li>Dev &#8211; REST API &#8211; Fix position param for images. #20497</li>\n<li>Dev &#8211; REST API &#8211; Handle children products deletion regardless of type. #20670</li>\n<li>Dev &#8211; Added woocommerce_increase_coupon_usage_count and woocommerce_decrease_coupon_usage_count action hooks to increase extensibility of Coupons. #19981</li>\n<li>Dev &#8211; Add endpoints to account menu items filter. #19980</li>\n<li>Dev &#8211; Added qty param to <code>wc_add_to_cart_message</code> filter. #19817</li>\n<li>Dev &#8211; Added <code>woocommerce_search_products_ids</code> filter. #20160</li>\n<li>Dev &#8211; Introduced <code>woocommerce_cart_calculate_shipping_address</code> field to allow manipulation of cart shipping calculator data. #20046</li>\n<li>Dev &#8211; Introduced <code>woocommerce_shipping_calculator_enable_country</code> filter. #20046</li>\n<li>Dev &#8211; Pass product id to backorder notification. #20416</li>\n<li>Dev &#8211; Added woocommerce_cart_shipping_total filter to control shipping display. #20591</li>\n<li>Dev &#8211; Refactor &#8220;Order again&#8221; handling to separate logic better. #20606</li>\n<li>Dev &#8211; Added &#8216;woocommerce_products_admin_list_table_filters&#8217; filter to make it easier to customize the products list table filters. #20634</li>\n<li>Dev &#8211; Added <code>woocommerce_shipping_method_add_rate_args</code> and <code>woocommerce_shipping_method_add_rate</code> filters. #20633</li>\n<li>Dev &#8211; Added <code>woocommerce_coupon_validate_user_usage_limit</code> filter. #20630</li>\n<li>Dev &#8211; Add hooks needed for product custom tables feature plugin. #20520</li>\n<li>Dev &#8211; Added new filter to &#8216;Item in quotes&#8217; translation for messages. #20714</li>\n<li>Dev &#8211; Add &#8216;woocommerce_shutdown_error&#8217; hook triggered on request termination with an error. #20787</li>\n<li>Dev &#8211; New filter &#8216;woocommerce_admin_meta_boxes_variations_count&#8217; to customize the shown count of variations. #21067</li>\n<li>Dev &#8211; Added ability to query products that have a field set in wc_get_products/WC_Product_Query using the wildcard symbol &#8216;*&#8217;. #21162</li>\n<li>Dev &#8211; Added a JavaScript events before and after the order total recalculation on the Edit Order page. #21181</li>\n<li>Dev &#8211; Check for <code>needs_payment</code> instead of <code>has_status( \'pending\' )</code> in PayPal PDT handler for custom order status support. #21200</li>\n<li>Dev &#8211; Added form action hooks for edit account and login templates. #21248</li>\n<li>Dev &#8211; Add action for when system tools are run. #21270</li>\n<li>Dev &#8211; Add &#8211; woocommerce_restock_refunded_items filter to control default state of the restock option when refunding items on an order. #21314</li>\n<li>Dev &#8211; Add an extensible/swappable job queue via WC_Action_Queue and WC_Queue_Interface. #20030</li>\n<li>Dev &#8211; Use WC_Action_Queue for schedule and delivery of webhooks. #20030</li>\n<li>Dev &#8211; Include Action Scheduler v2.1.0 and use it for the default job queue. #21424 /  #20030</li>\n<li>Dev &#8211; Save reviews under the &#8216;review&#8217; comment type. #21305</li>\n<li>Localization &#8211; Updated IT provinces. #20286</li>\n<li>Localization &#8211; Eircode validation. #20330</li>\n<li>Localization &#8211; Disable postcode requirement for Bahrain. #21103</li>\n<li>Localization &#8211; Make postcode field optional and hidden for Nigeria and label State. #21056</li>\n<li>Localization &#8211; Make Romania state selection mandatory. #21180</li>\n<li>Localization &#8211; Make city field optional and hidden for Singapore addresses. #21016</li>\n</ul>\n<p><a href=\"https://raw.githubusercontent.com/woocommerce/woocommerce/master/CHANGELOG.txt\" rel=\"nofollow\">See changelog for all versions</a>.</p>\n\";s:11:\"screenshots\";s:1377:\"<ol><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-1.png?rev=1063946\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-1.png?rev=1063946\" alt=\"The WooCommerce settings panel.\"></a><p>The WooCommerce settings panel.</p></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-2.png?rev=1063946\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-2.png?rev=1063946\" alt=\"WooCommerce products admin.\"></a><p>WooCommerce products admin.</p></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-3.png?rev=1063946\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-3.png?rev=1063946\" alt=\"Product data panel.\"></a><p>Product data panel.</p></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-4.png?rev=1063946\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-4.png?rev=1063946\" alt=\"WooCommerce sales reports.\"></a><p>WooCommerce sales reports.</p></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-5.png?rev=1087192\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-5.png?rev=1087192\" alt=\"A single product page.\"></a><p>A single product page.</p></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-6.png?rev=1087192\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-6.png?rev=1087192\" alt=\"A product archive (grid).\"></a><p>A product archive (grid).</p></li></ol>\";}s:13:\"download_link\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.2.zip\";s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-1.png?rev=1063946\";s:7:\"caption\";s:31:\"The WooCommerce settings panel.\";}i:2;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-2.png?rev=1063946\";s:7:\"caption\";s:27:\"WooCommerce products admin.\";}i:3;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-3.png?rev=1063946\";s:7:\"caption\";s:19:\"Product data panel.\";}i:4;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-4.png?rev=1063946\";s:7:\"caption\";s:26:\"WooCommerce sales reports.\";}i:5;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-5.png?rev=1087192\";s:7:\"caption\";s:22:\"A single product page.\";}i:6;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-6.png?rev=1087192\";s:7:\"caption\";s:25:\"A product archive (grid).\";}}s:4:\"tags\";a:5:{s:10:\"e-commerce\";s:10:\"e-commerce\";s:9:\"ecommerce\";s:9:\"ecommerce\";s:5:\"sales\";s:5:\"sales\";s:4:\"sell\";s:4:\"sell\";s:5:\"store\";s:5:\"store\";}s:8:\"versions\";a:44:{s:5:\"3.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.0.zip\";s:5:\"3.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.1.zip\";s:5:\"3.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.2.zip\";s:5:\"3.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.3.zip\";s:5:\"3.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.4.zip\";s:5:\"3.0.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.5.zip\";s:5:\"3.0.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.6.zip\";s:5:\"3.0.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.7.zip\";s:5:\"3.0.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.8.zip\";s:5:\"3.0.9\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.9.zip\";s:5:\"3.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.0.zip\";s:5:\"3.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.1.zip\";s:5:\"3.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.2.zip\";s:5:\"3.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.0.zip\";s:5:\"3.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.1.zip\";s:5:\"3.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.2.zip\";s:5:\"3.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.3.zip\";s:5:\"3.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.4.zip\";s:5:\"3.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.5.zip\";s:5:\"3.2.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.6.zip\";s:5:\"3.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.0.zip\";s:5:\"3.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.1.zip\";s:5:\"3.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2.zip\";s:10:\"3.3.2-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2-rc.1.zip\";s:5:\"3.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.3.zip\";s:5:\"3.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.4.zip\";s:5:\"3.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.5.zip\";s:5:\"3.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0.zip\";s:12:\"3.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-beta.1.zip\";s:10:\"3.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-rc.2.zip\";s:5:\"3.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.1.zip\";s:5:\"3.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.2.zip\";s:5:\"3.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.3.zip\";s:5:\"3.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.4.zip\";s:5:\"3.4.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.5.zip\";s:5:\"3.4.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.6.zip\";s:5:\"3.4.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.7.zip\";s:5:\"3.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0.zip\";s:12:\"3.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-beta.1.zip\";s:10:\"3.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.1.zip\";s:10:\"3.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.2.zip\";s:5:\"3.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.1.zip\";s:5:\"3.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.2.zip\";s:5:\"trunk\";s:54:\"https://downloads.wordpress.org/plugin/woocommerce.zip\";}s:11:\"donate_link\";s:0:\"\";s:12:\"contributors\";a:0:{}}s:13:\"wordpress-seo\";a:25:{s:4:\"name\";s:9:\"Yoast SEO\";s:4:\"slug\";s:13:\"wordpress-seo\";s:7:\"version\";s:5:\"9.2.1\";s:6:\"author\";s:43:\"<a href=\"https://yoa.st/1uk\">Team Yoast</a>\";s:14:\"author_profile\";s:42:\"https://profiles.wordpress.org/joostdevalk\";s:8:\"requires\";s:3:\"4.8\";s:6:\"tested\";s:3:\"5.0\";s:12:\"requires_php\";s:5:\"5.2.4\";s:13:\"compatibility\";a:0:{}s:6:\"rating\";d:98;s:7:\"ratings\";a:6:{i:5;i:22697;i:4;i:549;i:3;i:130;i:2;i:101;i:1;i:478;i:0;i:1;}s:11:\"num_ratings\";i:23956;s:15:\"support_threads\";i:514;s:24:\"support_threads_resolved\";i:456;s:10:\"downloaded\";i:142734218;s:12:\"last_updated\";s:21:\"2018-11-21 2:01pm GMT\";s:5:\"added\";s:10:\"2010-10-11\";s:8:\"homepage\";s:18:\"https://yoa.st/1uj\";s:8:\"sections\";a:4:{s:11:\"description\";s:5787:\"<h3>Yoast SEO: the #1 WordPress SEO plugin</h3>\n<p>Need some help with your search engine optimization? Need an SEO plugin that helps you reach for the stars? Yoast SEO is the original WordPress SEO plugin since 2008. It is the favorite tool of millions of users, ranging from the bakery around the corner to some of the most popular sites on the planet. With Yoast SEO, you get a solid toolset that helps you aim for that number one spot in the search results. Yoast: SEO for everyone.</p>\n<p>Yoast SEO does everything in its power to please both visitors and search engine spiders. How? Below you’ll find a small sampling of the powers of Yoast SEO:</p>\n<h4>Taking care of your WordPress SEO</h4>\n<ul>\n<li>The most advanced XML Sitemaps functionality at the push of a button.</li>\n<li>Full control over site breadcrumbs: add a piece of code and you’re good to go.</li>\n<li>Set canonical URLs to avoid duplicate content. Never have to worry about Google penalties again.</li>\n<li>Title and meta description templating for better branding and consistent snippets in the search results.</li>\n<li><strong>[Premium]</strong> Expand Yoast SEO with the News SEO, Video SEO, Local SEO and WooCommerce SEO extensions.</li>\n<li><strong>[Premium]</strong> Need help? Yoast SEO Premium users get 1 year free access to our awesome support team.</li>\n</ul>\n<blockquote>\n<p>Note: some features are Premium. Which means you need Yoast SEO Premium to unlock those features. You can <a href=\"https://yoa.st/1v8\" rel=\"nofollow\">get Yoast SEO Premium here</a>!</p>\n</blockquote>\n<h4>Write killer content with Yoast SEO</h4>\n<ul>\n<li>Content &amp; SEO analysis: Invaluable tools to write SEO-friendly texts.</li>\n<li>The snippet preview shows you how your post or page will look in the search results &#8211; even on mobile. Yoast SEO Premium even has social media previews!</li>\n<li><strong>[Premium]</strong> The Insights tool shows you what your text focuses on so you can keep your article in line with your keyphrases.</li>\n<li><strong>[Premium]</strong> Synonyms &amp; related keyphrases: Optimize your article for synonyms and related keyphrases.</li>\n<li><strong>[Premium]</strong> Automatic internal linking suggestions: write your article and get automatic suggested posts to link to.</li>\n</ul>\n<h4>Keep your site in perfect shape</h4>\n<ul>\n<li>Yoast SEO tunes the engine of your site so you can work on creating great content.</li>\n<li>Our cornerstone content and internal linking features help you optimize your site structure in a breeze.</li>\n<li>Integrates with Google Search Console: See how your site performs in the search engines and fix crawl errors.</li>\n<li>Manage SEO roles: Give your colleagues access to specific sections of the Yoast SEO plugin.</li>\n<li>Bulk editor: Make large-scale edits to your site.</li>\n<li><strong>[Premium]</strong> Social previews to manage the way your page is shared on social networks like Facebook and Twitter.</li>\n<li><strong>[Premium]</strong> Redirect manager: It keeps your site healthy by easily redirecting errors from Google Search Console, deleted pages and changed URLs.</li>\n</ul>\n<h3>Premium support</h3>\n<p>The Yoast team does not always provide active support for the Yoast SEO plugin on the WordPress.org forums, as we prioritize our email support. One-on-one email support is available to people who <a href=\"https://yoa.st/1v8\" rel=\"nofollow\">bought Yoast SEO Premium</a> only.</p>\n<p>Note that the <a href=\"https://yoa.st/1v8\" rel=\"nofollow\">Yoast SEO Premium</a> also has several extra features too, including the option to have synonyms and related keyphrases, internal linking suggestions, cornerstone content checks and a redirect manager, so it is well worth your investment!</p>\n<p>You should also check out the <a href=\"https://yoa.st/1uu\" rel=\"nofollow\">Yoast Local SEO</a>, <a href=\"https://yoa.st/1uv\" rel=\"nofollow\">Yoast News SEO</a> and <a href=\"https://yoa.st/1uw\" rel=\"nofollow\">Yoast Video SEO</a> extensions to Yoast SEO. They work with the free version of Yoast SEO already, and these premium extensions of course come with support too.</p>\n<h3>Bug reports</h3>\n<p>Bug reports for Yoast SEO are <a href=\"https://github.com/Yoast/wordpress-seo\" rel=\"nofollow\">welcomed on GitHub</a>. Please note GitHub is not a support forum, and issues that aren’t properly qualified as bugs will be closed.</p>\n<h3>Further Reading</h3>\n<p>For more info on search engine optimization, check out the following:</p>\n<ul>\n<li>The <a href=\"https://yoa.st/1v8\" rel=\"nofollow\">Yoast SEO Plugin</a> official homepage.</li>\n<li>The <a href=\"https://yoa.st/1va\" rel=\"nofollow\">Yoast SEO Knowledgebase</a>.</li>\n<li><a href=\"https://yoa.st/1v6\" rel=\"nofollow\">WordPress SEO &#8211; The definitive Guide by Yoast</a>.</li>\n<li>Other <a href=\"https://yoa.st/1v9\" rel=\"nofollow\">WordPress Plugins</a> by the same team.</li>\n<li>Follow Yoast on <a href=\"https://facebook.com/yoast\" rel=\"nofollow\">Facebook</a> &amp; <a href=\"https://twitter.com/yoast\" rel=\"nofollow\">Twitter</a>.</li>\n</ul>\n<h3>From within WordPress</h3>\n<ol>\n<li>Visit &#8216;Plugins &gt; Add New&#8217;</li>\n<li>Search for &#8216;Yoast SEO&#8217;</li>\n<li>Activate Yoast SEO from your Plugins page.</li>\n<li>Go to &#8220;after activation&#8221; below.</li>\n</ol>\n<h3>Manually</h3>\n<ol>\n<li>Upload the <code>wordpress-seo</code> folder to the <code>/wp-content/plugins/</code> directory</li>\n<li>Activate the Yoast SEO plugin through the &#8216;Plugins&#8217; menu in WordPress</li>\n<li>Go to &#8220;after activation&#8221; below.</li>\n</ol>\n<h3>After activation</h3>\n<ol>\n<li>You should see (a notice to start) the Yoast SEO configuration wizard.</li>\n<li>Go through the configuration wizard and set up the plugin for your site.</li>\n<li>You&#8217;re done!</li>\n</ol>\n\";s:3:\"faq\";s:124:\"<p>You&#8217;ll find answers to many of your questions on <a href=\"https://yoa.st/1va\" rel=\"nofollow\">kb.yoast.com</a>.</p>\n\";s:9:\"changelog\";s:5322:\"<h4>9.2.1</h4>\n<p>Release Date: November 21th, 2018</p>\n<p>Bugfixes:</p>\n<ul>\n<li>Fixes a bug where the title and meta description field&#8217;s cursor would jump to the start when typing.</li>\n</ul>\n<h4>9.2.0</h4>\n<p>Release Date: November 20th, 2018</p>\n<p>Enhancements:</p>\n<ul>\n<li>Adds support for the &#8216;eye&#8217; markers in Gutenberg using the experimental annotations API in Gutenberg. They will work for the paragraph, quote, heading and list blocks.</li>\n<li>Adds the latest og:locale options provided by Facebook. Props to <a href=\"https://github.com/valtlfelipe\" rel=\"nofollow\">valtlfelipe</a></li>\n<li>Adds support for oEmbed utilization of Yoast custom fields (post meta) values. Specifically the image and the title. Props to <a href=\"https://github.com/ben-caplan\" rel=\"nofollow\">ben-caplan</a></li>\n<li>Defines attachment as non-accessible when attachment urls are redirected to the attachment file itself. Props to <a href=\"https://github.com/stodorovic\" rel=\"nofollow\">stodorovic</a></li>\n<li>Improves the accessibility of the &#8220;Bulk editor&#8221; and &#8220;Search console&#8221; tables.</li>\n<li>Hides SEO title and metadescription fields on the author edit page when the author archives are disabled.</li>\n<li>Replaces Settings ZIP download (export) and upload (import) functionality with Settings fields.</li>\n</ul>\n<p>Bugfixes:</p>\n<ul>\n<li>Fixes a bug where assessments would fail if a &#8220;&lt;&#8221; character is present in the content.</li>\n<li>Fixes a bug where the excerpt replacement variable will output a piece of the post content when no excerpt is given.</li>\n<li>Fixes a bug where the wrong title is rendered for the WooCommerce product archive.</li>\n<li>Fixes a bug where the Yoast metabox is visible even when the attachment urls are redirected to the attachment file itself.</li>\n<li>Fixes a bug where the Dashboard Widget was not displayed in the correct language.</li>\n<li>Fixes a bug in combination with Gutenberg where paragraphs were sometimes not correctly detected because paragraph tags were not automatically added in WordPress-like fashion.</li>\n<li>Fixes a bug in combination with Gutenberg where multiple marker buttons could be active at the same time.</li>\n<li>Fixes a bug in combination with Gutenberg where escaped HTML is shown in the OpenGraph description.</li>\n</ul>\n<p>Compatibility:</p>\n<ul>\n<li>Adds the <code>__block_editor_compatible_meta_box</code> flag to our metabox registrations to indicate they are compatible with WordPress 5.0.</li>\n<li>Revise the enqueue order of the JavaScript assets to ensure compatibility with the classic editor plugin and WordPress 5.0.</li>\n</ul>\n<p>Security:</p>\n<ul>\n<li>Fixes a possible command execution by users with SEO Manager roles. Props to <a href=\"https://twitter.com/gweeperx\" rel=\"nofollow\">Dimopoulos Elias</a></li>\n</ul>\n<p>Other:</p>\n<ul>\n<li>Disables the non-functioning markers for the subheading distribution assessment.</li>\n<li>Refactor SEO assessment filenames and exports. Props to <a href=\"https://github.com/Kingdutch\" rel=\"nofollow\">Kingdutch</a></li>\n<li>Deprecates the <code>Yoast_Modal</code> class.</li>\n</ul>\n<p><h4>9.1.0</h4>\n</p>\n<p>Release Date: November 6th, 2018</p>\n<p>Enhancements:</p>\n<ul>\n<li>Improves keyphrase recognition in the first paragraph on texts which start with images and captions.</li>\n<li>Adds a warning notification to the permalink settings page, linking to a knowledge base article. Props to <a href=\"https://github.com/valtlfelipe\" rel=\"nofollow\">valtlfelipe</a></li>\n<li>Adds the filter <code>wpseo_opengraph_is_valid_image_url</code> that allows custom image URL validation. Props to <a href=\"https://github.com/petenelson\" rel=\"nofollow\">petenelson</a></li>\n<li>Updates the font size of the snippet title measure element to correctly mimic Google desktop snippet title. Props to <a href=\"https://github.com/ol0lll\" rel=\"nofollow\">ol0lll</a></li>\n</ul>\n<p>Bugfixes:</p>\n<ul>\n<li>Fixes a bug where the featured image was not recognized in the SEO analysis when using Gutenberg.</li>\n<li>Fixes an accessibility issue where focus would be lost when removing an uploaded image in the configuration wizard.</li>\n<li>Fixes a bug where notices were being thrown when quick editing a post and no post type object could be found.</li>\n<li>Fixes a bug where a dependency wasn&#8217;t loaded for the SEO -&gt; Tools page.</li>\n<li>Fixes a faulty reference to the old SEOAssessor class.</li>\n<li>Fixes the copy of the date archives help text which contains faulty information. Props to <a href=\"https://github.com/mkronenfeld\" rel=\"nofollow\">mkronenfeld</a></li>\n<li>Fixes the spelling of the words &#8220;plug-in&#8221; and &#8220;set-up&#8221;. Props to <a href=\"https://github.com/pedro-mendonca\" rel=\"nofollow\">pedro-mendonca</a></li>\n<li>Fixes a bug where a type error is thrown when the posts or terms focus keyword isn&#8217;t of the type WP_Post as this can collide with third-party plugins.</li>\n</ul>\n<p>Other:</p>\n<ul>\n<li>Changes the reference in the admin bar menu from &#8220;AdWords External&#8221; to &#8220;Google Ads&#8221;.</li>\n<li>Removes non-functioning eye-markers for the link keyphrase assessment.</li>\n</ul>\n<p><h4>Earlier versions</h4>\n</p>\n<p>For the changelog of earlier versions, please refer to https://yoa.st/yoast-seo-changelog</p>\n\";s:11:\"screenshots\";s:1928:\"<ol><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-1.png?rev=1961113\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-1.png?rev=1961113\" alt=\"The Yoast SEO plugin general meta box. You&#039;ll see this on edit post pages, for posts, pages and custom post types.\"></a><p>The Yoast SEO plugin general meta box. You\'ll see this on edit post pages, for posts, pages and custom post types.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-2.png?rev=1961113\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-2.png?rev=1961113\" alt=\"Example of the SEO analysis functionality.\"></a><p>Example of the SEO analysis functionality.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-3.png?rev=1961113\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-3.png?rev=1961113\" alt=\"Example of the readability analysis functionality.\"></a><p>Example of the readability analysis functionality.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-4.png?rev=1834347\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-4.png?rev=1834347\" alt=\"Overview of site-wide SEO problems and possible improvements.\"></a><p>Overview of site-wide SEO problems and possible improvements.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-5.png?rev=1834347\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-5.png?rev=1834347\" alt=\"Control over which features you want to use.\"></a><p>Control over which features you want to use.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-6.png?rev=1834347\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-6.png?rev=1834347\" alt=\"Easily import SEO data from other SEO plugins like All In One SEO pack, HeadSpace2 SEO and wpSEO.de.\"></a><p>Easily import SEO data from other SEO plugins like All In One SEO pack, HeadSpace2 SEO and wpSEO.de.</p></li></ol>\";}s:13:\"download_link\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.9.2.1.zip\";s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-1.png?rev=1961113\";s:7:\"caption\";s:114:\"The Yoast SEO plugin general meta box. You\'ll see this on edit post pages, for posts, pages and custom post types.\";}i:2;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-2.png?rev=1961113\";s:7:\"caption\";s:42:\"Example of the SEO analysis functionality.\";}i:3;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-3.png?rev=1961113\";s:7:\"caption\";s:50:\"Example of the readability analysis functionality.\";}i:4;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-4.png?rev=1834347\";s:7:\"caption\";s:61:\"Overview of site-wide SEO problems and possible improvements.\";}i:5;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-5.png?rev=1834347\";s:7:\"caption\";s:44:\"Control over which features you want to use.\";}i:6;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-6.png?rev=1834347\";s:7:\"caption\";s:100:\"Easily import SEO data from other SEO plugins like All In One SEO pack, HeadSpace2 SEO and wpSEO.de.\";}}s:4:\"tags\";a:5:{s:16:\"content-analysis\";s:16:\"Content analysis\";s:21:\"google-search-console\";s:21:\"google search console\";s:11:\"readability\";s:11:\"Readability\";s:3:\"seo\";s:3:\"seo\";s:11:\"xml-sitemap\";s:11:\"xml sitemap\";}s:8:\"versions\";a:38:{s:3:\"7.0\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.0.zip\";s:5:\"7.0.1\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.0.1.zip\";s:5:\"7.0.2\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.0.2.zip\";s:5:\"7.0.3\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.0.3.zip\";s:3:\"7.1\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.1.zip\";s:3:\"7.2\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.2.zip\";s:3:\"7.3\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.3.zip\";s:3:\"7.4\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.4.zip\";s:5:\"7.4.1\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.4.1.zip\";s:5:\"7.4.2\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.4.2.zip\";s:3:\"7.5\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.5.zip\";s:5:\"7.5.1\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.5.1.zip\";s:5:\"7.5.3\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.5.3.zip\";s:3:\"7.6\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.6.zip\";s:5:\"7.6.1\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.6.1.zip\";s:3:\"7.7\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.7.zip\";s:5:\"7.7.1\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.7.1.zip\";s:5:\"7.7.2\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.7.2.zip\";s:5:\"7.7.3\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.7.3.zip\";s:3:\"7.8\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.8.zip\";s:3:\"7.9\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.9.zip\";s:5:\"7.9.1\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.7.9.1.zip\";s:3:\"8.0\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.8.0.zip\";s:3:\"8.1\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.8.1.zip\";s:5:\"8.1.1\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.8.1.1.zip\";s:5:\"8.1.2\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.8.1.2.zip\";s:3:\"8.2\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.8.2.zip\";s:5:\"8.2.1\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.8.2.1.zip\";s:3:\"8.3\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.8.3.zip\";s:3:\"8.4\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.8.4.zip\";s:3:\"9.0\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.9.0.zip\";s:5:\"9.0.1\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.9.0.1.zip\";s:5:\"9.0.2\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.9.0.2.zip\";s:5:\"9.0.3\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.9.0.3.zip\";s:3:\"9.1\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.9.1.zip\";s:3:\"9.2\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.9.2.zip\";s:5:\"9.2.1\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.9.2.1.zip\";s:5:\"trunk\";s:56:\"https://downloads.wordpress.org/plugin/wordpress-seo.zip\";}s:11:\"donate_link\";s:18:\"https://yoa.st/1up\";s:12:\"contributors\";a:0:{}}s:7:\"bbpress\";a:25:{s:4:\"name\";s:7:\"bbPress\";s:4:\"slug\";s:7:\"bbpress\";s:7:\"version\";s:6:\"2.5.14\";s:6:\"author\";s:55:\"<a href=\"https://bbpress.org\">The bbPress Community</a>\";s:14:\"author_profile\";s:46:\"https://profiles.wordpress.org/johnjamesjacoby\";s:8:\"requires\";s:3:\"4.7\";s:6:\"tested\";s:5:\"4.9.8\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";a:0:{}s:6:\"rating\";d:80;s:7:\"ratings\";a:5:{i:5;i:169;i:4;i:41;i:3;i:25;i:2;i:18;i:1;i:37;}s:11:\"num_ratings\";i:290;s:15:\"support_threads\";i:1;s:24:\"support_threads_resolved\";i:0;s:10:\"downloaded\";i:5169172;s:12:\"last_updated\";s:21:\"2018-10-14 7:15pm GMT\";s:5:\"added\";s:10:\"2010-01-13\";s:8:\"homepage\";s:19:\"https://bbpress.org\";s:8:\"sections\";a:4:{s:11:\"description\";s:472:\"<p>Have you ever been frustrated with forum or bulletin board software that was slow, bloated and always got your server hacked? bbPress is focused on ease of integration, ease of use, web standards, and speed.</p>\n<p>We&#8217;re keeping things as small and light as possible while still allowing for great add-on features through WordPress&#8217;s extensive plugin system. What does all that mean? bbPress is lean, mean, and ready to take on any job you throw at it.</p>\n\";s:12:\"installation\";s:1293:\"<h4>From your WordPress dashboard</h4>\n<ol>\n<li>Visit &#8216;Plugins &gt; Add New&#8217;</li>\n<li>Search for &#8216;bbPress&#8217;</li>\n<li>Activate bbPress from your Plugins page. (You&#8217;ll be greeted with a Welcome page.)</li>\n<li>Visit &#8216;Forums &gt; Add New&#8217; and create some forums. (You can always delete these later.)</li>\n<li>If you have pretty permalinks enabled, visit yourdomain.com/forums, or if you do not have pretty permalinks enabled, visit yourdomain.com?post_type=forum</li>\n</ol>\n<h4>From WordPress.org</h4>\n<ol>\n<li>Download bbPress.</li>\n<li>Upload the &#8216;bbpress&#8217; directory to your &#8216;/wp-content/plugins/&#8217; directory, using your favorite method (ftp, sftp, scp, etc&#8230;)</li>\n<li>Activate bbPress from your Plugins page. (You&#8217;ll be greeted with a Welcome page.)</li>\n<li>Visit &#8216;Forums &gt; Add New&#8217; and create some forums. (You can always delete these later.)</li>\n<li>If you have pretty permalinks enabled, visit yourdomain.com/forums, or if you do not have pretty permalinks enabled, visit yourdomain.com?post_type=forum</li>\n</ol>\n<h4>Extra</h4>\n<ol>\n<li>Visit &#8216;Settings &gt; Forums&#8217; and adjust your configuration.</li>\n<li>Adjust the CSS of your theme as needed, to make everything pretty.</li>\n</ol>\n\";s:9:\"changelog\";s:9239:\"<h4>2.5.14</h4>\n<ul>\n<li>Improved support for PHP 7.1 and higher</li>\n<li>Improved pagination for non-public post statuses</li>\n<li>Fix converter row-limit boundaries</li>\n</ul>\n<h4>2.5.13</h4>\n<ul>\n<li>Improved support for <code>post_parent__in</code> type queries</li>\n</ul>\n<h4>2.5.12</h4>\n<ul>\n<li>Fix role initialization bug</li>\n</ul>\n<h4>2.5.11</h4>\n<ul>\n<li>Improved support for WordPress 4.7</li>\n<li>Improved localization of role names</li>\n<li>Increase minimum WordPress version to 4.2</li>\n</ul>\n<h4>2.5.10</h4>\n<ul>\n<li>Improved user display-name rendering</li>\n</ul>\n<h4>2.5.9</h4>\n<ul>\n<li>Improved user mentions</li>\n</ul>\n<h4>2.5.8</h4>\n<ul>\n<li>Improved ajax actions</li>\n<li>Improved user query parsing</li>\n<li>Fix BuddyPress Groups notice</li>\n</ul>\n<h4>2.5.7</h4>\n<ul>\n<li>Improved output of certain URLs</li>\n</ul>\n<h4>2.5.6</h4>\n<ul>\n<li>Improved notification &amp; subscription email sending</li>\n</ul>\n<h4>2.5.5</h4>\n<ul>\n<li>Improved bulk editing of users</li>\n<li>Improved suggesting of topics &amp; authors for moderators</li>\n<li>Improved converter tool access</li>\n</ul>\n<h4>2.5.4</h4>\n<ul>\n<li>Fix reply editing causing polluted hierarchy</li>\n<li>Add tool for repairing reply positions within topics</li>\n<li>Improved custom slug and displayed user field sanitization</li>\n<li>Improved SSL support when relying on theme compatibility</li>\n</ul>\n<h4>2.5.3</h4>\n<ul>\n<li>WordPress 3.8 support (dashicons, new color schemes)</li>\n<li>Fix dropdown selects in settings pages</li>\n<li>Fix accidental topic subscription removal on reply form</li>\n<li>Fix poor grammar in profile title element</li>\n<li>Fix admin area SSL support</li>\n</ul>\n<h4>2.5.2</h4>\n<ul>\n<li>Fix BuddyPress (1.9.1) Notification integration</li>\n</ul>\n<h4>2.5.1</h4>\n<ul>\n<li>Updated subscriptions setting description</li>\n<li>Fix forum subscriptions not appearing on profiles for some users</li>\n<li>Allow links to have targets</li>\n<li>Improve Windows compatibility</li>\n</ul>\n<h4>2.5</h4>\n<ul>\n<li>Added forum subscriptions</li>\n<li>Added importers for AEF, Drupal, FluxBB, Kunena Forums (Joomla), MyBB, Phorum, PHPFox, PHPWind, PunBB, SMF, Xenforo and XMB</li>\n<li>Added BuddyPress Notifications integration</li>\n<li>Added ability to enqueue scripts and styles in the template stack</li>\n<li>Fix various existing importer scripts</li>\n<li>Fix forum visibility meta saving</li>\n<li>Fix Akismet anonymous user meta checking</li>\n<li>Fix inconsistent bbp_dropdown() results</li>\n<li>Fix topic and reply ping-status inconsistencies</li>\n</ul>\n<h4>2.4.1</h4>\n<ul>\n<li>Fix forum status saving</li>\n<li>Fix widget settings saving</li>\n<li>Fix custom wp_title compatibility</li>\n<li>Fix search results custom permalink compatibility</li>\n<li>Fix custom user topics &amp; replies pages</li>\n<li>Fix hierarchical reply handling in converter</li>\n</ul>\n<h4>2.4</h4>\n<ul>\n<li>Added hierarchical reply support</li>\n<li>Added ability to disable forum search</li>\n<li>Reorganized settings page</li>\n<li>Improved rewrite rules</li>\n<li>Improved responsive CSS</li>\n<li>Improved code posting</li>\n<li>Improved user capability integration</li>\n<li>Improved cache getting and setting</li>\n<li>Audit strict type comparisons</li>\n<li>Audit GlotPress string escaping</li>\n<li>Audit title attribute usage</li>\n<li>Audit WordPress core function usage</li>\n<li>General code clean-up</li>\n</ul>\n<h4>2.3.2</h4>\n<ul>\n<li>Improved posting of preformatted code</li>\n<li>Improved theme compatibility CSS</li>\n<li>Improved BuddyPress Activity Streams integration</li>\n</ul>\n<h4>2.3.1</h4>\n<ul>\n<li>Improved posting of preformatted code</li>\n<li>Fix deleting of post cache group</li>\n<li>Fix moderators not having view_trash capability</li>\n</ul>\n<h4>2.3</h4>\n<ul>\n<li>Added forum search functionality</li>\n<li>Improved BuddyPress Group Forums integration</li>\n<li>Improved allowed tags in topics and replies</li>\n<li>Added template stack support to theme compatability</li>\n<li>Added more forum migration options</li>\n</ul>\n<h4>2.2.4</h4>\n<ul>\n<li>Prepare converter queries</li>\n<li>Improve validation and sanitization of form values</li>\n</ul>\n<h4>2.2.3</h4>\n<ul>\n<li>Improve compatibility with some themes</li>\n<li>Fix integration with BuddyPress Group Forums</li>\n<li>Fix BuddyPress Activity Stream integration</li>\n</ul>\n<h4>2.2.2</h4>\n<ul>\n<li>RTL and i18n fixes</li>\n<li>Improved user profile theme compatibility</li>\n<li>Fixed incorrect link in credits page</li>\n<li>Fixed admin area JS issues related to topic suggest</li>\n<li>Fixed template part reference in extras user edit template</li>\n</ul>\n<h4>2.2.1</h4>\n<ul>\n<li>Fix role mapping for non-WordPress roles</li>\n<li>Fix issue with private forums being blocked</li>\n<li>Allow moderators to see hidden forums</li>\n</ul>\n<h4>2.2</h4>\n<ul>\n<li>Improved user roles and capabilities</li>\n<li>Improved theme compatibility</li>\n<li>Improved BuddyPress Group Forums integration</li>\n<li>Improved forums conversion tool</li>\n<li>Improved forums tools and settings</li>\n<li>Improved multisite support</li>\n<li>Added What&#8217;s New and Credits pages</li>\n<li>WordPress 3.5 and BuddyPress 1.7 ready</li>\n</ul>\n<h4>2.1.2</h4>\n<ul>\n<li>Fixed admin-side help verbiage</li>\n<li>Fixed reply height CSS</li>\n<li>Fixed password converter</li>\n<li>Fixed child post trash and delete functions</li>\n</ul>\n<h4>2.1.1</h4>\n<ul>\n<li>Fixed Invision, phpBB, and vBulletin importers</li>\n<li>Fixed private/hidden forum bugs</li>\n<li>Fixed topic split meta values</li>\n<li>Fixed theme compatibility logic error</li>\n<li>Fixed role mask issues for shared user installs</li>\n<li>Fixed missing function cruft</li>\n<li>Fixed missing filter on displayed user fields</li>\n</ul>\n<h4>2.1</h4>\n<ul>\n<li>WordPress 3.4 compatibility</li>\n<li>Deprecate $bbp global, use bbpress() singleton</li>\n<li>Private forums now visible to registered users</li>\n<li>Updated forum converter</li>\n<li>Topic and reply edits now ran through Akismet</li>\n<li>Fixed Akismet edit bug</li>\n<li>Fixed Widgets nooping globals</li>\n<li>Fixed translation load order</li>\n<li>Fixed user-edit bugs</li>\n<li>Fixed settings screen regressions</li>\n<li>Improved post cache invalidation</li>\n<li>Improved admin-side nonce checks</li>\n<li>Improved admin settings API</li>\n<li>Improved bbPress 1.1 converter</li>\n<li>Improved BuddyPress integration</li>\n<li>Improved Theme-Compatibility</li>\n<li>Improved template coverage</li>\n<li>Improved query performance</li>\n<li>Improved breadcrumb behavior</li>\n<li>Improved multisite integration</li>\n<li>Improved code clarity</li>\n<li>Improved RTL styling</li>\n<li>Added 2x menu icons for HiDPI displays</li>\n<li>Added fancy editor support</li>\n<li>Added fallback theme picker</li>\n<li>Added tools for importing, resetting, and removing</li>\n</ul>\n<h4>2.0</h4>\n<ul>\n<li>Released on September 21, 2011</li>\n</ul>\n<h4>2.0-rc-5</h4>\n<ul>\n<li>Fixed Genesis incompatibilities</li>\n<li>Fixed BuddyPress activity stream issues</li>\n<li>Fixed Subscription email sending issues</li>\n<li>Fixed Theme Compat display issues for some themes</li>\n<li>Improved Theme Compat class</li>\n<li>More future proofing internal API&#8217;s</li>\n</ul>\n<h4>2.0-rc-4</h4>\n<ul>\n<li>BuddyPress @mention integration</li>\n<li>Improved Akismet user agent handling</li>\n<li>Added blacklist_keys support</li>\n<li>Fixed spam/deleted user handling</li>\n<li>Updated green admin color scheme for WordPress 3.2</li>\n<li>Added actions to topic/reply forms</li>\n<li>Improved support for future ajaxification</li>\n</ul>\n<h4>2.0-rc-3</h4>\n<ul>\n<li>Fixed activation/deactivation</li>\n<li>Added Forum Participant role for multisite use</li>\n</ul>\n<h4>2.0-rc-2</h4>\n<ul>\n<li>BuddyPress activity action integration</li>\n<li>Multisite integration</li>\n<li>Fixed a bushel of bugs</li>\n<li>Fixed tag pagination again</li>\n<li>Fixed ajax priority loading</li>\n</ul>\n<h4>2.0-rc-1</h4>\n<ul>\n<li>Fixed tag pagination</li>\n<li>Broke tag pagination</li>\n<li>Squashed a bunch of bugs</li>\n</ul>\n<h4>2.0-beta-3b</h4>\n<ul>\n<li>Fix regression in forum index theme compatibility template</li>\n<li>Audit usage of get strings for moderator level and above users</li>\n</ul>\n<h4>2.0-beta-3</h4>\n<ul>\n<li>Akismet integration</li>\n<li>Fixes replies within wp-admin</li>\n<li>Fixes reply notification links</li>\n<li>Fixes inconsistent breadcrumb behavior</li>\n<li>Fixes theme compatibility issues</li>\n<li>Fixes archive and page conflicts</li>\n<li>Improvements to unpretty permalink support</li>\n<li>Improvements to importer</li>\n<li>Improvements to multisite support</li>\n<li>Normalize theme, shortcodes, and template parts</li>\n<li>Add humans.txt</li>\n<li>Add empty index.php files to prevent snooping</li>\n<li>Add max length to topic titles (default 80 chars)</li>\n</ul>\n<h4>2.0-beta-2</h4>\n<ul>\n<li>GlotPress integration</li>\n<li>Fixes Forum archive bug</li>\n<li>Fixes and improvements to importer</li>\n<li>Adds home link support to breadcrumb</li>\n<li>Improvements to Theme Compatibility</li>\n<li>Numerous template and CSS improvements</li>\n<li>RTL support</li>\n<li>Improved multisite support</li>\n<li>Add filters for future anti-spam support</li>\n<li>Add missing breadcrumbs to various template files</li>\n<li>Topic/reply trash fixes</li>\n</ul>\n<h4>2.0-beta-1</h4>\n<ul>\n<li>In development</li>\n</ul>\n\";s:11:\"screenshots\";s:1136:\"<ol><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-1.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-1.png?rev=872931\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-2.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-2.png?rev=872931\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-3.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-3.png?rev=872931\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-4.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-4.png?rev=872931\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-5.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-5.png?rev=872931\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-6.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-6.png?rev=872931\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-7.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-7.png?rev=872931\" alt=\"\"></a></li></ol>\";}s:13:\"download_link\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.14.zip\";s:11:\"screenshots\";a:7:{i:1;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-1.png?rev=872931\";s:7:\"caption\";s:0:\"\";}i:2;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-2.png?rev=872931\";s:7:\"caption\";s:0:\"\";}i:3;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-3.png?rev=872931\";s:7:\"caption\";s:0:\"\";}i:4;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-4.png?rev=872931\";s:7:\"caption\";s:0:\"\";}i:5;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-5.png?rev=872931\";s:7:\"caption\";s:0:\"\";}i:6;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-6.png?rev=872931\";s:7:\"caption\";s:0:\"\";}i:7;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-7.png?rev=872931\";s:7:\"caption\";s:0:\"\";}}s:4:\"tags\";a:5:{s:7:\"akismet\";s:7:\"akismet\";s:10:\"discussion\";s:10:\"discussion\";s:6:\"forums\";s:6:\"forums\";s:7:\"support\";s:7:\"support\";s:5:\"theme\";s:5:\"theme\";}s:8:\"versions\";a:55:{s:3:\"2.0\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.0.zip\";s:10:\"2.0-beta-1\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-1.zip\";s:11:\"2.0-beta-2b\";s:62:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-2b.zip\";s:10:\"2.0-beta-3\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-3.zip\";s:11:\"2.0-beta-3b\";s:62:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-3b.zip\";s:8:\"2.0-rc-2\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-2.zip\";s:8:\"2.0-rc-3\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-3.zip\";s:8:\"2.0-rc-4\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-4.zip\";s:8:\"2.0-rc-5\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-5.zip\";s:5:\"2.0.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.0.1.zip\";s:5:\"2.0.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.0.2.zip\";s:5:\"2.0.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.0.3.zip\";s:3:\"2.1\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.1.zip\";s:10:\"2.1-beta-1\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.1-beta-1.zip\";s:7:\"2.1-rc1\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc1.zip\";s:7:\"2.1-rc2\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc2.zip\";s:7:\"2.1-rc3\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc3.zip\";s:7:\"2.1-rc4\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc4.zip\";s:5:\"2.1.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.1.1.zip\";s:5:\"2.1.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.1.2.zip\";s:5:\"2.1.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.1.3.zip\";s:3:\"2.2\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.2.zip\";s:5:\"2.2.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.1.zip\";s:5:\"2.2.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.2.zip\";s:5:\"2.2.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.3.zip\";s:5:\"2.2.4\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.4.zip\";s:3:\"2.3\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.3.zip\";s:9:\"2.3-beta1\";s:60:\"https://downloads.wordpress.org/plugin/bbpress.2.3-beta1.zip\";s:5:\"2.3.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.3.1.zip\";s:5:\"2.3.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.3.2.zip\";s:3:\"2.4\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.4.zip\";s:5:\"2.4.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.4.1.zip\";s:3:\"2.5\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.5.zip\";s:5:\"2.5.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.1.zip\";s:6:\"2.5.10\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.10.zip\";s:6:\"2.5.11\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.11.zip\";s:6:\"2.5.12\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.12.zip\";s:6:\"2.5.13\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.13.zip\";s:6:\"2.5.14\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.14.zip\";s:5:\"2.5.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.2.zip\";s:5:\"2.5.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.3.zip\";s:5:\"2.5.4\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.4.zip\";s:5:\"2.5.5\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.5.zip\";s:5:\"2.5.6\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.6.zip\";s:5:\"2.5.7\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.7.zip\";s:5:\"2.5.8\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.8.zip\";s:5:\"2.5.9\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.9.zip\";s:10:\"2.6-beta-1\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.6-beta-1.zip\";s:10:\"2.6-beta-2\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.6-beta-2.zip\";s:8:\"2.6-rc-1\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-1.zip\";s:8:\"2.6-rc-3\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-3.zip\";s:8:\"2.6-rc-5\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-5.zip\";s:8:\"2.6-rc-6\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-6.zip\";s:8:\"2.6-rc-7\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-7.zip\";s:5:\"trunk\";s:50:\"https://downloads.wordpress.org/plugin/bbpress.zip\";}s:11:\"donate_link\";s:0:\"\";s:12:\"contributors\";a:0:{}}s:19:\"the-events-calendar\";a:25:{s:4:\"name\";s:19:\"The Events Calendar\";s:4:\"slug\";s:19:\"the-events-calendar\";s:7:\"version\";s:5:\"4.7.1\";s:6:\"author\";s:51:\"<a href=\"http://m.tri.be/1x\">Modern Tribe, Inc.</a>\";s:14:\"author_profile\";s:42:\"https://profiles.wordpress.org/moderntribe\";s:8:\"requires\";s:3:\"4.5\";s:6:\"tested\";s:3:\"5.0\";s:12:\"requires_php\";s:5:\"5.2.4\";s:13:\"compatibility\";a:0:{}s:6:\"rating\";d:90;s:7:\"ratings\";a:5:{i:5;i:1291;i:4;i:88;i:3;i:54;i:2;i:40;i:1;i:130;}s:11:\"num_ratings\";i:1603;s:15:\"support_threads\";i:206;s:24:\"support_threads_resolved\";i:67;s:10:\"downloaded\";i:14241967;s:12:\"last_updated\";s:21:\"2018-12-05 6:11pm GMT\";s:5:\"added\";s:10:\"2010-01-19\";s:8:\"homepage\";s:0:\"\";s:8:\"sections\";a:5:{s:11:\"description\";s:10200:\"<p>Create an events calendar and manage it with ease. The Events Calendar plugin provides professional-level quality and features backed by a team you can trust.</p>\n<p>Packed with loads of useful features, The Events Calendar by Modern Tribe is ready to go right out of the box. It’s extensible, easy to use, and completely customizable.</p>\n<p>Just getting started? Read through the <a href=\"http://m.tri.be/2d\" rel=\"nofollow\">New User Primer</a> to get set up.</p>\n<p>Looking for additional functionality including recurring events, ticket sales, publicly submitted events, automatic imports, and more?</p>\n<p><strong>Check out <a href=\"http://m.tri.be/mj\" rel=\"nofollow\">Events Calendar PRO</a> and <a href=\"http://m.tri.be/2a\" rel=\"nofollow\">other add-ons</a></strong></p>\n<blockquote>\n<p><strong>New Import Tool!</strong><br />\n  We’ve made bulk event imports easier to manage than ever. This add-on service for The Events Calendar allows you to import events from your favorite sources, including Meetup, Google Calendar, iCalendar, CSV, ICS and Other URLs (beta).<br />\n  <a href=\"http://m.tri.be/197u\" rel=\"nofollow\">Check out Event Aggregator now</a>.</p>\n</blockquote>\n<h4>Built solid &amp; supported</h4>\n<p>The Events Calendar is crafted the WordPress way with hours of strategy, design, development, and testing going into each release. We stand behind our work and offer light support weekly for the community via the WordPress.org support forums.</p>\n<p>If you need a deeper level of support or a faster response to your specific question, our Events Calendar PRO add-on includes access to our premium support forums with a 24-48 hour response time during the workweek.</p>\n<p>Enjoy using The Events Calendar, know how to customize it, and want to make money helping people? We’re growing our community team and would love to hear from you. If you’re interested, <a href=\"http://m.tri.be/mk\" rel=\"nofollow\">check this out!</a></p>\n<h4>Plug-n-play &amp; highly customizable</h4>\n<p>The Events Calendar is built to work out of the box. Just turn it on, configure the settings to match your needs and you&#8217;ll be making events in less than 5 minutes.</p>\n<p>By developers, for developers&#8230; it&#8217;s ready to be the foundation for your wildest hack sessions. Complete with a skeleton stylesheet to theme fast and efficiently, loads of tools including partial template overrides, a host of template tags, hooks and filters, <a href=\"http://m.tri.be/eu\" rel=\"nofollow\">careful documentation</a>, as well as a <a href=\"http://m.tri.be/ext\" rel=\"nofollow\">library of free extensions</a>. The Events Calendar is built FOR people who build websites.</p>\n<p>Whether your vision is big or small, you’re in good company. Hundreds of thousands of churches, eateries, small businesses, musicians, venues, and non-profits are publishing and promoting their events with The Events Calendar.</p>\n<p>The Events Calendar has been scaled to work on networks with over 25 million unique visitors per month and hundreds of thousands of events. Fortune 100 companies, major universities, government institutions, and some seriously epic startups showcase their events with our platform.</p>\n<h4>Features</h4>\n<p>Whether you’re operating a hyperlocal hub listing thousands of events, a university with many thousands of users, or you’re a sole business owner listing your classes, The Events Calendar has your back.</p>\n<ul>\n<li>Rapidly create events</li>\n<li>Saved venues &amp; organizers</li>\n<li>Calendar month view with tooltips</li>\n<li>Event List view</li>\n<li>Day view</li>\n<li>Event search</li>\n<li>Google maps</li>\n<li>Widget: Upcoming events list</li>\n<li>Events Taxonomies (Categories &amp; Tags)</li>\n<li>Google Calendar and iCal exporting</li>\n<li>WP REST API endpoints</li>\n<li>Completely ajaxified for super smooth browsing</li>\n<li>Completely responsive from mobile to tablet to desktop</li>\n<li>Tested on the major theme frameworks such as Avada, Genesis, Woo Themes, Thesis and many more.</li>\n<li>Increase your SEO with Microformats</li>\n<li>Internationalized &amp; translated</li>\n<li>Multiple stylesheets to improve integration</li>\n<li>Extensive template tags for customization</li>\n<li>Hooks &amp; filters galore</li>\n<li>Caching support</li>\n<li>Debug mode for developers</li>\n<li><a href=\"http://m.tri.be/1a0r\" rel=\"nofollow\">Library of extensions</a></li>\n</ul>\n<h4>Submitting Patches</h4>\n<p>If you’ve identified a bug and have a fix, we’d welcome it at our <a href=\"https://github.com/moderntribe/the-events-calendar\" rel=\"nofollow\">GitHub page for The Events Calendar</a>. Simply submit a pull request so we can review as part of our <a href=\"http://m.tri.be/release-schedule\" rel=\"nofollow\">release cycle</a> and merge into the codebase if appropriate from there. If a pull request is rejected, we&#8217;ll do our best to tell you why. Users whose pull requests are accepted will receive credit in the plugin&#8217;s changelog. For more information, check out the readme at our GitHub page. Happy coding!</p>\n<h3>Documentation</h3>\n<p>All of our online documentation can be found on <a href=\"http://m.tri.be/eu\" rel=\"nofollow\">our documentation site</a>.</p>\n<p>Some links you may find particularly useful are:</p>\n<ul>\n<li><a href=\"http://m.tri.be/2l\" rel=\"nofollow\">The Events Calendar New User Primer</a></li>\n<li><a href=\"http://m.tri.be/2m\" rel=\"nofollow\">The Themer&#8217;s Guide to The Events Calendar</a></li>\n<li><a href=\"http://m.tri.be/18wm\" rel=\"nofollow\">Knowledgebase</a></li>\n</ul>\n<p>If you have any questions about this plugin, you can post a thread in our <a href=\"https://wordpress.org/support/plugin/the-events-calendar\" rel=\"nofollow\">WordPress.org forum</a>. Please search existing threads before opening a new one.</p>\n<p>The <a href=\"http://m.tri.be/2r\" rel=\"nofollow\">Modern Tribe premium support forums</a> are available for you to read. You won&#8217;t, however, be able to post a message in any forums beyond Pre-Sale Questions unless you have purchased a premium license.</p>\n<h3>Add-Ons</h3>\n<p>But wait: there&#8217;s more! We&#8217;ve got a whole stable of plugins available to help you be awesome at what you do. Check out a full list of the products below, and over on <a href=\"http://m.tri.be/18wn\" rel=\"nofollow\">our website</a>.</p>\n<p>Our Free Plugins:</p>\n<ul>\n<li><a href=\"https://wordpress.org/plugins/event-tickets/\">Event Tickets</a></li>\n<li><a href=\"https://wordpress.org/plugins/advanced-post-manager/\">Advanced Post Manager</a></li>\n<li><a href=\"https://wordpress.org/plugins/gigpress/\">GigPress</a></li>\n<li><a href=\"https://wordpress.org/plugins/image-widget/\">Image Widget</a></li>\n</ul>\n<p>Our Premium Plugins and Services:</p>\n<ul>\n<li><a href=\"http://m.tri.be/18wi\" rel=\"nofollow\">Events Calendar PRO</a></li>\n<li><a href=\"http://m.tri.be/197u\" rel=\"nofollow\">Event Aggregator</a> (service)</li>\n<li><a href=\"http://m.tri.be/18wk\" rel=\"nofollow\">Event Tickets Plus</a></li>\n<li><a href=\"http://m.tri.be/2g\" rel=\"nofollow\">Community Events</a></li>\n<li><a href=\"http://m.tri.be/18wl\" rel=\"nofollow\">Community Tickets</a></li>\n<li><a href=\"http://m.tri.be/fa\" rel=\"nofollow\">Filter Bar</a></li>\n<li><a href=\"http://m.tri.be/2e\" rel=\"nofollow\">Eventbrite Tickets</a></li>\n</ul>\n<h3>Help</h3>\n<p>Welcome to The Events Calendar, a full-featured events management system for WordPress. Thank you so much for using the labor of our love. We are Modern Tribe and we are here to help you be awesome.</p>\n<p>If you aren&#8217;t familiar with The Events Calendar, check out our <a href=\"http://m.tri.be/2p\" rel=\"nofollow\">new user primer</a>. It&#8217;ll introduce you to the basics of what the plugin has to offer and will have you creating events in no time. From there, the resources below &#8212; extensive template tag documentation, FAQs, video walkthroughs and more &#8212; will give you a leg up as you dig deeper.</p>\n<p>Additional resources available include:</p>\n<ul>\n<li><a href=\"https://theeventscalendar.com/release-schedule/\" rel=\"nofollow\">Release Schedule</a></li>\n<li><a href=\"https://theeventscalendar.com/known-issues/\" rel=\"nofollow\">Known Issues</a></li>\n<li><a href=\"http://m.tri.be/eu\" rel=\"nofollow\">Documentation</a></li>\n<li><a href=\"http://m.tri.be/2n\" rel=\"nofollow\">FAQ</a></li>\n<li><a href=\"http://m.tri.be/2t\" rel=\"nofollow\">Help Videos</a></li>\n<li><a href=\"http://m.tri.be/2u\" rel=\"nofollow\">Tutorials</a></li>\n<li><a href=\"http://m.tri.be/2v\" rel=\"nofollow\">Release Notes</a></li>\n<li><a href=\"http://m.tri.be/2r\" rel=\"nofollow\">Forums</a></li>\n</ul>\n<p>We hit the <a href=\"https://wordpress.org/support/plugin/the-events-calendar/\" rel=\"nofollow\">The Events Calendar forum here on WordPress.org</a> about once a week, assisting users with basic troubleshooting and identifying bugs that have been reported. (If you are looking for more active support, might we suggest buying a PRO license? Our team hits the <a href=\"http://m.tri.be/2r\" rel=\"nofollow\">Premium Forums</a> daily.)</p>\n<p>Some things to consider before posting on the forum:</p>\n<ul>\n<li>Look through existing threads before posting a new one and check that there isn&#8217;t already a discussion going on for your issue.</li>\n<li>Your issue will be solved more quickly if you run a few checks before making a support request. Deactivate your plugins one by one &#8211; if the issue is fixed by deactivating a plugin you know you&#8217;ve got a plugin conflict. To test your Theme, revert to the default Twenty Twelve Theme to see if you are still experiencing the problem. If not, your Theme is the issue. Please provide this information when making your support request.</li>\n<li>Sometimes, just resetting your permalinks can fix the issue. Visit Events -&gt; Settings -&gt; Permalinks, save your permalinks with a different option and then save with your preferred choice again. This can solve events-related problems and is worth a shot before creating a new thread.</li>\n</ul>\n<p>Still not happy? Shoot us an email to support@theeventscalendar.com or tweet to <a href=\"https://twitter.com/TheEventsCal\" rel=\"nofollow\">@TheEventsCal</a> and tell us why. We&#8217;ll do what we can to make it right.</p>\n\";s:12:\"installation\";s:999:\"<h4>Install &amp; Activate</h4>\n<p>Installing the plugin is easy. Just follow these steps:</p>\n<ol>\n<li>From the dashboard of your site, navigate to Plugins &#8211;&gt; Add New.</li>\n<li>Select the Upload option and hit &#8220;Choose File.&#8221;</li>\n<li>When the popup appears select the the-events-calendar-x.x.zip file from your desktop. (The &#8216;x.x&#8217; will change depending on the current version number).</li>\n<li>Follow the on-screen instructions and wait as the upload completes.</li>\n<li>When it&#8217;s finished, activate the plugin via the prompt. A message will show confirming activation was successful. A link to access the calendar directly on the frontend will be presented here as well.</li>\n</ol>\n<p>That&#8217;s it! Just configure your settings as you see fit, and you&#8217;re on your way to creating events in style. Need help getting things started? Check out our <a href=\"http://m.tri.be/2l\" rel=\"nofollow\">new user primer</a> for help with settings and features.</p>\n\";s:3:\"faq\";s:5576:\"\n<h4>Are there any troubleshooting steps you&#8217;d suggest I try that might resolve my issue before I post a new thread?</h4>\n<p>\n<p>First, make sure that you&#8217;re running the latest version of The Events Calendar (4.6 as of this release). If you&#8217;re running Events Calendar PRO it needs to match the version number of The Events Calendar. And if you&#8217;ve got any other add-ons, make sure those are current / running the latest code as well.</p>\n<p>The most common issues we see are either plugin or theme conflicts. You can test if a plugin or theme is conflicting by manually deactivating other plugins until just The Events Calendar is running on your site. If the issue persists from there, revert to the default Twenty Fourteen theme. If the issue is resolved after deactivating a specific plugin or your theme, you&#8217;ll know that is the source of the conflict.</p>\n<p>Note that we aren&#8217;t going to say &#8220;tough luck&#8221; if you identify a plugin/theme conflict. While we can&#8217;t guarantee 100% integration with any plugin or theme out there, we will do our best (and reach out the plugin/theme author as needed) to figure out a solution that benefits everyone.</p>\n</p>\n<h4>I&#8217;m still stuck. Where do I go to file a bug or ask a question?</h4>\n<p>\n<p>Users of the free The Events Calendar should post their questions in the plugin&#8217;s <a href=\"https://wordpress.org/support/plugin/the-events-calendar/\" rel=\"nofollow\">WordPress.org forum</a>, which we hit about once a week (usually on Wednesdays). Please make sure to read <a href=\"http://m.tri.be/19oc\" rel=\"nofollow\">our sticky post</a> providing an overview of the support we provide free users BEFORE posting. If you find you&#8217;re not getting support in as timely a fashion as you wish, you might want to consider purchasing a PRO license.</p>\n<p>If you&#8217;re already a PRO user, you&#8217;re entitled access to our more actively-monitored <a href=\"http://m.tri.be/2r\" rel=\"nofollow\">Events Calendar PRO forum</a> on our website. We can provide a deeper level of support here and hit these forums on a daily basis during the work week. Generally, except in times of increased support loads, we reply to all comments within 24-48 hours during the business week.</p>\n</p>\n<h4>Events Calendar PRO looks awesome! I&#8217;m sold! How can I get my hands on it?</h4>\n<p>\n<p>Events Calendar PRO can be purchased directly on <a href=\"http://m.tri.be/18wi\" rel=\"nofollow\">our website</a>. There are five (5) license types available, and all licenses include access to premium support, new feature releases, and regular maintenance updates.</p>\n</p>\n<h4>I&#8217;m interested in PRO or another add-on, but there are a few questions I&#8217;ve got before making the purchase. Can you help me get those addressed?</h4>\n<p>\n<p>Absolutely. If you&#8217;re not finding your questions answered on the product pages, hit up our <a href=\"http://m.tri.be/2w\" rel=\"nofollow\">pre-sales forum</a> on our site. You can save yourself some time by reviewing the threads first to verify if your question has already been asked. If it hasn&#8217;t, post a new thread as a guest. We&#8217;ll get you a reply as quickly as we can, so you can make an informed decision regarding purchase.</p>\n</p>\n<h4>What add-ons are available for The Events Calendar, and where can I read more about them?</h4>\n<p>\n<p>The following add-ons are available for The Events Calendar:</p>\n<ul>\n<li><a href=\"http://m.tri.be/18wi\" rel=\"nofollow\">Events Calendar PRO</a>, for adding premium calendar features like recurring events, advanced views, cool widgets, shortcodes, additional fields, and more!</li>\n<li><a href=\"http://m.tri.be/197u\" rel=\"nofollow\">Event Aggregator</a>, a service that effortlessly fills your calendar with events from Meetup, Google Calendar, iCalendar, Eventbrite, CSV, and ICS.</li>\n<li><a href=\"http://m.tri.be/18wj\" rel=\"nofollow\">Event Tickets</a> (free), which allows you to collect RSVPs to events. It can run alongside The Events Calendar or as a standalone plugin that adds RSVP functionality to WordPress posts and pages.</li>\n<li><a href=\"http://m.tri.be/18wk\" rel=\"nofollow\">Event Tickets Plus</a>, which allows you to sell tickets for your events using your favorite e-commerce platform.</li>\n<li><a href=\"http://m.tri.be/2g\" rel=\"nofollow\">Community Events</a>, for allowing frontend event submission from your readers.</li>\n<li><a href=\"http://m.tri.be/18wl\" rel=\"nofollow\">Community Tickets</a>, which allows event organizers to sell tickets to the events they submit via Community Events.</li>\n<li><a href=\"http://m.tri.be/fa\" rel=\"nofollow\">Filter Bar</a>, for adding advanced frontend filtering capabilities to your events calendar.</li>\n<li><a href=\"http://m.tri.be/2e\" rel=\"nofollow\">Eventbrite Tickets</a>, for selling tickets to your event directly through Eventbrite.</li>\n</ul>\n</p>\n<h4>I have a feature idea. What&#8217;s the best way to tell you about it?</h4>\n<p>\n<p>We&#8217;ve got a <a href=\"https://tribe.uservoice.com/forums/195723-feature-ideas\" rel=\"nofollow\">UserVoice page</a> where we&#8217;re actively watching for feature ideas from the community. Vote up existing feature requests or add your own, and help us shape the future of the products business in a way that best meets the community&#8217;s needs.</p>\n</p>\n<h4>I&#8217;ve still got questions. Where can I find answers?</h4>\n<p>\n<p>Check out our extensive <a href=\"http://m.tri.be/18wm\" rel=\"nofollow\">knowledgebase</a> for articles on using, tweaking, and troubleshooting our plugins.</p>\n</p>\n\n\";s:9:\"changelog\";s:124438:\"<h4>[4.7.1] 2018-12-05</h4>\n<ul>\n<li>Feature &#8211; Added additional caching to TEC REST API archives and the Post Repository event/venue/organizer responses [117159]</li>\n<li>Feature &#8211; Added new <code>tribe_events_set_month_view_events_from_cache</code> action to make it easier to listen for when Month View events are retrieved from the Month View cache [116124]</li>\n<li>Fix &#8211; Importing CSV files with whitespace at the beginning of the rows won&#8217;t remove headers and skip columns on Preview [117236]</li>\n<li>Fix &#8211; Prevent JavaScript error in Month View when the Date filter is removed from the Tribe Bar (thank you to @tyrann0us on GitHub for submitting this fix!) [116995]</li>\n<li>Fix &#8211; Facilitate automated updates for Events Calendar PRO even if it&#8217;s requirements have not been met</li>\n</ul>\n<h4>[4.7.0.1] 2018-11-30</h4>\n<ul>\n<li>Fix &#8211; Update common library to maximize compatibility with earlier PHP versions (our thanks to @megabit81 for highlighting this problem) [119073]</li>\n<li>Fix &#8211; Update common library to ensure better compatibility with addons running inside multisite networks [119044]</li>\n<li>Language &#8211; 0 new strings added, 141 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.7] 2018-11-29</h4>\n<ul>\n<li>Feature &#8211; added new setting to activate the block editor on events for users running the WordPress 5.0 beta.</li>\n<li>Feature &#8211; added an Event Date Time block to add and display the event date and time</li>\n<li>Feature &#8211; added an Event Price block to add and display the event price and optional event description</li>\n<li>Feature &#8211; added an Event Organizer block to add and display an organizer on an event single</li>\n<li>Feature &#8211; added an Event Venue block to add and display the event venue information including optional link or map</li>\n<li>Feature &#8211; added an Event Website block to add and display an external website link as a button with custom label</li>\n<li>Feature &#8211; added an Event Sharing block to display event export options and allow for more customization</li>\n<li>Feature &#8211; added an Event Details Classic block to maintain a combined content display as in the classic editor</li>\n<li>Feature &#8211; added a Featured Image block to display an event’s featured image in the editor content</li>\n<li>Feature &#8211; added a Tags block to display an event’s tags in the editor content</li>\n<li>Feature &#8211; added an Event Categories block to display an event’s categories in the editor content</li>\n<li>Feature &#8211; added a new Events Blocks section to the block inserter</li>\n<li>Tweak &#8211; Added filters: <code>tribe_blocks_editor_update_classic_content_params</code>, <code>tribe_blocks_editor_update_classic_content</code>, <code>tribe_events_editor_default_classic_template</code>, <code>tribe_events_editor_default_template</code>, <code>tribe_events_google_maps_api</code>, <code>tribe_events_editor_assets_should_enqueue_frontend</code>, <code>tribe_events_single_map_zoom_level</code>, <code>tribe_events_single_event_time_formatted</code>, <code>tribe_events_single_event_time_title</code>, <code>tribe_events_event_block_datetime_use_yearless_format</code>, <code>tribe_get_event_website_link_target</code>, <code>tribe_events_single_event_time_formatted</code>, <code>tribe_events_single_event_time_title</code></li>\n<li>Tweak &#8211; Added actions: <code>tribe_blocks_editor_flag_post_classic_editor</code>, <code>tribe_events_editor_register_blocks</code>, <code>tribe_events_single_event_meta_primary_section_start</code>, <code>tribe_events_single_event_meta_primary_section_end</code>, <code>tribe_events_single_event_meta_secondary_section_start</code>, <code>tribe_events_single_event_meta_secondary_section_end</code>, <code>tribe_events_single_meta_details_section_start</code>, <code>tribe_events_single_meta_details_section_end</code>, <code>tribe_events_single_meta_map_section_start</code>, <code>tribe_events_single_meta_map_section_end</code>, <code>tribe_events_single_meta_organizer_section_start</code>, <code>tribe_events_single_meta_organizer_section_end</code>, <code>tribe_events_single_meta_venue_section_start</code>, <code>tribe_events_single_meta_venue_section_end</code></li>\n<li>Tweak &#8211; Changed views: <code>blocks/classic-event-details</code>, <code>blocks/event-category</code>, <code>blocks/event-datetime</code>, <code>blocks/event-links</code>, <code>blocks/event-organizer</code>, <code>blocks/event-price</code>, <code>blocks/event-tags</code>, <code>blocks/event-venue</code>, <code>blocks/event-website</code>, <code>blocks/featured-image</code>, <code>blocks/parts/details</code>, <code>blocks/parts/map</code>, <code>blocks/parts/organizer</code>, <code>blocks/parts/venue</code>, <code>silence</code>, <code>single-event-blocks</code>, <code>single-event</code>, <code>single-event/back-link</code>, <code>single-event/comments</code>, <code>single-event/content</code>, <code>single-event/footer</code>, <code>single-event/notices</code>, <code>single-event/title</code></li>\n<li>Language &#8211; 11 new strings added, 0 updated, 0 fuzzied, and 30 obsoleted</li>\n</ul>\n<h4>[4.6.26.1] 2018-11-21</h4>\n<ul>\n<li>Fix &#8211; Resolved a compatibility issue with WordPress version 4.7.11 and earlier (our thanks to @placer69 and @earthnutvt for flagging this) [118627]</li>\n</ul>\n<h4>[4.6.26] 2018-11-13</h4>\n<ul>\n<li>Fix &#8211; Fixed the setting-up of strings in the Tribe Bar datepicker to ensure they&#8217;re translatable into languages other than English [115286]</li>\n<li>Tweak &#8211; Improved the legibility of text in Featured Events that are in the Event List widget [116702]</li>\n<li>Tweak &#8211; Clarified a number of maps-related settings strings [114865]</li>\n</ul>\n<h4>[4.6.25] 2018-10-22</h4>\n<ul>\n<li>Fix &#8211; List only enabled views on the &#8220;Default View&#8221; option. Thanks to wescole, John Meuse and others for reporting! [114807]</li>\n<li>Fix &#8211; Handle left-over Facebook scheduled imports and notices [114831]</li>\n<li>Fix &#8211; Fixed event navigation when the mini calendar widget was on the event page. Props to Matt and wescole for flagging this [114359]</li>\n<li>Fix &#8211; Ensure columns without headers are handled in CSV imports [114199]</li>\n<li>Tweak &#8211; Added notice for the Events Gutenberg extension and eBook download [115543]</li>\n<li>Tweak &#8211; Avoid unnecessary HTTP calls in the Settings screens [114013]</li>\n<li>Tweak &#8211; Show only applicable refinements for the Eventbrite source types in Event Aggregator imports [107009]</li>\n<li>Tweak &#8211; Added <code>tribe_aggregator_resolve_geolocation</code> filter to allow for disabling of Geocoding using the EA service [114171]</li>\n<li>Tweak &#8211; Added <code>tribe_aggregator_clean_unsupported</code> filter to specify whether unsupported origin records should be removed or not</li>\n</ul>\n<h4>[4.6.24.1] 2018-10-08</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where a fatal error could be generated when trying to save a new Event Aggregator scheduled import [115339]</li>\n<li>Fix &#8211; Handle left-over Facebook scheduled imports and notices [114831]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_import_setting_origins</code> filter to the origins available for default import settings [115704]</li>\n</ul>\n<h4>[4.6.24] 2018-10-03</h4>\n<ul>\n<li>Fix &#8211; Prevent broken and low-resolution Google Maps if user has not provided a Google Maps API key of their own by providing our own fallback API key [114442]</li>\n<li>Fix &#8211; Only load widget assets when widget is active on the page [113141]</li>\n<li>Fix &#8211; Ensure that venue, organizer, and meta information doesn&#8217;t show on password-protected events [102643]</li>\n<li>Fix &#8211; Correct the Google Maps API link in the Settings help text to point to the correct API page [112322]</li>\n<li>Fix &#8211; Restores the event categories and tags creation summary in CSV imports [105888]</li>\n<li>Fix &#8211; Updated the Events Gutenberg extension install check to show only when the extension is not active [114577]</li>\n<li>Fix &#8211; Stop potential fatal errors from debug logging when running EA import actions from command line [114555]</li>\n<li>Fix &#8211; Fixed a bug where it was often not possible to un-check the &#8220;Enable JSON-LD&#8221; option in the Events List Widget (thanks to @myrunningresource and @craigwilcox for reporting this!) [113541]</li>\n<li>Fix &#8211; Ensure that the <code>tribe-events-bar-should-show</code> filter functions as aspected; if <code>__return_false</code> is passed, the Tribe Bar will be totally hidden (thanks @debranettles for reporting this!) [112260]</li>\n<li>Fix &#8211; Added checks to prevent JS Type Error in mobile view. Thanks szenenight, agrilife and others for flagging this! [113524]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_month_daily_events</code> filter to the Month view [114041]</li>\n<li>Tweak &#8211; Move Google Maps API loading to tribe_assets and only load once on single views when PRO is active, thanks to info2grow first reporting [112221]</li>\n<li>Tweak &#8211; Accept 0 as an argument in tribe_get_events() so that <code>\'post_parent\' =&gt; 0</code> works, thanks Cy for the detailed report [111518]</li>\n<li>Fix &#8211; handle left-over Facebook scheduled imports and notices [114831]</li>\n<li>Tweak &#8211; Added new filters for customizing the fallback Google Maps embeds: <code>tribe_is_using_basic_gmaps_api</code>, <code>tribe_get_basic_gmap_embed_url</code>, and <code>tribe_get_basic_gmap_embed_url_args</code> [114442]</li>\n<li>Tweak &#8211; Fixed the handling of the global $post variable in some Month View templates to make it easier for themers to customize those templates [113283]</li>\n<li>Tweak &#8211; Ensure linked posts are listed alphabetically in metabox dropdowns, as they are in all other admin locations [108120]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_month_daily_events</code> filter to the Month view [114041]</li>\n<li>Tweak &#8211; Move Google Maps API loading to tribe_assets and only load once on single views when PRO is active, thanks to info2grow first reporting [112221]</li>\n<li>Tweak &#8211; Accept 0 as an argument in tribe_get_events() so that <code>\'post_parent\' =&gt; 0</code> works, thanks Cy for the detailed report [111518]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_record_by_origin</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_service_post_import_args</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_import_validate_meta_by_origin</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_aggregator_refine_keyword_exclusions</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_aggregator_refine_location_exclusions</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_event_translate_service_data_field_map</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_event_translate_service_data_venue_field_map</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_event_translate_service_data_organizer_field_map</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_status_third_party</code> action to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_aggregator_import_form</code> action to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added <code>$origin_show_map_options</code> parameter to the <code>tribe_aggregator_fields</code> filter to allow new EA origins to make use of them [114652]</li>\n<li>Fix &#8211; Fixed an issue where a fatal error could be generated when trying to save a new Event Aggregator scheduled import [115339]</li>\n</ul>\n<h4>[4.6.23] 2018-09-12</h4>\n<ul>\n<li>Fix &#8211; Fixed the &#8220;Full Styles&#8221; mobile view. Thanks Matthew, Laura and others for flagging this! [112301]</li>\n<li>Fix &#8211; Modify resource url function to work in mu-plugin directory, thanks to Doug for reporting it  [86104]</li>\n<li>Fix &#8211; Remove references to and settings for Facebook importing in Event Aggregator [112432]</li>\n<li>Fix &#8211; Ensure Event Aggregator allows for importing events from Eventbrite sites other than eventbrite.com, including but not limited to eventbrite.ca, .co.uk, and .co.nz [107821]</li>\n<li>Fix &#8211; Allow venue location fields to be intentionally empty on Venue Singular REST API calls [108834]</li>\n<li>Tweak &#8211; Add the WordPress Custom Fields Metabox show|hide settings from the Events Calendar Pro [109815]</li>\n<li>Tweak &#8211; Allow changing Event Aggregator import process system between the asynchronous and the cron-based one; previously only available as a filter [113418, 113475]</li>\n<li>Tweak &#8211; Allow stopping and clearing asynchronous queue processes from the admin UI [113418, 113475]</li>\n<li>Deprecated &#8211; <code>Tribe__Events__Aggregator__Record__Facebook</code></li>\n</ul>\n<h4>[4.6.22.1] 2018-08-27</h4>\n<ul>\n<li>Fix &#8211; Allow user to choose venues not created by them. Props to @integrity, @nomadadmin, and many others for reporting this! [113147]</li>\n</ul>\n<h4>[4.6.22] 2018-08-22</h4>\n<ul>\n<li>Add &#8211; Allow filtering events, in REST API requests, by their post ID with <code>include</code> [94326]</li>\n<li>Add &#8211; Enable future event display to get all events in the future that have not started [70769]</li>\n<li>Add &#8211; Allow filtering events, in REST API requests, by their post ID with <code>include</code> [94326]</li>\n<li>Add &#8211; Enable future event display to get all events in the future that have not started [70769]</li>\n<li>Fix &#8211; Prevent subsequent CSV imports from duplicating events in some instances [102745]</li>\n<li>Fix &#8211; The &#8220;Import events but preserve local changes to event fields&#8221; Event Aggregator change authority setting will now behave as expected [87443]</li>\n<li>Fix &#8211; Multiple fixes regarding linked post types (e.g. Organizers and custom post types) &#8211; props to @natureslens and others for reporting these [105116]:\n<ul>\n<li>Now correctly saves in their drag-and-drop order</li>\n<li>Deprecated the functions added in version 4.6.13 that previously attempted to fix ordering logic but was not done in a backwards-compatible way: <code>get_order_meta_key()</code> and <code>tribe_sanitize_organizers()</code></li>\n<li>We no longer rely on a separate postmeta value dedicated to ordering linked posts (e.g. <code>_EventOrganizerID_Order</code>), and you may want to remove all such values from your database after re-saving any events that have linked posts and their ordering is important</li>\n<li><code>tribe_get_linked_posts_by_post_type()</code> now works as expected, no longer returning zero results in error, nor returning all of the post type&#8217;s posts if there are none linked. The <code>tribe_events_return_all_linked_posts_if_none</code> filter was added, as it is necessary for this fix.</li>\n<li>Editing an existing event no longer loses the linked posts just because they were not part of the submission. Example of the bug in prior versions: If organizers are editable in the wp-admin event edit screen but not on the Community Events &#8220;event edit&#8221; form (via template override or other custom code), all pre-existing organizers were removed in error.</li>\n</ul>\n</li>\n<li>Fix &#8211; Handle the case where Event Aggregator import queues might get stuck when deleting import records [111856]</li>\n<li>Fix &#8211; Only show admin notice when it is a top-level page with the event slug, thanks to MikeNGarrett for the code fix! [111186]</li>\n<li>Fix &#8211; Change template_redirect to an action for some legacy view redirects, thanks barryceelen! [110463]</li>\n<li>Fix &#8211; Correctly import and set Organizers for iCal and ICS files Event Aggregator imports [96059]</li>\n<li>Fix &#8211; Retain category title in month view and month view shortcode, thanks corthoover for the first report [108258]</li>\n<li>Fix &#8211; The &#8220;Import events but preserve local changes to event fields&#8221; Event Aggregator change authority setting will now behave as expected [87443]</li>\n<li>Fix &#8211; Handle the case where Event Aggregator import queues might get stuck when deleting import records [111856]</li>\n<li>Fix &#8211; Prevent subsequent CSV imports from duplicating events in some instances [102745]</li>\n<li>Fix &#8211; Fix the classic header option not working. Thanks @hanemac, David Luyendyk and others for flagging this! [111672]</li>\n<li>Tweak &#8211; Namespace javascript debug function to prevent conflicts causing a function found, thanks to Tom-Mulvey for the fix [110462]</li>\n<li>Tweak &#8211; Add venue name to address string for iCal and gCal export, thanks for the coding from sylviavanos [110464]</li>\n<li>Tweak &#8211;  Drop the order from the query WPML linked query as it is set later in the method, thanks to dgwatkins for the PR [110459]</li>\n<li>Tweak &#8211; Display JS debug messages only if setting is set or through the <code>tribe_events_js_debug</code> filter. Thanks to Rob, @aand and others for flagging this! [82781]</li>\n</ul>\n<h4>[4.6.21] 2018-08-01</h4>\n<ul>\n<li>Add &#8211; Make global $post obj available to tribe_events_get_the_excerpt() with setup_postdata($post) [108043]</li>\n<li>Add &#8211; Added WPML metadata improvements for Organizers and Venue. Thanks to David Garcia Watkins and the entire WPML team for their contribution [106798]</li>\n<li>Fix &#8211; Ensure no console errors are being displayed if there&#8217;s no Google Maps API key present. Thanks Greg for flagging this [95312]</li>\n<li>Fix &#8211; Fixed an issue where saving Event Aggregator scheduled imports with an empty preview would generate PHP notices [110311]</li>\n<li>Fix &#8211; Escape each closing html element in month view tooltip to prevent PHP parser from exposing html, thanks to Karen for a solution [64834]</li>\n<li>Fix &#8211; Sending empty &#8216;categories&#8217; and &#8216;tags&#8217; for the REST API event endpoints when inserting and updating events [109627]</li>\n<li>Fix &#8211; Prevent selection of past dates when setting up Scheduled Other URL Imports in Event Aggregator [111227]</li>\n<li>Tweak &#8211; Manage plugin assets via <code>tribe_assets()</code> [40267]</li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Abstract_Asset in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Abstract_Events_Css in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Admin_Menu in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Admin_Ui in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Admin in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Ajax_Calendar in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Ajax_Dayview in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Ajax_List in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Bootstrap_Datepicker in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Calendar_Script in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Chosen in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Datepicker in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Dialog in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Dynamic in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Ecp_Plugins in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Events_Css_Default in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Events_Css_Full in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Events_Css_Skeleton in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Events_Css in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Factory in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Jquery_Placeholder in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Jquery_Resize in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__PHP_Date_Formatter in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Settings in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Smoothness in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Tribe_Events_Bar in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Tribe_Select2 in favor of using <code>tribe_asset</code></li>\n</ul>\n<h4>[4.6.20.1] 2018-07-10</h4>\n<ul>\n<li>Fix &#8211; Fix an issue where Event Aggregator imports might get blocked at 1% progress [110258]</li>\n<li>Fix &#8211; Fix the error displayed when navigating the month view via shortcode. Thanks Lam, @ltcalendar, Disk and others for flagging this! [109589]</li>\n</ul>\n<h4>[4.6.20] 2018-07-09</h4>\n<ul>\n<li>Feature &#8211; Add featured event column support for CLI imports [108027]</li>\n<li>Fix &#8211; Display the exact search term in the &#8220;no results&#8221; notice on the events page [106991]</li>\n<li>Fix &#8211; Allow venue and organizer fields to be intentionally empty on Event Singular REST API calls [109482]</li>\n<li>Fix &#8211; Added basic checks to prevent saving obviously-invalid event meta values, such as sending <code>EventStartMinute</code> of <code>60</code> (since it should be 0-59) to <code>tribe_create_event()</code>. This prevents falling back to &#8220;zero&#8221; values (e.g. Unix Epoch) when another value was intended. Thanks to @compton-bob for flagging this via our Help Desk. [109722]</li>\n<li>Fix &#8211; Add Privacy Policy guide for The Events Calendar [108454]</li>\n<li>Tweak &#8211; Added event ID parameter to <code>tribe_events_event_classes</code> filter to make it more useful [64807]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_record_finalized</code> action to allow developers to act before Event Aggregator imports start [109938]</li>\n</ul>\n<h4>[4.6.19] 2018-06-20</h4>\n<ul>\n<li>Feature &#8211; CSV importer now supports a featured event column [72376]</li>\n<li>Add &#8211; Add Eventbrite Icon to Third Party Accounts on the help page [105388]</li>\n<li>Add &#8211; Accessibility repair: new title-bar template for loop views included above the filter bar and content containing the page title in a <code>h1</code> tag.</li>\n<li>Fix &#8211; Accessibility repair: adjust main content container element from <code>div</code> to <code>main</code>.</li>\n<li>Fix &#8211; More robust handling of errors and exceptions during Event Aggregator imports [107929]</li>\n<li>Fix &#8211; Ensure that the &#8220;Export Events&#8221; button is properly displayed in month view when paginating. Thanks to @linpleva, Steven, Will and others for flagging this! [104751]</li>\n<li>Fix &#8211; Month view pagination for datepicker formats: YYYY.MM.DD, MM.DD.YYYY, and DD.MM.YYYY. Thanks @netzwerk, @wdburgdorf, @oliverwick and others for notifying us! [105443]</li>\n<li>Fix &#8211; Resolved customizer inconsistencies with month/week views and full styles [69758]</li>\n<li>Fix &#8211; Check the Events Aggregator license each time the page is accessed [67864]</li>\n<li>Fix &#8211; Improve Event Import message responses from Event Aggregator for certain cases where &#8220;Unknown service message&#8221; would be returned [107606]</li>\n<li>Fix &#8211; Make the date picker respect the &#8220;Start of the week&#8221; Setting. Thanks to @websource, @dsb and others for flagging this! [76320]</li>\n<li>Fix &#8211; Correct the &#8220;View All&#8221; link when using the events month view and plain permalinks. props to Kay and Robert for notifying us [72544]</li>\n<li>Fix &#8211; Keep filter bar date when changing from month to list view, with all datepicker formats. Thanks to Caio for reporting this! [83018]</li>\n<li>Fix &#8211; Correct the pagination in list view when a keyword is being searched. Thanks to @versi, @akr and Mary for reporting this! [94613]</li>\n<li>Fix &#8211; Split linked posts (Organizers and Venues) by ownership, for all users [71349]</li>\n<li>Fix &#8211; The connected status for Eventbrite under Third Party Accounts on the Help page [106868]</li>\n<li>Fix &#8211; Fixed two PHP 5.2 errors on the Events &gt; Help page [108338]</li>\n<li>Fix &#8211; Display the correct Import Settings when Eventbrite Tickets is enabled [106947]</li>\n<li>Tweak &#8211; Modify the default values for the CSV settings if there&#8217;s no EA license [94426]</li>\n<li>Tweak &#8211; Added classes to meta output in Single Event meta templates to facilitate customization [62704]</li>\n<li>Tweak &#8211; Add the <code>tribe_aggregator_async_insert_event</code> filter to allow overriding the Event Aggregator asynchronous event insertion [107929]</li>\n<li>Tweak &#8211; Add the <code>\'tribe_aggregator_async_import_event_task</code> filter to allow overriding the Event Aggregator asynchronous import task [107929]</li>\n<li>Tweak &#8211; Added venue google map link to events in Day view [91610]</li>\n<li>Tweak &#8211; Renamed the Time zone mode option &#8220;Use the local time zones for each event&#8221; to &#8220;Use manual timezones for each event&#8221; (thanks @hikeitbaby for the suggestion) [67148]</li>\n<li>Tweak &#8211; Accessibility repair: heading hierarchy improvements throughout.</li>\n<li>Tweak &#8211; Accessibility repair: make sure all elements have unique <code>id</code> attributes.</li>\n<li>Tweak &#8211; Accessibility repair: remove redundant tab stops on feature image links.</li>\n<li>Tweak &#8211; Accessibility repair: filter bar view selector adjustments.</li>\n<li>Tweak &#8211; Accessibility repair: provide meaningful aria labels for filter bar inputs.</li>\n<li>Tweak &#8211; Accessibility repair: hide Google Map embeds from screen readers.</li>\n<li>Tweak &#8211; Enable only url imports for Eventbrite when that plugin is not active [107415]</li>\n<li>Tweak &#8211; The EB 4.5 migration process to better detect events for migration and insure all fields are migrated [106623]</li>\n<li>Tweak &#8211; Add <code>tribe_events_month_has_events_filtered</code> function and filter to see if there are events on a certain month, with filters (categories, search) [67607]</li>\n<li>Language &#8211; 68 new strings added, 406 updated, 3 fuzzied, and 37 obsoleted</li>\n</ul>\n<h4>[4.6.18] 2018-06-04</h4>\n<ul>\n<li>Add &#8211; Eventbrite to Event Aggregator import origins [61172]</li>\n<li>Add &#8211; Priority attribute to Import Setting fields to be able to customize order of fields [61173]</li>\n<li>Add &#8211; Default category and change authority for Eventbrite Imports [61173]</li>\n<li>Add &#8211; Ability to schedule Eventbrite imports through Event Aggregator [35454]</li>\n<li>Add &#8211; Preview for Eventbrite events in the import screen ordered from farthest future event to closest [70130]</li>\n<li>Add &#8211; Import Eventbrite events using the Other URL import origin [81825]</li>\n<li>Add &#8211; Ability to preview and import multiple Eventbrite events using the Organizer URL [94284]</li>\n<li>Add &#8211; Import from Eventbrite Location Search URL, i.e. https://www.eventbrite.com/d/or&#8211;portland/events/ [94588]</li>\n<li>Tweak &#8211; Move Eventbrite settings from Legacy Import to Settings Import Tab [94388]</li>\n<li>Tweak &#8211; Add Eventbrite imports to the Import History Tab [81826]</li>\n<li>Tweak &#8211; Remove Legacy Imports UI [81829]</li>\n</ul>\n<h4>[4.6.17] 2018-05-29</h4>\n<ul>\n<li>Tweak &#8211; Add tribe_redirected parameter to enable a visitor to select another view after default mobile redirect, thanks to Marcella for notifying us [102743]</li>\n<li>Fix &#8211; Hide any errors generated by servers that don&#8217;t support <code>set_time_limit()</code> (props to @jsww for flagging this!) [64183]</li>\n<li>Fix &#8211; Add a warning when the site Timezone is set to UTC [105217]</li>\n<li>Fix &#8211; An issue with organizers and venues not being attached to events on Eventbrite import  [106869]</li>\n<li>Language &#8211; 4 new strings added, 170 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.16] 2018-05-16</h4>\n<ul>\n<li>Tweak &#8211; Replaced the Aggregator queue processing system to run independently of WP Cron (not for CSV) [105650]</li>\n<li>Fix &#8211; Prevents notices for Events Community when handling State and Province fields [106415]</li>\n</ul>\n<h4>[4.6.15] 2018-05-09</h4>\n<ul>\n<li>Feature &#8211; Added wp-cli command to import events from a source with Event Aggregator. See <code>wp event-aggregator import-from --help</code> to know more [104426]</li>\n<li>Feature &#8211; Added wp-cli command to run scheduled imports with Event Aggregator. See <code>wp event-aggregator run-import --help</code> to know more [104426]</li>\n<li>Fix &#8211; Ensure that organizers can be deleted when an event has multiple organizers [103715]</li>\n<li>Fix &#8211; Fixed a bug where the <code>[tribe_events]</code> Month View pagination would fail when no Tribe Bar was visible and plain permalinks were being used [95720]</li>\n<li>Fix &#8211; Prevent <code>url_to_postid</code> from running when on the main events page to avoid query conflicts [94328]</li>\n<li>Fix &#8211; Prevent 404s and malformed URLs that would sometimes arise when navigating to a past-events view from the &#8220;All&#8221;-events view on a single recurring event [43925]</li>\n<li>Fix &#8211; Make the <code>[tribe_events]</code> shortcode&#8217;s output scroll to top when using the List View to match the non-shortcode List View  [81509]</li>\n<li>Fix &#8211; Ensure that default venue and address values are used throughout various venue-creation forms [63915]</li>\n<li>Tweak &#8211; Honor the return types for <code>tribe_has_next_event</code> and <code>tribe_has_previous_event</code> when the global query is null</li>\n<li>Language &#8211; 28 new strings added, 290 updated, 29 fuzzied, and 7 obsoleted</li>\n</ul>\n<h4>[4.6.14.1] 2018-04-18</h4>\n<ul>\n<li>Fix &#8211; Fixed fatal error that would sometimes arise when The Events Calendar was set to display on the front page</li>\n</ul>\n<h4>[4.6.14] 2018-04-18</h4>\n<ul>\n<li>Fix &#8211; Updated the &#8220;front page&#8221; logic to store the value in the DB instead of &#8220;mocking&#8221; the view via JS [100832]</li>\n<li>Fix &#8211; Fixed the generation of PHP warnings on retrieval of posts if the &#8220;Include events in main blog loop&#8221; option is checked (thanks to Colin Carmichael for reporting this problem) [97667]</li>\n<li>Fix &#8211; Made the <code>tribe-ea-record</code> custom post type (used to store Event Aggregator record information) private [99106]</li>\n<li>Fix &#8211; Expanded the size of the time zone input in the admin to allow for better visibility for long names [100363]</li>\n<li>Fix &#8211; If the main events page is set to be the site&#8217;s front page, ensure it shows as &#8220;selected&#8221; in the Customizer&#8217;s front page option [100832]</li>\n<li>Fix &#8211; Fixed an issue where failed Event Aggregator scheduled imports would re-attempt the import too soon [102489]</li>\n<li>Fix &#8211; Ensure the Tribe Bar displays all the available ranges of dates and times [100646]</li>\n<li>Fix &#8211; Hid the filters in the Tribe Bar if a unique view is enabled [75114]</li>\n<li>Fix &#8211; Fixed some imported-event handling so that events with no time and that aren&#8217;t all-day events do not display on the front-end [93979]</li>\n<li>Fix &#8211; Changed the HTTP status codes of empty event, venue, organizer, category, and tag archives from 404 to 200 and return empty arrays to stick with WP REST API standard [102283]</li>\n<li>Fix &#8211; Better &#8220;guessing&#8221; on column mapping during the import of CSV file (thanks to April in our Help Desk for flagging this problem!) [96162]</li>\n<li>Fix &#8211; Add new <code>tribe_events_linked_post_type_meta_key</code> filter, required to be set for each custom linked post type, to output custom linked post types in their drag-and-drop order (thanks @natureslens for highlighting the issue) [100733]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_find_matching_organizer</code> and <code>tribe_aggregator_find_matching_venue</code> filters in Events Aggregator to allow the definition of custom Venue and Organizer match criteria [97292]</li>\n<li>Tweak &#8211; Display the retry time for a failed Event Aggregator scheduled import in the Scheduled tab [102489]</li>\n<li>Tweak &#8211; Add new filter, <code>tribe_events_import_event_duplicate_matches</code>, to determine if an event is part of the duplicates matches [77956]</li>\n<li>Tweak &#8211; Ensure &#8220;secondary&#8221; maps, e.g. in the sidebar, have the same full-width behavior as &#8220;main&#8221; maps [74052]</li>\n<li>Tweak &#8211; Restore some missing header navigation elements [99742]</li>\n<li>Tweak &#8211; Add notice if an import is missing required columns [67886]</li>\n<li>Tweak &#8211; Save time zone and time zone abbreviation fields (if provided) even if date was not changed when saving event through API [102705]</li>\n</ul>\n<h4>[4.6.13] 2018-03-28</h4>\n<ul>\n<li>Feature &#8211; Added facilities allowing users to trash or permanently delete expired events [98826]</li>\n<li>Fix &#8211; Corrected the behavior of the previous/next event links rendered on single event pages (props to @jeremyfelt for fixing this) [101757]</li>\n<li>Fix &#8211; Save order of organizers as displayed in the admin (thanks to JobInfo and others for report) [79126]</li>\n<li>Tweak &#8211; Added Gutenberg compatibility for the Gutenberg Extension plugin</li>\n<li>Tweak &#8211; Added new filter <code>tribe_tickets_venue_action_links_edit_url</code> to modify the venue edit link for the sales and attendee reports [93923]</li>\n<li>Tweak &#8211; Altered day view to start at 00:00:00 and not 00:00:01 [99641]</li>\n</ul>\n<h4>[4.6.12] 2018-03-08</h4>\n<ul>\n<li>Fix &#8211; Resolved an oversight resulting in notice-level errors when the <code>tribe_event_is_on_date()</code> function was called incorrectly (props to @sharewisdom for pointing this out) [99117]</li>\n<li>Fix &#8211; Resolved errors within the admin environment when the &#8220;ticketed&#8221; view of events is generated [99266]</li>\n<li>Fix &#8211; Improved compatibility with WordPress SEO in relation to the default mobile events view [68716]</li>\n<li>Fix &#8211; Resolved Javascript errors in month view which were triggered under some conditions by the presence of password-protected events [99089]</li>\n<li>Fix &#8211; Improved logic responsible for identifying which events are expired (in the past) by using timezone-aware comparisons [91168]</li>\n<li>Fix &#8211; Corrected the export of upcoming events from single organizer pages (added to support changes in Events Calendar PRO) [70727]</li>\n<li>Tweak &#8211; Added safety checks around our use of the global $wp_query object (thanks @archetypalsxe for highlighting this issue!) [100199]</li>\n<li>Tweak &#8211; Renamed &#8216;Use Javascript to control date filtering&#8217; option to &#8216;Enable live refresh&#8217; and improved the associated helper text [98022]</li>\n<li>Tweak &#8211; Added caching to reduce the number of HTTP requests being made in relation to Event Aggregator within the admin environment [99486]</li>\n<li>Tweak &#8211; Improved performance by reducing the number of queries that run in single event pages (in relation to <code>tribe_get_prev_event_link()</code> and <code>tribe_get_next_event_link()</code> specifically) [94587]</li>\n<li>Tweak &#8211; Added pagination to single organizer and venue pages [97772]</li>\n<li>Tweak &#8211; Improved compatibility with the Twety Seventeen theme (ensuring the calendar is full-width if set to be the site&#8217;s homepage) [97977]</li>\n<li>Language &#8211; 3 new strings added, 161 updated, 1 fuzzied, and 2 obsoleted</li>\n</ul>\n<h4>[4.6.11.1] 2018-02-16</h4>\n<ul>\n<li>Fix &#8211; The render of the venue and organizer templates (thanks to Antonio and others for reporting this in our forums) [99550]</li>\n<li>Fix &#8211; Make sure events on calendar are not affected by DST changes [99537]</li>\n</ul>\n<h4>[4.6.11] 2018-02-14</h4>\n<ul>\n<li>Fix &#8211; Ensure parity of CSS styles between the default Month View and the embedded Month Views generated by Events Calendar PRO&#8217;s [tribe_events] shortcode (thanks @copoloff for reporting this bug!) [92329]</li>\n<li>Fix &#8211; If <code>tribe_ical_feed_calname</code>  is empty the property <code>X-WR-CALNAME</code> is not added to the .ics file [46620]</li>\n<li>Fix &#8211; Stopped modifications of the main query if is in a single post to allow custom variables don&#8217;t affect the page loading when using shortcode (our thanks to Joseph Reckley and others for highlighting this problem) [91787]</li>\n<li>Tweak &#8211; Fixed a handful of small CSS bugs in the mobile views of the Twenty Sixteen, Twenty Fifteen, and Twenty Fourteen themes [95693]</li>\n<li>Tweak &#8211; Added new hooks (<code>tribe_events_ical_before</code>, <code>tribe_events_ical_events_list_args</code> and <code>tribe_events_ical_events_list_query</code>) to allow further customization of the iCal feed [86227]</li>\n<li>Tweak &#8211; Added safeguards to reduce conflicts when lodash and underscore are used on the same site [92205]</li>\n<li>Language &#8211; 0 new strings added, 41 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.10.1] 2018-01-26</h4>\n<ul>\n<li>Fix &#8211; Make sure rewrite rule for <code>/events</code> is not hardcoded and is based on dynamic option field (thanks to @earnjam and others for flagging this problem) [98463]</li>\n</ul>\n<h4>[4.6.10] 2018-01-23</h4>\n<ul>\n<li>Fix &#8211; Allow The Events Calendar REST API to be disabled using the <code>tribe_events_rest_api_enabled</code> filter [97209]</li>\n<li>Fix &#8211; Remove the errant <code>div.tribe-events-single-section</code> on the single event view when there is no venue [97615]</li>\n<li>Fix &#8211; Make sure the date for past events is set to the current date not the end of the day of the current date [71936]</li>\n<li>Fix &#8211; Use <code>featured_color_scheme_custom</code> if present as mechanism to overwrite the default color scheme for highlight color [96821]</li>\n<li>Fix &#8211; Make sure the date for past events is set to the current date not the end of the day of the current date [71936]</li>\n<li>Tweak &#8211; Trigger an event <code>map-created.tribe</code> when a map is created to allow flexibility on customization [91984]</li>\n<li>Tweak &#8211; Add a link to the knowledge base about &#8216;Setting Up Your Google Maps API Key&#8217; [89761]</li>\n<li>Tweak &#8211; Add <code>the_title</code> filter to events called by <code>tribe_events_template_data</code> [38237]</li>\n<li>Tweak &#8211; Made the &#8220;events&#8221; and &#8220;event&#8221; slugs translatable by WPML and other multilingual plugins [95026]</li>\n<li>Tweak &#8211; Introduced the <code>tribe_events_query_force_local_tz</code> filter to allow for forcing non-UTC event start and end times in Tribe__Events__Query [92948]</li>\n<li>Tweak &#8211; Prevent empty or otherwise-invalid values for various date-format options in the Display settings [94725]</li>\n<li>Tweak &#8211; Brought day number headers in the Month View into compliance with WCAG 2.0 accessibility standards when using the &#8220;Tribe Events&#8221; stylesheet [68411]</li>\n<li>Tweak &#8211; Improved the alignment of the event cost on the single-event view (props to @canberraclimbersassociation for reporting this bug) [97208]</li>\n<li>Tweak &#8211; Added some more context to the labeling of the &#8220;Number of events per page&#8221; option (thanks to Todd H. for highlighting this label) [73659]</li>\n<li>Tweak &#8211; Improve performance on Event Admin List Count by removing JOIN and use cached results [63567]</li>\n<li>Tweak &#8211; Made the &#8220;/page/&#8221; component of some views&#8217; URL string translatable [40976]</li>\n<li>Tweak &#8211; Button &#8220;Merge Duplicates&#8221; is always visible from now on [75208]</li>\n<li>Tweak &#8211; Allow queries to explicitly include or exclude events that are nominally hidden from event listings [91254]</li>\n</ul>\n<h4>[4.6.9] 2018-01-10</h4>\n<ul>\n<li>Feature &#8211; Add new utility functions tribe_is_events_home and tribe_is_events_front_page similar to native WP is_home and is_front_page [42195]</li>\n<li>Fix &#8211; Avoid issues when importing multiple organizers that specify images [96354]</li>\n<li>Fix &#8211; Make sure latitude and longitude information from iCal feeds is used if available [96363]</li>\n<li>Fix &#8211; Fixed an issue that prevented EA from importing images attached to Facebook events [96393]</li>\n<li>Fix &#8211; Remove the duplicate filter call that was running twice for <code>tribe_rest_venue_data</code> [96090]</li>\n<li>Tweak &#8211; Added new <code>tribe_aggregator_import_event_image</code>, <code>tribe_aggregator_import_venue_image</code> and <code>tribe_aggregator_import_organizer_image</code> filter so that users can control whether, during EA imports, images should be attached to post or not [96393]</li>\n<li>Tweak &#8211; Made it possible to translate the iCal feed&#8217;s description field (props @gafderks) [96677]</li>\n<li>Tweak &#8211; Improved escaping of map IDs (props LucaPipolo) [96772]</li>\n<li>Tweak &#8211; Added new REST API endpoint that allows looking up organizers by slug instead of ID at the path <code>organizers/by-slug/{slug}/</code>, it has the same functionality as the endpoint <code>organizers/{ID}</code> [96088]</li>\n<li>Tweak &#8211; Added new REST API endpoint that allows looking up venues by slug instead of ID at the path <code>venues/by-slug/{slug}/</code>, it has the same functionality as the endpoint <code>venues/{ID}</code> [96088]</li>\n<li>Tweak &#8211; Added <code>slug</code> to the REST API responses for organizer and venue data [96088]</li>\n<li>Tweak &#8211; Added <code>slug</code> to the REST API parameters allowed to use when inserting or updating an organizer or event [96088]</li>\n<li>Tweak &#8211; Added action: <code>tribe_events_venue_save</code> [96069]</li>\n<li>Tweak &#8211; Added action: <code>tribe_events_organizer_save</code> [96069]</li>\n<li>Tweak &#8211; Added filter: <code>tribe_events_rest_venue_prepare_postarr</code> [96069]</li>\n<li>Tweak &#8211; Added filter: <code>tribe_events_rest_organizer_prepare_postarr</code> [96069]</li>\n<li>Tweak &#8211; Old <code>tribe_rest_venue_data</code> filter was passing the venue and the event two the second parameter because of the duplication. Now it has the second parameter as $venue, third parameter as $event if event ID was provided [96090]</li>\n<li>Language &#8211; 5 new strings added, 30 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.8] 2017-12-18</h4>\n<ul>\n<li>Fix &#8211; Preserve filter bar checkbox selections when changing views [66749]</li>\n<li>Fix &#8211; Fix radio filters so they are only included as values when switching views when checked [72954]</li>\n<li>Fix &#8211; Ensure the correct properties are set for list widget queries, to avoid problems when running alongside Events Calendar PRO (props @KZeni) [94105]</li>\n<li>Fix &#8211; Fixed some layout issues with the &#8220;Buy Now&#8221; button and stock labels on mobile list views [81115]</li>\n<li>Fix &#8211; Fixed issue where left- or right-aligned images at the bottom of event descriptions would overlap event meta on single-event pages [71134]</li>\n<li>Fix &#8211; Fixed issue where Google Maps Link would display in some situations even when there is no address information for which to generate a link. [94909]</li>\n<li>Fix &#8211; Corrected reference to a Select2 asset (our thanks to @pyxis630 for flagging this problem and props to @andrasguseo for the fix) [95348]</li>\n<li>Fix &#8211; Ensure that when start and end dates are passed to the REST API, all events within the date range are correctly retrieved (thanks @braffenberg and others for highlighting this issue!) [90005]</li>\n<li>Tweak &#8211; Added Google Maps API key to all Google Maps URLs when the key is available, allowing maps to load more reliably on some hosting environments (props to @sfdfortnight, @thor, and many others for reporting this!) [62910]</li>\n<li>Tweak &#8211; Adjusted CSS to improve the display of venue URLs/phone numbers (especially when Events Calendar PRO is also active) (our thanks to Mathew on the forums for flagging this issue) [69127]</li>\n<li>Tweak &#8211; Added new REST API endpoint that allows looking up events by slug instead of ID at the path <code>events/by-slug/{slug}/</code>, it has the same functionality as the endpoint <code>events/{ID}</code> [92825]</li>\n<li>Tweak &#8211; Added <code>slug</code> to the REST API responses for event data [92825]</li>\n<li>Tweak &#8211; Added <code>slug</code> to the REST API parameters allowed to use when inserting or updating an event [92825]</li>\n<li>Tweak &#8211; Added new <code>tribe_events_rest_use_inclusive_start_end_dates</code> filter so that users can make the REST API return events from a more literal date range [90005]</li>\n<li>Language &#8211; 3 new strings added, 68 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.7] 2017-12-07</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where EA imports might not correctly create venues for iCalendar imports (thanks @starweb and others for highlighting this issue) [94323]</li>\n<li>Fix &#8211; Fixed an issue where Month View wouldn&#8217;t render correctly in X Theme with the &#8220;Events template&#8221; option set to &#8220;Default Page Template&#8221; [92554]</li>\n<li>Fix &#8211; Fixed a WPML incompatibility issue where language could be switched to the wrong one (thanks @dgwatkins) [94732]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_x_theme_force_full_content()</code> filter to let users disable X Theme compatibility code [92554]</li>\n<li>Language &#8211; 0 new strings added, 2 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.6] 2017-11-21</h4>\n<ul>\n<li>Feature &#8211; Added Template class which adds a few layers of filtering to any template file included</li>\n<li>Tweak &#8211; Added clear warnings and errors to prevent and limit the import of iCalendar sources missing required fields [93600]</li>\n<li>Tweak &#8211; Included <code>tribe_callback_return</code> for static returns for Hooks</li>\n<li>Tweak &#8211; Improved Aggregator notices including error data on the responses [87326]</li>\n<li>Language &#8211; 4 new strings added, 79 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.5] 2017-11-16</h4>\n<ul>\n<li>Fix &#8211; Improved legacy URL redirect logic to prevent unwanted redirects (our thanks to wesleyanhq and Adam Schwartz for highlighting this issue) [86942]</li>\n<li>Fix &#8211; Modified tribe_get_template_part() to remove potential for multiple templates to be rendered in a single call [46630]</li>\n<li>Fix &#8211; Fixed an issue where Event Aggregator scheduled imports might remain stuck in pending status [90501, 92614, 91754]</li>\n<li>Fix &#8211; Removed code which was automatically populating various address fields with default values when creating a new venue from within the event editor [44732]</li>\n<li>Fix &#8211; Resolved some issues with the &#8220;Show Map&#8221; and &#8220;Show Map Link&#8221; options in CSV files not being reliably respected on import (props @joappf and many others for highlighting this issue) [82784]</li>\n<li>Fix &#8211; Added opportunities to override edit linked post links [89015]</li>\n<li>Fix &#8211; Fixed a bug where only some parts of event featured images were clickable in List Views (thanks @mattemkadia for highlighting this issue) [81392]</li>\n<li>Fix &#8211; Fixed the broken &#8216;Learn more&#8217; URL received after an unsuccessful &#8220;Other URL&#8221; import preview [92890]</li>\n<li>Fix &#8211; Fixed issue in list view navigation with backwards previous/next classes (thanks @secondtoughest) [36230]</li>\n<li>Fix &#8211; Fixed an issue where venues and organizers would not be correctly assigned to events in CSV imports with import statuses other than &#8220;Publish&#8221; [79680]</li>\n<li>Tweak &#8211; Remove net import scheduled notes for on domand imports [79079]</li>\n<li>Tweak &#8211; Allow for non-Latin characters to be used as the Events URL slug and the Single Event URL slug (thanks @daviddweb for originally reporting this) [61880]</li>\n<li>Tweak &#8211; Remove net import scheduled notes for on domand imports [79079]</li>\n<li>Tweak &#8211; Fixed some layout issues that would emerge with &#8220;Events URL Slug&#8221; option when &#8220;Plain&#8221; permalinks were enabled [92314]</li>\n<li>Tweak &#8211; Tweaked some language in Event Aggregator&#8217;s metabox on individual edit-event screens to reduce confusion around the impact of the Update Authority on CSV imports [77957]</li>\n<li>Tweak &#8211; Fix PHP 7.1 compatibility with Event Aggregator (props @BJP NEALE) [90002]</li>\n<li>Tweak &#8211; Added new filter: <code>tribe_events_force_filtered_ical_link</code>. This makes the &#8220;Export Events&#8221; URL more easily modifiable (thanks to @tdudley07 for highlighting this issue) [43908]</li>\n<li>Tweak &#8211; Made the &#8220;End of Day Cutoff&#8221; option better accommodate 24-hour and other time formats (thanks @festivalgeneral for bringing this issue to our attention!) [78621]</li>\n<li>Tweak &#8211; Made the options presented by the timezone selector filterable (via the newly added <code>tribe_events_timezone_choice</code> hook &#8211; our thanks to National University&#8217;s Marketing Department for this idea) [92909]</li>\n<li>Tweak &#8211; Improved integration with Twenty Seventeen &#8211; main events page now uses full height header when set to front page (thanks @uncovery for pointing this out) [89767]</li>\n<li>Tweak &#8211; Ensured REST API taxonomy endpoints are only registered in WordPress versions 4.7 and higher (thanks @dnaber-de for reporting this) [93227]</li>\n<li>Language &#8211; 1 new strings added, 132 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.6.4] 2017-11-09</h4>\n<ul>\n<li>Tweak &#8211; Timepicker is now part of Tribe Common, it was removed from The Events Calendar</li>\n<li>Tweak &#8211; Required changes to make the plugin compatible with version 4.6 of Event Tickets</li>\n<li>Language &#8211; 10 new strings added, 167 updated, 0 fuzzied, and 2 obsoleted</li>\n</ul>\n<h4>[4.6.3] 2017-11-02</h4>\n<ul>\n<li>Fix &#8211; Prevent JS error when adding a Pro widget in the WP Customizer screen [72127]</li>\n<li>Fix &#8211; Fixed issue where the value of an event&#8217;s &#8220;Show Google Maps Link&#8221; option would not properly affect the displaying of the link on List View (props: @etechnologie) [75547]</li>\n<li>Fix &#8211; Added some more specification to our jquery-ui-datepicker CSS to limit conflicts with other plugins and themes [90577]</li>\n<li>Fix &#8211; Improve shortcode pagination/view change url so it is reusable (props: @der.chef and others) [70021]</li>\n<li>Fix &#8211; Ensure the <code>tribe_json_ld_{type}_object</code> filter is available to make modifications of event, venue and organizer JSON LD data possible (thanks to Mathew for flagging this problem) [89801]</li>\n<li>Fix &#8211; Improved JSON LD output for events by outputting the correct UTC offset where required (our thanks to Nina and many others for flagging this issue) [78233]</li>\n<li>Tweak &#8211; Fixed some display issues for the event schedule details (props @mia-caro)</li>\n<li>Tweak &#8211; Improved the clarity of and amount of context for some linked post labels to make translation of those labels a little easier and more nuanced (props @hnacc and others) [88589]</li>\n<li>Tweak &#8211; Changed the order in which the list view &#8220;next events&#8221; link is assembled for better translatability (with thanks to @alelouya for highlighting this problem) [72097]</li>\n<li>Tweak &#8211; Adjusted linked posts selector HTML to improve compatibility with Batcache [92049]</li>\n<li>Tweak &#8211; Improved datepicker handling so an end date on or later than the start date can always be selected [89825]</li>\n<li>Language &#8211; 0 new strings added, 7 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.2] 2017-10-18</h4>\n<ul>\n<li>Fix &#8211; Restored functionality to the &#8220;currency position&#8221; options in Events Settings, and in the per-event cost settings (props @schola and many others!) [89918]</li>\n<li>Fix &#8211; Fixed issue in Month view with multi-month events not appearing on subsequent months (thanks @shinno.kei &amp; @schittly for helping isolate this) [89747]</li>\n<li>Fix &#8211; Made some changes to prevent Month View caching from breaking WPML support when in Month View (props: @mpike and many others!) [82286]</li>\n<li>Fix &#8211; Fixed start/end times being displayed in incorrect timezone in structured data (thanks @mtncreative &amp; @esosa) [42125]</li>\n<li>Fix &#8211; Fixed an issue that would cause a 404 error if the selected default view was not enabled (thanks @pruneau) [45612]</li>\n<li>Fix &#8211; Improved translatability by adding missing textdomains for a number of strings (props @pedro-mendonca) [91071]</li>\n<li>Fix &#8211; Removed unneeded escaping to ensure the organizer link displays as expected (pros @f4w-pwharton) [91074]</li>\n<li>Tweak &#8211; Improvements to the readme.txt file surrounding plugin requirements (thanks @ramiy) [90285]</li>\n<li>Tweak &#8211; Improve site identification in multisite installations using Event Aggregator to avoid throttling issues [90489]</li>\n<li>Tweak &#8211; Avoid notice level errors when a non-existent category archive is requested (our thanks to Charles Simmons for highlighting this) [90697]</li>\n<li>Tweak &#8211; Added a new filter <code>tribe_events_ical_single_event_links</code> to make customizing the iCal and gCal export links on single-event views easier [90705]</li>\n</ul>\n<h4>[4.6.1] 2017-10-04</h4>\n<ul>\n<li>Fix &#8211; Fixed &#8220;Next Events&#8221; and &#8220;Previous Events&#8221; navigation links in list views, which would sometimes make a category-filtered list view lose its category filter as a user navigated through pages of future or past events (props @forumhelpdesk and @atomicdust for reporting this!) [72013]</li>\n<li>Fix &#8211; Fixed some layout issues with the Tribe Bar datepicker that would arise when using a Twentysixteen or Twentyfifteen child them (thanks to @stefanrueegger for reporting this) [46471]</li>\n<li>Fix &#8211; Prevented modification of event titles within the loop when using TRIBE_MODIFY_GLOBAL_TITLE [89273]</li>\n<li>Fix &#8211; Fixed issue when exporting all-day multi-day events via iCal where the end date was one day early (Thank you @fairmont for reporting this!) [87775]</li>\n<li>Fix &#8211; Fixed issues with the jQuery Timepicker vendor script conflicting with other plugins&#8217; similar scripts (props: @hcny et al.) [74644]</li>\n<li>Fix &#8211; Fixed an issue that would prevent Event Aggregator scheduled imports from running [88395]</li>\n<li>Fix &#8211; Fixed the &#8220;Start Time&#8221; and &#8220;End Time&#8221; timepicker fields in the event-creation screen to make it impossible to have an end date/time that comes before the start date/time [72686]</li>\n<li>Tweak &#8211; Remove unnecessary parameters from some remove_action calls in the plugin (thanks to @JPry on GitHub for submitting this fix!) [88867]</li>\n<li>Tweak &#8211; Adjusted the EA cron start time so that it never gets created in the past [88965]</li>\n<li>Tweak &#8211; Improved options format in the Event Aggregator settings [88970]</li>\n<li>Tweak &#8211; Added a filter to CSV importer for altering the delimiter, escaping, and enclosing characters [70570]</li>\n<li>Tweak &#8211; Adjusted the <code>tribe_update_venue()</code> template tag so it no longer creates some unnecessary meta fields involving post_title, post_content, etc. (thanks @oheinrich for bringing this to our attention) [66968]</li>\n<li>Tweak &#8211; Improved the performance of The Events Calendar REST API tweaking some queries [89743]</li>\n<li>Tweak &#8211; Add support for a <code>found_posts</code> argument in <code>tribe_get_events</code>, <code>tribe_get_venues</code> and <code>tribe_get_organizers</code> functions to return the number of posts found matching the current query arguments [89743]</li>\n<li>Deprecated &#8211; Deprecated the <code>tribe-events-bar-date-search-default-value</code> filter; use <code>tribe_events_bar_date_search_default_value</code> instead [67482]</li>\n<li>Language &#8211; Improvements to aid translatability of text throughout plugin (props: @ramiy) [88982]</li>\n<li>Language &#8211; 7 new strings added, 180 updated, 4 fuzzied, and 3 obsoleted</li>\n</ul>\n<h4>[4.6] 2017-09-25</h4>\n<ul>\n<li>Feature &#8211; Added full CRUD REST support for Events, Organizers, Venues, Event Categories, and Tags</li>\n<li>Tweak &#8211; Updated Bootstrap Datepicker to v1.7.0</li>\n<li>Tweak &#8211; Added latitude/longitude to REST responses when available on venues</li>\n<li>Tweak &#8211; Added JSON-LD data to REST responses when available</li>\n<li>Tweak &#8211; Replaced deprecated first parameter of <code>tribe_get_organizers()</code> with a parameter that, when specified with a truthy value, returns only organizers with upcoming events attached to them</li>\n<li>Tweak &#8211; Added linked post filters: <code>tribe_{$this-&gt;post_type}_has_events_excluded_post_stati</code>, <code>tribe_events_tribe_organizer_create</code>, <code>tribe_events_tribe_organizer_update</code>, <code>tribe_event_venue_duplicate_post_fields</code>, <code>tribe_event_organizer_duplicate_custom_fields</code></li>\n<li>Tweak &#8211; Added action: <code>tribe_events_organizer_created</code></li>\n<li>Tweak &#8211; Added REST filters: <code>tribe_rest_organizer_default_only_with_upcoming</code>, <code>tribe_rest_venue_default_only_with_upcoming</code>, <code>tribe_events_rest_term_allow_delete</code></li>\n<li>Tweak &#8211; Added duplicate-detection filters: <code>tribe_duplicate_post_strategies</code>, <code>tribe_duplicate_post_strategy</code>, <code>tribe_duplicate_post_{$strategy}_strategy</code></li>\n<li>Language &#8211; 152 new strings added, 217 updated, 6 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.5.13] 2017-09-20</h4>\n<ul>\n<li>Feature &#8211; Add link to the featured image in the Events List widget. New filter introduced to control this: <code>tribe_events_list_widget_featured_image_link</code> (props to @cabadaj007 for the feature request) [84807]</li>\n<li>Feature &#8211; Remove &#8216;France, Metropolitan&#8217; option from country list to prevent issues with Google Maps API (thanks @varesanodotfr for pointing this out) [78023]</li>\n<li>Feature &#8211; Ignored Events will restore previous status instead of setting to &#8216;publish&#8217; [82213]</li>\n<li>Fix &#8211; Patched jQuery Resize vendor library to avoid JavaScript conflicts (props to @britner for the original report) [71994]</li>\n<li>Fix &#8211; Fixed a typo in the Event List widget options [71081]</li>\n<li>Fix &#8211; Addressed some PHP notices that would sometimes emerge in tag-filtered post lists in the wp-admin (thanks to @wfsec28 and others in the forums for reporting this!) [45274]</li>\n<li>Fix &#8211; When &#8220;Full Styles&#8221; or &#8220;Tribe Events Styles&#8221; are used, prevent duplicate featured images from showing up in the Twenty Seventeen theme (props to @want2what and others in the forums for reporting this) [80955]</li>\n<li>Fix &#8211; Fixed the issue that would prevent the start date and date range parameters from being taken into account when using &#8216;Other URL&#8217; source in Event Aggregator</li>\n<li>Fix &#8211; Aggregator will no longer update comments while inactive [78890]</li>\n<li>Fix &#8211; Avoid issues when REST API archive request parameters are not in the original order (thanks @Nslaver for reporting this and providing a fix) [88748]</li>\n<li>Tweak &#8211; Aggregator prevents duplicated records with the same params from being created [68833]</li>\n<li>Tweak &#8211; Aggregator will now allow for some minor shifts in schedule execution time to help distribute requests to EA Service [86628]</li>\n<li>Tweak &#8211; Improve text in the Event Aggregator settings [77452]</li>\n<li>Tweak &#8211; Add actions before and after posts are inserted or updated by Event Aggregator to allow custom functions to kick in (<code>tribe_aggregator_before_insert_posts</code> and <code>tribe_aggregator_after_insert_posts</code>) [87530]</li>\n<li>Tweak &#8211; Allow users to import CSV with numerically-named categories by using a flag (currently <code>%n</code>) (thanks @Shamsi for reporting) [78340]</li>\n<li>Tweak &#8211; Allow date range and events count limits to be set on each type of import (except for &#8216;Other URL&#8217;) in Event Aggregator [79975]</li>\n</ul>\n<h4>[4.5.12.3] 2017-09-19</h4>\n<ul>\n<li>Fix &#8211; Display events on Month View correctly for WordPress version 4.8.2 and up (props @realcrozetva for reporting this) [88952]</li>\n</ul>\n<h4>[4.5.12.2] 2017-09-08</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where manually running Scheduled Imports would always result in a failed import [87321]</li>\n</ul>\n<h4>[4.5.12.1] 2017-09-07</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where events imported via Event Aggregator from an iCal-like source would be duplicated in place of being updated [87654]</li>\n</ul>\n<h4>[4.5.12] 2017-09-06</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where, with certain date formats chosen in the Events display settings, the &#8220;Next Month&#8221; link navigation wasn&#8217;t working (props to @tttammi and others for reporting this issue!) [86937]</li>\n<li>Fix &#8211; Fixed a typo in REST API Swagger documentation that mentioned &#8220;organizer&#8221; when it should have stated &#8220;venue&#8221;.</li>\n<li>Fix &#8211; Fixed issues with Event Aggregator queueing system where events might be duplicated or incorrectly updated [79975]</li>\n<li>Fix &#8211; Prevent notice when the Aggregator Record title is an array [82149]</li>\n<li>Fix &#8211; Allows Aggregator Google Map settings to extend the Global Setting by default (props to queerio for reporting this!) [67639]</li>\n<li>Fix &#8211; Prevent Warnings when throwing WordPress admin notices from Aggregator daily usage limit (props to cigarplanner for reporting this!) [83187]</li>\n<li>Fix &#8211; Resolved problem where Aggregator wouldn&#8217;t allow you to remove filtering terms for Records [76949]</li>\n<li>Fix &#8211; Allow any datepicker format to be used on Aggregator filtering Events (props to matthewseymour for reporting this!) [77819]</li>\n<li>Fix &#8211; Added check to see if log directory is readable before listing logs within it (thank you @rodrigochallengeday-org and @richmondmom for reporting this) [86091]</li>\n<li>Tweak &#8211; Datatables Head and Foot checkboxes will not select all items, only the current page [77395]</li>\n<li>Tweak &#8211; Included tooltip for Aggregator &#8220;Hide &amp; Ignore&#8221; button for events [67890]</li>\n<li>Tweak &#8211; Added all the Aggregator Origins to the Admin Bar [68693]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_get_state_options</code></li>\n<li>Tweak &#8211; Added template tags: <code>maybe_format_from_datepicker()</code></li>\n<li>Tweak &#8211; Added the <code>tribe_rest_single_event_data</code> filter to the single event REST API endpoint to allow filtering the returned data (thanks @mwender) [88748]</li>\n<li>Language &#8211; 2 new strings added, 90 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.5.11] 2017-08-24</h4>\n<ul>\n<li>Fix &#8211; Avoid Event Aggregator previews or scheduled imports being marked as failures [84259]</li>\n<li>Fix &#8211; Fixed start and end date limit parsing for events archive in the REST API code [78375]</li>\n<li>Fix &#8211; Fixed issue with <code>tribe_events_get_the_excerpt()</code> returning a read more link that sometimes pointed to the current page [70473]</li>\n<li>Fix &#8211; Fixed Post ID not being sent to the_title filter for Organizers and Venues (props Anna L.) [85206]</li>\n<li>Fix &#8211; Fixed issue where Month View tooltips would often go off-screen in some smaller viewport sizes [65136]</li>\n<li>Fix &#8211; Fixed an issue that would sometimes render Event Aggregator options invalid even with a valid license [78469]</li>\n<li>Fix &#8211; Fixed an issue where the mobile.php template file would often fail to include an event&#8217;s featured image [74291]</li>\n<li>Fix &#8211; Resolved issue where invalid linked post IDs prevent proper updates on linked posts (props to Mathew L. and a few others for highlighting this issue) [71802]</li>\n<li>Fix &#8211; Do not hijack the blog when the main events page is configured to appear on the site&#8217;s homepage (our thanks to Jason and others for flagging this problem) [72094]</li>\n<li>Fix &#8211; Remove extra trailing double-quotes at the end of the timepicker data-format attributes [85603]</li>\n<li>Fix &#8211; Fixed an issues where Event Aggregator scheduled imports could not run other than manually [81639]</li>\n<li>Tweak &#8211; Prevent stray commas from showing up for some event venues in the List View [72289]</li>\n<li>Tweak &#8211; Prevent stray commas from showing up for some event venues in the Day View [85429]</li>\n<li>Tweak &#8211; Modify certain event queries to widen the window of opportunity for query caching (props @garretjohnson) [84841]</li>\n<li>Tweak &#8211; Improve Event Aggregator message regarding Facebook token expiration [70376]</li>\n<li>Tweak &#8211; Support importing from URLs (Event Aggregator) where the protocol hasn&#8217;t been specified by defaulting to HTTP [76466]</li>\n<li>Tweak &#8211; Removed WP API adjustments [85996]</li>\n<li>Tweak &#8211; Added filter: <code>tribe_aggregator_meta_source</code> to filter the Event Aggregator import source</li>\n<li>Tweak &#8211; Added filter: <code>tribe_events_linked_post_meta_values_{$current_linked_post_meta_key}</code> for filtering the array of values retrieved for a specific linked post meta field</li>\n<li>Tweak &#8211; Updated views: <code>src/views/day/single-event.php</code> and <code>src/views/list/single-event.php</code></li>\n<li>Compatibility &#8211; Minimum supported version of WordPress is now 4.5</li>\n<li>Language &#8211; Improvements to various strings to improve ease of translation (props to @ramiy)</li>\n<li>Language &#8211; 5 new strings added, 56 updated, 1 fuzzied, and 3 obsoleted [the-events-calendar]</li>\n</ul>\n<h4>[4.5.10.1] 2017-08-16</h4>\n<ul>\n<li>Fix &#8211; Updates common library to resolve a range of issues preventing frontend assets from loading and breaking parts of our user interface [85017]</li>\n</ul>\n<h4>[4.5.10] 2017-08-09</h4>\n<ul>\n<li>Fix &#8211; Avoid duplicate events when importing from some iCal, Google Calendar and Facebook feeds in Event Aggregator (our thanks to Jason Sears, controlyours and many other users for highlighting these issues) [67038]</li>\n<li>Fix &#8211; Fixed bug that caused scheduled imports to get stuck in a perpetual state of failure when receiving error messages from the Event Aggregator service (our thanks to Antonio Jose and others for flagging this problem) [83767]</li>\n<li>Fix &#8211; Resolved issue where errors from the Event Aggregator service were not properly logging/visible on the History tab [83767]</li>\n<li>Tweak &#8211; Made linked post fields&#8217; auto-save features more stringently check for empty values to prevent the plugin from trying to &#8220;save&#8221; empty values (our thanks to Jean-Marie for highlighting this problem) [80282]</li>\n<li>Tweak &#8211; Moved the organizer e-mail address field label a bit to better accommodate Community Events [80426]</li>\n<li>Tweak &#8211; Added filter to tribe_get_display_end_date()&#8217;s return value [77730]</li>\n<li>Tweak &#8211; Avoid notice-level errors while processing queues within Event Aggregator (our thanks to David Sharpe and others for reporting this) [84020]</li>\n<li>Tweak &#8211; Improve compatibility and avoid Javascript errors when running alongside Twenty Seventeen [70853]</li>\n<li>Compatibility &#8211; Minimum supported version of WordPress is now 4.4</li>\n<li>Language &#8211; 1 new strings added, 119 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.5.9] 2017-07-26</h4>\n<ul>\n<li>Fix &#8211; Send Aggregator callback URL with correct Scheme [83364]</li>\n<li>Fix &#8211; Scheduled Aggregator cron for inserting will re-enqueue to complete scheduled imports [83382]</li>\n<li>Fix &#8211; Avoid overwriting Venues and Organizers when importing FB events with similarly named Venues and Organizers [75370]</li>\n<li>Fix &#8211; Improve handling of large and/or slow Google Calendar and iCal feeds [79975]</li>\n<li>Tweak &#8211; Added period &#8220;.&#8221; separator to datepicker formats. [65282]</li>\n<li>Tweak &#8211; Added tribe_events_month_get_events_in_month filter to allow overriding of events used in month templates. [83317]</li>\n</ul>\n<h4>[4.5.8.1] 2017-07-21</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where failed EA Imports would hang for a long time before failing [83344]</li>\n</ul>\n<h4>[4.5.8] 2017-07-13</h4>\n<ul>\n<li>Fix &#8211; Remove permalink logic for recurring events (Events Calendar PRO will implement instead) [74153]</li>\n<li>Fix &#8211; Avoid type error when setting up one-time imports for Facebook URLs (our thanks to @J for flagging this!) [78664]</li>\n<li>Fix &#8211; Add a safety check in isOrganizer() function (our thanks to Kevin for flagging this!) [81645]</li>\n<li>Fix &#8211; Avoid EA Client hanging when no events are found while attempting an import from a Facebook source [82713]</li>\n<li>Fix &#8211; Improve compatibility of The Events Calendar when operating with WPML from within a subdirectory (props: @dgwatkins) [81998]</li>\n</ul>\n<h4>[4.5.7] 2017-06-28</h4>\n<ul>\n<li>Fix &#8211; Restore support for translated events category slugs when WPML is active [73478]</li>\n<li>Fix &#8211; Improve handling of shortcodes within event view excerpts (props: @awbauer) [81226]</li>\n<li>Fix &#8211; Improve compatibility with WPML in relation to event permalinks specifically (props: @dgwatkins) [81224]</li>\n<li>Fix &#8211; Improved handling of Venue fields that allows for better form validation in Community Events [76297]</li>\n<li>Tweak &#8211; Better detection and reporting of communication failures with the Event Aggregator server</li>\n<li>Tweak &#8211; Textual corrections (with thanks to @garrett-eclipse for highlighting many of these) [77196]</li>\n<li>Tweak &#8211; New filter added (&#8220;tribe_events_linked_posts_dropdown_enable_creation&#8221;) to facilitate more control over linked posts [80487]</li>\n<li>Tweak &#8211; Improve performance of theme compatibility code [71974]</li>\n<li>Tweak &#8211; Don&#8217;t show Event Aggregator system status in Help tab if there&#8217;s no Event Aggregator license in place [68506]</li>\n</ul>\n<h4>[4.5.6] 2017-06-22</h4>\n<ul>\n<li>Tweak &#8211; Improved how Cost field looks and it&#8217;s consistency across views [71092 &amp; 71094]</li>\n<li>Fix &#8211; Resolved issue where the Meta Chunker attempted to inappropriately chunk meta for post post_types [80857]</li>\n<li>Tweak &#8211; Added actions: <code>tribe_events_inside_cost</code></li>\n<li>Tweak &#8211; Changed views: <code>day/single-event</code>, <code>day/single-featured</code>, <code>list/single-event</code>, <code>list/single-featured</code></li>\n<li>Language &#8211; 1 new strings added, 15 updated, 1 fuzzied, and 1 obsoleted [the-events-calendar]</li>\n<li>Language &#8211; 0 new strings added, 0 updated, 1 fuzzied, and 0 obsoleted [tribe-common]</li>\n</ul>\n<h4>[4.5.5] 2017-06-14</h4>\n<ul>\n<li>Fix &#8211; Removed extra double quotes in organizer link output [71133]</li>\n<li>Fix &#8211; Make the list and day view styles match more closely [63599]</li>\n<li>Fix &#8211; Better sanitization on CSV imports (thanks to Valentinos Chouris from NCC Group for reporting this) [80311]</li>\n<li>Fix &#8211; Prevent tabs from being incorrectly escaped in iCal output (props: KZeni) [80452]</li>\n<li>Fix &#8211; Fixed inconsistent font styling of Tribe Bar form labels. [27252]</li>\n<li>Tweak &#8211; Removed unused Javascript (jQuery UI Dialog) to help avoid warnings (our thanks to @gama6889 for flagging this) [80766]</li>\n<li>Tweak &#8211; Added new filter hooks &#8216;tribe_events_register_event_type_args&#8217; and &#8216;tribe_events_register_event_cat_type_args&#8217; [80658]</li>\n</ul>\n<h4>[4.5.4] 2017-06-06</h4>\n<ul>\n<li>Tweak &#8211; Minor tweaks to the CSS for linked post types (Organizer/Venues)</li>\n<li>Fix &#8211; Prevent drag and drop icon showing when singular linked post type is been displayed</li>\n<li>Fix &#8211; Resolved issue where scheduled imports sometimes failed to execute [79587]</li>\n<li>Fix &#8211; Better sanitization of data (Props to Valentinos Chouris for reporting this) [80310]</li>\n<li>Language &#8211; 2 new strings added, 156 updated, 0 fuzzied, and 4 obsoleted [the-events-calendar]</li>\n<li>Language &#8211; 4 new strings added, 20 updated, 1 fuzzied, and 0 obsoleted [tribe-common]</li>\n</ul>\n<h4>[4.5.3] 2017-06-01</h4>\n<ul>\n<li>Fix &#8211; Made it easier to translate the update confirmation message (our thanks to safu9 for highlighting this) [79729]</li>\n<li>Fix &#8211; Fixed compatibility issue with WPML which caused organizers and venues to disappear on translated events [67581]</li>\n<li>Fix — Fixed bug where venues and organizers would be duplicated when their associated event is previewed. [64088]</li>\n<li>Tweak &#8211; Other fixes to the plugin verbiage (with thanks to @garrett-eclipse and others)</li>\n</ul>\n<h4>[4.5.2.1] 2017-05-19</h4>\n<ul>\n<li>Fix &#8211; Prevent fatal errors occuring in PHP 5.5 and earlier [79208]</li>\n</ul>\n<h4>[4.5.2] 2017-05-17</h4>\n<ul>\n<li>Fix &#8211; Correct REST API reference URL (our thanks to Lindsey for flagging this) [78658]</li>\n<li>Fix &#8211; Improve Event Aggregator integration to avoid situations where imports continually restart but do not complete [77988]</li>\n<li>Tweak &#8211; Make the inclusion or exclusion of the year (within the event schedule string) filterable [78070]</li>\n<li>Tweak &#8211; Adjustments to help avoid false positive security alerts being generated in relation to our customizer integration [78355]</li>\n</ul>\n<h4>[4.5.1] 2017-05-04</h4>\n<ul>\n<li>Fix &#8211; Prevented errors on EA import screen that happened in exotic circumstance. Thanks @kathryn for reporting this! [75787]</li>\n<li>Fix &#8211; Made EA preserve custom dates after reimporting a Facebook Event when option is set. [75787]</li>\n<li>Fix &#8211; Enhance month view caching to minimize impact of JSON-LD generation [74656]</li>\n<li>Tweak &#8211; Styling/layout improvements within the Event Aggregator screen [77895]</li>\n</ul>\n<h4>[4.5.0.2] 2017-05-01</h4>\n<ul>\n<li>Fix &#8211; Ensure compatibility with WordPress version 4.4 and earlier</li>\n</ul>\n<h4>[4.5.0.1] 2017-05-01</h4>\n<ul>\n<li>Fix &#8211; Resolving issue where some premium plugins were falsely claiming they were out of date</li>\n</ul>\n<h4>[4.5] 2017-05-01</h4>\n<ul>\n<li>Feature &#8211; Event Aggregator now allows users to import from other sites with The Events Calendar [68139]</li>\n<li>Feature &#8211; Include a Events REST API endpoint for read operations [70711]</li>\n<li>Feature &#8211; Include granular Scheduling for Events Aggregator</li>\n<li>Tweak &#8211; Update Authority for modified fields now will include Organizer, Venues and Taxonomy changes [71152]</li>\n<li>Tweak &#8211; Clean up direct calls to get events and use wrapper <code>tribe_get_events()</code> which has a hook for customizing</li>\n<li>Tweak &#8211; Remove including Event Tickets for backwards compatibility as a vendor library [71908]</li>\n<li>Tweak &#8211; Create a global ID to increase consistency on all of the imported items with Event Aggregator [75218]</li>\n<li>Fix &#8211; Prevent Aggregator to run on Empty Queues thus generating fatals (props to @Donald for the report here) [75377]</li>\n<li>Fix &#8211; Categories and Tags are no longer cleared when importing with Event Aggregator (thank you @Nicolas for the report) [74264]</li>\n<li>Fix &#8211; Increase consistency on Column Mapping for CSV imports [76476]</li>\n<li>Tweak &#8211; Added filters for REST API: <code>tribe_events_rest_url_prefix</code>, <code>tribe_rest_url</code>, <code>tribe_events_rest_use_builtin</code>, <code>tribe_rest_events_archive_data</code>, <code>tribe_rest_event_max_per_page</code>, <code>tribe_rest_event_data</code>, <code>tribe_rest_venue_data</code>, <code>tribe_rest_organizer_data</code>, <code>tribe_rest_event_categories_data</code>, <code>tribe_rest_event_tags_data</code>, <code>tribe_rest_event_taxonomy_term_data</code>, <code>tribe_rest_event_featured_image</code>, <code>tribe_events_rest_api_enabled</code></li>\n<li>Tweak &#8211; Added filters for REST API Documentation: <code>tribe_rest_swagger_cost_details_documentation</code>, <code>tribe_rest_swagger_date_details_documentation</code>, <code>tribe_rest_swagger_image_details_documentation</code>, <code>tribe_rest_swagger_image_size_documentation</code>, <code>tribe_rest_swagger_term_documentation</code>, <code>tribe_rest_swagger_event_documentation</code>, <code>tribe_rest_swagger_organizer_documentation</code>, <code>tribe_rest_swagger_venue_documentation</code>, <code>tribe_rest_swagger_documentation</code></li>\n<li>Tweak &#8211; Added filters for Modified fields tracking: <code>tribe_tracker_post_types</code>, <code>tribe_tracker_excluded_meta_keys</code>, <code>tribe_tracker_enabled</code>, <code>tribe_tracker_enabled_for_terms</code>, <code>tribe_tracker_taxonomies</code></li>\n<li>Tweak &#8211; Added filters for Event Aggregator: <code>tribe_aggregator_localized_data</code>, <code>tribe_aggregator_service_messages</code>, <code>tribe_aggregator_url_import_range_options</code>, <code>tribe_aggregator_url_import_range_cap</code>, <code>tribe_aggregator_url_import_range_start</code>, <code>tribe_aggregator_url_import_range_end</code></li>\n<li>Tweak &#8211; Removed filters for Event Aggregator: <code>tribe_aggregator_track_modified_fields</code></li>\n<li>Tweak &#8211; Added actions for Initialization: <code>tribe_events_bound_implementations</code></li>\n<li>Tweak &#8211; Removed methods for <code>Tribe__Events__Main</code>: <code>track_event_post_field_changes</code>, <code>maybe_load_tickets_framework</code></li>\n<li>Tweak &#8211; Removed methods for <code>Tribe__Events__Aggregator__Service</code>: <code>has_service_message</code></li>\n</ul>\n<h4>[4.4.5] 2017-03-23</h4>\n<ul>\n<li>Fix &#8211; Local changes to events should be preserved in accordance with the Event Import Authority setting (thanks to @bryan for reporting this one) [72876]</li>\n<li>Fix &#8211; Correct the value for days of the week abbreviation (thanks @mmmmartin03 for the report) [75379]</li>\n<li>Tweak &#8211; Enable the month view cache by default on new installations [74867]</li>\n<li>Tweak &#8211; External links to Google maps changed from http to https (nice find by @bjf2000 &#8211; reported via the .org support page) [74930]</li>\n<li>Tweak &#8211; Links to WordPress.org changed from http to https (ultimately this is also credited to @bjf2000&#8217;s find. Thanks!) [72273]</li>\n</ul>\n<h4>[4.4.4] 2017-03-08</h4>\n<ul>\n<li>Fix &#8211; Avoid unnecessarily removing a callback from an action while inside the same action (improves PolyLang compatibility &#8211; props @Chouby) [73122]</li>\n<li>Fix &#8211; Resolving issue where sites that overrode the wp-admin path would fail to successfully perform a Facebook OAuth with Event Aggregator [74687]</li>\n<li>Tweak &#8211; Improve template loading for easier customization by developers and better support of the template hierarchy (props @QWp6t) [72842]</li>\n</ul>\n<h4>[4.4.3] 2017-02-22</h4>\n<ul>\n<li>Fix &#8211; Resolved issue where iCal exports on month view were exporting more events than intended (thanks to @s2ldesign for reporting in our forums) [72133]</li>\n<li>Fix &#8211; Resolved meta width issue for maps when Pro is active (gracias a @ANTONIO JOSE por el reporte del error)  [69844, 72272]</li>\n<li>Fix &#8211; Resolved issue where featured images were not being imported via Event Aggregator Facebook imports (cheers to @Cody for the initial bug report) [72764]</li>\n<li>Fix &#8211; Resolved issue where translated &#8216;all&#8217; slugs were not respected (thank you @Marianne for your report in the forums) [71996]</li>\n<li>Tweak &#8211; Translation improvements and fixes (@Katja &#8211; thanks! ) [70068]</li>\n<li>Tweak &#8211; Allow &#8220;-1&#8221; when specifying the &#8220;Month view events per day&#8221; setting [70497]</li>\n</ul>\n<h4>[4.4.2] 2017-02-09</h4>\n<ul>\n<li>Fix &#8211; Ensure the global and source-specific Google Map settings for imports are respected [67228]</li>\n<li>Fix &#8211; Prevent PHP 5.2 Strict mode from throwing notices due to usage of <code>is_a</code> [72812]</li>\n<li>Fix &#8211; Ensure the events list widget&#8217;s show/hide if there are upcoming events setting is respected [72965]</li>\n<li>Tweak &#8211; Add filters for template tag functions related to dates: <code>tribe_get_start_time</code>, <code>tribe_get_end_time</code>, <code>tribe_get_start_date</code> and <code>tribe_get_end_date</code> [67759]</li>\n</ul>\n<h4>[4.4.1.1] 2017-01-26</h4>\n<ul>\n<li>Fix &#8211; Resolved fatal caused when rendering themes that override tribe styles</li>\n</ul>\n<h4>[4.4.1] 2017-01-26</h4>\n<ul>\n<li>Fix &#8211; Resolve the Fatals related to undefined methods and Memory exhaustion [71958, 71912]</li>\n<li>Fix &#8211; iCal export for Single events working again [71916]</li>\n<li>Tweak &#8211; Changes the Search label to prevent duplicate words (props @oheinrich) [72149]</li>\n<li>Tweak &#8211; Add theme version to <code>tribe-event.css</code> (props @berler) [71973]</li>\n<li>Fix &#8211; Resolve JavaScript error when jQuery was been de-registered [71369]</li>\n<li>Fix &#8211; Prevent Fatals when Importing Images on Event Aggregator [70576]</li>\n<li>Fix &#8211; Prevent Third Party notes to be escaped, anchor link working again [71872]</li>\n<li>Fix &#8211; Google Maps now are using HTTPS instead of HTTP (props @cliffordp)</li>\n<li>Fix &#8211; Prevent Fatals on Event Aggregator Cron, due to Activity logging failure [71904]</li>\n<li>Fix &#8211; Elminate some cases of problem with Facebook manual import on Event Aggregator [69137]</li>\n<li>Fix &#8211; WPML integration smaller incompatibilities [70520, 70522]</li>\n</ul>\n<h4>[4.4.0.1] 2017-01-09</h4>\n<ul>\n<li>Fix &#8211; Adds safety check to ensure a smooth activation process when earlier versions of Tribe Common are active</li>\n</ul>\n<h4>[4.4] 2017-01-09</h4>\n<ul>\n<li>Feature &#8211; Add dynamic helper text to single event editor to display the events date and time [66484]</li>\n<li>Feature &#8211; Add support for featured events [65898]</li>\n<li>Feature &#8211; Add support for placing the main events archive on the site homepage [38757]</li>\n<li>Feature &#8211; Add support for the theme customizer [67489]</li>\n<li>Feature &#8211; Make it possible to adjust map pins via the theme customizer [65889]</li>\n<li>Feature &#8211; Support for Event Aggregator in a multisite network context added [61427]</li>\n<li>Fix &#8211; Add a link to The Events Calendar Help page in the Network Administration screen of multisite installations [68665]</li>\n<li>Fix &#8211; Multisite license editing and displaying consistency [68662]</li>\n<li>Tweak &#8211; Adjusted styles and added actions for featured events in the List Widget [65923]</li>\n<li>Tweak &#8211; Organizers and Venues are now with a better and cleaner interface [68430]</li>\n<li>Tweak &#8211; Eliminate duplicate meta data for organizer posts [25084]</li>\n<li>Tweak &#8211; Improved the start/end date user interface [66486, 66487, 66550]</li>\n<li>Tweak &#8211; iCal export now includes all events &#8211; up to a reasonable limit &#8211; rather than just those in the current view [65037]</li>\n<li>Tweak &#8211; Adjustments made to the default week view color scheme [69756]</li>\n<li>Tweak &#8211; Add AJAX and improve consistency of the venue and organizer UI [38129]</li>\n</ul>\n<h4>[4.3.5] 2016-12-20</h4>\n<ul>\n<li>Tweak &#8211; Updated the template override instructions in a number of templates [68229]</li>\n<li>Tweak &#8211; Improve behavior of tribe_get_events_title() in respect of single events [46313]</li>\n<li>Tweak &#8211; Event Aggregator will only load on the Administration, prevent bigger loads for Front-End users [70812]</li>\n<li>Tweak &#8211; Allow better filtering for Organizers and Venue Meta fields (Props: @Chouby from Polylang) [70894]</li>\n<li>Fix &#8211; Prevent JavaScript Notices related to Bumpdown [69886]</li>\n<li>Fix &#8211; Assets URL on Windows Servers are fully operational again [68377]</li>\n<li>Fix &#8211; JavaScript and CSS files will respect HTTPS on all pages [69561]</li>\n<li>Fix &#8211; Fixed comment count and visibility issues due to Event Aggregator records [68297]</li>\n<li>Fix &#8211; Fixed PHP notices and warnings raised when importing .ics files [69960]</li>\n<li>Fix &#8211; Only show link to Venues if Pro is active in List View [69887]</li>\n<li>Fix &#8211; Fixed and issue that would make Event Aggregator importing notices remain stuck in the Import screen [70614]</li>\n<li>Fix &#8211; Avoid error screen when saving licenses on multisite installations [68599]</li>\n<li>Fix &#8211; Fix calendar view links in WPML language switcher [67134]</li>\n</ul>\n<h4>[4.3.4.2] 2016-12-13</h4>\n<ul>\n<li>Fix &#8211; Correct an oversight leading to breakages of the /all/ events archive for Events Calendar PRO users [70662]</li>\n</ul>\n<h4>[4.3.4.1] 2016-12-09</h4>\n<ul>\n<li>Fix &#8211; Updates Tribe Common to remove some stray characters that were impacting page layouts (props: @Aetles) [70536]</li>\n</ul>\n<h4>[4.3.4] 2016-12-08</h4>\n<ul>\n<li>Tweak &#8211; Tribe Common now is loaded only once across our plugin suite, improves performance in some cases [65755]</li>\n<li>Fix &#8211; Featured Images for Event Aggregator imports are working as expected again. [69465]</li>\n<li>Fix &#8211; Google Calendar and iCalendar files are now updating their respective events [68684]</li>\n<li>Fix &#8211; On demand Event Aggregator records will update events correctly [69542]</li>\n</ul>\n<h4>[4.3.3] 2016-11-16</h4>\n<ul>\n<li>Feature &#8211; Added Tribe Extension class and loader, to make small addons easier to build [68188]</li>\n<li>Fix &#8211; Ordering on Month view is working as expected again [69123]</li>\n<li>Fix &#8211; Enable ampersand character in mobile month view titles (thanks @kate for the report of this) [45409]</li>\n<li>Fix &#8211; Prevent notices for Event Aggregator License checking [67981]</li>\n<li>Fix &#8211; Mismatched text domains are resolved, important for translations (props to @Hans) [68462]</li>\n<li>Fix &#8211; Sticky on Month View is working as expected again [68902]</li>\n<li>Fix &#8211; Prevent HTTPS websites from pointing to Assets in HTTP [68372]</li>\n<li>Fix &#8211; On <code>WP_Query</code> we will no-longer overwrite custom <code>post__not_in</code> params [42143]</li>\n</ul>\n<h4>[4.3.2] 2016-11-02</h4>\n<ul>\n<li>Fix &#8211; Fixes an issue where the text in the Location search field was URL encoded when using the back or forward button for navigation. [61742]</li>\n<li>Fix &#8211; Aggregator Errors will not show more than once daily as comments (Thanks @Jacob for your report on the forums) [68094]</li>\n<li>Fix &#8211; Event Aggregator ICS default configuration now are been Selected Correctly [67885]</li>\n<li>Fix &#8211; Shortcode Month view now will display tooltips correctly [68094]</li>\n<li>Fix &#8211; Avoid loading the select2 JavaScript library twice when Advanced Custom Fields is activated (props to @ryan for the initial report [43605]</li>\n<li>Fix &#8211; Avoid errors and notices on calendar page when X theme and WPML plugins are active (thanks @ingrid for reporting this one) [64400]</li>\n</ul>\n<h4>[4.3.1.1] 2016-10-20</h4>\n<ul>\n<li>Fix &#8211; Corrected a packaging issue from the 4.3.1 release [67936]</li>\n</ul>\n<h4>[4.3.1] 2016-10-20</h4>\n<ul>\n<li>Tweak &#8211; Implement the pruning of Event Aggregator history records after 7 days, filterable by tribe_aggregator_record_retention [68283]</li>\n<li>Tweak &#8211; Event Aggregator will now verify that the license key has uses remaining before creating a history record [68286]</li>\n<li>Tweak &#8211; Improve <code>tribe_create_event</code> documentation (Props to Keith) [44871]</li>\n<li>Fix &#8211; Resolved an issue where scheduled Event Aggregator imports marked as &#8220;On Demand&#8221; were being run by cron [68284]</li>\n<li>Fix &#8211; Resolved a bug where empty meta fields were being inserted into Event Aggregator record post meta [68290]</li>\n<li>Fix &#8211; Resolved a bug where Venue and Organizers urls were been generated incorrectly (Thanks @Matt) [68168]</li>\n<li>Fix &#8211; Pagination links on Month view are updating correctly [67977]</li>\n<li>Fix &#8211; Resolved the support for translated event category archive slug that could lead to broken links on the front-end while using WPML (Props to Wilco in the support Forums) [62018]</li>\n<li>Fix &#8211; Resolved a bug where searching for past events in the List view would always yield no results (Thanks for the report @Davide) [61863]</li>\n<li>Fix &#8211; Resolved an issue where long file names would break plugin updates on some Windows installations (pros to @Alan [62552]</li>\n<li>Fix &#8211; Resolved an issue where the <code>/all</code> link on recurring events on non English websites could be broken (reported by @lumiest &#8211; thanks!) [68062]</li>\n<li>Fix &#8211; Pagination links on Month view are updating correctly [67977]</li>\n</ul>\n<h4>[4.3.0.1] 2016-10-14</h4>\n<ul>\n<li>Fix &#8211; Preventing legacy Facebook events from being duplicated</li>\n</ul>\n<h4>[4.3] 2016-10-13</h4>\n<ul>\n<li>Feature &#8211; Added Event Aggregator to enable service-based event imports from iCal feeds, Facebook, and Meetup</li>\n<li>Feature &#8211; Revamped the CSV import screens to work within the new Event Aggregator pages</li>\n<li>Tweak &#8211; Adjusted some view logic to support the new Event Views shortcode in Pro [44800]</li>\n<li>Tweak &#8211; Added a button to copy the system infomation on the help tab [43709]</li>\n<li>Tweak &#8211; Added an option for users to opt into automatic system infomation so our support system can grab the system information found on the help tab automatically [31645]</li>\n<li>Tweak &#8211; Use an earlier hook for iCal feed generation (props @jlambe) [64141]</li>\n<li>Tweak &#8211; Revise and simplify integration with Event Tickets attendee screen [61992]</li>\n<li>Tweak &#8211; Added context to a set of strings to make translation easier (props @pedro-mendonca) [64586]</li>\n<li>Tweak &#8211; Deprecated various disused functions and classes relating to the Meta Factory [39905]</li>\n<li>Fix &#8211; Cease using GLOB_BRACE for including deprecated files due to limited server support [63172]</li>\n<li>Fix &#8211; Avoid problems that can occur when hooking and unhooking actions (props @Chouby) [63474]</li>\n<li>Fix &#8211; Resolves an issue where we were duplicating a core WordPress hook but with a different set of parameters (props @Chouby) [66455]</li>\n<li>Fix &#8211; Correct the datetime formatting issues within the iCal feed (props @henryk) [65968]</li>\n<li>Deprecated &#8211; <code>Tribe__Events__Main::initOptions()</code> has been deprecated with no replacement</li>\n<li>Deprecated &#8211; <code>Tribe__Events__Main::set_meta_factory_global()</code> has been deprecated in favor of using the <code>Tribe__Events__Meta_Factory</code> class</li>\n<li>Deprecated &#8211; The <code>setup_meta()</code> method in both the <code>Tribe__Events__Template__Single_Event</code> and <code>Tribe__Events__Template_Factory</code> classes has been deprecated</li>\n<li>Deprecated &#8211; The <code>the_title()</code>, <code>event_date()</code>, <code>event_category()</code>, <code>event_tag()</code>, <code>event_website()</code>, <code>event_origin()</code>, <code>organizer_name()</code>, <code>organizer_email()</code>, <code>venue_name()</code>, <code>venue_address()</code>, and <code>venue_map()</code> methods have been deprecated in the <code>Tribe__Events__Advanced_Functions__Register_Meta</code> class</li>\n<li>Deprecated &#8211; The <code>register()</code>, <code>check_exists()</code>, and <code>get_args()</code> methods have been deprecated in the <code>Tribe__Events__Meta_Factory</code> class</li>\n</ul>\n<h4>[4.2.7] 2016-09-15</h4>\n<ul>\n<li>Tweak &#8211; Additional support for plugin extensions</li>\n</ul>\n<h4>[4.2.6] 2016-08-31</h4>\n<ul>\n<li>Add &#8211; tribe_is_event_past() conditional to detect if event end time is past current time (Reported by @Jonathan in our support forums &#8211; thanks Jonathan.)</li>\n</ul>\n<h4>[4.2.5] 2016-08-17</h4>\n<ul>\n<li>Fix &#8211; Fixed inconsistent template filtering logic for single event template [62525]</li>\n<li>Tweak &#8211; Restored preview for published events [64874]</li>\n</ul>\n<h4>[4.2.4] 2016-08-03</h4>\n<ul>\n<li>Tweak &#8211; Changed &#8220;Event Add-Ons&#8221; to load faster [64286]</li>\n<li>Fix &#8211; Fixed default venue setting [64628]</li>\n<li>Fix &#8211; Fixed default venue state and province settings [64629]</li>\n</ul>\n<h4>[4.2.3] 2016-07-20</h4>\n<ul>\n<li>Fix &#8211; In month view, be sure to unhook JSON-LD output when calling unhook function</li>\n<li>Fix &#8211; Incorrect JSON-LD event start and end times (thank you @jjbte for reporting on .org forums)</li>\n<li>Fix &#8211; Show Google Map and Link checkbox so they show when editing an event (Reported originally by Michael of @NailedIT in the .org forum)</li>\n<li>Fix &#8211; Use Community Events Venue Edit Link when on Community Events Forms instead of Admin (also as a result of the report abve from @NailedIT. Thanks again.)</li>\n</ul>\n<h4>[4.2.2] 2016-07-06</h4>\n<ul>\n<li>Fix &#8211; Small CSS Issue on Welcome Page</li>\n<li>Fix &#8211; Month view on mobile device width doesn&#8217;t have links to prev/next months</li>\n<li>Fix &#8211; Reimport of updated CSV removes featured image (Bug #46149)</li>\n<li>Fix &#8211; Fixed the issue that would make multiple organizers details disappear when trying to submit invalid event data using Community</li>\n<li>Fix &#8211; Add a check to avoid being unable to switch view when Filter Bar plugin is active and at least one field is set to auto-complete mode</li>\n<li>Fix &#8211; Only add the events custom post type to the tag archive queries and not custom queries with tags [45635]</li>\n<li>Fix &#8211; When using the filter tribe_events_excerpt_allow_shortcode shortcodes will be maybe be processed in event excerpts in the list views [42289]</li>\n</ul>\n<h4>[4.2.1.1] 2016-06-28</h4>\n<ul>\n<li>Fix &#8211; Ensure translations load as expected with all supported versions of WordPress (thanks to @JacobALund for originally reporting this on .org forums)</li>\n</ul>\n<h4>[4.2.1] 2016-06-22</h4>\n<ul>\n<li>Tweak &#8211; Adjust the caching rules for Month View for faster loading</li>\n<li>Fix &#8211; Replace a bad return type to avoid unnecessary notices in the error log</li>\n<li>Fix &#8211; Add missing styles for correctly hide screen reader text</li>\n<li>Fix &#8211; Fixes <code>tribe_get_event_link()</code> which wasn&#8217;t working when passing second parameter as `true&#8217;</li>\n<li>Tweak &#8211; Reduce the ginormous font size of Month View titles in skeleton styles</li>\n<li>Fix &#8211; Add styling to adjust List View description to full width</li>\n<li>Fix &#8211; Miscellaneous tweaks to improve the Month and Day views</li>\n<li>Fix &#8211; Fix a shorthand array that was causing errors in PHP 5.2 and 5.3 when importing events</li>\n</ul>\n<h4>[4.2] 2016-06-08</h4>\n<ul>\n<li>Feature &#8211; Added Google Maps API key field in the Settings tab to avoid map timeouts and errors on larger sites (Thanks to Yan for reporting this!)</li>\n<li>Feature &#8211; Added support for featured image, multiple organizers, excerpt and more custom fields in the .csv file import function for events (Thank you to Graphic Designer for posting on UserVoice!)</li>\n<li>Feature &#8211; Added support for featured image, description, map details and more custom fields in the .csv file import function for venues</li>\n<li>Feature &#8211; Added support for featured image and description in the .csv file import function for organizers (Thank you to Rebecca for posting on UserVoice!)</li>\n<li>Feature &#8211; Added an oEmbed template for events</li>\n<li>Feature &#8211; Improve performance of a query used to determine if there are free/uncosted events (Thank you @fabianmarz for the pull request!)</li>\n<li>Feature &#8211; Added support for attaching custom post types to events</li>\n<li>Tweak &#8211; Improved filtering of the <code>tribe_event_featured_image()</code> function (Cheers to @fabianmarz!)</li>\n<li>Tweak &#8211; Add an encoding class for the CSV importer to prevent non utf8 characters from preventing imports (Thanks to screenrage for the report!)</li>\n<li>Tweak &#8211; Improved our JSON-LD output to ensure consistency (Props to @garrettjohnson and Lars!)</li>\n<li>Tweak &#8211; Language files in the <code>wp-content/languages/plugins</code> path will be loaded before attempting to load internal language files (Thank you to user aafhhl for bringing this to our attention!)</li>\n<li>Tweak &#8211; Switch to HTTPS for the &#8220;Powered by The Events Calendar&#8221; link (Thank you Cynthia for reporting this!)</li>\n<li>Tweak &#8211; Switch to using HTTPS by default for interactions with Google Maps API</li>\n<li>Tweak &#8211; Improved filterability of calendar excerpts by introducing the new <code>tribe_events_get_the_excerpt</code> filter hook</li>\n<li>Tweak &#8211; Improved filtering of organizer details when importing by CSV (Props to @Geir for bringing this up!)</li>\n<li>Tweak &#8211; Adjustments for single event view in Twenty Fifteen theme</li>\n<li>Tweak &#8211; Improved performance of query used to test for events without any cost</li>\n<li>Tweak &#8211; Added missing semicolon to a laquo (Props to mwender on GitHub for the fix!)</li>\n<li>Tweak &#8211; Improve the &#8220;stickiness&#8221; of CSV import column mappings (Thank you @jamesgol!)</li>\n<li>Tweak &#8211; Consistency of JSON-LD markup improved (Cheers to @garrettjohnson for the help!)</li>\n<li>Tweak &#8211; Avoid notice-level errors when working with WP CLI on a site where The Events Calendar is also active (Thanks to @sun)</li>\n<li>Tweak &#8211; Corrected the spelling of timezone in the CSV Importer&#8217;s event field</li>\n<li>Tweak &#8211; Updated venue and organizer templates to use the new architecture for attaching custom post types to events</li>\n<li>Tweak &#8211; Move plugin CSS to PostCSS</li>\n<li>Tweak &#8211; Category default view is now set to <code>default</code> in place of hardcoding the current default view in the category base rewrite rule [31907]</li>\n<li>Deprecated &#8211; <code>Tribe__Events__PUE__Checker</code>, <code>Tribe__Events__PUE__Plugin_Info</code>, and <code>Tribe__Events__PUE__Utility</code> classes are deprecated and are replaced by <code>Tribe__PUE__Checker</code>, <code>Tribe__PUE__Plugin_Info</code>, and <code>Tribe__PUE__Utility</code> classes</li>\n<li>Fixed &#8211; Changed the use of <code>have_posts()</code> in the maybe iCal links for the main views that could cause an infinite loop</li>\n<li>Accessibility &#8211; Focus styles added for search fields</li>\n<li>Accessibility &#8211; Add ARIA labels for Month/Day/List sub nav</li>\n<li>Accessibility &#8211; Add ARIA label for events footer sub nav heading</li>\n</ul>\n<h4>[4.1.4] 2016-05-19</h4>\n<ul>\n<li>Fix &#8211; Improve accuracy of list view pagination after switching from month view</li>\n<li>Tweak &#8211; Give the multi-organizer form &#8216;sticky&#8217; properties so values persist even if the submission is initially rejected</li>\n<li>Tweak &#8211; Resolved minor CSS issues in the welcome page</li>\n</ul>\n<h4>[4.1.3] 2016-04-28</h4>\n<ul>\n<li>Fix &#8211; Month View single days are now ordered as follows: sticky events, ongoing multi-day events, all day events, then start time. In other words, all events should be ordered as you&#8217;d expect when viewing events in Month View.</li>\n<li>Fix &#8211; Updated the compatibility of CSV importer with WordPress 4.5 due to a change in the <code>post_status</code> filter. This will help prevent some of the errors you may have seen when importing events using a CSV file.</li>\n<li>Tweak &#8211; Added new event names for AJAX success to the List, Month, and Day views to help The Events Calendar&#8217;s compatibility with our other premium plugins.</li>\n</ul>\n<h4>[4.1.2] 2016-04-11</h4>\n<ul>\n<li>Tweak &#8211; Removed an unneeded hook that attempted to add a query argument to event tag links</li>\n<li>Fix &#8211; Resolved an issue where events marked as &#8220;sticky&#8221; would not display as such in Month View</li>\n<li>Fix &#8211; Dashes, hyphens, or whatever you like to call them in the events archive slug no longer breaks the URL</li>\n<li>Fix &#8211; The notice that pops up when a conflicting &#8220;events&#8221; page exists can now be dismissed</li>\n</ul>\n<h4>[4.1.1.1] 2016-04-07</h4>\n<ul>\n<li>Security &#8211; Tightened up security with post type link filtering (props to Nadal Soler for reporting this issue!)</li>\n<li>Security &#8211; Tightened up security around tribe bar submissions (props to Paul Mynarsky for reporting this issue!)</li>\n</ul>\n<h4>[4.1.1] 2016-03-30</h4>\n<ul>\n<li>Fix &#8211; Resolved bug where array notices were output on single event pages when venues were not set (props to zaxiscreative for reporting this issue!)</li>\n<li>Fix &#8211; Resolved issue where the Month View in mobile sizes retained the long day-of-week names when the abbreviations should have been used (props to Lucy for the bug report!)</li>\n<li>Fix &#8211; Fixed bug where a &#8220;0&#8221; was added to the default Venue name when creating a new event</li>\n<li>Fix &#8211; Fixed notice that caused Ajax requests to fail (props to cgrymala on WP.org for reporting this!)</li>\n<li>Fix &#8211; Removed quotes from around TZID-specified timezones in iCal feeds which causes problems with some parsers (props to factory44 for reporting the issue that lead to this fix)</li>\n<li>Fix &#8211; Resolved various capitalization issues with German translations (props to oheinrich in our forums for pointing out this issue!)</li>\n</ul>\n<h4>[4.1.0.1] 2016-03-17</h4>\n<ul>\n<li>Fix &#8211; Resolved multiple issues with the German <code>de_DE</code> language file that caused a number of site-breaking issues</li>\n</ul>\n<h4>[4.1] 2016-03-15</h4>\n<ul>\n<li>Feature &#8211; Added a tribe_get_venue_website_url() function for fetching Venue website URLs (props to fervorcreative in our forums for this request!)</li>\n<li>Performance &#8211; Lazy-load venue and organizer selector data</li>\n<li>Tweak &#8211; Allow iCal filenames to be filtered via a new filter: tribe_events_ical_feed_filename</li>\n<li>Tweak &#8211; Added a hook to allow single day queries in month view to be filtered: tribe_events_month_daily_events_query_args</li>\n<li>Tweak &#8211; Improved the logic around rebuilding known date ranges</li>\n<li>Tweak &#8211; Always show the &#8220;Merge Duplicates&#8221; button for venues and organizers in the Events General Settings page</li>\n<li>Tweak &#8211; Allow the &#8220;same slug&#8221; notice to be dismissed and fix some text in that message</li>\n<li>Tweak &#8211; Ignore alpha/beta/rc suffixes on version numbers when checking template versions</li>\n<li>Tweak &#8211; Add a filter for month view daily events query: tribe_events_month_daily_events_query_args</li>\n<li>Tweak &#8211; Added a more flexible cost range parsing function</li>\n<li>Tweak &#8211; Obfuscate license keys Events &gt; Help &gt; System Information</li>\n<li>Fix &#8211; Fixed a fatal that sometimes occurred when refreshing the import CSV page</li>\n<li>Fix &#8211; Fixed issue where some characters were not escaped appropriately for month and year formats</li>\n<li>Fix &#8211; Added missing tribe-loading@2x.gif</li>\n<li>Fix &#8211; Fixed a warning produced by passing a DateTime() object into start_date or end_date args of tribe_get_events (props to iamhexcoder for the pull request!)</li>\n<li>Fix &#8211; Fixed bug where events in month view were not always sorted in chronological order</li>\n<li>Fix &#8211; Fixed the System Info URL in Events &gt; Help</li>\n<li>Fix &#8211; Resolved issue where the default country would be &#8220;Array&#8221; if no default country is set</li>\n<li>Fix &#8211; Fixed bug where ajaxurl was sometimes undefined</li>\n</ul>\n<h4>[4.0.7] 2016-03-02</h4>\n<ul>\n<li>Fix &#8211; Resolve display issues on templates with Jetpack and a few themes</li>\n<li>Fix &#8211; Mobile breakpoints on month view working with custom breakpoints</li>\n<li>Fix &#8211; Reordering Venue and Organizer metadata no longer breaks titles</li>\n<li>Fix &#8211; Prevented notices from happening when using <code>the_title</code> filter</li>\n<li>Fix &#8211; iCal links now will respect categories on the first page</li>\n<li>Fix &#8211; Prevent third-party bugs with SEO plugins when inserting events programmatically</li>\n<li>Fix &#8211; Organizer information is showing up again correctly</li>\n<li>Fix &#8211; Modified the add-on license validation method to better explain what is happening</li>\n<li>Fix &#8211; Description on mobile views now have the correct class attribute on HTML</li>\n<li>Fix &#8211; Added missing semicolon on the list navigation for &#8220;&amp;laquo&#8221;</li>\n</ul>\n<h4>[4.0.6] 2016-02-17</h4>\n<ul>\n<li>Tweak &#8211; Adjust injection of event data into the_content from priority 10 to 9 for better 3rd-party plugin compatibility</li>\n<li>Tweak &#8211; Change mobile month view selector to load event details below the calendar for better theme compatibility</li>\n<li>Tweak &#8211; Better handling of edge cases on the post_excerpt for List View</li>\n<li>Tweak &#8211; Removal of generic CSS classes like <code>.updated</code> and <code>.published</code></li>\n<li>Fix &#8211; Prevent Notices from appearing when using <code>tribe_get_organizer()</code></li>\n<li>Fix &#8211; Make HTML Single Event Pages valid</li>\n<li>Fix &#8211; Numeric named categories URLs are now fully working</li>\n<li>Fix &#8211; Event Title now Accepts HTML on Tooltips</li>\n<li>Fix &#8211; Licenses Tab now will work with <code>DISALLOW_FILE_MODS</code> (Props to Sun for spotting and fixing this)</li>\n</ul>\n<h4>[4.0.5] 2016-01-15</h4>\n<ul>\n<li>Security &#8211; Security fix with Venues and Organizers (props to grantdayjames for reporting this!)</li>\n</ul>\n<h4>[4.0.4] 2015-12-23</h4>\n<ul>\n<li>Tweak &#8211; Including the latest embedded Event Tickets release for backward compatibility</li>\n</ul>\n<h4>[4.0.3] 2015-12-22</h4>\n<ul>\n<li>Tweak &#8211; Adjust single-event.php template to allow the &#8220;Time&#8221; title and content to be filterable (Props to Sitecrafting for highlighting this issue!)</li>\n<li>Fix &#8211; Resolved issue with an overly escaped Event Category edit URL that prevented editing categories (Thanks to Ian for the first report of this issue!)</li>\n<li>Fix &#8211; Fixed issue where clicking on columns on the Events listed in the Admin Dashboard were ALWAYS sorted by Event start/end date before sorting by the column selected (Cheers to Corrado for bringing this to our attention!)</li>\n</ul>\n<h4>[4.0.2] 2015-12-16</h4>\n<ul>\n<li>Tweak &#8211; Adding better support for non-numeric cost values on events (Props to Mirja for highlighting this!)</li>\n<li>Tweak &#8211; Avoid notice level errors when advanced events list widget settings are saved (Thank you Johan for reporting the issue!)</li>\n<li>Tweak &#8211; Improve messaging in the same-slug warning message (Thanks to Simon for bringing this to our attention!)</li>\n<li>Tweak &#8211; Hook to Event Tickets to inject event dates into ticket emails</li>\n<li>Tweak &#8211; Adding better support for default venues (Props to Karly for noting this!)</li>\n<li>Tweak &#8211; Improve handling of internationalized slugs (Cheers to Oliver for the help!)</li>\n<li>Fix &#8211; Ensure the past events list displays the correct events when accessed via ajax (Thank you Jesse for highlighting this!)</li>\n<li>Fix &#8211; Support ordering by venue/organizer within event queries (Thank you Doug for bringing this to our attention!)</li>\n<li>Fix &#8211; Fixed issue where events with the same date/time would sometimes be excluded from single-event navigation (Cheers to JeremyEnglert for the tip!)</li>\n<li>Fix &#8211; Resolved issue where events set with the explicit cost of 0 were not showing as &#8220;Free&#8221; (Thank you terrizsolo for reporting this!)</li>\n<li>Fix &#8211; Fixed bug where the datepicker in Twenty Sixteen was really ugly</li>\n<li>Fix &#8211; Fixed bug where using Quick Edit on events caused the table columns in the event list to become jumbled on save (Props to A K for the report!)</li>\n<li>Fix &#8211; Resolved bug where category links sometimes included event category 1 (Thank you Anthony for the original report of this problem!)</li>\n<li>Fix &#8211; Fixed a settings page URL (Props to Kristy for the heads up!)</li>\n</ul>\n<h4>[4.0.1] 2015-12-10</h4>\n<ul>\n<li>Tweak &#8211; Add a warning message for major updates</li>\n<li>Tweak &#8211; For SEO reasons, use an h1 for the title rather than an h2 (props to wpexplorer for this fix)</li>\n<li>Tweak &#8211; Target the calendar view grid in JS using a simpler selector</li>\n<li>Fix &#8211; Resolved WP 4.4 related fatal on the Nav Menu page that prevented the admin footer from rendering/enqueuing JS</li>\n<li>Fix &#8211; Resolved bug where visiting /events/upcoming could sometimes result in an infinite redirect loop</li>\n<li>Fix &#8211; Removed <code>wp_trim_excerpt</code> and use only it&#8217;s powers, fixing the excerpt problem</li>\n<li>Fix &#8211; Fixed bug where the mobile calendar view did not display the date for the date being viewed</li>\n<li>Fix &#8211; Fixed bug where the admin toolbar&#8217;s Events &gt; Import &gt; CSV did not link to the CSV importer page</li>\n<li>Fix &#8211; Fixed issue where the events list in the admin dashboard were not ordered in an intuitive manner</li>\n<li>Fix &#8211; Resolved bug where sorting by event category or tag resulted in an error</li>\n<li>Fix &#8211; Fixed bug where full event content text was displayed where excerpts should have been displayed</li>\n<li>Fix &#8211; Resolved issue where events imported via CSV were excluded from single event navigation</li>\n<li>Fix &#8211; Fixed bug where /events/list would sometimes 404 on a new install</li>\n<li>Fix &#8211; Resolved bug where multiday all-day events displayed the end date as one day later than it should be when the End of Day Cut-off was set to something other than 12am</li>\n<li>Fix &#8211; Timezone handling fixed within generated iCal feeds</li>\n</ul>\n<h4>[4.0] 2015-12-02</h4>\n<ul>\n<li>Security &#8211; A TON of escaping was added to our codebase thanks to the efforts of the always-helpful Andy Fragen (@afragen)</li>\n<li>Feature &#8211; Moved the Ticket framework code into its own plugin (event-tickets)</li>\n<li>Feature &#8211; The event cost now supports more international formats with the addition of the tribe_events_cost_separators filter (Thank you remokrol for bringing this to our attention!)</li>\n<li>Feature &#8211; Added support for the twentysixteen theme</li>\n<li>Feature &#8211; Created a new Add-Ons tab in Settings so that TEC add-ons can have a consolidated settings tab</li>\n<li>Feature &#8211; Improve the date formats UI by providing example output for each selected format</li>\n<li>Tweak &#8211; Restructured TEC&#8217;s core settings code for reusability with other standalone plugins like Event Tickets</li>\n<li>Tweak &#8211; Deprecate old JS event names in favor of a new JS event naming standard. Example: deprecated tribe_ev_runAjax in favor of run-ajax.tribe</li>\n<li>Tweak &#8211; Consolidated import pages for TEC and add-ons</li>\n<li>Tweak &#8211; When suggesting a UTF-8 compatibility CSV formatting tool, point to one that still exists</li>\n<li>Tweak &#8211; Added the ability to filter attendees CSV items via tribe_events_tickets_attendees_csv_items (Props to @bostondv on GitHub for this patch!)</li>\n<li>Tweak &#8211; Updated all excerpt output to use tribe_events_get_the_excerpt() to ensure a consistent display of excerpt content (Cheers to Joseph to pointing this out!)</li>\n<li>Tweak &#8211; Add support for wp_get_document_title in response to the WordPress 4.4 deprecation of wp_title</li>\n<li>Tweak &#8211; Check post creation permissions before letting users create venues and organizers from the event meta box</li>\n<li>Tweak &#8211; Only display data separators between fields that have data when rendering organizers (Thank you Bud for highlighting this issue!)</li>\n<li>Tweak &#8211; When a user cannot create organizers, prevent the auto-selection of organizers when editing an event</li>\n<li>Tweak &#8211; Remove microformat CSS classes from templates and replace with namespaced content-relevant CSS classes</li>\n<li>Tweak &#8211; Changed the &#8220;updated&#8221; CSS class to &#8220;tribe-updated&#8221; so that it is properly namespaced (Thank you vijayrajesh!)</li>\n<li>Tweak &#8211; The Plugin Update Checker will now auto-save valid plugin keys (Thanks to Denon for originally bringing this up!)</li>\n<li>Tweak &#8211; Cleaned up the output of JSON-LD data. Filterable via the new tribe_google_data_markup_json filter</li>\n<li>Tweak &#8211; Drop the use of the generic CSS class &#8220;placeholder&#8221; in favor of &#8220;tribe-event-placeholder&#8221; (Thanks to Marc on the forums!)</li>\n<li>Tweak &#8211; Adjusted the CSS padding on Admin Menu items for Events</li>\n<li>Tweak &#8211; Various codesniffer fixes</li>\n<li>Tweak &#8211; tribe_get_venue_link() no longer echoes if you ask it to return an <a> element</a></li>\n<li>Tweak &#8211; Error messages for empty Venue names</li>\n<li>Tweak &#8211; Improve our responsiveness for the widget mini calendar, allowing smaller sidebars.</li>\n<li>Tweak &#8211; No longer retrieve empty costs when fetching all costs for all events</li>\n<li>Tweak &#8211; Change the priority of bootstrapping the-events-calendar to ensure it occurs before any of the TEC addons in the event some addons are upgraded to v4.0 later than TEC</li>\n<li>Tweak &#8211; Adjust the logic used for adding a noindex/follow tag to event views</li>\n<li>Tweak &#8211; No longer hiding default address fields when default venues are selected when Pro is active</li>\n<li>Fix &#8211; Resolved issue where the iCal feed did not provide an appropriately formatted timezone in some cases (Cheers to Matt for the report!)</li>\n<li>Fix &#8211; Added support for translating some previously untranslatable strings (Props to tititou36, media325, and Stef!)</li>\n<li>Fix &#8211; Prevented duplicate CSS IDs on the mini calendars (Cheers to Corrado for the help!)</li>\n<li>Fix &#8211; Fixed bug causing tribe_get_single_ical_link() and tribe_get_ical_link() to use the same URL when it shouldn&#8217;t (Props to Ben Byrne @drywall on Twitter for the heads up!)</li>\n<li>Fix &#8211; Fixed issue where the &#8220;Add another organizer&#8221; text wasn&#8217;t using the correct singular label (Thank you MIKE for the report!)</li>\n<li>Fix &#8211; Various CSS fixes for twenty(ten-fifteen)</li>\n<li>Fix &#8211; Improved our handling of <code>get_current_screen()</code> across the plugin, avoiding notices and warnings (Thank you Mike for the help!)</li>\n<li>Fix &#8211; Fixed bug where accessing object properties on a non object errored out when saving event meta (props to @dalethedeveloper on GitHub for this fix!)</li>\n<li>Fix &#8211; Fixed bug where organizer ID meta attached sometimes included a blank record. That blank record is no longer returned in tribe_get_organizer_ids()</li>\n<li>Fix &#8211; Fixed error message returned when tabbing away from a blank event name meta box so that it properly indicates that an event name is required (Our thanks to @tapan29bd for this fix!)</li>\n<li>Fix &#8211; Resolved issue where Timezone event start/end date property name strings were malformed which guaranteed a a call to get_post_meta for Timezone date strings</li>\n<li>Fix &#8211; Fixed CSS issue where the month view calendar could sometimes extend beyond the edge of the page when Skeleton Styles were enabled</li>\n<li>Fix &#8211; Fixed a problem where iCal data was generated with incorrect dates in the case of some all days events (thanks to Matt for highlighting this)</li>\n<li>Fix &#8211; Resolved a problem causing the previous month view to appear when it should not</li>\n<li>Fix &#8211; Fixed issue in mobile month view where date was missing from heading</li>\n<li>Fix &#8211; Resolved issue that caused /events/ to 404 if it was visited on a new install before hitting &#8220;Save&#8221; on the Events &gt; Settings &gt; Display page</li>\n<li>Deprecated &#8211; The Tribe__Events__Main::defaultValueReplaceEnabled() method is being deprecated in favor of tribe_get_option(&#8216;defaultValueReplace&#8217;). Schedules for removal in v4.5</li>\n<li>Deprecated &#8211; The tribe_event_link() has been deprecated in favor of tribe_get_event_link(). Scheduled for removal in 5.0</li>\n<li>Deprecated &#8211; The third parameter of tribe_get_organizer_link() (the $echo parameter) has been deprecated and is scheduled for removal in 5.0</li>\n<li>Deprecated &#8211; Tribe__Events__Abstract_Deactivation in favor of Tribe__Abstract_Deactivation</li>\n<li>Deprecated &#8211; Tribe__Events__Admin__Helpers in favor of Tribe__Admin__Helpers</li>\n<li>Deprecated &#8211; Tribe__Events__App_Shop in favor of Tribe__App_Shop</li>\n<li>Deprecated &#8211; Tribe__Events__Autoloader in favor of Tribe__Autoloader</li>\n<li>Deprecated &#8211; Tribe__Events__Cache in favor of Tribe__Cache</li>\n<li>Deprecated &#8211; Tribe__Events__Cache_Listener in favor of Tribe__Cache_Listener</li>\n<li>Deprecated &#8211; Tribe__Events__Changelog_Reader in favor of Tribe__Changelog_Reader</li>\n<li>Deprecated &#8211; Tribe__Events__Credits in favor of Tribe__Credits</li>\n<li>Deprecated &#8211; Tribe__Events__Date_Utils in favor of Tribe__Date_Utils</li>\n<li>Deprecated &#8211; Tribe__Events__Field in favor of Tribe__Field</li>\n<li>Deprecated &#8211; Tribe__Events__Settings in favor of Tribe__Settings</li>\n<li>Deprecated &#8211; Tribe__Events__Settings_Tab in favor of Tribe__Settings_Tab</li>\n<li>Deprecated &#8211; Tribe__Events__Support in favor of Tribe__Support</li>\n<li>Deprecated &#8211; Tribe__Events__Template_Part_Cache in favor of Tribe__Template_Part_Cache</li>\n<li>Deprecated &#8211; Tribe__Events__Tickets__Attendees_Table in favor of Tribe__Tickets__Attendees_Table in the event-tickets plugin</li>\n<li>Deprecated &#8211; Tribe__Events__Tickets__Metabox in favor of Tribe__Tickets__Metabox in the event-tickets plugin</li>\n<li>Deprecated &#8211; Tribe__Events__Tickets__Ticket_Object in favor of Tribe__Tickets__Ticket_Object in the event-tickets plugin</li>\n<li>Deprecated &#8211; Tribe__Events__Tickets__Tickets in favor of Tribe__Tickets__Tickets in the event-tickets plugin</li>\n<li>Deprecated &#8211; Tribe__Events__Tickets__Tickets_Pro in favor of Tribe__Tickets__Tickets_Handler in the event-tickets plugin</li>\n<li>Deprecated &#8211; Tribe__Events__Validate in favor of Tribe__Validate</li>\n<li>Deprecated &#8211; Tribe__Events__View_Helpers in favor of Tribe__View_Helpers</li>\n<li>Deprecated &#8211; Tribe__Events__Main::OPTIONNAME in favor of Tribe__Main::OPTIONNAME</li>\n<li>Deprecated &#8211; Tribe__Events__Main::OPTIONNAMENETWORK in favor of Tribe__Main::OPTIONNAMENETWORK</li>\n<li>Deprecated &#8211; Tribe__Events__Main::addHelpAdminMenuItem() in favor of Tribe__Settings_Manager::add_help_admin_menu_item()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::addNetworkOptionsPage() in favor of Tribe__Settings_Manager::add_network_options_page()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::array_insert_after_key() in favor of Tribe__Main::array_insert_after_key()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::array_insert_before_key() in favor of Tribe__Main::array_insert_before_key()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::debug() in favor of Tribe__Debug::debug()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::defaultValueReplaceEnabled() in favor of tribe_get_option( &#8216;defaultValueReplace&#8217; )</li>\n<li>Deprecated &#8211; Tribe__Events__Main::doHelpTab() in favor of Tribe__Settings_Manager::do_help_tab()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::doNetworkSettingTab() in favor of Tribe__Settings_Manager::do_network_settings_tab()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::doSettingTabs() in favor of Tribe__Settings_Manager::do_setting_tabs()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::do_licenses_tab() in favor of Tribe__Settings_Manager::do_licenses_tab()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::getNetworkOption() in favor of Tribe__Settings_Manager::get_network_option()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::getNetworkOptions() in favor of Tribe__Settings_Manager::get_network_options()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::getNotices() in favor of Tribe__Notices::get()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::getOption() in favor of Tribe__Settings_Manager::get_option()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::getOptions() in favor of Tribe__Settings_Manager::get_options()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::have_addons() in favor of Tribe__Settings_Manager::have_addons()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::isNotice() in favor of Tribe__Notices::is_notice()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::pluginDir in favor of Tribe__Events__Main::plugin_dir</li>\n<li>Deprecated &#8211; Tribe__Events__Main::pluginName in favor of Tribe__Events__Main::plugin_name</li>\n<li>Deprecated &#8211; Tribe__Events__Main::pluginPath in favor of Tribe__Events__Main::plugin_path</li>\n<li>Deprecated &#8211; Tribe__Events__Main::pluginUrl in favor of Tribe__Events__Main::plugin_url</li>\n<li>Deprecated &#8211; Tribe__Events__Main::removeNotice() in favor of Tribe__Notices::remove_notice()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::renderDebug() in favor of Tribe__Debug::render()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::saveAllTabsHidden() in favor of Tribe__Settings_Manager::save_all_tabs_hidden()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::setNetworkOptions() in favor of Tribe__Settings_Manager::set_network_options()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::setNotice() in favor of Tribe__Notices::set_notice()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::truncate() in favor of tribe_events_get_the_excerpt()</li>\n<li>Deprecated &#8211; tribe_event_beginning_of_day() in favor of tribe_beginning_of_day()</li>\n<li>Deprecated &#8211; tribe_event_end_of_day() in favor of tribe_end_of_day()</li>\n<li>Deprecated &#8211; tribe_event_format_date() in favor of tribe_format_date()</li>\n<li>Deprecated &#8211; tribe_events_the_notices() in favor of tribe_the_notices()</li>\n</ul>\n<h4>3.x and previous</h4>\n<p>For release notes from the 3.x and older lifecycles, see our <a href=\"https://theeventscalendar.com/category/products/release-notes/\" rel=\"nofollow\">full historical release notes</a>.</p>\n\";s:11:\"screenshots\";s:2685:\"<ol><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-1.png?rev=1679210\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-1.png?rev=1679210\" alt=\"Month View with hover\"></a><p>Month View with hover</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-10.png?rev=1679210\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-10.png?rev=1679210\" alt=\"Events List Widget\"></a><p>Events List Widget</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-11.png?rev=1679210\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-11.png?rev=1679210\" alt=\"Mobile Month View\"></a><p>Mobile Month View</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-12.png?rev=1679210\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-12.png?rev=1679210\" alt=\"CSV Importer\"></a><p>CSV Importer</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-2.png?rev=1679210\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-2.png?rev=1679210\" alt=\"Month View\"></a><p>Month View</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-3.png?rev=1679210\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-3.png?rev=1679210\" alt=\"List View\"></a><p>List View</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-4.png?rev=1679210\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-4.png?rev=1679210\" alt=\"Day View\"></a><p>Day View</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-5.png?rev=1679210\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-5.png?rev=1679210\" alt=\"Single event\"></a><p>Single event</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-6.png?rev=1679210\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-6.png?rev=1679210\" alt=\"Event Editor\"></a><p>Event Editor</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-7.png?rev=1679210\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-7.png?rev=1679210\" alt=\"Events admin listing\"></a><p>Events admin listing</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-8.png?rev=1679210\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-8.png?rev=1679210\" alt=\"General Settings\"></a><p>General Settings</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-9.png?rev=1679210\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-9.png?rev=1679210\" alt=\"Display Settings\"></a><p>Display Settings</p></li></ol>\";}s:13:\"download_link\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.1.zip\";s:11:\"screenshots\";a:12:{i:1;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-1.png?rev=1679210\";s:7:\"caption\";s:21:\"Month View with hover\";}i:10;a:2:{s:3:\"src\";s:73:\"https://ps.w.org/the-events-calendar/assets/screenshot-10.png?rev=1679210\";s:7:\"caption\";s:18:\"Events List Widget\";}i:11;a:2:{s:3:\"src\";s:73:\"https://ps.w.org/the-events-calendar/assets/screenshot-11.png?rev=1679210\";s:7:\"caption\";s:17:\"Mobile Month View\";}i:12;a:2:{s:3:\"src\";s:73:\"https://ps.w.org/the-events-calendar/assets/screenshot-12.png?rev=1679210\";s:7:\"caption\";s:12:\"CSV Importer\";}i:2;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-2.png?rev=1679210\";s:7:\"caption\";s:10:\"Month View\";}i:3;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-3.png?rev=1679210\";s:7:\"caption\";s:9:\"List View\";}i:4;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-4.png?rev=1679210\";s:7:\"caption\";s:8:\"Day View\";}i:5;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-5.png?rev=1679210\";s:7:\"caption\";s:12:\"Single event\";}i:6;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-6.png?rev=1679210\";s:7:\"caption\";s:12:\"Event Editor\";}i:7;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-7.png?rev=1679210\";s:7:\"caption\";s:20:\"Events admin listing\";}i:8;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-8.png?rev=1679210\";s:7:\"caption\";s:16:\"General Settings\";}i:9;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-9.png?rev=1679210\";s:7:\"caption\";s:16:\"Display Settings\";}}s:4:\"tags\";a:5:{s:8:\"calendar\";s:8:\"calendar\";s:5:\"event\";s:5:\"Event\";s:6:\"events\";s:6:\"events\";s:9:\"organizer\";s:9:\"organizer\";s:5:\"venue\";s:5:\"venue\";}s:8:\"versions\";a:160:{s:3:\"1.5\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.zip\";s:5:\"1.5.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.1.zip\";s:5:\"1.5.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.2.zip\";s:5:\"1.5.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.3.zip\";s:5:\"1.5.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.4.zip\";s:5:\"1.5.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.5.zip\";s:5:\"1.5.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.6.zip\";s:3:\"1.6\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.zip\";s:5:\"1.6.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.1.zip\";s:5:\"1.6.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.2.zip\";s:5:\"1.6.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.3.zip\";s:5:\"1.6.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.4.zip\";s:5:\"1.6.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.5.zip\";s:3:\"2.0\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.zip\";s:5:\"2.0.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.1.zip\";s:6:\"2.0.10\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.10.zip\";s:6:\"2.0.11\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.11.zip\";s:5:\"2.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.2.zip\";s:5:\"2.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.3.zip\";s:5:\"2.0.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.4.zip\";s:5:\"2.0.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.5.zip\";s:5:\"2.0.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.6.zip\";s:5:\"2.0.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.7.zip\";s:5:\"2.0.8\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.8.zip\";s:5:\"2.0.9\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.9.zip\";s:3:\"3.0\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.zip\";s:5:\"3.0.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.1.zip\";s:5:\"3.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.2.zip\";s:5:\"3.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.3.zip\";s:3:\"3.1\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.1.zip\";s:4:\"3.10\";s:67:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.10.zip\";s:6:\"3.10.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.10.1.zip\";s:4:\"3.11\";s:67:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.11.zip\";s:6:\"3.11.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.11.1.zip\";s:6:\"3.11.2\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.11.2.zip\";s:4:\"3.12\";s:67:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.zip\";s:6:\"3.12.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.1.zip\";s:6:\"3.12.2\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.2.zip\";s:6:\"3.12.3\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.3.zip\";s:6:\"3.12.4\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.4.zip\";s:6:\"3.12.5\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.5.zip\";s:6:\"3.12.6\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.6.zip\";s:3:\"3.2\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.2.zip\";s:3:\"3.3\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.3.zip\";s:5:\"3.3.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.3.1.zip\";s:3:\"3.4\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.4.zip\";s:5:\"3.4.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.4.1.zip\";s:3:\"3.5\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.5.zip\";s:5:\"3.5.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.5.1.zip\";s:3:\"3.6\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.6.zip\";s:5:\"3.6.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.6.1.zip\";s:3:\"3.7\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.7.zip\";s:3:\"3.8\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.8.zip\";s:5:\"3.8.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.8.1.zip\";s:3:\"3.9\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.zip\";s:5:\"3.9.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.1.zip\";s:5:\"3.9.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.2.zip\";s:5:\"3.9.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.3.zip\";s:3:\"4.0\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.zip\";s:5:\"4.0.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.1.zip\";s:5:\"4.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.2.zip\";s:5:\"4.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.3.zip\";s:5:\"4.0.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.4.zip\";s:5:\"4.0.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.5.zip\";s:5:\"4.0.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.6.zip\";s:5:\"4.0.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.7.zip\";s:3:\"4.1\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.zip\";s:7:\"4.1.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.0.1.zip\";s:5:\"4.1.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.1.zip\";s:7:\"4.1.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.1.1.zip\";s:5:\"4.1.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.2.zip\";s:5:\"4.1.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.3.zip\";s:5:\"4.1.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.4.zip\";s:3:\"4.2\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.zip\";s:5:\"4.2.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.1.zip\";s:7:\"4.2.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.1.1.zip\";s:5:\"4.2.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.2.zip\";s:5:\"4.2.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.3.zip\";s:5:\"4.2.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.4.zip\";s:5:\"4.2.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.5.zip\";s:5:\"4.2.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.6.zip\";s:5:\"4.2.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.7.zip\";s:3:\"4.3\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.zip\";s:7:\"4.3.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.0.1.zip\";s:5:\"4.3.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.1.zip\";s:7:\"4.3.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.1.1.zip\";s:5:\"4.3.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.2.zip\";s:5:\"4.3.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.3.zip\";s:5:\"4.3.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.4.zip\";s:7:\"4.3.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.4.1.zip\";s:7:\"4.3.4.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.4.2.zip\";s:5:\"4.3.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.5.zip\";s:3:\"4.4\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.zip\";s:7:\"4.4.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.0.1.zip\";s:5:\"4.4.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.1.zip\";s:7:\"4.4.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.1.1.zip\";s:5:\"4.4.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.2.zip\";s:5:\"4.4.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.3.zip\";s:5:\"4.4.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.4.zip\";s:5:\"4.4.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.5.zip\";s:3:\"4.5\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.zip\";s:7:\"4.5.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.0.1.zip\";s:7:\"4.5.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.0.2.zip\";s:5:\"4.5.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.1.zip\";s:6:\"4.5.10\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.10.zip\";s:8:\"4.5.10.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.10.1.zip\";s:6:\"4.5.11\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.11.zip\";s:6:\"4.5.12\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.zip\";s:8:\"4.5.12.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.1.zip\";s:8:\"4.5.12.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.2.zip\";s:8:\"4.5.12.3\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.3.zip\";s:6:\"4.5.13\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.13.zip\";s:5:\"4.5.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.2.zip\";s:7:\"4.5.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.2.1.zip\";s:5:\"4.5.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.3.zip\";s:5:\"4.5.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.4.zip\";s:5:\"4.5.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.5.zip\";s:5:\"4.5.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.6.zip\";s:5:\"4.5.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.7.zip\";s:5:\"4.5.8\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.8.zip\";s:7:\"4.5.8.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.8.1.zip\";s:5:\"4.5.9\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.9.zip\";s:3:\"4.6\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.zip\";s:5:\"4.6.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.1.zip\";s:6:\"4.6.10\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.10.zip\";s:8:\"4.6.10.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.10.1.zip\";s:6:\"4.6.11\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.11.zip\";s:8:\"4.6.11.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.11.1.zip\";s:6:\"4.6.12\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.12.zip\";s:6:\"4.6.13\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.13.zip\";s:6:\"4.6.14\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.14.zip\";s:8:\"4.6.14.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.14.1.zip\";s:6:\"4.6.15\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.15.zip\";s:6:\"4.6.16\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.16.zip\";s:6:\"4.6.17\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.17.zip\";s:6:\"4.6.18\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.18.zip\";s:6:\"4.6.19\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.19.zip\";s:5:\"4.6.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.2.zip\";s:6:\"4.6.20\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.20.zip\";s:8:\"4.6.20.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.20.1.zip\";s:6:\"4.6.21\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.21.zip\";s:6:\"4.6.22\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.22.zip\";s:8:\"4.6.22.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.22.1.zip\";s:6:\"4.6.23\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.23.zip\";s:6:\"4.6.24\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.24.zip\";s:8:\"4.6.24.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.24.1.zip\";s:6:\"4.6.25\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.25.zip\";s:6:\"4.6.26\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.26.zip\";s:8:\"4.6.26.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.26.1.zip\";s:5:\"4.6.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.3.zip\";s:5:\"4.6.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.4.zip\";s:5:\"4.6.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.5.zip\";s:5:\"4.6.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.6.zip\";s:5:\"4.6.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.7.zip\";s:5:\"4.6.8\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.8.zip\";s:5:\"4.6.9\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.9.zip\";s:3:\"4.7\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.zip\";s:7:\"4.7.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.0.1.zip\";s:5:\"4.7.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.1.zip\";s:5:\"trunk\";s:62:\"https://downloads.wordpress.org/plugin/the-events-calendar.zip\";}s:11:\"donate_link\";s:18:\"http://m.tri.be/29\";s:12:\"contributors\";a:0:{}}s:14:\"contact-form-7\";a:25:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:7:\"version\";s:5:\"5.0.5\";s:6:\"author\";s:62:\"<a href=\"https://ideasilo.wordpress.com/\">Takayuki Miyoshi</a>\";s:14:\"author_profile\";s:43:\"https://profiles.wordpress.org/takayukister\";s:8:\"requires\";s:3:\"4.8\";s:6:\"tested\";s:5:\"4.9.8\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";a:0:{}s:6:\"rating\";d:90;s:7:\"ratings\";a:5:{i:5;i:1107;i:4;i:114;i:3;i:35;i:2;i:29;i:1;i:121;}s:11:\"num_ratings\";i:1406;s:15:\"support_threads\";i:421;s:24:\"support_threads_resolved\";i:108;s:10:\"downloaded\";i:97630918;s:12:\"last_updated\";s:22:\"2018-10-29 11:58pm GMT\";s:5:\"added\";s:10:\"2007-08-02\";s:8:\"homepage\";s:25:\"https://contactform7.com/\";s:8:\"sections\";a:5:{s:11:\"description\";s:2779:\"<p>Contact Form 7 can manage multiple contact forms, plus you can customize the form and the mail contents flexibly with simple markup. The form supports Ajax-powered submitting, CAPTCHA, Akismet spam filtering and so on.</p>\n<h4>Docs &amp; Support</h4>\n<p>You can find <a href=\"https://contactform7.com/docs/\" rel=\"nofollow\">docs</a>, <a href=\"https://contactform7.com/faq/\" rel=\"nofollow\">FAQ</a> and more detailed information about Contact Form 7 on <a href=\"https://contactform7.com/\" rel=\"nofollow\">contactform7.com</a>. If you were unable to find the answer to your question on the FAQ or in any of the documentation, you should check the <a href=\"https://wordpress.org/support/plugin/contact-form-7/\" rel=\"nofollow\">support forum</a> on WordPress.org. If you can&#8217;t locate any topics that pertain to your particular issue, post a new topic for it.</p>\n<h4>Contact Form 7 Needs Your Support</h4>\n<p>It is hard to continue development and support for this free plugin without contributions from users like you. If you enjoy using Contact Form 7 and find it useful, please consider <a href=\"https://contactform7.com/donate/\" rel=\"nofollow\"><strong>making a donation</strong></a>. Your donation will help encourage and support the plugin&#8217;s continued development and better user support.</p>\n<h4>Privacy Notices</h4>\n<p>With the default configuration, this plugin, in itself, does not:</p>\n<ul>\n<li>track users by stealth;</li>\n<li>write any user personal data to the database;</li>\n<li>send any data to external servers;</li>\n<li>use cookies.</li>\n</ul>\n<p>If you activate certain features in this plugin, the contact form submitter&#8217;s personal data, including their IP address, may be sent to the service provider. Thus, confirming the provider&#8217;s privacy policy is recommended. These features include:</p>\n<ul>\n<li>reCAPTCHA (<a href=\"https://policies.google.com/?hl=en\" rel=\"nofollow\">Google</a>)</li>\n<li>Akismet (<a href=\"https://automattic.com/privacy/\" rel=\"nofollow\">Automattic</a>)</li>\n</ul>\n<h4>Recommended Plugins</h4>\n<p>The following plugins are recommended for Contact Form 7 users:</p>\n<ul>\n<li><a href=\"https://wordpress.org/plugins/flamingo/\">Flamingo</a> by Takayuki Miyoshi &#8211; With Flamingo, you can save submitted messages via contact forms in the database.</li>\n<li><a href=\"https://wordpress.org/plugins/bogo/\">Bogo</a> by Takayuki Miyoshi &#8211; Bogo is a straight-forward multilingual plugin that doesn&#8217;t cause headaches.</li>\n</ul>\n<h4>Translations</h4>\n<p>You can <a href=\"https://contactform7.com/translating-contact-form-7/\" rel=\"nofollow\">translate Contact Form 7</a> on <a href=\"https://translate.wordpress.org/projects/wp-plugins/contact-form-7\" rel=\"nofollow\"><strong>translate.wordpress.org</strong></a>.</p>\n\";s:12:\"installation\";s:414:\"<ol>\n<li>Upload the entire <code>contact-form-7</code> folder to the <code>/wp-content/plugins/</code> directory.</li>\n<li>Activate the plugin through the &#8216;Plugins&#8217; menu in WordPress.</li>\n</ol>\n<p>You will find &#8216;Contact&#8217; menu in your WordPress admin panel.</p>\n<p>For basic usage, you can also have a look at the <a href=\"https://contactform7.com/\" rel=\"nofollow\">plugin web site</a>.</p>\n\";s:3:\"faq\";s:442:\"<p>Do you have questions or issues with Contact Form 7? Use these support channels appropriately.</p>\n<ol>\n<li><a href=\"https://contactform7.com/docs/\" rel=\"nofollow\">Docs</a></li>\n<li><a href=\"https://contactform7.com/faq/\" rel=\"nofollow\">FAQ</a></li>\n<li><a href=\"https://wordpress.org/support/plugin/contact-form-7/\" rel=\"nofollow\">Support Forum</a></li>\n</ol>\n<p><a href=\"https://contactform7.com/support/\" rel=\"nofollow\">Support</a></p>\n\";s:9:\"changelog\";s:3930:\"<p>For more information, see <a href=\"https://contactform7.com/category/releases/\" rel=\"nofollow\">Releases</a>.</p>\n<h4>5.0.5</h4>\n<ul>\n<li>Fixes the inconsistency problem between get_data_option() and get_default_option() in the WPCF7_FormTag class.</li>\n<li>Suppresses PHP errors occur on unlink() calls.</li>\n<li>Introduces wpcf7_is_file_path_in_content_dir() to support the use of the UPLOADS constant.</li>\n</ul>\n<h4>5.0.4</h4>\n<ul>\n<li>Specifies the capability_type argument explicitly in the register_post_type() call to fix the privilege escalation vulnerability issue.</li>\n<li>Local File Attachment – disallows the specifying of absolute file paths referring to files outside the wp-content directory.</li>\n<li>Config Validator – adds a test item to detect invalid file attachment settings.</li>\n<li>Fixes a bug in the JavaScript fallback function for legacy browsers that do not support the HTML5 placeholder attribute.</li>\n<li>Acceptance Checkbox – unsets the form-tag&#8217;s do-not-store feature.</li>\n</ul>\n<h4>5.0.3</h4>\n<ul>\n<li>CSS: Applies the &#8220;not-allowed&#8221; cursor style to submit buttons in the &#8220;disabled&#8221; state.</li>\n<li>Acceptance Checkbox: Revises the tag-generator UI to encourage the use of better options in terms of personal data protection.</li>\n<li>Introduces wpcf7_anonymize_ip_addr() function.</li>\n<li>Introduces the consent_for:storage option for all types of form-tags.</li>\n</ul>\n<h4>5.0.2</h4>\n<ul>\n<li>Added the Privacy Notices section to the readme.txt file.</li>\n<li>Updated the Information meta-box content.</li>\n<li>Use get_user_locale() instead of get_locale() where it is more appropriate.</li>\n<li>Acceptance Checkbox: Reset submit buttons’ disabled status after a successful submission.</li>\n</ul>\n<h4>5.0.1</h4>\n<ul>\n<li>Fixed incorrect uses of _n().</li>\n<li>Config validation: Fixed incorrect count of alerts in the Additional Settings tab panel.</li>\n<li>Config validation: Fixed improper treatment for the [_site_admin_email] special mail-tag in the From mail header field.</li>\n<li>Acceptance checkbox: The class and id attributes specified were applied to the wrong HTML element.</li>\n<li>Config validation: When there is an additional mail header for mailboxes like Cc or Reply-To, but it has a possible empty value, “Invalid mailbox syntax is used” error will be returned.</li>\n<li>Explicitly specify the fourth parameter of add_action() to avoid passing unintended parameter values.</li>\n<li>Check if the target directory is empty before removing the directory.</li>\n</ul>\n<h4>5.0</h4>\n<ul>\n<li>Additional settings: on_sent_ok and on_submit have been removed.</li>\n<li>New additional setting: skip_mail</li>\n<li>Flamingo: Inbound channel title changes in conjunction with a change in the title of the corresponding contact form.</li>\n<li>DOM events: Make an entire API response object accessible through the event.detail.apiResponse property.</li>\n<li>HTML mail: Adds language-related attributes to the HTML header.</li>\n<li>File upload: Sets the accept attribute to an uploading field.</li>\n<li>Introduces the WPCF7_MailTag class.</li>\n<li>Allows aborting a mail-sending attempt using the wpcf7_before_send_mail action hook. Also, you can set a custom status and a message through the action hook.</li>\n<li>Acceptance checkbox: Allows the specifying of a statement of conditions in the form-tag’s content part.</li>\n<li>Acceptance checkbox: Supports the optional option.</li>\n<li>New special mail tags: [_site_title], [_site_description], [_site_url], [_site_admin_email], [_invalid_fields], [_user_login], [_user_email], [_user_url], [_user_first_name], [_user_last_name], [_user_nickname], and [_user_display_name]</li>\n<li>New filter hooks: wpcf7_upload_file_name, wpcf7_autop_or_not, wpcf7_posted_data_{$type}, and wpcf7_mail_tag_replaced_{$type}</li>\n<li>New form-tag features: zero-controls-container and not-for-mail</li>\n</ul>\n\";s:11:\"screenshots\";s:225:\"<ol><li><a href=\"https://ps.w.org/contact-form-7/assets/screenshot-1.png?rev=1176454\"><img src=\"https://ps.w.org/contact-form-7/assets/screenshot-1.png?rev=1176454\" alt=\"screenshot-1.png\"></a><p>screenshot-1.png</p></li></ol>\";}s:13:\"download_link\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.5.zip\";s:11:\"screenshots\";a:1:{i:1;a:2:{s:3:\"src\";s:67:\"https://ps.w.org/contact-form-7/assets/screenshot-1.png?rev=1176454\";s:7:\"caption\";s:16:\"screenshot-1.png\";}}s:4:\"tags\";a:5:{s:7:\"contact\";s:7:\"contact\";s:12:\"contact-form\";s:12:\"contact form\";s:5:\"email\";s:5:\"email\";s:8:\"feedback\";s:8:\"feedback\";s:4:\"form\";s:4:\"form\";}s:8:\"versions\";a:132:{s:3:\"1.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.1.zip\";s:4:\"1.10\";s:62:\"https://downloads.wordpress.org/plugin/contact-form-7.1.10.zip\";s:8:\"1.10.0.1\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.1.10.0.1.zip\";s:6:\"1.10.1\";s:64:\"https://downloads.wordpress.org/plugin/contact-form-7.1.10.1.zip\";s:3:\"1.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.2.zip\";s:3:\"1.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.3.zip\";s:5:\"1.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.3.1.zip\";s:5:\"1.3.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.3.2.zip\";