<?php
function mdocs_show_file_info_templates() {
	// TABLE SHOW OPTIONS
	register_setting('mdocs-global-settings', 'mdocs-displayed-file-info');
	add_option('mdocs-displayed-file-info', array());
	mdocs_add_file_info('show-name', 'Name', null,null, 'mdocs_display_name', '0', 15, true);
	mdocs_add_file_info('show-description', 'Description', null,null, 'mdocs_display_description', 1, 30);
	mdocs_add_file_info('show-downloads', 'Downloads', 'fas fa-cloud-download-alt','mdocs-orange', 'mdocs_display_downloads', 2, 12, true);
	mdocs_add_file_info('show-version', 'Version', 'fa fa-history','mdocs-blue', 'mdocs_display_version', 3,9, true);
	mdocs_add_file_info('show-author', 'Owner', 'fa fa-pencil','mdocs-green', 'mdocs_display_owner', 4,9);
	mdocs_add_file_info('show-real-author','Author', null,null, 'mdocs_display_real_author', 5,9);
	mdocs_add_file_info('show-modified', 'Last Modified', 'fa fa-calendar','mdocs-red', 'mdocs_display_updated', 6,15, true);
	mdocs_add_file_info('show-rating', 'Rating', null,null, 'mdocs_display_rating', 7,10, true);
	mdocs_add_file_info('show-download', 'Download', 'fa fa-download',null, 'mdocs_display_download_btn', 8,12);
	mdocs_add_file_info('show-file-size', 'File Size', 'fa fa-database',null, 'mdocs_display_file_size', 9,10);
	mdocs_add_file_info('show-file-type', 'File Type', null,'mdocs-black', 'mdocs_display_file_type', 10,9);
}
function mdocs_add_file_info($key, $text=null, $icon=null, $color=null, $function=null, $order=null,$width=null, $show=null) {
	$file_info = get_option('mdocs-displayed-file-info');
	if(!array_key_exists($key, $file_info)) {
		if(is_bool($show)) $file_info[$key]['show'] = $show;
		$file_info[$key]['slug'] = preg_replace('/show-/','',$key);
		if($text != null) $file_info[$key]['text'] = $text;
		if($icon != null) $file_info[$key]['icon'] = $icon;
		else $file_info[$key]['icon'] = '';
		if($color != null) $file_info[$key]['color'] = $color;
		else $file_info[$key]['color'] = '';
		if($function != null) $file_info[$key]['function'] = $function;
		if($order != null) $file_info[$key]['order'] = $order;
		if($width != null) $file_info[$key]['width'] = $width;
		update_option('mdocs-displayed-file-info',$file_info);
	} 
}
function mdocs_update_file_info($key, $text=null, $icon=null, $color=null, $function=null, $order=null,$width=null, $show=null) {
	$file_info = get_option('mdocs-displayed-file-info');
	if(is_bool($show)) $file_info[$key]['show'] = $show;
	$file_info[$key]['slug'] = preg_replace('/show-/','',$key);
	if($text != null) $file_info[$key]['text'] = $text;
	if($icon != null) $file_info[$key]['icon'] = $icon;
	else $file_info[$key]['icon'] = '';
	if($color != null) $file_info[$key]['color'] = $color;
	else $file_info[$key]['color'] = '';
	if($function != null) $file_info[$key]['function'] = $function;
	if($order != null) $file_info[$key]['order'] = $order;
	if($width != null) $file_info[$key]['width'] = $width;
	update_option('mdocs-displayed-file-info',$file_info);
}
function mdocs_delete_file_info($slug='') {
	//if(get_option('mdocs-file-info-'.md5($slug))) {
		$show_options = get_option('mdocs-displayed-file-info');
		unset($show_options['show-'.$slug]);
		update_option('mdocs-displayed-file-info', $show_options);
		//delete_option('mdocs-file-info-'.md5($slug));
	//}
}
function mdocs_dispaly_default($the_mdoc) {
	_e('No function found.', 'memphis-documents-library');
}
function mdocs_display_name($the_mdoc) {
	
}
function mdocs_display_file_type($the_mdoc) {
	echo mdocs_get_file_type_icon($the_mdoc,true,true);
}
function mdocs_display_downloads($the_mdoc) {
	echo $the_mdoc['downloads'].' <small>'.__('downloads','memphis-documents-library').'</small>';
}
function mdocs_display_version($the_mdoc) {
	echo $the_mdoc['version'];
}
function mdocs_display_owner($the_mdoc) {
	echo get_user_by('login', $the_mdoc['owner'])->display_name;
}
function mdocs_display_updated($the_mdoc) {
	$the_date = mdocs_format_unix_epoch($the_mdoc['modified']);
	if($the_date['gmdate'] > time()) $scheduled = '<small class="text-muted"><em>'.__('Scheduled').'</em></small>';
	else $scheduled = '';
	echo $the_date['formated-date'];
}
function mdocs_display_rating($the_mdoc) {
	$the_rating = mdocs_get_rating($the_mdoc);
	for($i=1;$i<=5;$i++) {
		if($the_rating['average'] >= $i) echo '<i class="fas fa-star fa-xs mdocs-gold" id="'.$i.'" aria-hidden="true"></i>';
		elseif(ceil($the_rating['average']) == $i ) echo '<i class="fas fa-star-half-alt fa-xs mdocs-gold" id="'.$i.'" aria-hidden="true"></i>';
		else echo '<i class="far fa-star fa-xs" id="'.$i.'" aria-hidden="true"></i>';
	}
}
function mdocs_display_download_btn($the_mdoc) {
	$show_download = false;
	if($the_mdoc['non_members'] == 'on' ) $show_download = true;
	if(get_option( 'mdocs-hide-all-files-non-members' ) == false && $the_mdoc['non_members'] == '')$show_download = true;
	if($the_mdoc['non_members'] == '' ) $show_download = false;
	if(get_option( 'mdocs-hide-all-files-non-members') == true)  $show_download = false;
	if(is_user_logged_in()) $show_download = true;

	if($show_download) {
		?><a href="<?php echo site_url().'/?mdocs-file='.$the_mdoc['id']; ?>"><?php echo __('Download','memphis-documents-library'); ?></a><?php
	} else {
		?><a href="<?php echo wp_login_url(htmlspecialchars(get_permalink($the_mdoc['parent']))); ?>"><?php echo __('Login','memphis-documents-library'); ?></a><?php
	}
}
function mdocs_display_description($the_mdoc) {
	echo stripcslashes($the_mdoc['desc']);
}
function mdocs_display_real_author($the_mdoc) {
	if(isset($the_mdoc['author']))	echo $the_mdoc['author'];
}
function mdocs_display_file_size($the_mdoc) {
	$upload_dir = wp_upload_dir();
	$mdocs_file = $upload_dir['basedir'].'/mdocs/'.$the_mdoc['filename'];
	echo mdocs_convert_bytes(filesize($mdocs_file));
	
}
?>